/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.SWTUtil;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.ui.connection.RemoteConnectionCombo;
import com.nvidia.cuda.ide.remote.ui.connection.toolkits.RemoteConnectionToolkitWizard;
import com.nvidia.viper.Activator;
import com.nvidia.viper.StringUtils;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.fs.ConnectionNotFoundException;
import com.nvidia.viper.fs.FileSystem;
import com.nvidia.viper.model.Executable;
import com.nvidia.viper.properties.EnvDialog;
import com.nvidia.viper.ui.ViperObservables;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public abstract class ExecutablePropertyControl
extends Composite {
    private static final int REMOTE_VALIDATION_DELAY = 200;
    private RemoteConnectionCombo connectionCombo;
    private Text toolkitName;
    private Text pathText;
    private Text cwdText;
    private Text argsText;
    private Table envTable;
    public int labelWidth;
    private Executable executable = null;
    private IRunnableContext runnableContext;
    private Button newToolkitButton;
    private Link connectLink;
    private ScheduledExecutorService validatorThread = Executors.newSingleThreadScheduledExecutor();
    private final WritableValue executableHandle = WritableValue.withValueType(Executable.class);
    private final AtomicReference<ValidatorRunnable> runnable = new AtomicReference();

    private static IStatus validateValues(String path, String cwd, FileSystem system) {
        try {
            if (CoreUtil.isNullOrEmpty((String)path)) {
                return CoreUtil.errorStatus((String)ViperMessages.NewSession_Wizard_Missing_Executable_Message, (Object[])new Object[0]);
            }
            if (!system.isConnected()) {
                return CoreUtil.warningStatus((String)ViperMessages.NewSession_Wizard_Not_Connected_Message, (Object[])new Object[0]);
            }
            if (!system.isExistingFile(path.trim())) {
                return CoreUtil.errorStatus((String)ViperMessages.NewSession_Wizard_File_Message, (Object[])new Object[0]);
            }
            if (!cwd.isEmpty() && !system.isExistingDirectory(cwd.trim())) {
                return CoreUtil.errorStatus((String)ViperMessages.NewSession_Wizard_WorkDir_Message, (Object[])new Object[0]);
            }
            return Status.OK_STATUS;
        }
        catch (ViperException e) {
            ViperExceptionHandler.handle(ViperMessages.NewSession_Label, ViperMessages.NewSession_Wizard_Connection_Exception_Message, e);
            return CoreUtil.warningStatus((String)ViperMessages.NewSession_Wizard_Validation_Exception_Message, (Object[])new Object[0]);
        }
    }

    private static Dimension getLargestLabelDimensions(Font font, String ... labels) {
        Dimension dimension = new Dimension(0, 0);
        String[] stringArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            dimension = dimension.getUnioned(FigureUtilities.getTextExtents((String)string, (Font)font));
            ++n2;
        }
        return dimension;
    }

    public ExecutablePropertyControl(Composite parent, int style, IRunnableContext runnableContext) {
        super(parent, style);
        this.runnableContext = runnableContext;
        FormLayout layout = new FormLayout();
        this.setLayout((Layout)layout);
        this.setLabelWidth(parent.getFont());
        this.connectionCombo = this.createConnectionCombo(null);
        this.toolkitName = this.createToolkitField(this.connectionCombo.getControl());
        this.pathText = this.createFileBrowse((Control)this.toolkitName, ViperMessages.FilePath_Label, false);
        this.pathText.setMessage(ViperMessages.FilePath_Message);
        this.pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ExecutablePropertyControl.this.pathText.getText().isEmpty()) {
                    ExecutablePropertyControl.this.executable.setFilename(null);
                } else {
                    ExecutablePropertyControl.this.executable.setFilename(ExecutablePropertyControl.this.pathText.getText().trim());
                }
                ExecutablePropertyControl.this.revalidate();
            }
        });
        this.cwdText = this.createFileBrowse((Control)this.pathText, ViperMessages.CurrentWorkDir_Label, true);
        this.cwdText.setMessage(ViperMessages.CurrentWorkDir_Message);
        this.cwdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ExecutablePropertyControl.this.cwdText.getText().isEmpty()) {
                    ExecutablePropertyControl.this.executable.setWorkingDir(null);
                } else {
                    ExecutablePropertyControl.this.executable.setWorkingDir(ExecutablePropertyControl.this.cwdText.getText());
                }
                ExecutablePropertyControl.this.revalidate();
            }
        });
        this.argsText = this.createText((Control)this.cwdText, ViperMessages.CmdArgs_Label);
        this.argsText.setMessage(ViperMessages.CmdArgs_Message);
        this.argsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ExecutablePropertyControl.this.argsText.getText().isEmpty()) {
                    ExecutablePropertyControl.this.executable.setArgs(null);
                } else {
                    ExecutablePropertyControl.this.executable.setArgs(ExecutablePropertyControl.this.argsText.getText());
                }
            }
        });
        this.envTable = this.createNameValueTable((Control)this.argsText, ViperMessages.EnvironmentVar_Label);
        this.envTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.item != null) {
                    String name = ((TableItem)e.item).getText(0);
                    String value = ((TableItem)e.item).getText(1);
                    EnvDialog ed = new EnvDialog(ExecutablePropertyControl.this.envTable.getShell(), "Edit Environment Variable", name, value);
                    if (ed.open() == 0) {
                        ExecutablePropertyControl.this.executable.addEnvVar(ed.getName(), ed.getValue());
                        ExecutablePropertyControl.this.refreshNameValueTable(ExecutablePropertyControl.this.envTable, ExecutablePropertyControl.this.executable.getEnv());
                    }
                }
            }
        });
        this.connectLink = new Link((Composite)this, 0);
        this.connectLink.setText("<a>Connect to a remote system</a>");
        FormData linkData = new FormData();
        linkData.right = new FormAttachment(100);
        linkData.top = new FormAttachment((Control)this.envTable, 8);
        this.connectLink.setLayoutData((Object)linkData);
        this.connectLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecutablePropertyControl.this.connect();
            }
        });
        this.setupBindings();
    }

    private void setupBindings() {
        DataBindingContext context = new DataBindingContext();
        final IObservableValue model = ViperObservables.observeConnection((IObservableValue)this.executableHandle);
        context.bindValue(this.connectionCombo.observeSelection(), model);
        ComputedValue offlineMode = new ComputedValue(Boolean.class){

            protected Object calculate() {
                Object value = model.getValue();
                if (value instanceof IRemoteConnection) {
                    return !((IRemoteConnection)value).isConnected(IRemoteConnection.Service.Files);
                }
                return false;
            }
        };
        context.bindValue((IObservableValue)SWTObservables.observeVisible((Control)this.connectLink), (IObservableValue)offlineMode);
        context.bindValue((IObservableValue)new ValidationTrigger(IRemoteConnection.class), model);
        context.bindValue((IObservableValue)new ValidationTrigger(Boolean.class), (IObservableValue)offlineMode);
        context.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.newToolkitButton), (IObservableValue)new ComputedValue(Boolean.class){

            protected Object calculate() {
                IRemoteConnection value = (IRemoteConnection)model.getValue();
                if (value != null && !value.isLocalSystem()) {
                    return true;
                }
                return false;
            }
        });
        context.bindValue((IObservableValue)SWTObservables.observeText((Control)this.toolkitName), (IObservableValue)new ComputedValue(){

            protected Object calculate() {
                IRemoteConnection c = (IRemoteConnection)model.getValue();
                if (c != null) {
                    ICudaToolkit tk = (ICudaToolkit)c.observeToolkit().getValue();
                    return tk != null ? tk.getName() : "";
                }
                return null;
            }
        });
    }

    private final void revalidate() {
        String path = this.pathText.getText();
        String cwd = this.cwdText.getText();
        FileSystem system = this.getFileSystem();
        if (system.isLocal()) {
            this.setValidationStatus(ExecutablePropertyControl.validateValues(path, cwd, system));
        } else {
            this.runnable.set(new ValidatorRunnable(system, path, cwd));
            this.validatorThread.schedule(this.runnable.get(), 200L, TimeUnit.MILLISECONDS);
        }
    }

    public abstract void setValidationStatus(IStatus var1);

    protected void connect() {
        final IRemoteConnection connection = this.connectionCombo.getSelection();
        if (connection != null && !connection.isConnected(IRemoteConnection.Service.Files)) {
            try {
                this.runnableContext.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException {
                        try {
                            connection.connect(IRemoteConnection.Service.Files, monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                ViperExceptionHandler.handle(ViperMessages.NewSession_Wizard_Title, "Unable to connect", (Exception)e.getCause());
            }
            catch (InterruptedException e) {
                ViperExceptionHandler.logError(null, e);
            }
        }
    }

    private RemoteConnectionCombo createConnectionCombo(Control prev) {
        CLabel connectionLabel = new CLabel((Composite)this, 0);
        connectionLabel.setText(ViperMessages.Connection_Label);
        Button newConnectionButton = new Button((Composite)this, 8);
        newConnectionButton.setText("Manage...");
        final RemoteConnectionCombo connectionCombo = new RemoteConnectionCombo((Composite)this);
        newConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecutablePropertyControl.this.manage(connectionCombo);
            }
        });
        this.layoutControls(prev, (Control)connectionLabel, connectionCombo.getControl(), (Control)newConnectionButton);
        return connectionCombo;
    }

    private Text createToolkitField(Control prev) {
        CLabel toolkitLabel = new CLabel((Composite)this, 0);
        toolkitLabel.setText(ViperMessages.Toolkit_Label);
        this.toolkitName = new Text((Composite)this, 2060);
        this.newToolkitButton = new Button((Composite)this, 8);
        this.newToolkitButton.setText("Manage...");
        this.newToolkitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecutablePropertyControl.this.editToolkit(ExecutablePropertyControl.this.toolkitName);
            }
        });
        this.layoutControls(prev, (Control)toolkitLabel, (Control)this.toolkitName, (Control)this.newToolkitButton);
        return this.toolkitName;
    }

    public void setInput(Executable executable) {
        this.executable = executable;
        this.executableHandle.setValue((Object)executable);
    }

    protected void setLabelWidth(Font font) {
        this.labelWidth = ExecutablePropertyControl.getLargestLabelDimensions((Font)font, (String[])new String[]{ViperMessages.Connection_Label, ViperMessages.Toolkit_Label, ViperMessages.FilePath_Label, ViperMessages.CurrentWorkDir_Label, ViperMessages.CmdArgs_Label, ViperMessages.EnvironmentVar_Label}).width;
    }

    protected Text createFileBrowse(Control prev, String labelText, boolean dir) {
        ExecutablePropertyControl parent = this;
        CLabel pathLabel = new CLabel((Composite)parent, 0);
        pathLabel.setText(labelText);
        final Text fileText = new Text((Composite)parent, 18436);
        final Button browseButton = new Button((Composite)parent, 8);
        browseButton.setText("Browse...");
        this.layoutControls(prev, (Control)pathLabel, (Control)fileText, (Control)browseButton);
        if (dir) {
            browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExecutablePropertyControl.this.browseForDir(fileText, browseButton);
                }
            });
        } else {
            browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExecutablePropertyControl.this.browseForFile(fileText, browseButton);
                }
            });
        }
        return fileText;
    }

    protected FileSystem getFileSystem() {
        IRemoteConnection connection = this.connectionCombo.getSelection();
        String connectionName = connection == null ? null : connection.getName();
        try {
            return FileSystem.getFilesystem(connectionName);
        }
        catch (ConnectionNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private void layoutControls(Control prev, Control label, Control entry, Control button) {
        FormData entryData = new FormData();
        FormData buttonData = new FormData();
        FormData labelData = new FormData();
        entryData.left = new FormAttachment(0, this.labelWidth + 5 + 6 + 2);
        entryData.top = prev == null ? new FormAttachment(0, 4) : new FormAttachment(prev, 4);
        if (button != null) {
            buttonData.right = new FormAttachment(100, 0);
            entryData.right = new FormAttachment(button, -5);
            buttonData.top = new FormAttachment(entry, 0, 0x1000000);
        } else {
            entryData.right = new FormAttachment(100, 0);
        }
        entryData.width = SWTUtil.getTextExtent((Drawable)entry, (String)"W").x * 30;
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment(entry, 0);
        labelData.top = new FormAttachment(entry, 0, 0x1000000);
        label.setLayoutData((Object)labelData);
        entry.setLayoutData((Object)entryData);
        if (button != null) {
            button.setLayoutData((Object)buttonData);
        }
    }

    protected Text createText(Control prev, String labelText) {
        ExecutablePropertyControl parent = this;
        CLabel label = new CLabel((Composite)parent, 0);
        label.setText(labelText);
        Text text = new Text((Composite)parent, 18436);
        FormData textData = new FormData();
        FormData labelData = new FormData();
        textData.left = new FormAttachment(0, this.labelWidth + 5 + 6 + 2);
        textData.top = prev == null ? new FormAttachment(0, 4) : new FormAttachment(prev, 4);
        textData.right = new FormAttachment(100, 0);
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment((Control)text, 0);
        labelData.top = new FormAttachment((Control)text, 0, 0x1000000);
        text.setLayoutData((Object)textData);
        label.setLayoutData((Object)labelData);
        return text;
    }

    protected Table createNameValueTable(Control prev, String labelText) {
        ExecutablePropertyControl parent = this;
        CLabel label = new CLabel((Composite)parent, 0);
        label.setText(labelText);
        final Button addButton = new Button((Composite)parent, 8);
        addButton.setText("Add");
        Button removeButton = new Button((Composite)parent, 8);
        removeButton.setText("Delete");
        Table table = new Table((Composite)parent, 2048);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn nameColumn = new TableColumn(table, 0);
        nameColumn.setText("Name");
        TableColumn valueColumn = new TableColumn(table, 0);
        valueColumn.setText("Value");
        nameColumn.pack();
        valueColumn.pack();
        FormData labelData = new FormData();
        FormData tableData = new FormData();
        FormData addData = new FormData();
        FormData removeData = new FormData();
        tableData.height = table.getHeaderHeight() + 2 * table.getItemHeight();
        addData.width = removeButton.computeSize((int)-1, (int)-1).x;
        tableData.left = new FormAttachment(0, this.labelWidth + 5 + 6 + 2);
        tableData.top = prev == null ? new FormAttachment(0, 4) : new FormAttachment(prev, 4);
        addData.right = new FormAttachment(100, 0);
        removeData.right = new FormAttachment(100, 0);
        tableData.right = new FormAttachment((Control)removeButton, -5);
        addData.top = new FormAttachment((Control)table, 4, 128);
        removeData.top = new FormAttachment((Control)addButton, 4);
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment((Control)table, 0);
        labelData.top = new FormAttachment((Control)table, 0, 128);
        label.setLayoutData((Object)labelData);
        table.setLayoutData((Object)tableData);
        addButton.setLayoutData((Object)addData);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnvDialog ed = new EnvDialog(addButton.getShell(), "Create Environment Variable", null, null);
                if (ed.open() == 0) {
                    ExecutablePropertyControl.this.executable.addEnvVar(ed.getName(), ed.getValue());
                    ExecutablePropertyControl.this.refreshNameValueTable(ExecutablePropertyControl.this.envTable, ExecutablePropertyControl.this.executable.getEnv());
                }
            }
        });
        removeButton.setLayoutData((Object)removeData);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = ExecutablePropertyControl.this.envTable.getSelection();
                if (items != null && items.length > 0 && items[0] != null) {
                    String name = items[0].getText(0);
                    ExecutablePropertyControl.this.executable.removeEnvVar(name);
                    ExecutablePropertyControl.this.refreshNameValueTable(ExecutablePropertyControl.this.envTable, ExecutablePropertyControl.this.executable.getEnv());
                }
            }
        });
        return table;
    }

    public Text getPathText() {
        return this.pathText;
    }

    public void setPathText(Text pathText) {
        this.pathText = pathText;
    }

    public Text getCwdText() {
        return this.cwdText;
    }

    public void setCwdText(Text cwdText) {
        this.cwdText = cwdText;
    }

    public void refresh() {
        this.refreshFilePath(this.pathText, this.executable == null ? null : this.executable.getFilename());
        this.refreshFilePath(this.cwdText, this.executable == null ? null : this.executable.getWorkingDir());
        this.refreshString(this.argsText, this.executable == null ? null : this.executable.getArgs());
        this.refreshNameValueTable(this.envTable, this.executable == null ? null : this.executable.getEnv());
    }

    protected void refreshFilePath(Text text, String path) {
        text.setText(path == null ? "" : path);
    }

    protected void refreshString(Text text, String string) {
        text.setText(string == null ? "" : string);
    }

    protected void refreshNameValueTable(Table table, Map<String, String> nameValuePairs) {
        table.removeAll();
        if (nameValuePairs != null) {
            for (String name : nameValuePairs.keySet()) {
                String value = nameValuePairs.get(name);
                TableItem item = new TableItem(table, 0);
                item.setText(new String[]{name, value});
            }
        }
    }

    private void manage(RemoteConnectionCombo connectionCombo) {
        IRemoteConnection newSelection = connectionCombo.manage();
        this.executable.setConnectionName(newSelection == null ? null : newSelection.getName());
    }

    private void editToolkit(Text text) {
        IRemoteConnection connection = this.connectionCombo.getSelection();
        if (connection != null) {
            RemoteConnectionToolkitWizard wizard = new RemoteConnectionToolkitWizard(connection);
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            dialog.open();
        }
    }

    private void browseForDir(Text fileText, Button browseButton) {
        String filterPath;
        String cwd = this.cwdText.getText();
        Path dirPath = new Path(cwd);
        if (dirPath.toFile().isDirectory()) {
            filterPath = cwd;
        } else {
            filterPath = Activator.getDefault().getPreferenceStore().getString("WorkingDirPath");
            if (StringUtils.emptyToNull(filterPath) == null) {
                dirPath = new Path(this.pathText.getText());
                filterPath = dirPath.removeLastSegments(1).toString();
            }
        }
        try {
            Shell shell = browseButton.getShell();
            final FileSystem fileSystem = this.getFileSystem();
            this.runnableContext.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        fileSystem.connect(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
            String filename = fileSystem.browseForDirectory(shell, "Select a directory", "Select working directory for application", filterPath);
            if (filename != null) {
                Path path = new Path(filename);
                filterPath = path.toFile().isDirectory() ? filename : path.removeLastSegments(1).toOSString();
                Activator.getDefault().getPreferenceStore().setValue("WorkingDirPath", filterPath);
                fileText.setText(filename);
            }
        }
        catch (InvocationTargetException e) {
            ViperExceptionHandler.handle("Browse for Directory", "Unable to open directory browser", (Exception)e.getCause());
        }
        catch (InterruptedException e) {
            ViperExceptionHandler.handle("Browse for Directory", "Unable to open directory browser", e);
        }
        catch (CoreException e) {
            ViperExceptionHandler.handle("Browse for Directory", "Unable to open directory browser", (Exception)((Object)e));
        }
    }

    private void browseForFile(Text fileText, Button browseButton) {
        try {
            Shell shell = browseButton.getShell();
            Path path = new Path(this.pathText.getText());
            final FileSystem fileSystem = this.getFileSystem();
            String prefPath = null;
            prefPath = path.toFile().exists() ? (path.toFile().isDirectory() ? path.toOSString() : path.removeLastSegments(1).toOSString()) : Activator.getDefault().getPreferenceStore().getString("ExecutablePath");
            String[] filename = new String[1];
            this.runnableContext.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        fileSystem.connect(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
            filename[0] = fileSystem.browseForFile(shell, "Select a file", "Select application executable file", prefPath);
            if (filename[0] != null) {
                path = new Path(filename[0]);
                prefPath = path.toFile().isDirectory() ? filename[0] : path.removeLastSegments(1).toOSString();
                Activator.getDefault().getPreferenceStore().setValue("ExecutablePath", prefPath);
                fileText.setText(filename[0]);
            }
        }
        catch (InvocationTargetException e) {
            ViperExceptionHandler.handle("Browse for File", "Unable to open file browser", (Exception)e.getCause());
        }
        catch (InterruptedException e) {
            ViperExceptionHandler.handle("Browse for File", "Unable to open file browser", e);
        }
        catch (CoreException e) {
            ViperExceptionHandler.handle("Browse for File", "Unable to open file browser", (Exception)((Object)e));
        }
    }

    private final class ValidationTrigger
    extends AbstractObservableValue {
        private Class<?> valueType;

        public ValidationTrigger(Class<?> type) {
            this.valueType = type;
        }

        public Object getValueType() {
            return this.valueType;
        }

        protected Object doGetValue() {
            return null;
        }

        protected void doSetValue(Object value) {
            ExecutablePropertyControl.this.revalidate();
        }
    }

    private final class ValidatorRunnable
    implements Runnable {
        private final FileSystem system;
        private final String executablePath;
        private final String cwd;

        private ValidatorRunnable(FileSystem system, String executablePath, String cwd) {
            this.system = system;
            this.executablePath = executablePath;
            this.cwd = cwd;
        }

        @Override
        public void run() {
            if (ExecutablePropertyControl.this.runnable.get() == this) {
                final IStatus status = ExecutablePropertyControl.validateValues(this.executablePath, this.cwd, this.system);
                if (ExecutablePropertyControl.this.runnable.get() == this) {
                    ExecutablePropertyControl.this.pathText.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (ExecutablePropertyControl.this.runnable.get() == ValidatorRunnable.this) {
                                ExecutablePropertyControl.this.setValidationStatus(status);
                                ExecutablePropertyControl.this.runnable.set(null);
                            }
                        }
                    });
                }
            }
        }
    }
}

