/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.parts;

import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionPropertyChangeListener;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.RegionOfInterest;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineIntervalEnvironment;
import com.nvidia.viper.model.TimelineIntervalPair;
import com.nvidia.viper.model.TimelineIntervalUtilization;
import com.nvidia.viper.model.TimelineRuler;
import com.nvidia.viper.parts.RegionOfInterestSnapDragTracker;
import com.nvidia.viper.parts.ScaleDragTracker;
import com.nvidia.viper.ui.TimelineFigure;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.swt.SWT;

public class TimelineEditPart
extends AbstractGraphicalEditPart
implements ISessionPropertyChangeListener {
    private static final Point UNKNOWN_MOUSE_LOCATION = new Point(-1, -1);
    private Point mouseLocation = new Point(UNKNOWN_MOUSE_LOCATION);
    private RegionOfInterest resizeRoi = null;
    private boolean resizeRoiStart;

    protected IFigure createFigure() {
        TimelineFigure f = new TimelineFigure(this.getCastedModel());
        f.setBackgroundColor(this.getCastedModel().getBackgroundColor());
        f.setOutline(false);
        f.setPreferredSize(this.getFigureSize());
        this.setFigureScaling(f);
        this.handleSelectedInterval(f, this.getCastedModel().getSession().getPrimarySelected());
        f.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

            public void mouseMoved(MouseEvent me) {
                TimelineEditPart.this.mouseLocation.setLocation(me.x, me.y);
                ITimelineInterval ti = TimelineEditPart.this.getIntervalAt(TimelineEditPart.this.mouseLocation, 1);
                TimelineEditPart.this.setHighlighted(TimelineEditPart.this.getCastedModel(), ti);
                TimelineEditPart.this.updateDrag();
            }

            public void mouseDragged(MouseEvent me) {
                this.mouseMoved(me);
            }

            public void mouseExited(MouseEvent me) {
                TimelineEditPart.this.mouseLocation.setLocation(UNKNOWN_MOUSE_LOCATION);
                TimelineEditPart.this.setHighlighted(null, null);
            }
        });
        return f;
    }

    protected Dimension getFigureSize() {
        int height = !this.getCastedModel().isVisible() ? 0 : TimelineFigure.getScaledTimelineHeight(this.getCastedModel());
        return new Dimension((int)((double)this.getCastedModel().getSession().getVisibleDuration() * this.getCastedModel().getSession().getHorizontalScale()), height);
    }

    protected void setFigureScaling(TimelineFigure figure) {
        figure.setXScale(this.getCastedModel().getSession().getHorizontalScale());
    }

    public Timeline getCastedModel() {
        return (Timeline)this.getModel();
    }

    protected TimelineFigure getTimelineFigure() {
        return (TimelineFigure)this.getFigure();
    }

    protected void createEditPolicies() {
    }

    protected void updateDrag() {
        Session session = this.getCastedModel().getSession();
        TimelineRuler ruler = session.getHorizontalRuler();
        if (ruler != null) {
            double hScale = session.getHorizontalScale();
            long mousens = (long)((double)this.mouseLocation.x / hScale);
            int slop = (int)(2.0 / hScale);
            List<RegionOfInterest> rois = session.getHorizontalRuler().getContainingRegionsOfInterest(mousens, slop);
            this.resizeRoi = null;
            if (rois.size() > 0) {
                for (RegionOfInterest roi : rois) {
                    if (!roi.isSelected()) continue;
                    boolean rev = roi.getStart() > roi.getEnd();
                    long start = (long)((double)Math.min(roi.getStart(), roi.getEnd()) * hScale);
                    long end = (long)((double)Math.max(roi.getStart(), roi.getEnd()) * hScale);
                    if ((long)this.mouseLocation.x < start || (long)this.mouseLocation.x > end) continue;
                    if ((long)this.mouseLocation.x - start < 5L && (long)this.mouseLocation.x - start < end - (long)this.mouseLocation.x) {
                        this.resizeRoi = roi;
                        this.resizeRoiStart = !rev;
                        break;
                    }
                    if (end - (long)this.mouseLocation.x >= 5L) continue;
                    this.resizeRoi = roi;
                    this.resizeRoiStart = rev;
                    break;
                }
            }
        }
        this.getTimelineFigure().setCursor(this.resizeRoi != null ? Cursors.SIZEWE : Cursors.ARROW);
    }

    public DragTracker getDragTracker(Request request) {
        if (!request.getType().equals("selection")) {
            return null;
        }
        if (this.resizeRoi != null) {
            return new RegionOfInterestSnapDragTracker(this, this.resizeRoi, this.resizeRoiStart);
        }
        SelectionRequest sreq = (SelectionRequest)request;
        if (sreq.getLastButtonPressed() == 1 && (sreq.getModifiers() & SWT.MOD1) != 0) {
            return new ScaleDragTracker(this, this.getCastedModel().getSession());
        }
        return super.getDragTracker(request);
    }

    protected void snapRegionOfInterest(RegionOfInterest regionOfInterest, boolean updateStart, int locX) {
        double hScale = this.getCastedModel().getSession().getHorizontalScale();
        long ns = (long)((double)locX / hScale);
        Session session = this.getCastedModel().getSession();
        TimelineRuler ruler = session.getHorizontalRuler();
        if (ruler != null) {
            TimelineIntervalPair hilite = session.getPrimaryHighlighted();
            if (hilite.getInterval() != null) {
                ITimelineInterval interval = hilite.getInterval();
                long start = interval.getStart();
                long end = interval.getEnd();
                long extendedEnd = interval.getExtendedEnd();
                ns = Math.abs(ns - start) <= Math.abs(ns - end) ? (Math.abs(ns - start) <= Math.abs(ns - extendedEnd) ? start : extendedEnd) : (Math.abs(ns - end) <= Math.abs(ns - extendedEnd) ? end : extendedEnd);
            }
            long startns = updateStart ? ns : regionOfInterest.getStart();
            long endns = !updateStart ? ns : regionOfInterest.getEnd();
            ruler.moveRegionOfInterest(regionOfInterest, startns, endns);
        }
    }

    protected void refreshVisuals() {
        this.getFigure().repaint();
    }

    public void setSelected(int value) {
        Session session = this.getCastedModel().getSession();
        if (value != 0) {
            ITimelineInterval interval = this.getIntervalAt(this.mouseLocation, 1);
            if (interval != null) {
                TimelineIntervalPair currPrimarySelected = session.getPrimarySelected();
                Collection<TimelineIntervalPair> currSecondarySelected = session.getSecondarySelected();
                TimelineIntervalPair newPrimarySelected = null;
                HashSet<TimelineIntervalPair> newSecondarySelected = null;
                if (value == 2 || currPrimarySelected == null) {
                    newPrimarySelected = new TimelineIntervalPair(this.getCastedModel(), interval);
                } else if (interval == currPrimarySelected.getInterval()) {
                    if (currSecondarySelected == null || currSecondarySelected.isEmpty()) {
                        newPrimarySelected = null;
                    } else {
                        newPrimarySelected = currSecondarySelected.iterator().next();
                        newSecondarySelected = new HashSet<TimelineIntervalPair>(currSecondarySelected);
                        newSecondarySelected.remove(newPrimarySelected);
                        if (newSecondarySelected.isEmpty()) {
                            newSecondarySelected = null;
                        }
                    }
                } else {
                    newPrimarySelected = currPrimarySelected;
                    TimelineIntervalPair found = null;
                    if (currSecondarySelected != null) {
                        for (TimelineIntervalPair pair : currSecondarySelected) {
                            if (pair.getInterval() != interval) continue;
                            found = pair;
                            break;
                        }
                    }
                    HashSet<TimelineIntervalPair> hashSet = newSecondarySelected = currSecondarySelected == null ? new HashSet<TimelineIntervalPair>() : new HashSet<TimelineIntervalPair>(currSecondarySelected);
                    if (found != null) {
                        newSecondarySelected.remove(found);
                        if (newSecondarySelected.isEmpty()) {
                            newSecondarySelected = null;
                        }
                    } else {
                        newSecondarySelected.add(new TimelineIntervalPair(this.getCastedModel(), interval));
                    }
                }
                boolean setAnalysisInterval = true;
                Analysis analysis = session.getAnalysis();
                if (analysis != null && (newPrimarySelected == null || newPrimarySelected.getInterval() == null || newSecondarySelected != null && !newSecondarySelected.isEmpty())) {
                    setAnalysisInterval = false;
                    analysis.setActiveScopeInterval(null);
                }
                session.setPrimaryAndSecondarySelected(newPrimarySelected, newSecondarySelected, true, setAnalysisInterval);
            } else {
                TimelineIntervalPair pair = this.getCastedModel().getSession().getPrimarySelected();
                Timeline selectedTimeline = pair == null ? null : (pair.getInterval() != null ? null : pair.getTimeline());
                this.getCastedModel().getSession().setPrimarySelected(new TimelineIntervalPair(this.getCastedModel() == selectedTimeline ? null : this.getCastedModel(), null), true);
            }
        }
    }

    protected void setHighlighted(Timeline timeline, ITimelineInterval interval) {
        this.getCastedModel().getSession().setPrimaryHighlighted(new TimelineIntervalPair(timeline, interval));
    }

    protected ITimelineInterval getIntervalAt(Point point, int slop) {
        double scale = this.getCastedModel().getSession().getHorizontalScale();
        long ns = (long)((double)point.x / scale);
        long slopns = 0L;
        if (slop > 0) {
            slopns = (long)(1.0 / scale) * (long)slop;
        }
        Timeline.IntervalRange intervals = this.getCastedModel().getVisibleIntervals(ns - slopns, ns + slopns);
        boolean useExtended = this.getCastedModel().getKind().usesExtendedEnd();
        if (!intervals.isEmpty()) {
            int timelineMargin = TimelineFigure.getScaledValue(this.getCastedModel().getTimelineOuterMargin());
            int rowHeight = TimelineFigure.getScaledValue(this.getCastedModel().getIntervalRowHeight());
            int rowInnerMargin = TimelineFigure.getScaledValue(this.getCastedModel().getIntervalRowInnerMargin());
            Rectangle timelineOrigin = this.getFigure().getBounds();
            int y = point.y - timelineOrigin.y;
            int row = (y - timelineMargin) / (rowHeight + rowInnerMargin);
            int idx = intervals.getStartIndex();
            while (idx < intervals.getEndIndex()) {
                ITimelineInterval interval = intervals.getInterval(idx);
                if (!(interval instanceof TimelineIntervalUtilization) && interval.getStart() <= ns + slopns && (useExtended ? interval.getExtendedEnd() : interval.getEnd()) >= ns - slopns && this.getCastedModel().getVisibleIntervalRow(interval) == row) {
                    if (interval instanceof TimelineIntervalEnvironment) {
                        int symbolRadius = 3;
                        int yOffset = ((TimelineDevice)this.getCastedModel()).getYOffsetForEnvSymbol(interval);
                        if (yOffset < symbolRadius) {
                            yOffset = symbolRadius;
                        } else if (yOffset > rowHeight - symbolRadius) {
                            yOffset = rowHeight - symbolRadius;
                        }
                        int yLoc = timelineOrigin.y + rowHeight - yOffset;
                        if (point.y >= yLoc - symbolRadius && point.y <= yLoc + symbolRadius) {
                            return interval;
                        }
                    } else {
                        return interval;
                    }
                }
                ++idx;
            }
        }
        return null;
    }

    protected ITimelineInterval[] getAdjacentIntervalsAt(Point point) {
        double scale = this.getCastedModel().getSession().getHorizontalScale();
        long ns = (long)((double)point.x / scale);
        ITimelineInterval[] intervals = this.getCastedModel().getAdjacentVisibleIntervals(ns);
        return intervals;
    }

    public void activate() {
        super.activate();
        this.getCastedModel().getSession().addPropertyChangeListener(this);
        this.getCastedModel().addPropertyChangeListener(this);
    }

    public void deactivate() {
        super.deactivate();
        if (this.getCastedModel() != null) {
            if (this.getCastedModel().getSession() != null) {
                this.getCastedModel().getSession().removePropertyChangeListener(this);
            }
            this.getCastedModel().removePropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(IModel model, String propertyName) {
        if ("session:hScale".equals(propertyName)) {
            this.setFigureScaling(this.getTimelineFigure());
            this.getFigure().setPreferredSize(this.getFigureSize());
            this.refreshVisuals();
        } else if ("session:colorMode".equals(propertyName)) {
            this.refreshVisuals();
        } else if ("timeline:bgcolor".equals(propertyName)) {
            this.getFigure().setBackgroundColor(((Timeline)model).getBackgroundColor());
            this.refreshVisuals();
        } else if ("timeline:visible".equals(propertyName) || "session:timeline".equals(propertyName)) {
            this.getFigure().setVisible(this.getCastedModel().isVisible());
            this.getFigure().setPreferredSize(this.getFigureSize());
        } else if ("session:expertdata".equals(propertyName)) {
            this.figure.setBackgroundColor(this.getCastedModel().getBackgroundColor());
            this.refreshVisuals();
        } else if ("session:sInterval".equals(propertyName)) {
            if (this.handleSelectedInterval((TimelineFigure)this.getFigure(), ((Session)model).getPrimarySelected())) {
                this.refreshVisuals();
            }
        } else if ("session:hInterval".equals(propertyName) && this.handleHighlightedIntervals((TimelineFigure)this.getFigure(), this.getCastedModel().getSession().getHighlighted())) {
            this.refreshVisuals();
        }
    }

    protected boolean handleHighlightedIntervals(TimelineFigure figure, Collection<TimelineIntervalPair> highlights) {
        if (highlights == null) {
            return figure.setHighlightIntervals(null);
        }
        HashSet<ITimelineInterval> intervals = new HashSet<ITimelineInterval>(highlights.size());
        for (TimelineIntervalPair pair : highlights) {
            intervals.add(pair.getInterval());
        }
        return figure.setHighlightIntervals(intervals);
    }

    protected boolean handleSelectedInterval(TimelineFigure figure, TimelineIntervalPair pair) {
        if (pair == null) {
            figure.setIsSelected(false);
        } else {
            figure.setIsSelected(pair.getInterval() == null && pair.getTimeline() == this.getCastedModel());
        }
        return true;
    }
}

