/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.parts;

import com.nvidia.viper.ViperColors;
import com.nvidia.viper.model.Session;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.tools.SimpleDragTracker;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;

public class ScaleDragTracker
extends SimpleDragTracker {
    protected static final int DRAG_THRESHOLD = 3;
    private AbstractGraphicalEditPart source;
    private Session session;
    private RoundedRectangle scaleFigure;

    public ScaleDragTracker(AbstractGraphicalEditPart source, Session session) {
        this.source = source;
        this.session = session;
        this.scaleFigure = new RoundedRectangle();
        this.scaleFigure.setBackgroundColor(ViperColors.SCALE_DRAG_BGCOLOR);
        this.scaleFigure.setOutline(false);
        this.scaleFigure.setBorder(null);
        this.scaleFigure.setOpaque(false);
        this.scaleFigure.setAlpha(75);
    }

    protected boolean movedPastThreshold() {
        return Math.abs(this.getLocation().x - this.getStartLocation().x) > 3;
    }

    protected Cursor calculateCursor() {
        if (this.isInState(36)) {
            return this.getDefaultCursor();
        }
        return null;
    }

    protected boolean handleButtonUp(int button) {
        if (!this.isInState(36)) {
            this.source.setSelected(1);
            return true;
        }
        return super.handleButtonUp(button);
    }

    protected void eraseSourceFeedback() {
        if (this.scaleFigure.getParent() != null) {
            this.removeFeedback((IFigure)this.scaleFigure);
        }
    }

    protected void showSourceFeedback() {
        Point startLoc = this.getStartLocation();
        Point loc = this.getLocation();
        this.source.getFigure().translateToRelative((Translatable)startLoc);
        this.source.getFigure().translateToRelative((Translatable)loc);
        Viewport viewport = ((FigureCanvas)this.getCurrentViewer().getControl()).getViewport();
        Rectangle clip = viewport.getClientArea();
        clip.shrink(viewport.getInsets());
        clip.height -= 3;
        Rectangle bounds = Rectangle.SINGLETON;
        bounds.x = Math.min(loc.x, startLoc.x);
        bounds.y = 0;
        bounds.width = Math.abs(loc.x - startLoc.x);
        bounds.height = Integer.MAX_VALUE;
        bounds.intersect(clip);
        this.scaleFigure.setBounds(bounds);
        this.addFeedback((IFigure)this.scaleFigure);
    }

    protected void performDrag() {
        long length = Math.abs(this.getLocation().x - this.getStartLocation().x);
        double nslength = (double)length / this.session.getHorizontalScale();
        int width = this.getCurrentViewer().getControl().getSize().x;
        double prefScale = (double)width / nslength;
        double oldScale = this.session.getHorizontalScale();
        this.session.setHorizontalScale(prefScale);
        double newScale = this.session.getHorizontalScale();
        double locFactor = newScale / oldScale;
        Point startLoc = this.getStartLocation();
        Point loc = this.getLocation();
        this.source.getFigure().translateToRelative((Translatable)startLoc);
        this.source.getFigure().translateToRelative((Translatable)loc);
        int oldLoc = Math.min(loc.x, startLoc.x);
        final int newLoc = (int)((double)oldLoc * locFactor);
        final FigureCanvas canvas = (FigureCanvas)this.getCurrentViewer().getControl();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                canvas.scrollToX(newLoc);
            }
        });
    }

    protected Cursor getDefaultCursor() {
        return Cursors.SIZEWE;
    }

    protected String getDebugName() {
        return "Timeline Scaling";
    }

    protected String getCommandName() {
        return "Scale";
    }
}

