/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.ViperColors;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.activity.CuptiActivityKind;
import com.nvidia.viper.activity.CuptiActivityUvmCounter;
import com.nvidia.viper.activity.CuptiActivityUvmCounterKind;
import com.nvidia.viper.activity.CuptiActivityUvmCounterScope;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineIntervalUVM;
import com.nvidia.viper.model.TimelineKind;
import java.util.HashMap;
import java.util.Map;

public class TimelineUVM
extends Timeline
implements IModel {
    private long totalValue = 0L;
    private final CuptiActivityUvmCounterScope uvmCounterScope = CuptiActivityUvmCounterScope.CUPTI_ACTIVITY_UVM_COUNTER_SCOPE_PROCESS_SINGLE_DEVICE;
    private final CuptiActivityKind activityKind = CuptiActivityKind.CUPTI_ACTIVITY_KIND_UVM_COUNTER;
    private final Map<Integer, ViperColors.GradientColors> processColors = new HashMap<Integer, ViperColors.GradientColors>();

    public TimelineUVM(String name, TimelineKind kind) {
        super(name, kind);
    }

    public long getTotalValue() {
        if (this.totalValue == 0L) {
            for (ITimelineInterval interval : this.intervals) {
                TimelineIntervalUVM uvmInterval = (TimelineIntervalUVM)interval;
                Long value = uvmInterval.getCounterValue();
                if (value == null) continue;
                this.totalValue += value.longValue();
            }
        }
        return this.totalValue;
    }

    private CuptiActivityUvmCounterKind getCounterKind() {
        switch (this.getKind()) {
            case UVM_MEMCPY_HTOD: {
                return CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_HTOD;
            }
            case UVM_MEMCPY_DTOH: {
                return CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_DTOH;
            }
            case UVM_PAGE_FAULT: {
                return CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_CPU_PAGE_FAULT_COUNT;
            }
        }
        return null;
    }

    @Override
    public void appendToPDM(ProfileDataModel pdm) throws ViperException {
        long cumulativeValue = 0L;
        long prevEnd = 0L;
        TimelineDevice device = (TimelineDevice)this.getAncestor(TimelineKind.DEVICE);
        int deviceId = device.getId();
        int i = 0;
        while (i < this.intervals.size()) {
            TimelineIntervalUVM uvmInterval = (TimelineIntervalUVM)this.intervals.get(i);
            if (i == 0 || uvmInterval.getStart() != prevEnd) {
                this.createAndAppendActivity(deviceId, uvmInterval.getProcessId(), cumulativeValue, uvmInterval.getStart(), pdm);
            }
            this.createAndAppendActivity(deviceId, uvmInterval.getProcessId(), cumulativeValue += uvmInterval.getCounterValue().longValue(), uvmInterval.getEnd(), pdm);
            prevEnd = uvmInterval.getEnd();
            ++i;
        }
    }

    private void createAndAppendActivity(int deviceId, int processId, long value, long timestamp, ProfileDataModel pdm) throws ViperException {
        CuptiActivityUvmCounterKind counterKind = this.getCounterKind();
        CuptiActivityUvmCounter activity = new CuptiActivityUvmCounter(this.activityKind, counterKind, this.uvmCounterScope, deviceId, processId, timestamp, value);
        try {
            activity.appendToPDM(pdm.getNativeHandle());
        }
        catch (Exception e) {
            if (e instanceof ViperException) {
                throw (ViperException)e;
            }
            throw new ViperException(e);
        }
    }

    @Override
    public ViperColors.GradientColors getIntervalColors(ITimelineInterval interval) {
        ViperColors.GradientColors color;
        if (interval instanceof TimelineIntervalUVM && (color = this.processColors.get(((TimelineIntervalUVM)interval).getProcessId())) != null) {
            return interval.getColor(color);
        }
        return super.getIntervalColors(interval);
    }

    public void setIntervalColors(Integer processId, ViperColors.GradientColors color) {
        if (color == null) {
            this.processColors.remove(processId);
        } else {
            this.processColors.put(processId, color);
        }
    }
}

