/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.activity.CuptiActivityFunction;
import com.nvidia.viper.activity.CuptiActivitySourceLocator;
import com.nvidia.viper.analysis.AnalysisResultInstructionExecution;
import com.nvidia.viper.analysis.AnalysisResultSourceLevel;
import com.nvidia.viper.editor.CudaFunction;
import com.nvidia.viper.model.CudaFunctionManager;
import com.nvidia.viper.model.ModelWithProperties;
import com.nvidia.viper.model.SassInstruction;
import com.nvidia.viper.model.Session;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SourceSassModel
extends ModelWithProperties {
    public static final String PROPERTY_UPDATED = "sourcesassmodel:updated";
    private Session session;
    private AnalysisResultSourceLevel sourceLevelResult;
    private List<SassInstruction> sassInstructions;
    private Map<Integer, List<Integer>> sourceSassMap;
    private String fileName;
    private Set<String> sourceFiles;
    private int topVisibleLine;
    private int functionId;

    public SourceSassModel(Session session, AnalysisResultSourceLevel sourceLevelResult) {
        this.session = session;
        this.sourceLevelResult = sourceLevelResult;
        this.functionId = -1;
        this.topVisibleLine = -1;
        this.collectSassInstructions();
    }

    public SourceSassModel(Session session, AnalysisResultSourceLevel sourceLevelResult, String fileName, int topVisibleLine) {
        this.session = session;
        this.sourceLevelResult = sourceLevelResult;
        this.fileName = fileName;
        this.topVisibleLine = topVisibleLine;
        this.functionId = -1;
        this.collectSassInstructions();
    }

    public SourceSassModel(Session session, AnalysisResultInstructionExecution sourceLevelResult, int functionId) {
        this.session = session;
        this.sourceLevelResult = sourceLevelResult;
        this.functionId = functionId;
        this.topVisibleLine = -1;
        this.collectSassInstructions();
    }

    private void collectSassInstructions() {
        if (this.session != null) {
            if (this.sassInstructions == null) {
                this.sassInstructions = new ArrayList<SassInstruction>();
            } else {
                this.sassInstructions.clear();
            }
            if (this.sourceSassMap == null) {
                this.sourceSassMap = new HashMap<Integer, List<Integer>>();
            } else {
                this.sourceSassMap.clear();
            }
            CudaFunctionManager cudaFunctionManager = this.session.getCudaFunctionManager();
            Collection<CuptiActivityFunction> cuptiActivityFunctions = cudaFunctionManager.getFunctions();
            for (CuptiActivityFunction function : cuptiActivityFunctions) {
                CudaFunction cudaFunction = cudaFunctionManager.getCudaFunction(function);
                if (!cudaFunction.updateSourceLocator(this.sourceLevelResult, function.id)) continue;
                List<SassInstruction> instructionList = cudaFunction.getSassInstructions();
                for (SassInstruction inst : instructionList) {
                    int locatorId = inst.getSourcelocatorid();
                    CuptiActivitySourceLocator locator = this.session.getSourceLocator().getLocation(locatorId);
                    if (locator == null) continue;
                    if (this.functionId == function.id) {
                        if (this.topVisibleLine == -1) {
                            this.topVisibleLine = locator.lineNumber;
                            this.fileName = locator.fileName;
                        } else if (locator.lineNumber < this.topVisibleLine && this.fileName.equals(locator.fileName)) {
                            this.topVisibleLine = locator.lineNumber;
                        }
                    }
                    if (this.sourceFiles == null) {
                        this.sourceFiles = new HashSet<String>();
                    }
                    this.sourceFiles.add(locator.fileName);
                }
                this.sassInstructions.addAll(instructionList);
            }
        }
    }

    public List<Integer> getSassLinesGroup(int sassLine) {
        CuptiActivitySourceLocator sourceLocator = this.getSourceLocator(sassLine);
        if (sourceLocator != null) {
            return this.sourceSassMap.get(sourceLocator.id);
        }
        return null;
    }

    public List<Integer> getSassLines(String cudaFileName, int cudaLine) {
        CuptiActivitySourceLocator sourceLocator = this.getSourceLocator(cudaFileName, cudaLine);
        if (sourceLocator != null) {
            if (this.sourceSassMap.get(sourceLocator.id) != null) {
                return this.sourceSassMap.get(sourceLocator.id);
            }
            ArrayList<Integer> sassLines = new ArrayList<Integer>();
            int i = 0;
            while (i < this.sassInstructions.size()) {
                if (this.sassInstructions.get(i).getSourcelocatorid() == sourceLocator.id) {
                    sassLines.add(i);
                }
                ++i;
            }
            if (sassLines.size() != 0) {
                this.sourceSassMap.put(sourceLocator.id, sassLines);
                return sassLines;
            }
        }
        return null;
    }

    private CuptiActivitySourceLocator getSourceLocator(String cudaFileName, int cudaLine) {
        URI uriCudaFile;
        if (cudaFileName == null) {
            return null;
        }
        try {
            uriCudaFile = new URI(cudaFileName);
        }
        catch (URISyntaxException uRISyntaxException) {
            uriCudaFile = new File(cudaFileName).toURI();
        }
        CuptiActivitySourceLocator sourceLocator = this.session.getSourceLocator().getLocation(uriCudaFile, cudaLine);
        return sourceLocator;
    }

    public Session getSession() {
        return this.session;
    }

    public AnalysisResultInstructionExecution getAnalysisResultInstructionExecution() {
        if (this.sourceLevelResult instanceof AnalysisResultInstructionExecution) {
            return (AnalysisResultInstructionExecution)this.sourceLevelResult;
        }
        return null;
    }

    public List<SassInstruction> getSassInstructions() {
        return this.sassInstructions;
    }

    public CuptiActivitySourceLocator getSourceLocator(int sassLine) {
        if (sassLine == -1 || sassLine >= this.sassInstructions.size()) {
            return null;
        }
        int sourcelocatorid = this.sassInstructions.get(sassLine).getSourcelocatorid();
        CuptiActivitySourceLocator locator = this.session.getSourceLocator().getLocation(sourcelocatorid);
        return locator;
    }

    public String getSassDocumentString() {
        StringBuilder stringBuilder = new StringBuilder();
        String tabs = "\t\t";
        for (SassInstruction inst : this.sassInstructions) {
            String current = inst.getSass();
            if (!current.endsWith(":")) {
                stringBuilder.append(tabs);
            }
            stringBuilder.append(String.valueOf(current) + "\n");
        }
        return stringBuilder.toString();
    }

    public CuptiActivitySourceLocator getLocatorToOpen() {
        CuptiActivitySourceLocator firstLocator = null;
        for (SassInstruction inst : this.sassInstructions) {
            int locatorId = inst.getSourcelocatorid();
            CuptiActivitySourceLocator locator = this.session.getSourceLocator().getLocation(locatorId);
            if (locator != null && firstLocator == null) {
                firstLocator = locator;
            }
            if (locator == null || !locator.fileName.equals(this.fileName)) continue;
            return locator;
        }
        return firstLocator;
    }

    public int getTopVisibleLine() {
        return this.topVisibleLine;
    }

    public String getFilename() {
        return this.fileName;
    }

    public Set<String> getSourceFiles() {
        return this.sourceFiles;
    }

    public void update(SourceSassModel refModel) {
        if (refModel != null) {
            if (!this.fileName.equals(refModel.getFilename())) {
                this.fileName = refModel.getFilename();
            }
            if (this.topVisibleLine != refModel.getTopVisibleLine()) {
                this.topVisibleLine = refModel.getTopVisibleLine();
            }
            this.firePropertyChange(PROPERTY_UPDATED);
        }
    }
}

