/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.activity.CuptiActivityBranch;
import com.nvidia.viper.activity.CuptiActivityGlobalAccess;
import com.nvidia.viper.activity.CuptiActivityInstructionExecution;
import com.nvidia.viper.activity.CuptiActivityKind;
import com.nvidia.viper.activity.CuptiActivitySharedAccess;
import com.nvidia.viper.activity.ICuptiActivitySourceLevelResult;
import com.nvidia.viper.model.IProfilingData;
import com.nvidia.viper.model.ITimelineInterval;

public enum SourceLevelResult implements IProfilingData
{
    GLOBAL_ACCESS(CuptiActivityKind.CUPTI_ACTIVITY_KIND_GLOBAL_ACCESS, "global_access"),
    SHARED_ACCESS(CuptiActivityKind.CUPTI_ACTIVITY_KIND_SHARED_ACCESS, "shared_access"),
    BRANCH(CuptiActivityKind.CUPTI_ACTIVITY_KIND_BRANCH, "branch"),
    INSTRUCTION_EXECUTION(CuptiActivityKind.CUPTI_ACTIVITY_KIND_INSTRUCTION_EXECUTION, "instruction_execution");

    private final CuptiActivityKind activityKind;
    private final String nvprofFlag;

    private SourceLevelResult(CuptiActivityKind activityKind, String nvprofFlag) {
        this.activityKind = activityKind;
        this.nvprofFlag = nvprofFlag;
    }

    public CuptiActivityKind getActivityKind() {
        return this.activityKind;
    }

    @Override
    public String getName() {
        return this.nvprofFlag;
    }

    @Override
    public IProfilingData.Kind getProfileDataKind() {
        return IProfilingData.Kind.sourcelevel;
    }

    public ICuptiActivitySourceLevelResult createNullCuptiActivity(ITimelineInterval interval) {
        switch (this) {
            case BRANCH: {
                return new CuptiActivityBranch(interval, true);
            }
            case GLOBAL_ACCESS: {
                return new CuptiActivityGlobalAccess(interval, true);
            }
            case SHARED_ACCESS: {
                return new CuptiActivitySharedAccess(interval, true);
            }
            case INSTRUCTION_EXECUTION: {
                return new CuptiActivityInstructionExecution(interval, true);
            }
        }
        ViperExceptionHandler.logError("unknown source-level result kind " + this);
        return null;
    }
}

