/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.ViperException;
import com.nvidia.viper.analysis.AnalysisScope;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineContext;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineKernel;
import com.nvidia.viper.model.TimelineKind;
import com.nvidia.viper.model.TimelineStream;
import java.util.List;

public class SessionFilter {
    private Integer deviceId;
    private String contextName;
    private Integer contextId;
    private String streamName;
    private Integer streamId;
    private String kernelName;
    private int kernelInstanceCount;

    public SessionFilter(Integer deviceId, String contextName, Integer contextId, String streamName, Integer streamId, String kernelName, int kernelInstanceCount) throws ViperException {
        this.deviceId = deviceId;
        this.contextName = contextName;
        this.contextId = contextId;
        this.streamName = streamName;
        this.streamId = streamId;
        this.kernelName = kernelName;
        this.kernelInstanceCount = kernelInstanceCount;
        if (!this.isSingleKernelInstance()) {
            throw new ViperException("session filter does not specify single kernel instance");
        }
    }

    public SessionFilter(Session session, Analysis analysis) throws ViperException {
        this(analysis != null ? analysis.getActiveScopeInterval() : null);
    }

    public SessionFilter(ITimelineInterval analysisScopeInterval) throws ViperException {
        TimelineContext contextTl;
        TimelineDevice deviceTl;
        TimelineIntervalKernel kernel;
        TimelineKernel kernelTl;
        if (AnalysisScope.KERNEL_INSTANCE.isEnabled(analysisScopeInterval) && (kernelTl = (TimelineKernel)(kernel = (TimelineIntervalKernel)analysisScopeInterval).getPrimaryTimeline()) != null && (deviceTl = (TimelineDevice)kernelTl.getAncestor(TimelineKind.DEVICE)) != null && (contextTl = (TimelineContext)kernelTl.getAncestor(TimelineKind.CONTEXT)) != null) {
            int streamId = kernel.getStreamId();
            List<Timeline> streamTls = contextTl.getDescendants(TimelineKind.STREAM);
            Timeline streamTl = null;
            for (Timeline tl : streamTls) {
                if (((TimelineStream)tl).getId() != streamId) continue;
                streamTl = (TimelineStream)tl;
                break;
            }
            if (streamTl != null) {
                String kernelName = kernel.getName();
                int instanceCount = -1;
                for (ITimelineInterval interval : streamTl.getIntervals()) {
                    if (interval instanceof TimelineIntervalKernel && kernelName.equals(interval.getName())) {
                        ++instanceCount;
                    }
                    if (interval == kernel) break;
                }
                if (instanceCount >= 0) {
                    this.deviceId = deviceTl.getId();
                    this.contextId = contextTl.getId();
                    this.contextName = contextTl.getCustomName();
                    this.streamId = ((TimelineStream)streamTl).getId();
                    this.streamName = streamTl.getCustomName();
                    this.kernelName = kernelName;
                    this.kernelInstanceCount = instanceCount;
                    return;
                }
            }
        }
        throw new ViperException("analysis scope does not specify single kernel instance");
    }

    public Integer getDeviceId() {
        return this.deviceId;
    }

    public Integer getContextId() {
        if (this.contextName != null) {
            return null;
        }
        return this.contextId;
    }

    public String getContextName() {
        return this.contextName;
    }

    public Integer getStreamId() {
        if (this.streamName != null) {
            return null;
        }
        return this.streamId;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public String getKernelName() {
        return this.kernelName;
    }

    public int getKernelInstanceCount() {
        return this.kernelInstanceCount;
    }

    public boolean isSingleKernelInstance() {
        return !(this.deviceId == null || this.contextId == null && this.contextName == null || this.streamId == null && this.streamName == null || this.kernelName == null || this.kernelInstanceCount < 0);
    }

    public TimelineIntervalKernel getSingleKernelInstance(Session session) {
        if (!this.isSingleKernelInstance()) {
            return null;
        }
        List<Timeline> deviceTls = session.getTimelines(TimelineKind.DEVICE);
        Timeline deviceTl = null;
        for (Timeline tl : deviceTls) {
            if (((TimelineDevice)tl).getId() != this.deviceId.intValue()) continue;
            deviceTl = (TimelineDevice)tl;
            break;
        }
        if (deviceTl == null) {
            return null;
        }
        List<Timeline> contextTls = deviceTl.getDescendants(TimelineKind.CONTEXT);
        Timeline contextTl = null;
        for (Timeline tl : contextTls) {
            if ((this.contextName == null || !this.contextName.equals(tl.getCustomName())) && (this.contextName != null || ((TimelineContext)tl).getId() != this.contextId.intValue())) continue;
            contextTl = (TimelineContext)tl;
            break;
        }
        if (contextTl == null) {
            return null;
        }
        List<Timeline> streamTls = contextTl.getDescendants(TimelineKind.STREAM);
        Timeline streamTl = null;
        for (Timeline tl : streamTls) {
            if ((this.streamName == null || !this.streamName.equals(tl.getCustomName())) && (this.streamName != null || ((TimelineStream)tl).getId() != this.streamId.intValue())) continue;
            streamTl = (TimelineStream)tl;
            break;
        }
        if (streamTl == null) {
            return null;
        }
        int foundInstanceCount = -1;
        for (ITimelineInterval interval : streamTl.getIntervals()) {
            if (interval instanceof TimelineIntervalKernel && this.kernelName.equals(interval.getName())) {
                ++foundInstanceCount;
            }
            if (foundInstanceCount != this.kernelInstanceCount) continue;
            return (TimelineIntervalKernel)interval;
        }
        return null;
    }

    public String getNvprofCommandLine() {
        StringBuilder args = new StringBuilder(" --kernels \"");
        if (this.getContextId() != null) {
            args.append(this.getContextId());
        } else {
            args.append(this.getContextName());
        }
        args.append(":");
        if (this.getStreamId() != null) {
            args.append(this.getStreamId());
        } else {
            args.append(this.getStreamName());
        }
        args.append(":").append(this.getKernelName());
        args.append(":").append(this.getKernelInstanceCount() + 1).append("\"");
        return args.toString();
    }
}

