/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.CsvReader;
import com.nvidia.viper.EventManager;
import com.nvidia.viper.FileUtils;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.activity.CuptiActivityBase;
import com.nvidia.viper.activity.CuptiActivityComputeApiKind;
import com.nvidia.viper.activity.CuptiActivityContext;
import com.nvidia.viper.activity.CuptiActivityDevice;
import com.nvidia.viper.activity.CuptiActivityKernel;
import com.nvidia.viper.activity.CuptiActivityKind;
import com.nvidia.viper.activity.CuptiActivityMemcpy;
import com.nvidia.viper.activity.CuptiActivityMemcpyKind;
import com.nvidia.viper.activity.CuptiActivityMemoryKind;
import com.nvidia.viper.jni.CUptiResult;
import com.nvidia.viper.jni.CuptiException;
import com.nvidia.viper.jni.NativeCupti;
import com.nvidia.viper.model.Event;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionSerializable;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.ui.LargeDataMessageDialog;
import com.nvidia.viper.ui.PdmInputDialog;
import com.nvidia.viper.ui.ViperMessageDialog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.bind.DatatypeConverter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;

public class ProfileDataModel
implements IModel,
ISessionSerializable {
    private long hPdm;
    private int correlationId = 1;
    private boolean disposed = false;

    public ProfileDataModel() throws ViperException {
        try {
            this.hPdm = NativeCupti.cuptiPDMCreate();
        }
        catch (Exception e) {
            throw new ViperException(e);
        }
    }

    public ProfileDataModel(Element el) throws ViperException {
        try {
            String str = el.getTextContent();
            byte[] data = DatatypeConverter.parseBase64Binary((String)str);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            GZIPInputStream zStream = new GZIPInputStream(inputStream);
            this.hPdm = NativeCupti.cuptiPDMCreate();
            try {
                NativeCupti.cuptiPDMDeserialize(this.hPdm, zStream);
            }
            catch (CuptiException e) {
                if (CUptiResult.CUPTI_ERROR_OUT_OF_MEMORY.equals((Object)e.getCuptiResult())) {
                    ViperMessageDialog.openWarning(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ViperMessages.OutOfMemoryWarning_Label, ViperMessages.OutOfMemoryLoadWarning_Message);
                }
                this.handlePdmException(e);
            }
            zStream.close();
            ((InputStream)inputStream).close();
        }
        catch (Exception e) {
            this.handlePdmException(e);
        }
    }

    private void handlePdmException(Exception e) {
        ViperExceptionHandler.handle(ViperMessages.ReadPdm_Fail_Title, ViperMessages.ReadPdm_Fail_Message, e);
        try {
            NativeCupti.cuptiPDMDestroy(this.hPdm, 0);
            this.hPdm = NativeCupti.cuptiPDMCreate();
        }
        catch (CuptiException ee) {
            ViperExceptionHandler.logError("create empty PDM failed", ee);
        }
    }

    public void dispose() {
        try {
            NativeCupti.cuptiPDMDestroy(this.hPdm, 0);
        }
        catch (CuptiException e) {
            ViperExceptionHandler.logError("PDM destroy failed", e);
        }
        this.disposed = true;
    }

    protected void finalize() throws Throwable {
        if (!this.disposed) {
            ViperExceptionHandler.logError("PDM not disposed!");
            this.dispose();
        }
        super.finalize();
    }

    public long getNativeHandle() {
        return this.hPdm;
    }

    public void normalizeTimestamps(long normalizedTime) throws ViperException {
        try {
            NativeCupti.cuptiPDMNormalize(this.hPdm, normalizedTime);
        }
        catch (Exception e) {
            if (e instanceof ViperException) {
                throw (ViperException)e;
            }
            throw new ViperException(e);
        }
    }

    public void readUsingCorrelationId(File profileFile, Session session) throws ViperException {
        try {
            FileInputStream inputStream = new FileInputStream(profileFile);
            try {
                NativeCupti.cuptiPDMDeserializeCorrelation(this.hPdm, inputStream, session.getStartCorrelationId(), session.getEndCorrelationId());
            }
            catch (CuptiException e) {
                if (CUptiResult.CUPTI_ERROR_OUT_OF_MEMORY.equals((Object)e.getCuptiResult())) {
                    ViperMessageDialog.openWarning(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ViperMessages.OutOfMemoryWarning_Label, ViperMessages.OutOfMemoryLoadWarning_Message);
                }
                throw new ViperException(e);
            }
            ((InputStream)inputStream).close();
        }
        catch (Exception e) {
            throw new ViperException(e);
        }
    }

    public void readUsingSizeTime(File apiFile, final Session session) throws ViperException {
        if (session == null) {
            return;
        }
        if (session.getPdmStartTime() == -1L || session.getPdmSize() == -1) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    PdmInputDialog dialog = new PdmInputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                    dialog.create();
                    if (dialog.open() == 0) {
                        session.setPdmSize(dialog.getPdmSize());
                        session.setPdmStartTime(dialog.getStartTime());
                    }
                }
            });
        }
        try {
            ArrayList<Long> result = this.read(apiFile, session.getPdmSize() * 0x100000, session.getPdmStartTime() * 1000000L);
            if (result != null && result.size() == 3) {
                session.setStartCorrelationId(result.get(1));
                session.setEndCorrelationId(result.get(2));
            }
        }
        catch (ViperException e) {
            throw new ViperException(e);
        }
    }

    public ArrayList<Long> read(File file, int maxSize, long startTime) throws ViperException {
        ArrayList<Long> list = null;
        try {
            FileInputStream inputStream = new FileInputStream(file);
            try {
                list = NativeCupti.cuptiPDMDeserializeSizeAndTime(this.hPdm, inputStream, maxSize, startTime);
            }
            catch (CuptiException e) {
                if (CUptiResult.CUPTI_ERROR_OUT_OF_MEMORY.equals((Object)e.getCuptiResult())) {
                    ViperMessageDialog.openWarning(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ViperMessages.OutOfMemoryWarning_Label, ViperMessages.OutOfMemoryLoadWarning_Message);
                }
                throw new ViperException(e);
            }
            ((InputStream)inputStream).close();
        }
        catch (Exception e) {
            throw new ViperException(e);
        }
        return list;
    }

    public void read(File file) throws ViperException {
        this.read(new File[]{file});
    }

    public void read(File[] files) throws ViperException {
        if (!FileUtils.canLoad(files)) {
            LargeDataMessageDialog.show();
            throw new ViperException("LoadPdmCancel");
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                FileInputStream inputStream = new FileInputStream(file);
                try {
                    NativeCupti.cuptiPDMDeserialize(this.hPdm, inputStream);
                }
                catch (CuptiException e) {
                    if (CUptiResult.CUPTI_ERROR_OUT_OF_MEMORY.equals((Object)e.getCuptiResult())) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ViperMessageDialog.openWarning(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ViperMessages.OutOfMemoryWarning_Label, ViperMessages.OutOfMemoryLoadWarning_Message);
                            }
                        });
                    }
                    throw new ViperException(e);
                }
                ((InputStream)inputStream).close();
            }
            catch (Exception e) {
                throw new ViperException(e);
            }
            ++n2;
        }
    }

    public void readCsv(File file) throws ViperException {
        this.readCsv(new File[]{file});
    }

    public void readCsv(File[] files) throws ViperException {
        this.readFromCsv(files);
    }

    public void readCsv(String[] fileNames) throws ViperException {
        File[] files = new File[fileNames.length];
        int i = 0;
        while (i < fileNames.length) {
            files[i] = new File(fileNames[i]);
            ++i;
        }
        this.readCsv(files);
    }

    protected void readFromCsv(File[] files) throws ViperException {
        try {
            HashSet<Integer> seenDeviceNum = new HashSet<Integer>();
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                seenDeviceNum.clear();
                CsvReader cpr = new CsvReader(new FileInputStream(file), file.getName());
                while (cpr.step()) {
                    int contextNum;
                    int deviceNum = cpr.getCurrentDeviceNum();
                    String deviceName = cpr.getCurrentDeviceName();
                    if (deviceNum == -1 || deviceName == null) {
                        throw new ViperException("Command-line profile data missing device number and name");
                    }
                    if (!seenDeviceNum.contains(deviceNum)) {
                        CuptiActivityDevice activity = new CuptiActivityDevice(deviceNum, deviceName);
                        activity.appendToPDM(this.hPdm);
                        seenDeviceNum.add(deviceNum);
                    }
                    if ((contextNum = cpr.getCurrentContextNum()) == -1) {
                        throw new ViperException("Command-line profile data missing context number");
                    }
                    CuptiActivityComputeApiKind computeKind = cpr.getCurrentComputeKind();
                    CuptiActivityContext contextActivity = new CuptiActivityContext(contextNum, deviceNum, computeKind.getCode());
                    contextActivity.appendToPDM(this.hPdm);
                    String streamName = cpr.getStreamName();
                    if (streamName == null) {
                        throw new ViperException("Command-line profile data missing stream ID, be sure to include \"streamid\" in the profile configuration");
                    }
                    int streamNum = Integer.parseInt(streamName);
                    Long start = cpr.getGpuStartTimestamp();
                    if (start == null) {
                        throw new ViperException("Command-line profile data missing start timestamp, be sure to include \"gpustarttimestamp\" in the profile configuration");
                    }
                    Long length = cpr.getGpuTime();
                    if (length == null) {
                        throw new ViperException("CSV data missing duration");
                    }
                    CuptiActivityBase activity = null;
                    String name = cpr.getMethod();
                    CuptiActivityMemcpyKind memcpyKind = CuptiActivityMemcpyKind.decodeCSV(name);
                    if (memcpyKind != null) {
                        Long memXferSize = cpr.getMemTransferSize();
                        if (memXferSize == null) {
                            memXferSize = -1L;
                        }
                        CuptiActivityMemoryKind srcKind = CuptiActivityMemoryKind.CUPTI_ACTIVITY_MEMORY_KIND_UNKNOWN;
                        CuptiActivityMemoryKind dstKind = CuptiActivityMemoryKind.CUPTI_ACTIVITY_MEMORY_KIND_UNKNOWN;
                        int isAsync = name.endsWith("async") ? 1 : 0;
                        CuptiActivityMemcpy memcpy = new CuptiActivityMemcpy(this.correlationId, deviceNum, contextNum, streamNum, start, start + length, memXferSize, memcpyKind.getCode(), srcKind.getCode(), dstKind.getCode(), isAsync);
                        activity = memcpy;
                    } else {
                        Integer dynaSharedMem;
                        Integer statSharedMem;
                        Integer regPerThread;
                        Integer[] blockSize;
                        CuptiActivityKind kind = CuptiActivityKind.CUPTI_ACTIVITY_KIND_KERNEL;
                        Long gridId = cpr.getGridId();
                        Long parentGridId = cpr.getParentGridId();
                        if (parentGridId != null) {
                            kind = CuptiActivityKind.CUPTI_ACTIVITY_KIND_CDP_KERNEL;
                        }
                        CuptiActivityKernel kernel = new CuptiActivityKernel(kind, gridId == null ? 0L : gridId, parentGridId == null ? 0L : parentGridId, this.correlationId, deviceNum, contextNum, streamNum, start, start + length, name);
                        activity = kernel;
                        Integer[] gridSize = cpr.getGridSize();
                        if (gridSize != null) {
                            if (gridSize[0] != null) {
                                kernel.gridX = gridSize[0];
                            }
                            if (gridSize[1] != null) {
                                kernel.gridY = gridSize[1];
                            }
                            if (gridSize[2] != null) {
                                kernel.gridZ = gridSize[2];
                            }
                        }
                        if ((blockSize = cpr.getBlockSize()) != null) {
                            if (blockSize[0] != null) {
                                kernel.blockX = blockSize[0];
                            }
                            if (blockSize[1] != null) {
                                kernel.blockY = blockSize[1];
                            }
                            if (blockSize[2] != null) {
                                kernel.blockZ = blockSize[2];
                            }
                        }
                        if ((regPerThread = cpr.getRegistersPerThread()) != null) {
                            kernel.regPerThread = regPerThread;
                        }
                        if ((statSharedMem = cpr.getStaticSharedMemory()) != null) {
                            kernel.statSharedMem = statSharedMem;
                        }
                        if ((dynaSharedMem = cpr.getDynamicSharedMemory()) != null) {
                            kernel.dynaSharedMem = dynaSharedMem;
                        }
                        Set<String> eventNames = cpr.getCurrentEvents();
                        for (String eventName : eventNames) {
                            Long value = cpr.getEventValue(eventName);
                            if (value == null) continue;
                            Set<Event> events = EventManager.getEvents(eventName);
                            if (events.isEmpty()) {
                                ViperExceptionHandler.logError("Unknown event \"" + eventName + "\" in CSV");
                                continue;
                            }
                            Event event = events.iterator().next();
                            kernel.setEventValue(event, value);
                        }
                    }
                    activity.appendToPDM(this.hPdm);
                    ++this.correlationId;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            if (e instanceof ViperException) {
                throw (ViperException)e;
            }
            throw new ViperException(e);
        }
    }

    @Override
    public void write(Writer w) throws ViperException {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            GZIPOutputStream zStream = new GZIPOutputStream(outputStream);
            NativeCupti.cuptiPDMSerialize(this.hPdm, zStream);
            zStream.close();
            String str = DatatypeConverter.printBase64Binary((byte[])outputStream.toByteArray());
            w.write("<pdm>\n");
            w.write(str);
            w.write("</pdm>\n");
        }
        catch (Exception e) {
            throw new ViperException(e);
        }
    }
}

