/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.expert.EventTableColumnProvider;
import com.nvidia.viper.model.Event;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Metric;
import com.nvidia.viper.model.ModelWithProperties;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineIntervalKind;
import com.nvidia.viper.model.TimelineIntervalPair;
import com.nvidia.viper.model.TimelineKernel;
import com.nvidia.viper.model.TimelineKind;
import com.nvidia.viper.model.TimelineStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.gef.Disposable;
import org.eclipse.swt.widgets.Display;

public class ExpertData
extends ModelWithProperties
implements Disposable {
    private boolean showFilteredTimelineData;
    private boolean showHiddenTimelineData;
    private boolean filterBySelection = true;
    public static final String PROPERTY_DATA = "expertdata";
    private Session session;
    private Mode mode;
    private Set<Event> events;
    private Set<Metric> metrics;
    private KernelAggregate[] orderedDisplayAggregates;
    private Map<KernelAggregate, Integer> displayAggregateMap;
    private ITimelineInterval[] orderedDisplayIntervals;
    private Map<ITimelineInterval, Integer> displayIntervalMap;
    private Map<TimelineKernel, KernelAggregate> kernelAggregateMap;
    private Set<TimelineIntervalKind> intervalKinds;
    private RefreshThread refreshThread;
    private boolean refreshEvents;
    private boolean refreshMetrics;
    private boolean refreshIntervals;
    private boolean refreshAggregate;

    public ExpertData(Session session) {
        this.session = session;
        this.mode = Mode.INTERVAL;
        this.events = Collections.emptySet();
        this.metrics = Collections.emptySet();
        this.orderedDisplayIntervals = new ITimelineInterval[0];
        this.displayIntervalMap = new HashMap<ITimelineInterval, Integer>(16384);
        this.orderedDisplayAggregates = new KernelAggregate[0];
        this.displayAggregateMap = new HashMap<KernelAggregate, Integer>(256);
        this.kernelAggregateMap = new HashMap<TimelineKernel, KernelAggregate>();
        this.intervalKinds = new HashSet<TimelineIntervalKind>();
        this.showFilteredTimelineData = false;
        this.showHiddenTimelineData = false;
        this.filterBySelection = true;
        this.refresh(false, false);
    }

    public void dispose() {
        this.stopRefreshThread();
        this.session = null;
        this.orderedDisplayAggregates = null;
        this.displayAggregateMap = null;
        this.orderedDisplayIntervals = null;
        this.displayIntervalMap = null;
        this.kernelAggregateMap = null;
    }

    public Session getSession() {
        return this.session;
    }

    public void setShowFilteredTimelineData(boolean showFiltered) {
        this.showFilteredTimelineData = showFiltered;
    }

    public boolean isShowFilteredTimelineData() {
        return this.showFilteredTimelineData;
    }

    public void setFilterBySelection(boolean filterBySelection) {
        this.filterBySelection = filterBySelection;
    }

    public boolean isFilterBySelection() {
        return this.filterBySelection;
    }

    public void setShowHiddenTimelineData(boolean showHiddenTimelineData) {
        this.showHiddenTimelineData = showHiddenTimelineData;
    }

    public boolean isShowHiddenTimelineData() {
        return this.showHiddenTimelineData;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Event> getEvents() {
        ExpertData expertData = this;
        synchronized (expertData) {
            return this.events;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Metric> getMetrics() {
        ExpertData expertData = this;
        synchronized (expertData) {
            return this.metrics;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDisplayResultCnt() {
        ExpertData expertData = this;
        synchronized (expertData) {
            switch (this.mode) {
                case KERNEL_AGGREGATE: {
                    return this.orderedDisplayAggregates.length;
                }
            }
            return this.orderedDisplayIntervals.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getDisplayResults() {
        ExpertData expertData = this;
        synchronized (expertData) {
            switch (this.mode) {
                case KERNEL_AGGREGATE: {
                    return this.orderedDisplayAggregates;
                }
            }
            return this.orderedDisplayIntervals;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KernelAggregate getKernelAggregate(TimelineKernel timeline) {
        ExpertData expertData = this;
        synchronized (expertData) {
            return this.kernelAggregateMap.get(timeline);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasIntervalKind(TimelineIntervalKind kind) {
        ExpertData expertData = this;
        synchronized (expertData) {
            return this.intervalKinds.contains((Object)kind);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsDisplayResult(Object result) {
        ExpertData expertData = this;
        synchronized (expertData) {
            switch (this.mode) {
                case KERNEL_AGGREGATE: {
                    return this.displayAggregateMap.containsKey(result);
                }
            }
            return this.displayIntervalMap.containsKey(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDisplayResult(int index) {
        ExpertData expertData = this;
        synchronized (expertData) {
            switch (this.mode) {
                case KERNEL_AGGREGATE: {
                    if (index < 0 || index >= this.orderedDisplayAggregates.length) break;
                    return this.orderedDisplayAggregates[index];
                }
                default: {
                    if (index < 0 || index >= this.orderedDisplayIntervals.length) break;
                    return this.orderedDisplayIntervals[index];
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDisplayResultIndex(Object result) {
        Integer idx;
        ExpertData expertData = this;
        synchronized (expertData) {
            switch (this.mode) {
                case KERNEL_AGGREGATE: {
                    idx = this.displayAggregateMap.get(result);
                    break;
                }
                default: {
                    idx = this.displayIntervalMap.get(result);
                }
            }
        }
        if (idx == null) {
            return -1;
        }
        return idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortDisplayAggregates(Comparator<Object> comparator) {
        ExpertData expertData = this;
        synchronized (expertData) {
            Arrays.sort(this.orderedDisplayAggregates, comparator);
            int i = 0;
            while (i < this.orderedDisplayAggregates.length) {
                this.displayAggregateMap.put(this.orderedDisplayAggregates[i], i);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortDisplayIntervals(Comparator<Object> comparator) {
        ExpertData expertData = this;
        synchronized (expertData) {
            Arrays.sort(this.orderedDisplayIntervals, comparator);
            int i = 0;
            while (i < this.orderedDisplayIntervals.length) {
                this.displayIntervalMap.put(this.orderedDisplayIntervals[i], i);
                ++i;
            }
        }
    }

    public void sortDisplayResults(Comparator<Object> comparator) {
        switch (this.mode) {
            case KERNEL_AGGREGATE: {
                this.sortDisplayAggregates(comparator);
                break;
            }
            default: {
                this.sortDisplayIntervals(comparator);
            }
        }
    }

    public void refreshEvents(boolean async, boolean notify) {
        try {
            this.stopRefreshThread();
            this.refreshEvents = true;
        }
        finally {
            this.startRefreshThread(async, notify);
        }
    }

    public void refreshMetrics(boolean async, boolean notify) {
        try {
            this.stopRefreshThread();
            this.refreshMetrics = true;
        }
        finally {
            this.startRefreshThread(async, notify);
        }
    }

    public void refreshResults(boolean async, boolean notify) {
        try {
            this.stopRefreshThread();
            this.refreshIntervals = true;
        }
        finally {
            this.startRefreshThread(async, notify);
        }
    }

    public void refresh(boolean async, boolean notify) {
        try {
            this.stopRefreshThread();
            this.refreshEvents = true;
            this.refreshMetrics = true;
            this.refreshIntervals = true;
        }
        finally {
            this.startRefreshThread(async, notify);
        }
    }

    private RefreshThread startRefreshThread(boolean async, boolean notify) {
        if (this.refreshThread != null) {
            this.stopRefreshThread();
        }
        this.refreshThread = new RefreshThread(async, notify);
        this.refreshThread.start();
        if (!async) {
            while (true) {
                try {
                    this.refreshThread.join();
                }
                catch (InterruptedException e) {
                    ViperExceptionHandler.logError("interrupt at start refresh thread join", e);
                    continue;
                }
                break;
            }
        }
        return this.refreshThread;
    }

    private void stopRefreshThread() {
        if (this.refreshThread != null) {
            this.refreshThread.interrupt();
            while (true) {
                try {
                    this.refreshThread.join();
                    this.refreshThread = null;
                }
                catch (InterruptedException e) {
                    ViperExceptionHandler.logError("interrupt at stop refresh thread join", e);
                    continue;
                }
                break;
            }
        }
    }

    static /* synthetic */ boolean access$0(ExpertData expertData) {
        return expertData.refreshAggregate;
    }

    static /* synthetic */ boolean access$1(ExpertData expertData) {
        return expertData.refreshEvents;
    }

    static /* synthetic */ boolean access$2(ExpertData expertData) {
        return expertData.refreshMetrics;
    }

    static /* synthetic */ boolean access$3(ExpertData expertData) {
        return expertData.refreshIntervals;
    }

    static /* synthetic */ void access$4(ExpertData expertData, boolean bl) {
        expertData.refreshAggregate = bl;
    }

    static /* synthetic */ void access$6(ExpertData expertData, Set set) {
        expertData.events = set;
    }

    static /* synthetic */ void access$7(ExpertData expertData, boolean bl) {
        expertData.refreshEvents = bl;
    }

    static /* synthetic */ void access$8(ExpertData expertData, Set set) {
        expertData.metrics = set;
    }

    static /* synthetic */ void access$9(ExpertData expertData, boolean bl) {
        expertData.refreshMetrics = bl;
    }

    static /* synthetic */ Set access$10(ExpertData expertData) {
        return expertData.intervalKinds;
    }

    static /* synthetic */ Map access$11(ExpertData expertData) {
        return expertData.displayIntervalMap;
    }

    static /* synthetic */ void access$12(ExpertData expertData, ITimelineInterval[] iTimelineIntervalArray) {
        expertData.orderedDisplayIntervals = iTimelineIntervalArray;
    }

    static /* synthetic */ void access$13(ExpertData expertData, Comparator comparator) {
        expertData.sortDisplayIntervals(comparator);
    }

    static /* synthetic */ void access$14(ExpertData expertData, boolean bl) {
        expertData.refreshIntervals = bl;
    }

    static /* synthetic */ Map access$15(ExpertData expertData) {
        return expertData.kernelAggregateMap;
    }

    static /* synthetic */ Map access$16(ExpertData expertData) {
        return expertData.displayAggregateMap;
    }

    static /* synthetic */ void access$17(ExpertData expertData, KernelAggregate[] kernelAggregateArray) {
        expertData.orderedDisplayAggregates = kernelAggregateArray;
    }

    static /* synthetic */ void access$18(ExpertData expertData, Comparator comparator) {
        expertData.sortDisplayAggregates(comparator);
    }

    public class KernelAggregate {
        private final String name;
        private Set<TimelineKernel> timelines = new HashSet<TimelineKernel>();
        private List<TimelineIntervalPair> aggregatePairs = new LinkedList<TimelineIntervalPair>();
        private int numIntervals;
        private long avgDuration;
        private Integer regsPerThread;
        private Integer staticSharedMemory;
        private Integer avgDynamicSharedMemory;
        private Map<Event, ValueRef> events;
        private Map<Metric, ValueRef> metrics;

        public KernelAggregate(String name) {
            this.name = name;
            this.events = new HashMap<Event, ValueRef>();
            this.metrics = new HashMap<Metric, ValueRef>();
        }

        public String getName() {
            return this.name;
        }

        public Collection<TimelineKernel> getTimelines() {
            return this.timelines;
        }

        public int getNumIntervals() {
            return this.numIntervals;
        }

        public long getAverageDuration() {
            return this.avgDuration;
        }

        public Integer getRegistersPerThread() {
            return this.regsPerThread;
        }

        public Integer getStaticSharedMemory() {
            return this.staticSharedMemory;
        }

        public Integer getAverageDynamicSharedMemory() {
            return this.avgDynamicSharedMemory;
        }

        public boolean addAggregateItem(TimelineIntervalPair pair) {
            Timeline timeline = pair.getTimeline();
            if (!(timeline instanceof TimelineKernel)) {
                return false;
            }
            this.timelines.add((TimelineKernel)timeline);
            return this.aggregatePairs.add(pair);
        }

        public void calcAggregate() {
            this.numIntervals = 0;
            this.avgDynamicSharedMemory = 0;
            this.avgDuration = this.avgDynamicSharedMemory.intValue();
            this.regsPerThread = this.staticSharedMemory = Integer.valueOf(0);
            this.events.clear();
            this.metrics.clear();
            for (TimelineIntervalPair pair : this.aggregatePairs) {
                if (pair.getInterval() == null) {
                    for (ITimelineInterval interval : pair.getTimeline().getVisibleIntervals()) {
                        this.calcAggregateInterval(interval);
                    }
                    continue;
                }
                this.calcAggregateInterval(pair.getInterval());
            }
            if (this.numIntervals > 0) {
                this.avgDuration /= (long)this.numIntervals;
                if (this.avgDynamicSharedMemory != null) {
                    this.avgDynamicSharedMemory = this.avgDynamicSharedMemory / this.numIntervals;
                }
            }
        }

        private void calcAggregateInterval(ITimelineInterval interval) {
            if (interval instanceof TimelineIntervalKernel) {
                ValueRef ev;
                TimelineIntervalKernel kernel = (TimelineIntervalKernel)interval;
                ++this.numIntervals;
                this.avgDuration += kernel.getDuration();
                if (this.avgDynamicSharedMemory != null) {
                    Integer n = this.avgDynamicSharedMemory = kernel.getDynamicSharedMemory() == null ? null : Integer.valueOf(this.avgDynamicSharedMemory + kernel.getDynamicSharedMemory());
                }
                if (this.regsPerThread != null) {
                    this.regsPerThread = kernel.getRegistersPerThread();
                }
                if (this.staticSharedMemory != null) {
                    this.staticSharedMemory = kernel.getStaticSharedMemory();
                }
                for (Event event : kernel.getEvents()) {
                    Long eventVal;
                    ev = this.events.get(event);
                    if (ev == null) {
                        ev = new ValueRef();
                        this.events.put(event, ev);
                    }
                    if ((eventVal = kernel.getEventValue(event)) == null || eventVal < 0L) continue;
                    ValueRef valueRef = ev;
                    valueRef.count = valueRef.count + 1L;
                    ValueRef valueRef2 = ev;
                    valueRef2.longValue = valueRef2.longValue + eventVal;
                }
                for (Metric metric : kernel.getAggregateMetrics()) {
                    Number metricVal;
                    ev = this.metrics.get(metric);
                    if (ev == null) {
                        ev = new ValueRef();
                        this.metrics.put(metric, ev);
                    }
                    if ((metricVal = kernel.getAggregateMetricValue(metric)) == null) continue;
                    if (metric.getValueKind().isLongValue()) {
                        if (metricVal.longValue() < 0L) continue;
                        ValueRef valueRef = ev;
                        valueRef.longValue = valueRef.longValue + metricVal.longValue();
                        ValueRef valueRef3 = ev;
                        valueRef3.count = valueRef3.count + 1L;
                        continue;
                    }
                    if (!(metricVal.doubleValue() >= 0.0)) continue;
                    ValueRef valueRef = ev;
                    valueRef.doubleValue = valueRef.doubleValue + metricVal.doubleValue();
                    ValueRef valueRef4 = ev;
                    valueRef4.count = valueRef4.count + 1L;
                }
            }
        }

        public Long getAverageEventValue(Event event) {
            ValueRef lr = this.events.get(event);
            if (lr != null) {
                if (lr.count <= 0L) {
                    return null;
                }
                return lr.longValue / lr.count;
            }
            return null;
        }

        public Number getAverageMetricValue(Metric metric) {
            ValueRef lr = this.metrics.get(metric);
            if (lr != null) {
                if (lr.count <= 0L) {
                    return null;
                }
                if (metric.getValueKind().isLongValue()) {
                    return lr.longValue / lr.count;
                }
                return lr.doubleValue / (double)lr.count;
            }
            return null;
        }

        private class ValueRef {
            private long count = 0L;
            private long longValue = 0L;
            private double doubleValue = 0.0;

            private ValueRef() {
            }
        }
    }

    public static enum Mode {
        INTERVAL,
        KERNEL_AGGREGATE;

    }

    private class RefreshThread
    extends Thread {
        private boolean async;
        private boolean notify;

        public RefreshThread(boolean async, boolean notify) {
            super("ExpertData Refresh");
            this.async = async;
            this.notify = notify;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Could not resolve type clashes
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block36: {
                block37: {
                    block38: {
                        block34: {
                            block35: {
                                block33: {
                                    change = false;
                                    if (this.async) {
                                        RefreshThread.sleep(100L);
                                    }
                                    v0 = ExpertData.this;
                                    ExpertData.access$4(v0, ExpertData.access$0(v0) | (ExpertData.access$1(ExpertData.this) != false || ExpertData.access$2(ExpertData.this) != false || ExpertData.access$3(ExpertData.this) != false));
                                    if (ExpertData.access$1(ExpertData.this)) {
                                        newEvents = new HashSet<Event>();
                                        for (Object timeline : ExpertData.access$5(ExpertData.this).getTimelines()) {
                                            newEvents.addAll(timeline.getEvents());
                                        }
                                        timeline = this;
                                        synchronized (timeline) {
                                            ExpertData.access$6(ExpertData.this, Collections.unmodifiableSet(newEvents));
                                        }
                                        ExpertData.access$7(ExpertData.this, false);
                                        change = true;
                                    }
                                    if (!this.isInterrupted()) break block33;
lbl23:
                                    // 3 sources

                                    while (true) {
                                        if (this.notify && change) {
                                            Display.getDefault().asyncExec(new Runnable(){

                                                @Override
                                                public void run() {
                                                    ExpertData.this.firePropertyChange(ExpertData.PROPERTY_DATA);
                                                }
                                            });
                                        }
                                        return;
                                    }
                                }
                                if (ExpertData.access$2(ExpertData.this)) {
                                    newMetrics = new HashSet<Metric>();
                                    for (Object timeline : ExpertData.access$5(ExpertData.this).getTimelines()) {
                                        newMetrics.addAll(timeline.getAggregateMetrics());
                                    }
                                    timeline = this;
                                    synchronized (timeline) {
                                        ExpertData.access$8(ExpertData.this, Collections.unmodifiableSet(newMetrics));
                                    }
                                    ExpertData.access$9(ExpertData.this, false);
                                    change = true;
                                }
                                if (this.isInterrupted()) ** GOTO lbl23
                                if (!ExpertData.access$3(ExpertData.this)) ** GOTO lbl70
                                iset = this.getDataIntervals();
                                if (!this.isInterrupted()) break block34;
                                if (!this.notify || !change) break block35;
                                Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
                            }
                            return;
                        }
                        timeline = this;
                        synchronized (timeline) {
                            ExpertData.access$10(ExpertData.this).clear();
                            for (Object interval : iset) {
                                ExpertData.access$10(ExpertData.this).add(interval.getKind());
                            }
                            ExpertData.access$11(ExpertData.this).clear();
                            ExpertData.access$12(ExpertData.this, iset.toArray(new ITimelineInterval[0]));
                            ExpertData.access$13(ExpertData.this, EventTableColumnProvider.ColumnKind.START_TIME.getComparator(128, null));
                        }
                        ExpertData.access$14(ExpertData.this, false);
                        change = true;
lbl70:
                        // 2 sources

                        if (this.isInterrupted()) ** continue;
                        if (!ExpertData.access$0(ExpertData.this)) break block36;
                        agg = new HashMap<String, KernelAggregate>();
                        for (TimelineIntervalPair pair : this.getAggregateDataIntervals()) {
                            if (pair.getTimeline() == null) continue;
                            timeline = pair.getTimeline();
                            ta = (KernelAggregate)agg.get(timeline.getIdentifyingName());
                            if (ta == null) {
                                ta = new KernelAggregate(timeline.getDisplayName(false));
                                agg.put(timeline.getIdentifyingName(), ta);
                            }
                            ta.addAggregateItem(pair);
                        }
                        if (!this.isInterrupted()) break block37;
                        if (!this.notify || !change) break block38;
                        Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
                    }
                    return;
                }
                try {
                    try {
                        var3_4 = this;
                        synchronized (var3_4) {
                            ExpertData.access$15(ExpertData.this).clear();
                            for (KernelAggregate ta : agg.values()) {
                                ta.calcAggregate();
                                for (TimelineKernel timeline : ta.getTimelines()) {
                                    ExpertData.access$15(ExpertData.this).put(timeline, ta);
                                }
                            }
                            ExpertData.access$16(ExpertData.this).clear();
                            ExpertData.access$17(ExpertData.this, agg.values().toArray(new KernelAggregate[0]));
                            ExpertData.access$18(ExpertData.this, EventTableColumnProvider.ColumnKind.AVG_DURATION.getComparator(128, null));
                        }
                        ExpertData.access$4(ExpertData.this, false);
                        change = true;
                    }
                    catch (InterruptedException v5) {
                        if (!this.notify || !change) ** GOTO lbl123
                        Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
                    }
                }
                catch (Throwable var8_8) {
                    if (this.notify && change) {
                        Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
                    }
                    throw var8_8;
                }
            }
            if (this.notify && change) {
                Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
            }
lbl123:
            // 5 sources

        }

        private Collection<ITimelineInterval> getDataIntervals() {
            HashSet<ITimelineInterval> ftl;
            block7: {
                ftl = new HashSet<ITimelineInterval>();
                if (ExpertData.this.session == null) break block7;
                Collection<TimelineIntervalPair> allSelected = ExpertData.this.session.getAllSelected();
                if (ExpertData.this.filterBySelection && allSelected != null) {
                    for (TimelineIntervalPair selected : allSelected) {
                        ITimelineInterval interval = selected.getInterval();
                        if (interval != null) {
                            if (!this.isDataTimeline(interval.getPrimaryTimeline(), ExpertData.this.showHiddenTimelineData, ExpertData.this.showFilteredTimelineData)) continue;
                            ftl.add(interval);
                            continue;
                        }
                        if (this.isDataTimeline(selected.getTimeline(), true, true)) {
                            ftl.addAll(selected.getTimeline().getVisibleIntervals());
                            continue;
                        }
                        Timeline timeline = selected.getTimeline();
                        if (!(timeline instanceof TimelineStream)) continue;
                        for (ITimelineInterval sInterval : timeline.getIntervals()) {
                            if (!this.isDataTimeline(sInterval.getPrimaryTimeline(), true, ExpertData.this.showFilteredTimelineData)) continue;
                            ftl.add(sInterval);
                        }
                    }
                } else {
                    for (Timeline timeline : ExpertData.this.session.getTimelines()) {
                        if (!this.isDataTimeline(timeline, ExpertData.this.showHiddenTimelineData, ExpertData.this.showFilteredTimelineData)) continue;
                        ftl.addAll(timeline.getVisibleIntervals());
                    }
                }
            }
            return ftl;
        }

        private Collection<TimelineIntervalPair> getAggregateDataIntervals() {
            HashSet<TimelineIntervalPair> ftl;
            block5: {
                ftl = new HashSet<TimelineIntervalPair>();
                if (ExpertData.this.session == null) break block5;
                Collection<TimelineIntervalPair> allSelected = ExpertData.this.session.getAllSelected();
                if (ExpertData.this.filterBySelection && allSelected != null) {
                    for (TimelineIntervalPair selected : allSelected) {
                        ITimelineInterval interval = selected.getInterval();
                        if (interval != null) {
                            if (!this.isAggregateDataTimeline(interval.getPrimaryTimeline(), ExpertData.this.showHiddenTimelineData, ExpertData.this.showFilteredTimelineData)) continue;
                            ftl.add(new TimelineIntervalPair(interval.getPrimaryTimeline(), interval));
                            continue;
                        }
                        if (!this.isAggregateDataTimeline(selected.getTimeline(), true, true)) continue;
                        ftl.add(new TimelineIntervalPair(selected.getTimeline(), null));
                    }
                } else {
                    for (Timeline timeline : ExpertData.this.session.getTimelines()) {
                        if (!this.isAggregateDataTimeline(timeline, ExpertData.this.showHiddenTimelineData, ExpertData.this.showFilteredTimelineData)) continue;
                        ftl.add(new TimelineIntervalPair(timeline, null));
                    }
                }
            }
            return ftl;
        }

        private boolean isDataTimeline(Timeline timeline, boolean ignoreVisible, boolean ignoreFilter) {
            if (timeline != null && (ignoreVisible || timeline.isVisible()) && (ignoreFilter || !timeline.isFiltered())) {
                switch (timeline.getKind()) {
                    case MEMCPY_HTOD: 
                    case MEMCPY_DTOH: 
                    case MEMCPY_DTOD: 
                    case MEMCPY_PTOP: 
                    case KERNEL: {
                        return true;
                    }
                }
            }
            return false;
        }

        private boolean isAggregateDataTimeline(Timeline timeline, boolean ignoreVisible, boolean ignoreFilter) {
            return this.isDataTimeline(timeline, ignoreVisible, ignoreFilter) && TimelineKind.KERNEL.equals((Object)timeline.getKind());
        }
    }
}

