/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.jni.CuptiEventCategory;
import com.nvidia.viper.model.Event;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class EventCategory
implements Comparable<EventCategory> {
    public static final String MISC_CATEGORY_NAME = "Misc";
    private CuptiEventCategory category;
    private Set<Event> events;

    public EventCategory(CuptiEventCategory category) {
        this.category = category;
        this.events = new HashSet<Event>();
    }

    public String getDisplayName() {
        switch (this.category) {
            case CUPTI_EVENT_CATEGORY_MEMORY: {
                return "Memory";
            }
            case CUPTI_EVENT_CATEGORY_INSTRUCTION: {
                return "Instruction";
            }
            case CUPTI_EVENT_CATEGORY_CACHE: {
                return "Cache";
            }
            case CUPTI_EVENT_CATEGORY_PROFILE_TRIGGER: {
                return "Profile Trigger";
            }
        }
        return MISC_CATEGORY_NAME;
    }

    public Set<Event> getEvents() {
        return Collections.unmodifiableSet(this.events);
    }

    public void addEvent(Event event) {
        this.events.add(event);
    }

    public int hashCode() {
        return (this.category.hashCode() + 1) * 31;
    }

    public boolean equals(Object other) {
        if (!(other instanceof EventCategory)) {
            return false;
        }
        return this.category.equals((Object)((EventCategory)other).category);
    }

    @Override
    public int compareTo(EventCategory other) {
        return this.category.compareTo(other.category);
    }
}

