/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.expertsystem;

import com.nvidia.viper.StringUtils;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultKernelPriority;
import com.nvidia.viper.analysis.AnalysisScope;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.expertsystem.IExpertSystemStage;
import com.nvidia.viper.model.ExpertSystem;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineIntervalPair;
import java.util.List;
import org.eclipse.gef.Disposable;

public abstract class BaseStage
implements IExpertSystemStage,
Disposable {
    private ExpertSystem expertSystem;

    @Override
    public ExpertSystem getExpertSystem() {
        return this.expertSystem;
    }

    public BaseStage(ExpertSystem expertSystem) {
        this.expertSystem = expertSystem;
    }

    public void dispose() {
        this.expertSystem = null;
    }

    @Override
    public boolean isStepCompleted(int stepIdx) {
        return false;
    }

    @Override
    public boolean canPerformStep(int stepIdx) {
        return true;
    }

    @Override
    public boolean propertyChange(String propertyName) {
        return false;
    }

    public String getTruncatedName(ITimelineInterval interval, int maxChars) {
        int idx;
        String name = interval.getDisplayName();
        if (interval instanceof TimelineIntervalKernel && (idx = name.indexOf(40)) >= 0) {
            name = name.substring(0, idx);
        }
        if (name != null && !name.isEmpty()) {
            name = StringUtils.getBoundedText(name, maxChars);
        }
        return name;
    }

    protected ITimelineInterval getSelectedInDepthKernel() {
        Session session;
        TimelineIntervalPair primary;
        ITimelineInterval kernel = null;
        if (this.getExpertSystem() != null && this.getExpertSystem().getSession() != null && (primary = (session = this.getExpertSystem().getSession()).getPrimarySelected()) != null && primary.getInterval() != null && AnalysisScope.KERNEL_INSTANCE.isEnabled(primary.getInterval())) {
            if (session.getSecondarySelected() == null || session.getSecondarySelected().isEmpty()) {
                kernel = primary.getInterval();
            } else if (session.getAnalysis() != null) {
                List<AnalysisResult> priorityResults = session.getAnalysis().getAnalysisResults(AnalysisStage.KERNELS, AnalysisResultKernelPriority.class);
                for (AnalysisResult result : priorityResults) {
                    AnalysisResultKernelPriority priorityResult = (AnalysisResultKernelPriority)result;
                    AnalysisResultKernelPriority.PriorityRecord primaryRecord = priorityResult.getPriorityRecord(primary.getInterval());
                    if (primaryRecord == null) continue;
                    boolean foundAll = true;
                    for (TimelineIntervalPair secondary : session.getSecondarySelected()) {
                        AnalysisResultKernelPriority.PriorityRecord record = priorityResult.getPriorityRecord(secondary.getInterval());
                        if (record == primaryRecord) continue;
                        foundAll = false;
                        break;
                    }
                    if (!foundAll) continue;
                    kernel = primary.getInterval();
                    break;
                }
            }
        }
        return kernel;
    }
}

