/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.editor;

import com.nvidia.viper.FileUtils;
import com.nvidia.viper.ViperColors;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.actions.BarColumnAction;
import com.nvidia.viper.actions.ExecCountColumnAction;
import com.nvidia.viper.activity.CuptiActivitySourceLocator;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.editor.BarChartColumn;
import com.nvidia.viper.editor.InstExecutedColumn;
import com.nvidia.viper.editor.SourceSassEditorInput;
import com.nvidia.viper.editor.config.CudaViewerConfiguration;
import com.nvidia.viper.editor.config.SassViewerConfiguration;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionPropertyChangeListener;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.SourceSassModel;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineIntervalPair;
import com.nvidia.viper.ui.CudaViewer;
import com.nvidia.viper.ui.SassViewer;
import com.nvidia.viper.ui.ViperViewerBase;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;

public class SourceSassEditor
extends EditorPart {
    private CudaViewer cudaViewer;
    private SassViewer sassViewer;
    private Document sassDocument;
    private Session session;
    private SourceSassModel sourceSassModel;
    private SashForm sashForm;
    private int SASH_FORM_WIDTH = 5;
    private int OVERVIEW_WIDTH = 12;
    private int ANNOTATION_RULER_WIDTH = 10;
    private String cudaFileName;
    private Label labelSourceCol;
    private Composite cudaViewerControl;
    private Composite sassViewerControl;
    private final String labelTextFormat = "File - %s";
    private Button selectNextButton;
    private Button selectPreviousButton;
    private IPartListener2 partListener = new IPartListener2(){

        public void partVisible(IWorkbenchPartReference partRef) {
            if (partRef != null) {
                this.handleNewActivePart(partRef.getPart(true));
            }
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        private void handleNewActivePart(IWorkbenchPart part) {
            SourceSassEditor editor;
            if (part != null && part instanceof SourceSassEditor && (editor = (SourceSassEditor)part) == SourceSassEditor.this) {
                IEditorInput editorInput = editor.getEditorInput();
                if (editorInput instanceof SourceSassEditorInput) {
                    SourceSassEditorInput sourceSassInput = (SourceSassEditorInput)editorInput;
                    TimelineIntervalKernel interval = sourceSassInput.getKernelInterval();
                    Timeline timeline = interval.getPrimaryTimeline();
                    TimelineIntervalPair newSelection = new TimelineIntervalPair(timeline, interval);
                    SourceSassEditor.this.session.setPrimarySelected(newSelection, true);
                    Analysis analysis = SourceSassEditor.this.session.getAnalysis();
                    analysis.setGuidedMode(false);
                    analysis.setSelectedStage(AnalysisStage.KERNEL_INSTANCE_INSTRUCTION_EXECUTION);
                }
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.nvidia.viper.analysisview");
                        }
                        catch (PartInitException partInitException) {
                            ViperExceptionHandler.logError("unable to show analysis view");
                        }
                    }
                });
            }
        }
    };

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
        this.sourceSassModel = ((SourceSassEditorInput)input).getSourceSassModel();
        this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.partListener);
        if (this.sourceSassModel != null) {
            this.sourceSassModel.addPropertyChangeListener(new ISessionPropertyChangeListener(){

                @Override
                public void propertyChange(IModel model, String propertyName) {
                    if (propertyName.equals("sourcesassmodel:updated")) {
                        SourceSassEditor.this.updateCudaViewOnFileChange();
                    }
                }
            });
            this.session = this.sourceSassModel.getSession();
        }
    }

    private String resolveFilePathInViewer(CuptiActivitySourceLocator sourceLocator) {
        String fileName = FileUtils.resolveFilePathInBrowser(sourceLocator, this.session);
        if (fileName != null) {
            this.cudaFileName = sourceLocator.fileName;
            this.cudaViewer.setFileName(fileName);
            this.labelSourceCol.setText(String.format("File - %s", fileName));
            this.labelSourceCol.setToolTipText(fileName);
        } else {
            this.cudaViewer.highlightLine(-1);
        }
        return fileName;
    }

    protected void setInputWithNotify(IEditorInput input) {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.sashForm = new SashForm(parent, 256);
        this.sashForm.setLayout((Layout)new RowLayout());
        this.sashForm.setSashWidth(this.SASH_FORM_WIDTH);
        this.createCudaViewerControl();
        this.createSassViewerControl();
        this.updateViews();
    }

    private void createSassViewerControl() {
        this.sassViewerControl = new Composite((Composite)this.sashForm, 2048);
        GridLayout mainLayout = new GridLayout(6, false);
        mainLayout.marginWidth = 0;
        mainLayout.verticalSpacing = 0;
        mainLayout.marginHeight = 0;
        this.sassViewerControl.setLayout((Layout)mainLayout);
        Label label = new Label(this.sassViewerControl, 0);
        GridData data = new GridData(this.ANNOTATION_RULER_WIDTH, -1);
        label.setLayoutData((Object)data);
        Label labelBarChart = new Label(this.sassViewerControl, 0);
        GridData gridDataBarChart = new GridData(50, -1);
        labelBarChart.setLayoutData((Object)gridDataBarChart);
        Label labelExecCount = new Label(this.sassViewerControl, 0);
        GridData gridDataExecCount = new GridData(-1, -1);
        labelExecCount.setLayoutData((Object)gridDataExecCount);
        labelExecCount.setText("Exec Count");
        labelExecCount.setToolTipText(ViperMessages.SassExecCount_Tooltip);
        label = new Label(this.sassViewerControl, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label.setText("Disassembly");
        this.selectNextButton = this.addButtonInSassViewer(1024);
        this.selectNextButton.setToolTipText(ViperMessages.SelectNextInstructionButton_Tooltip);
        this.selectPreviousButton = this.addButtonInSassViewer(128);
        this.selectPreviousButton.setToolTipText(ViperMessages.SelectPrevInstructionButton_Tooltip);
        CompositeRuler viewRuler = new CompositeRuler();
        viewRuler.addDecorator(0, (IVerticalRulerColumn)new AnnotationRulerColumn(this.ANNOTATION_RULER_WIDTH));
        viewRuler.addDecorator(1, (IVerticalRulerColumn)new BarChartColumn());
        viewRuler.addDecorator(2, (IVerticalRulerColumn)SourceSassEditor.createInstructionsExecutedColumn(this.sassViewerControl, gridDataExecCount));
        DefaultMarkerAnnotationAccess annotationAccess = new DefaultMarkerAnnotationAccess();
        AnnotationModel annotationModel = new AnnotationModel();
        OverviewRuler overviewRuler = new OverviewRuler((IAnnotationAccess)annotationAccess, this.OVERVIEW_WIDTH, (ISharedTextColors)new SharedColor());
        this.sassViewer = new SassViewer(this, this.sassViewerControl, (IVerticalRuler)viewRuler, (IOverviewRuler)overviewRuler, true, 68354);
        this.sassViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 6, 1));
        this.sassDocument = new Document();
        this.sassViewer.setDocument((IDocument)this.sassDocument, (IAnnotationModel)annotationModel);
        this.sassViewer.configure(new SassViewerConfiguration());
        this.setupAnnotation((ISourceViewer)this.sassViewer, overviewRuler, annotationModel);
        MenuManager manager = new MenuManager();
        Menu menu = manager.createContextMenu(viewRuler.getControl());
        viewRuler.getControl().setMenu(menu);
        manager.add((IAction)this.getBarColAction(this.sassViewerControl, viewRuler, gridDataBarChart, labelBarChart, "ShowBarColSass", 1));
        manager.add((IAction)this.getExecCountColAction(this.sassViewerControl, viewRuler, gridDataExecCount, labelExecCount, "ShowExecCountColSass", 2));
    }

    private Button addButtonInSassViewer(final int style) {
        Button but = new Button(this.sassViewerControl, 4 | style);
        but.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (style == 1024) {
                    SourceSassEditor.this.sassViewer.selectNext();
                } else if (style == 128) {
                    SourceSassEditor.this.sassViewer.selectPrevious();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        but.setLayoutData((Object)new GridData(25, 25));
        return but;
    }

    public Button getSelectNextButton() {
        return this.selectNextButton;
    }

    public Button getSelectPreviousButton() {
        return this.selectPreviousButton;
    }

    private void createCudaViewerControl() {
        this.cudaViewerControl = new Composite((Composite)this.sashForm, 2048);
        GridLayout mainLayout = new GridLayout(4, false);
        mainLayout.marginWidth = 0;
        this.cudaViewerControl.setLayout((Layout)mainLayout);
        Label label = new Label(this.cudaViewerControl, 0);
        final GridData lineColGrid = new GridData(-1, -1);
        label.setLayoutData((Object)lineColGrid);
        label.setText("Line");
        Label labelBarChart = new Label(this.cudaViewerControl, 0);
        GridData gridDataBarChart = new GridData(50, -1);
        labelBarChart.setLayoutData((Object)gridDataBarChart);
        Label labelExecCount = new Label(this.cudaViewerControl, 0);
        GridData gridDataExecCount = new GridData(-1, -1);
        labelExecCount.setLayoutData((Object)gridDataExecCount);
        labelExecCount.setText("Exec Count");
        labelExecCount.setToolTipText(ViperMessages.CudaExecCount_Tooltip);
        this.labelSourceCol = new Label(this.cudaViewerControl, 0);
        this.labelSourceCol.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        CompositeRuler viewRuler = new CompositeRuler();
        final LineNumberRulerColumn lineCol = new LineNumberRulerColumn();
        viewRuler.addDecorator(0, (IVerticalRulerColumn)lineCol);
        viewRuler.addDecorator(1, (IVerticalRulerColumn)new BarChartColumn());
        viewRuler.addDecorator(2, (IVerticalRulerColumn)SourceSassEditor.createInstructionsExecutedColumn(this.cudaViewerControl, gridDataExecCount));
        DefaultMarkerAnnotationAccess annotationAccess = new DefaultMarkerAnnotationAccess();
        AnnotationModel annotationModel = new AnnotationModel();
        OverviewRuler overviewRuler = new OverviewRuler((IAnnotationAccess)annotationAccess, this.OVERVIEW_WIDTH, (ISharedTextColors)new SharedColor());
        this.cudaViewer = new CudaViewer(this, this.cudaViewerControl, (IVerticalRuler)viewRuler, (IOverviewRuler)overviewRuler, true, 68354);
        this.cudaViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.cudaViewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                SourceSassEditor.this.cudaViewer.clear();
                lineColGrid.widthHint = lineCol.getWidth() + 5;
                SourceSassEditor.this.cudaViewerControl.layout();
            }
        });
        this.cudaViewer.setDocument((IDocument)new Document(), (IAnnotationModel)annotationModel);
        this.cudaViewer.configure(new CudaViewerConfiguration());
        this.setupAnnotation((ISourceViewer)this.cudaViewer, overviewRuler, annotationModel);
        MenuManager manager = new MenuManager();
        Menu menu = manager.createContextMenu(viewRuler.getControl());
        viewRuler.getControl().setMenu(menu);
        manager.add((IAction)this.getBarColAction(this.cudaViewerControl, viewRuler, gridDataBarChart, labelBarChart, "ShowBarColCuda", 1));
        manager.add((IAction)this.getExecCountColAction(this.cudaViewerControl, viewRuler, gridDataExecCount, labelExecCount, "ShowExecCountColCuda", 2));
    }

    private Action getBarColAction(Composite viewerControl, CompositeRuler viewRuler, GridData gridDataBarChart, Label labelBarChart, String pref, int index) {
        BarColumnAction action = new BarColumnAction(viewerControl, viewRuler, gridDataBarChart, labelBarChart, pref, index);
        action.run();
        return action;
    }

    private Action getExecCountColAction(Composite viewerControl, CompositeRuler viewRuler, GridData gridDataExecCount, Label labelExecCount, String pref, int index) {
        ExecCountColumnAction action = new ExecCountColumnAction(viewerControl, viewRuler, gridDataExecCount, labelExecCount, pref, index);
        action.run();
        return action;
    }

    public static InstExecutedColumn createInstructionsExecutedColumn(final Composite viewerControl, final GridData gridDataExecCount) {
        final InstExecutedColumn instExecCudaColumn = new InstExecutedColumn();
        instExecCudaColumn.addListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("InstExecutedColumn:width")) {
                    gridDataExecCount.widthHint = instExecCudaColumn.getWidth();
                    viewerControl.layout();
                }
            }
        });
        return instExecCudaColumn;
    }

    private void updateCudaViewOnFileChange() {
        CuptiActivitySourceLocator locator = this.sourceSassModel.getLocatorToOpen();
        if (!locator.fileName.equals(this.cudaFileName) && this.resolveFilePathInViewer(locator) != null) {
            this.updateCudaView();
        }
        this.cudaViewer.selectMaxExecCountLine();
    }

    private void setupAnnotation(ISourceViewer viewer, OverviewRuler overviewRuler, AnnotationModel annotationModel) {
        AnnotationType[] annotationTypes = AnnotationType.values();
        int i = annotationTypes.length - 1;
        while (i >= 0) {
            AnnotationType annotationType = annotationTypes[i];
            overviewRuler.addAnnotationType((Object)annotationType.getType());
            overviewRuler.setAnnotationTypeLayer((Object)annotationType.getType(), 3);
            overviewRuler.setAnnotationTypeColor((Object)annotationType.getType(), annotationType.getColor());
            --i;
        }
        overviewRuler.setModel((IAnnotationModel)annotationModel);
    }

    public void highlightSassLines(int cudaLine) {
        List<Integer> sassLines = this.getSassLines(cudaLine);
        if (sassLines != null && sassLines.size() > 0) {
            this.sassViewer.highlightLines(sassLines);
        } else {
            this.sassViewer.highlightLines(null);
        }
    }

    public long getInstructionExecutedSass(int sassLine) {
        if (this.sassViewer != null) {
            return this.sassViewer.getInstructionExecuted(sassLine);
        }
        return -1L;
    }

    public long getThreadInstExecutedSass(int sassLine) {
        if (this.sassViewer != null) {
            return this.sassViewer.getThreadInstructionExecuted(sassLine);
        }
        return -1L;
    }

    public long getNoPredicateOffSass(int sassLine) {
        if (this.sassViewer != null) {
            return this.sassViewer.getNoPredicateOff(sassLine);
        }
        return -1L;
    }

    public List<Integer> getSassLines(int cudaLine) {
        return this.sourceSassModel.getSassLines(this.cudaFileName, cudaLine + 1);
    }

    public void highlightCudaLines(int sassLine) {
        int cudaLine = -1;
        CuptiActivitySourceLocator locator = this.sourceSassModel.getSourceLocator(sassLine);
        if (locator == null) {
            this.cudaViewer.highlightLine(-1);
            return;
        }
        cudaLine = locator.lineNumber - 1;
        if (!locator.fileName.equals(this.cudaFileName)) {
            if (this.resolveFilePathInViewer(locator) == null) {
                return;
            }
            this.updateCudaView();
        }
        this.cudaViewer.highlightLine(cudaLine);
        if (cudaLine < this.cudaViewer.getTopIndex() || cudaLine > this.cudaViewer.getBottomIndex()) {
            this.cudaViewer.setTopIndex(cudaLine);
        }
    }

    public void updateViews() {
        this.updateSassView();
        this.updateCudaViewOnFileChange();
    }

    private void updateSassView() {
        this.sassDocument.set(this.sourceSassModel.getSassDocumentString());
        this.updateAnnotations(this.sassViewer);
    }

    private void updateCudaView() {
        if (this.cudaViewer != null && this.cudaViewer.getFileName() != null) {
            this.cudaViewer.removeCaretListener();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    block11: {
                        ITextFileBufferManager mgr = FileBuffers.getTextFileBufferManager();
                        Path path = new Path(SourceSassEditor.this.cudaViewer.getFileName());
                        try {
                            try {
                                mgr.connect((IPath)path, LocationKind.LOCATION, null);
                                ITextFileBuffer buff = mgr.getTextFileBuffer((IPath)path, LocationKind.LOCATION);
                                IAnnotationModel annotationModel = SourceSassEditor.this.cudaViewer.getAnnotationModel();
                                SourceSassEditor.this.cudaViewer.setDocument(buff.getDocument(), annotationModel);
                            }
                            catch (CoreException e) {
                                ViperExceptionHandler.handle("File not found", "The file '" + path.toOSString() + "' could not found", (Exception)((Object)e));
                                try {
                                    mgr.disconnect((IPath)path, LocationKind.LOCATION, null);
                                }
                                catch (CoreException coreException) {
                                    ViperExceptionHandler.logError("couldn't disconnect FileBufferManager");
                                }
                                break block11;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                mgr.disconnect((IPath)path, LocationKind.LOCATION, null);
                            }
                            catch (CoreException coreException) {
                                ViperExceptionHandler.logError("couldn't disconnect FileBufferManager");
                            }
                            throw throwable;
                        }
                        try {
                            mgr.disconnect((IPath)path, LocationKind.LOCATION, null);
                        }
                        catch (CoreException coreException) {
                            ViperExceptionHandler.logError("couldn't disconnect FileBufferManager");
                        }
                    }
                }
            });
            this.updateAnnotations(this.cudaViewer);
            this.cudaViewer.addCaretListener();
        }
    }

    private void updateAnnotations(ViperViewerBase viewer) {
        IAnnotationModel annotationModel = viewer.getAnnotationModel();
        if (annotationModel != null) {
            Iterator ite = annotationModel.getAnnotationIterator();
            while (ite.hasNext()) {
                annotationModel.removeAnnotation((Annotation)ite.next());
            }
            viewer.createAnnotations(annotationModel);
        }
    }

    public void tileViewerWindows(int orientation) {
        this.restoreViewerLayout();
        this.sashForm.setOrientation(orientation);
    }

    public void maximizeCudaView() {
        if (!this.cudaViewerControl.equals(this.sashForm.getMaximizedControl())) {
            this.sashForm.setMaximizedControl((Control)this.cudaViewerControl);
        }
    }

    public void maximizeSassView() {
        if (!this.sassViewerControl.equals(this.sashForm.getMaximizedControl())) {
            this.sashForm.setMaximizedControl((Control)this.sassViewerControl);
        }
    }

    private void restoreViewerLayout() {
        if (this.sashForm.getMaximizedControl() != null) {
            this.sashForm.setMaximizedControl(null);
        }
    }

    public void setFocus() {
    }

    public SourceSassModel getSourceSassModel() {
        return this.sourceSassModel;
    }

    public Session getSession() {
        return this.session;
    }

    public static enum AnnotationType {
        HOTSPOT_HIGH("hotspot1.type", ViperColors.COLOR_HOTSPOT_HIGH, "HIGH"),
        HOTSPOT_MED("hotspot2.type", ViperColors.COLOR_HOTSPOT_MED, "MID");

        private final String type;
        private final Color color;
        private final String desc;

        private AnnotationType(String type, Color color, String desc) {
            this.type = type;
            this.color = color;
            this.desc = desc;
        }

        public String getType() {
            return this.type;
        }

        public Color getColor() {
            return this.color;
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class InfoControlCreator
    implements IInformationControlCreator {
        InfoControlCreator() {
        }

        public IInformationControl createInformationControl(Shell parent) {
            return new DefaultInformationControl(parent);
        }
    }

    class SharedColor
    implements ISharedTextColors {
        SharedColor() {
        }

        public Color getColor(RGB rgb) {
            return new Color((Device)Display.getDefault(), rgb);
        }

        public void dispose() {
        }
    }
}

