/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.analysis.TimeRange;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineIntervalKind;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class TimeRanges
extends ArrayList<TimeRange> {
    public TimeRanges() {
    }

    public TimeRanges(List<TimeRange> ranges) throws IllegalArgumentException {
        long currentStart = Long.MIN_VALUE;
        for (TimeRange range : ranges) {
            if (range.getStart() < currentStart) {
                throw new IllegalArgumentException("expected ranges ordered by start time");
            }
            this.add(range);
            currentStart = range.getStart();
        }
        this.normalize();
    }

    public TimeRanges(Timeline timeline) {
        super(timeline.getNumIntervals());
        for (ITimelineInterval interval : timeline.getIntervals()) {
            this.add(new TimeRange(interval.getStart(), interval.getEnd()));
        }
        this.normalize();
    }

    public TimeRanges(Timeline timeline, TimelineIntervalKind kind) {
        super(timeline.getNumIntervals());
        for (ITimelineInterval interval : timeline.getIntervals()) {
            if (!interval.getKind().equals((Object)kind)) continue;
            this.add(new TimeRange(interval.getStart(), interval.getEnd()));
        }
        this.normalize();
    }

    public long getTotalTime() {
        long total = 0L;
        for (TimeRange range : this) {
            total += range.getDuration();
        }
        return total;
    }

    public void union(TimeRanges other) {
        ListIterator<TimeRange> thisIter = this.listIterator();
        ListIterator otherIter = other.listIterator();
        if (thisIter.hasNext()) {
            TimeRange current = (TimeRange)thisIter.next();
            block0: while (otherIter.hasNext()) {
                TimeRange otherCurrent = (TimeRange)otherIter.next();
                while (current.getEnd() < otherCurrent.getStart()) {
                    if (!thisIter.hasNext()) {
                        otherCurrent = (TimeRange)otherIter.previous();
                        break block0;
                    }
                    current = (TimeRange)thisIter.next();
                }
                thisIter.previous();
                while (otherCurrent.getEnd() < current.getStart()) {
                    thisIter.add(otherCurrent);
                    if (!otherIter.hasNext()) break block0;
                    otherCurrent = (TimeRange)otherIter.next();
                }
                TimeRange rCurrent = (TimeRange)thisIter.next();
                assert (current == rCurrent);
                if (otherCurrent.getStart() <= current.getEnd()) {
                    TimeRange end = current;
                    while (thisIter.hasNext()) {
                        TimeRange range = (TimeRange)thisIter.next();
                        if (otherCurrent.getEnd() < range.getStart()) {
                            thisIter.previous();
                            break;
                        }
                        end = range;
                        thisIter.remove();
                    }
                    long startTime = Math.min(current.getStart(), otherCurrent.getStart());
                    long endTime = Math.max(end.getEnd(), otherCurrent.getEnd());
                    current = new TimeRange(startTime, endTime);
                    thisIter.previous();
                    thisIter.set(current);
                    current = (TimeRange)thisIter.next();
                    continue;
                }
                otherCurrent = (TimeRange)otherIter.previous();
            }
        }
        while (otherIter.hasNext()) {
            this.add((TimeRange)otherIter.next());
        }
    }

    public void intersect(TimeRanges other) {
        ListIterator<TimeRange> thisIter = this.listIterator();
        ListIterator otherIter = other.listIterator();
        if (thisIter.hasNext() && otherIter.hasNext()) {
            TimeRange current = (TimeRange)thisIter.next();
            block0: while (otherIter.hasNext()) {
                TimeRange otherCurrent = (TimeRange)otherIter.next();
                while (current.getEnd() <= otherCurrent.getStart()) {
                    thisIter.remove();
                    if (!thisIter.hasNext()) break block0;
                    current = (TimeRange)thisIter.next();
                }
                while (otherCurrent.getEnd() <= current.getStart()) {
                    if (!otherIter.hasNext()) {
                        thisIter.previous();
                        break block0;
                    }
                    otherCurrent = (TimeRange)otherIter.next();
                }
                if (otherCurrent.getStart() < current.getEnd()) {
                    long startTime = Math.max(current.getStart(), otherCurrent.getStart());
                    long endTime = Math.min(current.getEnd(), otherCurrent.getEnd());
                    TimeRange split = new TimeRange(startTime, endTime);
                    if (otherCurrent.getEnd() <= current.getEnd()) {
                        thisIter.previous();
                        thisIter.add(split);
                        if (!otherIter.hasNext()) break;
                        current = (TimeRange)thisIter.next();
                        continue;
                    }
                    thisIter.set(split);
                    if (!thisIter.hasNext()) break;
                    current = (TimeRange)thisIter.next();
                    otherCurrent = (TimeRange)otherIter.previous();
                    continue;
                }
                otherCurrent = (TimeRange)otherIter.previous();
            }
        }
        while (thisIter.hasNext()) {
            thisIter.next();
            thisIter.remove();
        }
    }

    protected void normalize() {
        ListIterator<TimeRange> iter = this.listIterator();
        if (iter.hasNext()) {
            TimeRange current = (TimeRange)iter.next();
            while (iter.hasNext()) {
                TimeRange next = (TimeRange)iter.next();
                if (current.getEnd() >= next.getStart()) {
                    long startTime = current.getStart();
                    long endTime = Math.max(current.getEnd(), next.getEnd());
                    iter.remove();
                    iter.previous();
                    iter.remove();
                    current = new TimeRange(startTime, endTime);
                    iter.add(current);
                    continue;
                }
                current = next;
            }
        }
    }
}

