/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.actions;

import com.nvidia.viper.Activator;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class ShowViewAction
extends Action {
    private IWorkbenchWindow window;
    private IViewDescriptor viewDesc;

    public ShowViewAction(IWorkbenchWindow window, String actionId) {
        this.window = window;
        String viewId = null;
        if ("com.nvidia.viper.showconsole".equals(actionId)) {
            viewId = Activator.getDefault().getViperWorkbench().getConsoleViewID();
        } else if ("com.nvidia.viper.showanalysis".equals(actionId)) {
            viewId = "com.nvidia.viper.analysisview";
        } else if ("com.nvidia.viper.showexpert".equals(actionId)) {
            viewId = "com.nvidia.viper.expertview";
        } else if ("com.nvidia.viper.showsettings".equals(actionId)) {
            viewId = "com.nvidia.viper.settingsview";
        } else if ("com.nvidia.viper.showproperties".equals(actionId)) {
            viewId = "com.nvidia.viper.timelinepropertyview";
        }
        if (viewId != null) {
            IViewRegistry reg = WorkbenchPlugin.getDefault().getViewRegistry();
            this.viewDesc = reg.find(viewId);
            if (this.viewDesc != null) {
                this.setText(String.valueOf(ViperMessages.ShowView_Label_Pre) + " " + this.viewDesc.getLabel() + " " + ViperMessages.ShowView_Label_Post);
                this.setImageDescriptor(this.viewDesc.getImageDescriptor());
                this.setToolTipText(String.valueOf(ViperMessages.ShowView_Tooltip_Pre) + " " + this.viewDesc.getLabel() + " " + ViperMessages.ShowView_Tooltip_Post);
                this.setId(actionId);
            }
        }
    }

    public void run() {
        IWorkbenchPage activePage = this.window.getActivePage();
        try {
            activePage.showView(this.viewDesc.getId());
        }
        catch (PartInitException partInitException) {
            ViperExceptionHandler.logError("unable to show view " + this.viewDesc.getId());
        }
    }
}

