/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.actions;

import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.actions.RunAnalysisAction;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.fs.DeviceListNotReadyException;
import com.nvidia.viper.fs.FileSystem;
import com.nvidia.viper.fs.IDevicesData;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.run.Runner;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;

public class RunAnalysisStageAction
extends Action {
    private Session session;
    private AnalysisStage[] stages;
    private DataCollection dataCollection;

    public RunAnalysisStageAction(Session session, AnalysisStage[] stages, DataCollection dataCollection) {
        super(ViperMessages.RunAnalysisStage_Label, null);
        this.session = session;
        this.stages = Arrays.copyOf(stages, stages.length);
        this.dataCollection = dataCollection;
        this.setToolTipText(ViperMessages.RunAnalysisStage_Tooltip);
        this.setId("com.nvidia.viper.runanalysisstage");
    }

    public void analysisCompleted(IStatus status) {
    }

    public void run() {
        boolean ret;
        final HashSet<AnalysisStage> collectStages = new HashSet<AnalysisStage>();
        AnalysisStage[] analysisStageArray = this.stages;
        int n = this.stages.length;
        int n2 = 0;
        while (n2 < n) {
            AnalysisStage stage = analysisStageArray[n2];
            try {
                ret = stage.analyze(this.session);
                if (DataCollection.FORCE.equals((Object)this.dataCollection) || DataCollection.IFNEEDED.equals((Object)this.dataCollection) && !ret) {
                    collectStages.add(stage);
                }
            }
            catch (ViperException e) {
                ViperExceptionHandler.handle("Analysis Failed", String.valueOf(stage.getLabel()) + " analysis failed", e);
            }
            ++n2;
        }
        Analysis analysis = this.session.getAnalysis();
        if (!collectStages.isEmpty()) {
            try {
                FileSystem system = this.session != null && this.session.getExecutable() != null ? FileSystem.getFilesystem(this.session.getExecutable().getConnectionName()) : FileSystem.getFilesystem(null);
                IDevicesData data = system.getDeviceData(true);
                final Runner runner = analysis.collectData(data, this.session, collectStages);
                ret = runner != null ? runner.runWithJob() : false;
                new Thread("Analysis Completion Waiter"){

                    @Override
                    public void run() {
                        final IStatus status = runner == null ? Status.OK_STATUS : runner.waitForCompletion();
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (status != Status.OK_STATUS && status != Status.CANCEL_STATUS) {
                                    Exception e = status.getException() instanceof Exception ? (Exception)status.getException() : null;
                                    ViperExceptionHandler.handle(ViperMessages.Launch_Fail_Title, status.getMessage(), e);
                                } else if (ret) {
                                    for (AnalysisStage astage : collectStages) {
                                        try {
                                            astage.analyze(RunAnalysisStageAction.this.session);
                                        }
                                        catch (ViperException e) {
                                            ViperExceptionHandler.handle("Analysis Failed", String.valueOf(astage.getLabel()) + " analysis failed", e);
                                        }
                                    }
                                } else if (!ret && RunAnalysisStageAction.this.session.needToGenerateTimeline()) {
                                    new RunAnalysisAction(RunAnalysisStageAction.this.session, true, RunAnalysisAction.ShowMode.GUIDED).run();
                                }
                                RunAnalysisStageAction.this.analysisCompleted(status);
                            }
                        });
                    }
                }.start();
            }
            catch (ViperException e) {
                ViperExceptionHandler.handle("Analysis Data Collection Failed", "Data collection for " + collectStages.size() + " analysis stages failed", e);
            }
            catch (DeviceListNotReadyException deviceListNotReadyException) {}
        } else {
            this.analysisCompleted(Status.OK_STATUS);
        }
    }

    public static enum DataCollection {
        FORCE,
        IFNEEDED,
        NONE;

    }
}

