/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.actions;

import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperImages;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.actions.RunAnalysisStageAction;
import com.nvidia.viper.actions.RunnerAction;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.expertsystem.ExpertSystemStageKind;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.Session;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.gef.Disposable;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class RunAnalysisAction
extends RunnerAction
implements Disposable {
    private Session session;
    private final boolean timelineOnly;
    private final ShowMode showMode;

    public RunAnalysisAction(Session session, boolean timelineOnly, ShowMode showMode) {
        super(ViperMessages.RunAnalysis_Label, ViperImages.DESC_RUN_ANALYSIS);
        this.session = session;
        this.timelineOnly = timelineOnly;
        this.showMode = showMode;
        this.setToolTipText(ViperMessages.RunAnalysis_Tooltip);
        this.setId("com.nvidia.viper.runanalysis");
    }

    @Override
    public void dispose() {
        super.dispose();
        this.session = null;
    }

    public void run() {
        final Analysis analysis = this.session.getAnalysis();
        if (analysis != null) {
            AnalysisStage[] aStages;
            if (this.timelineOnly) {
                aStages = new AnalysisStage[]{AnalysisStage.TIMELINE};
            } else {
                AnalysisStage[] allStages = analysis.getOrderedStages();
                LinkedHashSet<AnalysisStage> stages = new LinkedHashSet<AnalysisStage>(Arrays.asList(allStages));
                stages.removeAll(analysis.getVisitedStages());
                aStages = stages.toArray(new AnalysisStage[stages.size()]);
            }
            if (aStages.length > 0) {
                RunAnalysisStageAction analysisAction = new RunAnalysisStageAction(this.session, aStages, this.session.getExecutable() == null ? RunAnalysisStageAction.DataCollection.NONE : RunAnalysisStageAction.DataCollection.IFNEEDED){

                    @Override
                    public void analysisCompleted(IStatus status) {
                        analysis.setVisitedStages(aStages, true);
                        if (RunAnalysisAction.this.timelineOnly) {
                            analysis.setSelectedStage(aStages[0]);
                        }
                        if (RunAnalysisAction.this.session.getAnalysis() != null && !ShowMode.NONE.equals((Object)RunAnalysisAction.this.showMode)) {
                            if (!ShowMode.NONE.equals((Object)RunAnalysisAction.this.showMode)) {
                                RunAnalysisAction.this.session.getAnalysis().setGuidedMode(ShowMode.GUIDED.equals((Object)RunAnalysisAction.this.showMode));
                                if (RunAnalysisAction.this.session.getExpertSystem() != null) {
                                    RunAnalysisAction.this.session.getExpertSystem().setCurrentStageKind(ExpertSystemStageKind.INTRO);
                                }
                            }
                            try {
                                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.nvidia.viper.analysisview");
                            }
                            catch (PartInitException partInitException) {
                                ViperExceptionHandler.logError("unable to show analysis view");
                            }
                        }
                    }
                };
                analysisAction.run();
            }
        }
    }

    public static enum ShowMode {
        NONE,
        CURRENT,
        UNGUIDED,
        GUIDED;

    }
}

