/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.actions;

import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperImages;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.expertsystem.ExpertSystemStageKind;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.Session;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ResetAnalysisAction
extends Action {
    private final Session session;
    private final boolean showAnalysisView;

    public ResetAnalysisAction(Session session, boolean showAnalysisView) {
        super(ViperMessages.ResetAnalysis_Label, ViperImages.DESC_RESET_ALL_ANALYSIS);
        this.session = session;
        this.showAnalysisView = showAnalysisView;
        this.setToolTipText(ViperMessages.ResetAnalysis_Tooltip);
        this.setId("com.nvidia.viper.resetanalysis");
    }

    public void run() {
        Analysis analysis = this.session.getAnalysis();
        if (analysis != null) {
            this.session.setPrimaryAndSecondarySelected(null, null, true, true);
            analysis.setSelectedStage(AnalysisStage.NONE);
            analysis.clearAllVisitedStages();
            analysis.setActiveScopeInterval(null);
            this.session.getExpertSystem().setCurrentStageKind(ExpertSystemStageKind.INTRO);
            if (this.session.getExecutable() != null) {
                try {
                    this.session.setTimelines(null);
                }
                catch (ViperException viperException) {
                    ViperExceptionHandler.logError("unable to clear timelines");
                }
            }
        }
        if (this.showAnalysisView) {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.nvidia.viper.analysisview");
            }
            catch (PartInitException partInitException) {
                ViperExceptionHandler.logError("unable to show analysis view");
            }
        }
    }
}

