/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.actions;

import com.nvidia.viper.ViperImages;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionPropertyChangeListener;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.TimelineIntervalHierarchy;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineIntervalMemset;
import com.nvidia.viper.model.TimelineIntervalPair;
import com.nvidia.viper.ui.SessionEditor;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.jface.action.Action;

public class FocusTimelineAction
extends Action {
    private final SessionEditor editor;

    public FocusTimelineAction(SessionEditor editor) {
        super(ViperMessages.FocusTimeline_Label, ViperImages.DESC_FOCUS_TIMELINE);
        this.setToolTipText(ViperMessages.FocusTimeline_Tooltip);
        this.setId("com.nvidia.viper.focustimeline");
        this.editor = editor;
        this.setEnabled(this.getFocusIntervals() != null);
        if (editor != null && editor.getSession() != null) {
            editor.getSession().addPropertyChangeListener(new ISessionPropertyChangeListener(){

                @Override
                public void propertyChange(IModel model, String propertyName) {
                    if ("session:sInterval".equals(propertyName)) {
                        FocusTimelineAction.this.setEnabled(FocusTimelineAction.this.getFocusIntervals() != null);
                    }
                }
            });
        }
    }

    private Collection<ITimelineInterval> getFocusIntervals() {
        LinkedList<ITimelineInterval> intervals = new LinkedList<ITimelineInterval>();
        if (this.editor != null && this.editor.getSession() != null) {
            Session session = this.editor.getSession();
            TimelineIntervalPair primary = session.getPrimarySelected();
            if (this.isFocusInterval(primary)) {
                intervals.add(primary.getInterval());
            }
            if (session.getSecondarySelected() != null) {
                for (TimelineIntervalPair secondary : session.getSecondarySelected()) {
                    if (!this.isFocusInterval(secondary)) continue;
                    intervals.add(secondary.getInterval());
                }
            }
        }
        return intervals.isEmpty() ? null : intervals;
    }

    private boolean isFocusInterval(TimelineIntervalPair pair) {
        ITimelineInterval interval = null;
        if (pair != null) {
            interval = pair.getInterval();
        }
        if (interval instanceof TimelineIntervalHierarchy && interval.getKind().isFocusKind()) {
            TimelineIntervalHierarchy hier = (TimelineIntervalHierarchy)interval;
            if ((hier instanceof TimelineIntervalMemset || hier instanceof TimelineIntervalKernel) && hier.getParent() != null && hier.getParent() instanceof TimelineIntervalKernel) {
                return true;
            }
            HashSet<TimelineIntervalHierarchy> descendants = new HashSet<TimelineIntervalHierarchy>();
            hier.getDescendants(descendants);
            for (TimelineIntervalHierarchy d : descendants) {
                if (!(d instanceof TimelineIntervalKernel) || d.getChildren() == null || d.getChildren().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public void run() {
        Collection<ITimelineInterval> intervals = this.getFocusIntervals();
        if (intervals != null) {
            this.editor.getSession().focusOnIntervals(intervals);
        }
    }
}

