/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper;

import com.nvidia.viper.EventManager;
import com.nvidia.viper.MetricManager;
import com.nvidia.viper.MultiProcessPDMManager;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.activity.CuptiActivityAPI;
import com.nvidia.viper.activity.CuptiActivityComputeApiKind;
import com.nvidia.viper.activity.CuptiActivityContext;
import com.nvidia.viper.activity.CuptiActivityDevice;
import com.nvidia.viper.activity.CuptiActivityDeviceAttribute;
import com.nvidia.viper.activity.CuptiActivityEnvironment;
import com.nvidia.viper.activity.CuptiActivityEvent;
import com.nvidia.viper.activity.CuptiActivityFlag;
import com.nvidia.viper.activity.CuptiActivityFunction;
import com.nvidia.viper.activity.CuptiActivityInstructionExecution;
import com.nvidia.viper.activity.CuptiActivityKernel;
import com.nvidia.viper.activity.CuptiActivityKind;
import com.nvidia.viper.activity.CuptiActivityMarker;
import com.nvidia.viper.activity.CuptiActivityMarkerData;
import com.nvidia.viper.activity.CuptiActivityMemcpy;
import com.nvidia.viper.activity.CuptiActivityMemcpyP2p;
import com.nvidia.viper.activity.CuptiActivityMemset;
import com.nvidia.viper.activity.CuptiActivityMetric;
import com.nvidia.viper.activity.CuptiActivityModule;
import com.nvidia.viper.activity.CuptiActivityName;
import com.nvidia.viper.activity.CuptiActivityObjectKind;
import com.nvidia.viper.activity.CuptiActivityOverhead;
import com.nvidia.viper.activity.CuptiActivitySourceLocator;
import com.nvidia.viper.activity.CuptiActivityUvmCounter;
import com.nvidia.viper.activity.CuptiActivityUvmCounterKind;
import com.nvidia.viper.activity.CuptiActivityUvmCounterScope;
import com.nvidia.viper.activity.ICuptiActivity;
import com.nvidia.viper.activity.ICuptiActivitySourceLevelResult;
import com.nvidia.viper.jni.CuptiException;
import com.nvidia.viper.jni.NativeCupti;
import com.nvidia.viper.model.ContainerState;
import com.nvidia.viper.model.CudaFunctionManager;
import com.nvidia.viper.model.Event;
import com.nvidia.viper.model.Executable;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Metric;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.SessionFilter;
import com.nvidia.viper.model.SourceLevelResult;
import com.nvidia.viper.model.SourceLocator;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineContext;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineIntervalAPI;
import com.nvidia.viper.model.TimelineIntervalEnvironment;
import com.nvidia.viper.model.TimelineIntervalHierarchy;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineIntervalKind;
import com.nvidia.viper.model.TimelineIntervalMarker;
import com.nvidia.viper.model.TimelineIntervalMemcpy;
import com.nvidia.viper.model.TimelineIntervalMemset;
import com.nvidia.viper.model.TimelineIntervalOverhead;
import com.nvidia.viper.model.TimelineIntervalRange;
import com.nvidia.viper.model.TimelineIntervalUVM;
import com.nvidia.viper.model.TimelineKernel;
import com.nvidia.viper.model.TimelineKind;
import com.nvidia.viper.model.TimelineMemcpy;
import com.nvidia.viper.model.TimelineProcess;
import com.nvidia.viper.model.TimelineStream;
import com.nvidia.viper.model.TimelineThread;
import com.nvidia.viper.model.TimelineUVM;
import com.nvidia.viper.ui.UvmMessageDialog;
import com.nvidia.viper.ui.ViperMessageDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class TimelineFactory {
    private int pdmVersion = -1;
    private Map<Integer, CuptiActivitySourceLocator> sourceLocations;
    private Map<Integer, CuptiActivityFunction> functions;
    private List<CuptiActivityModule> modules;
    private List<ProcessTL> processes;
    private Map<Integer, DeviceTL> devices;
    private Map<Long, ITimelineInterval> gridIdIntervalMap;
    private Map<Integer, List<ITimelineInterval>> gpuIntervalMap;
    private Map<Integer, TimelineIntervalAPI> driverApiIntervalMap;
    private Map<Integer, TimelineIntervalAPI> runtimeApiIntervalMap;
    private MultiProcessPDMManager multiProcessManager;
    private int correlationIdProfiled;

    public TimelineFactory(ProfileDataModel pdm) throws ViperException {
        this.init();
        this.parsePdm(pdm);
    }

    public TimelineFactory(ProfileDataModel[] pdms) throws ViperException {
        ProfileDataModel pdm;
        this.multiProcessManager = new MultiProcessPDMManager();
        this.init();
        ProfileDataModel[] profileDataModelArray = pdms;
        int n = pdms.length;
        int n2 = 0;
        while (n2 < n) {
            pdm = profileDataModelArray[n2];
            this.manageMultipleProcesses(pdm);
            ++n2;
        }
        profileDataModelArray = pdms;
        n = pdms.length;
        n2 = 0;
        while (n2 < n) {
            pdm = profileDataModelArray[n2];
            this.parsePdm(pdm);
            ++n2;
        }
        this.correlationIdProfiled = -1;
    }

    private void init() {
        this.sourceLocations = new HashMap<Integer, CuptiActivitySourceLocator>();
        this.functions = new HashMap<Integer, CuptiActivityFunction>();
        this.processes = new LinkedList<ProcessTL>();
        this.devices = new HashMap<Integer, DeviceTL>();
        this.gridIdIntervalMap = new HashMap<Long, ITimelineInterval>();
        this.gpuIntervalMap = new HashMap<Integer, List<ITimelineInterval>>();
        this.runtimeApiIntervalMap = new HashMap<Integer, TimelineIntervalAPI>();
        this.driverApiIntervalMap = new HashMap<Integer, TimelineIntervalAPI>();
        this.modules = new ArrayList<CuptiActivityModule>();
        this.correlationIdProfiled = -2;
    }

    private void manageMultipleProcesses(ProfileDataModel pdm) {
        long maxCorrId = 0L;
        int processId = -1;
        long hPdm = pdm.getNativeHandle();
        try {
            ICuptiActivity activity;
            long hIterator = 0L;
            hIterator = NativeCupti.cuptiPDMCreateActivityIterator(hPdm);
            block11: while ((activity = NativeCupti.cuptiPDMNextActivity(hPdm, hIterator)) != null) {
                if (!activity.isValid()) continue;
                switch (activity.getKind()) {
                    case CUPTI_ACTIVITY_KIND_KERNEL: 
                    case CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL: 
                    case CUPTI_ACTIVITY_KIND_CDP_KERNEL: {
                        if (!(activity instanceof CuptiActivityKernel)) {
                            throw new ViperException("expected CuptiActivityKernel");
                        }
                        CuptiActivityKernel kernel = (CuptiActivityKernel)activity;
                        this.multiProcessManager.addStream(kernel.streamId, kernel.contextId, kernel.deviceId, pdm.toString());
                        continue block11;
                    }
                    case CUPTI_ACTIVITY_KIND_MEMSET: {
                        if (!(activity instanceof CuptiActivityMemset)) {
                            throw new ViperException("expected CuptiActivityMemset");
                        }
                        CuptiActivityMemset memset = (CuptiActivityMemset)activity;
                        this.multiProcessManager.addStream(memset.streamId, memset.contextId, memset.deviceId, pdm.toString());
                        continue block11;
                    }
                    case CUPTI_ACTIVITY_KIND_MEMCPY: 
                    case CUPTI_ACTIVITY_KIND_MEMCPY2: {
                        if (!(activity instanceof CuptiActivityMemcpy) && !(activity instanceof CuptiActivityMemcpyP2p)) {
                            throw new ViperException("expected CuptiActivityMemcpy");
                        }
                        CuptiActivityMemcpy memcpy = (CuptiActivityMemcpy)activity;
                        this.multiProcessManager.addStream(memcpy.streamId, memcpy.contextId, memcpy.deviceId, pdm.toString());
                        continue block11;
                    }
                    case CUPTI_ACTIVITY_KIND_DRIVER: 
                    case CUPTI_ACTIVITY_KIND_RUNTIME: {
                        if (!(activity instanceof CuptiActivityAPI)) {
                            throw new ViperException("expected CuptiActivityAPI");
                        }
                        CuptiActivityAPI api = (CuptiActivityAPI)activity;
                        if (processId == -1) {
                            processId = api.processId;
                        }
                        if ((long)api.correlationId <= maxCorrId) continue block11;
                        maxCorrId = api.correlationId;
                        continue block11;
                    }
                    case CUPTI_ACTIVITY_KIND_CONTEXT: {
                        if (!(activity instanceof CuptiActivityContext)) {
                            throw new ViperException("expected CuptiActivityContext");
                        }
                        CuptiActivityContext context = (CuptiActivityContext)activity;
                        this.multiProcessManager.addContext(context, pdm.toString());
                        continue block11;
                    }
                }
            }
            String customName = Integer.toString(processId);
            this.multiProcessManager.setContextCustomName(customName, pdm.toString());
            this.multiProcessManager.setStreamCustomName(customName, pdm.toString());
            this.multiProcessManager.setMaxCorrelationId(maxCorrId, pdm.toString());
        }
        catch (CuptiException cuptiException) {
            ViperExceptionHandler.logError("unable to read pdm");
        }
        catch (ViperException viperException) {
            ViperExceptionHandler.logError("unable to read pdm");
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
    }

    private void checkAndUpdateCorrelationId(int correlationId) {
        switch (this.correlationIdProfiled) {
            case -2: {
                this.correlationIdProfiled = correlationId;
                break;
            }
            case -1: {
                break;
            }
            default: {
                if (this.correlationIdProfiled == correlationId) break;
                this.correlationIdProfiled = -1;
            }
        }
    }

    public void parsePdm(ProfileDataModel pdm) throws ViperException {
        LinkedList<CuptiActivityEvent> events = new LinkedList<CuptiActivityEvent>();
        LinkedList<CuptiActivityMetric> metrics = new LinkedList<CuptiActivityMetric>();
        LinkedList<ICuptiActivity> sourceLevelResults = new LinkedList<ICuptiActivity>();
        LinkedList<CuptiActivityName> names = new LinkedList<CuptiActivityName>();
        LinkedList<CuptiActivityMarker> markers = new LinkedList<CuptiActivityMarker>();
        HashMap<Integer, CuptiActivityMarkerData> markerDatas = new HashMap<Integer, CuptiActivityMarkerData>();
        LinkedList<CuptiActivityDeviceAttribute> deviceAttributes = new LinkedList<CuptiActivityDeviceAttribute>();
        long hIterator = 0L;
        try {
            try {
                List<ITimelineInterval> correlatedIntervalList;
                int droppedDeviceAttributes;
                int droppedMarkers;
                int invalidRecords;
                block84: {
                    ICuptiActivity activity;
                    invalidRecords = 0;
                    long hPdm = pdm.getNativeHandle();
                    int version = NativeCupti.cuptiPDMGetVersion(hPdm);
                    if (this.pdmVersion == -1) {
                        this.pdmVersion = version;
                    } else if (version != this.pdmVersion) {
                        throw new ViperException("pdm version mismatch");
                    }
                    hIterator = NativeCupti.cuptiPDMCreateActivityIterator(hPdm);
                    block33: while (true) {
                        if (Thread.currentThread().getName().equals("LoadPdm") && Thread.currentThread().isInterrupted()) {
                            throw new ViperException("LoadPdmCancel");
                        }
                        activity = NativeCupti.cuptiPDMNextActivity(hPdm, hIterator);
                        if (activity == null) break block84;
                        if (!activity.isValid()) {
                            ++invalidRecords;
                            continue;
                        }
                        switch (activity.getKind()) {
                            case CUPTI_ACTIVITY_KIND_RUNTIME: {
                                if (!(activity instanceof CuptiActivityAPI)) {
                                    throw new ViperException("expected CuptiActivityAPI");
                                }
                                CuptiActivityAPI runtime = (CuptiActivityAPI)activity;
                                if (this.multiProcessManager != null) {
                                    int newCorrId;
                                    runtime.correlationId = newCorrId = this.multiProcessManager.getNewCorrelationId(runtime.correlationId, pdm.toString());
                                }
                                TimelineIntervalAPI interval = this.addRuntimeInterval(runtime);
                                if (runtime.correlationId == 0) continue block33;
                                this.runtimeApiIntervalMap.put(runtime.correlationId, interval);
                                continue block33;
                            }
                            case CUPTI_ACTIVITY_KIND_DRIVER: {
                                if (!(activity instanceof CuptiActivityAPI)) {
                                    throw new ViperException("expected CuptiActivityAPI");
                                }
                                CuptiActivityAPI driver = (CuptiActivityAPI)activity;
                                if (this.multiProcessManager != null) {
                                    int newCorrId;
                                    driver.correlationId = newCorrId = this.multiProcessManager.getNewCorrelationId(driver.correlationId, pdm.toString());
                                }
                                TimelineIntervalAPI interval = this.addDriverInterval(driver);
                                if (driver.correlationId == 0) continue block33;
                                this.driverApiIntervalMap.put(driver.correlationId, interval);
                                continue block33;
                            }
                            case CUPTI_ACTIVITY_KIND_KERNEL: 
                            case CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL: 
                            case CUPTI_ACTIVITY_KIND_CDP_KERNEL: {
                                int newStreamId;
                                int newCorrId;
                                if (!(activity instanceof CuptiActivityKernel)) {
                                    throw new ViperException("expected CuptiActivityKernel");
                                }
                                CuptiActivityKernel kernel = (CuptiActivityKernel)activity;
                                String streamCustomName = null;
                                this.checkAndUpdateCorrelationId(kernel.correlationId);
                                if (this.multiProcessManager != null) {
                                    streamCustomName = this.multiProcessManager.getStreamCustomName(kernel.streamId, kernel.contextId, kernel.deviceId, pdm.toString());
                                    int newCtxId = this.multiProcessManager.getNewContextId(kernel.contextId, kernel.deviceId, pdm.toString());
                                    newCorrId = this.multiProcessManager.getNewCorrelationId(kernel.correlationId, pdm.toString());
                                    newStreamId = this.multiProcessManager.getNewStreamId(kernel.streamId, kernel.contextId, kernel.deviceId, pdm.toString());
                                    kernel.correlationId = newCorrId;
                                    kernel.contextId = newCtxId;
                                    kernel.streamId = newStreamId;
                                }
                                TimelineIntervalKernel interval = this.addKernelInterval(kernel, streamCustomName);
                                if (kernel.correlationId != 0) {
                                    this.addInGpuIntervalMap(kernel.correlationId, interval);
                                }
                                if (kernel.gridId == 0L) continue block33;
                                this.gridIdIntervalMap.put(kernel.gridId, interval);
                                continue block33;
                            }
                            case CUPTI_ACTIVITY_KIND_PREEMPTION: {
                                continue block33;
                            }
                            case CUPTI_ACTIVITY_KIND_ENVIRONMENT: {
                                if (!(activity instanceof CuptiActivityEnvironment)) {
                                    throw new ViperException("expected CuptiActivityEnvironment");
                                }
                                CuptiActivityEnvironment envAct = (CuptiActivityEnvironment)activity;
                                this.addEnvironmentInterval(envAct);
                                continue block33;
                            }
                            case CUPTI_ACTIVITY_KIND_MEMSET: {
                                int newStreamId;
                                int newCorrId;
                                if (!(activity instanceof CuptiActivityMemset)) {
                                    throw new ViperException("expected CuptiActivityMemset");
                                }
                                CuptiActivityMemset memset = (CuptiActivityMemset)activity;
                                String streamCustomName = null;
                                if (this.multiProcessManager != null) {
                                    streamCustomName = this.multiProcessManager.getStreamCustomName(memset.streamId, memset.contextId, memset.deviceId, pdm.toString());
                                    int newCtxId = this.multiProcessManager.getNewContextId(memset.contextId, memset.deviceId, pdm.toString());
                                    newCorrId = this.multiProcessManager.getNewCorrelationId(memset.correlationId, pdm.toString());
                                    newStreamId = this.multiProcessManager.getNewStreamId(memset.streamId, memset.contextId, memset.deviceId, pdm.toString());
                                    memset.contextId = newCtxId;
                                    memset.correlationId = newCorrId;
                                    memset.streamId = newStreamId;
                                }
                                TimelineIntervalMemset interval = this.addMemsetInterval(memset, streamCustomName);
                                if (memset.correlationId == 0) continue block33;
                                this.addInGpuIntervalMap(memset.correlationId, interval);
                                continue block33;
                            }
                            case CUPTI_ACTIVITY_KIND_MEMCPY: {
                                int newStreamId;
                                int newCorrId;
                                if (!(activity instanceof CuptiActivityMemcpy)) {
                                    throw new ViperException("expected CuptiActivityMemcpy");
                                }
                                CuptiActivityMemcpy memcpy = (CuptiActivityMemcpy)activity;
                                String streamCustomName = null;
                                if (this.multiProcessManager != null) {
                                    streamCustomName = this.multiProcessManager.getStreamCustomName(memcpy.streamId, memcpy.contextId, memcpy.deviceId, pdm.toString());
                                    int newCtxId = this.multiProcessManager.getNewContextId(memcpy.contextId, memcpy.deviceId, pdm.toString());
                                    newCorrId = this.multiProcessManager.getNewCorrelationId(memcpy.correlationId, pdm.toString());
                                    newStreamId = this.multiProcessManager.getNewStreamId(memcpy.streamId, memcpy.contextId, memcpy.deviceId, pdm.toString());
                                    memcpy.contextId = newCtxId;
                                    memcpy.correlationId = newCorrId;
                                    memcpy.streamId = newStreamId;
                                }
                                TimelineIntervalMemcpy interval = this.addMemcpyInterval(memcpy, streamCustomName);
                                if (memcpy.correlationId == 0) continue block33;
                                this.addInGpuIntervalMap(memcpy.correlationId, interval);
                                continue block33;
                            }
                            case CUPTI_ACTIVITY_KIND_MEMCPY2: {
                                int newStreamId;
                                int newCorrId;
                                if (!(activity instanceof CuptiActivityMemcpyP2p)) {
                                    throw new ViperException("expected CuptiActivityMemcpyP2p");
                                }
                                CuptiActivityMemcpyP2p memcpy2 = (CuptiActivityMemcpyP2p)activity;
                                String streamCustomName = null;
                                if (this.multiProcessManager != null) {
                                    streamCustomName = this.multiProcessManager.getStreamCustomName(memcpy2.streamId, memcpy2.contextId, memcpy2.deviceId, pdm.toString());
                                    int newCtxId = this.multiProcessManager.getNewContextId(memcpy2.contextId, memcpy2.deviceId, pdm.toString());
                                    newCorrId = this.multiProcessManager.getNewCorrelationId(memcpy2.correlationId, pdm.toString());
                                    newStreamId = this.multiProcessManager.getNewStreamId(memcpy2.streamId, memcpy2.contextId, memcpy2.deviceId, pdm.toString());
                                    memcpy2.contextId = newCtxId;
                                    memcpy2.correlationId = newCorrId;
                                    memcpy2.streamId = newStreamId;
                                }
                                TimelineIntervalMemcpy interval = this.addMemcpyP2pInterval(memcpy2, streamCustomName);
                                if (memcpy2.correlationId == 0) continue block33;
                                this.addInGpuIntervalMap(memcpy2.correlationId, interval);
                                continue block33;
                            }
                            case CUPTI_ACTIVITY_KIND_EVENT: 
                            case CUPTI_ACTIVITY_KIND_EVENT_INSTANCE: {
                                if (!(activity instanceof CuptiActivityEvent)) {
                                    throw new ViperException("expected CuptiActivityEvent");
                                }
                                CuptiActivityEvent event = (CuptiActivityEvent)activity;
                                events.add(event);
                                this.checkAndUpdateCorrelationId(event.correlationId);
                                continue block33;
                            }
                            case CUPTI_ACTIVITY_KIND_METRIC: 
                            case CUPTI_ACTIVITY_KIND_METRIC_INSTANCE: {
                                if (!(activity instanceof CuptiActivityMetric)) {
                                    throw new ViperException("expected CuptiActivityMetric");
                                }
                                CuptiActivityMetric metric = (CuptiActivityMetric)activity;
                                metrics.add(metric);
                                this.checkAndUpdateCorrelationId(metric.correlationId);
                                continue block33;
                            }
                            case CUPTI_ACTIVITY_KIND_DEVICE: {
                                if (!(activity instanceof CuptiActivityDevice)) {
                                    throw new ViperException("expected CuptiActivityDevice");
                                }
                                CuptiActivityDevice device = (CuptiActivityDevice)activity;
                                this.addDevice(device.id, device);
                                continue block33;
                            }
                            case CUPTI_ACTIVITY_KIND_CONTEXT: {
                                if (!(activity instanceof CuptiActivityContext)) {
                                    throw new ViperException("expected CuptiActivityContext");
                                }
                                CuptiActivityContext context = (CuptiActivityContext)activity;
                                String customName = null;
                                if (this.multiProcessManager != null) {
                                    int newCtxId;
                                    int defaultStreamId = this.multiProcessManager.getNewStreamId(context.defaultStreamId, context.contextId, context.deviceId, pdm.toString());
                                    customName = this.multiProcessManager.getContextCustomName(context.contextId, context.deviceId, pdm.toString());
                                    context.contextId = newCtxId = this.multiProcessManager.getNewContextId(context.contextId, context.deviceId, pdm.toString());
                                    context.defaultStreamId = defaultStreamId;
                                }
                                this.addContext(context.contextId, context, customName);
                                continue block33;
                            }
                            case CUPTI_ACTIVITY_KIND_NAME: {
                                if (!(activity instanceof CuptiActivityName)) {
                                    throw new ViperException("expected CuptiActivityName");
                                }
                                names.add((CuptiActivityName)activity);
                                continue block33;
                            }
                            case CUPTI_ACTIVITY_KIND_MARKER: {
                                if (!(activity instanceof CuptiActivityMarker)) {
                                    throw new ViperException("expected CuptiActivityMarker");
                                }
                                CuptiActivityMarker marker = (CuptiActivityMarker)activity;
                                markers.add(marker);
                                continue block33;
                            }
                            case CUPTI_ACTIVITY_KIND_MARKER_DATA: {
                                if (!(activity instanceof CuptiActivityMarkerData)) {
                                    throw new ViperException("expected CuptiActivityMarkerData");
                                }
                                CuptiActivityMarkerData data = (CuptiActivityMarkerData)activity;
                                markerDatas.put(data.id, data);
                                continue block33;
                            }
                            case CUPTI_ACTIVITY_KIND_OVERHEAD: {
                                if (!(activity instanceof CuptiActivityOverhead)) {
                                    throw new ViperException("expected CuptiActivityOverhead");
                                }
                                CuptiActivityOverhead overhead = (CuptiActivityOverhead)activity;
                                this.addOverheadInterval(overhead);
                                continue block33;
                            }
                            case CUPTI_ACTIVITY_KIND_SOURCE_LOCATOR: {
                                if (!(activity instanceof CuptiActivitySourceLocator)) {
                                    throw new ViperException("expected CuptiActivitySourceLocator");
                                }
                                ICuptiActivity source = (CuptiActivitySourceLocator)activity;
                                this.addSourceLocator((CuptiActivitySourceLocator)source);
                                continue block33;
                            }
                            case CUPTI_ACTIVITY_KIND_GLOBAL_ACCESS: 
                            case CUPTI_ACTIVITY_KIND_BRANCH: 
                            case CUPTI_ACTIVITY_KIND_INSTRUCTION_EXECUTION: 
                            case CUPTI_ACTIVITY_KIND_SHARED_ACCESS: {
                                if (!(activity instanceof ICuptiActivitySourceLevelResult)) {
                                    throw new ViperException("expected ICuptiActivitySourceLevelResult");
                                }
                                ICuptiActivity source = (ICuptiActivitySourceLevelResult)activity;
                                sourceLevelResults.add(source);
                                this.checkAndUpdateCorrelationId(source.getCorrelationId());
                                continue block33;
                            }
                            case CUPTI_ACTIVITY_KIND_DEVICE_ATTRIBUTE: {
                                if (!(activity instanceof CuptiActivityDeviceAttribute)) {
                                    throw new ViperException("expected CuptiActivityDeviceAttribute");
                                }
                                deviceAttributes.add((CuptiActivityDeviceAttribute)activity);
                                continue block33;
                            }
                            case CUPTI_ACTIVITY_KIND_FUNCTION: {
                                if (!(activity instanceof CuptiActivityFunction)) {
                                    throw new ViperException("expected cuptiActivityFunctionLocator");
                                }
                                CuptiActivityFunction function = (CuptiActivityFunction)activity;
                                this.addFunction(function);
                                continue block33;
                            }
                            case CUPTI_ACTIVITY_KIND_MODULE: {
                                if (!(activity instanceof CuptiActivityModule)) {
                                    throw new ViperException("expected cuptiActivityModule");
                                }
                                CuptiActivityModule module = (CuptiActivityModule)activity;
                                this.addModule(module);
                                continue block33;
                            }
                            case CUPTI_ACTIVITY_KIND_UVM_COUNTER: {
                                if (!(activity instanceof CuptiActivityUvmCounter)) {
                                    throw new ViperException("expected cuptiActivityUvm");
                                }
                                CuptiActivityUvmCounter uvmCounter = (CuptiActivityUvmCounter)activity;
                                this.addUVMCounter(uvmCounter);
                                continue block33;
                            }
                        }
                        break;
                    }
                    throw new ViperException("unexpected profile record kind " + (Object)((Object)activity.getKind()));
                }
                if (invalidRecords > 0) {
                    this.openWarning(ViperMessages.DroppedRecords_Label, "The start and end timestamps on " + invalidRecords + " kernels, memcpys, and other collected profile data are invalid. Those profiling records have been dropped and will not be displayed in the timeline");
                }
                int droppedNames = 0;
                for (CuptiActivityName name : names) {
                    if (this.setName(name)) continue;
                    ++droppedNames;
                }
                if (droppedNames > 0) {
                    this.openWarning(ViperMessages.DroppedNames_Label, String.valueOf(droppedNames) + " " + ViperMessages.DroppedNames_Message);
                }
                if ((droppedMarkers = this.addMarkersAndRanges(markers, markerDatas)) > 0) {
                    this.openWarning(ViperMessages.DroppedMarkers_Label, String.valueOf(droppedMarkers) + " " + ViperMessages.DroppedMarkers_Message);
                }
                if ((droppedDeviceAttributes = this.addDeviceAttributes(deviceAttributes)) > 0) {
                    this.openWarning(ViperMessages.DroppedDeviceAttributes_Label, String.valueOf(droppedDeviceAttributes) + " " + ViperMessages.DroppedDeviceAttributes_Message);
                }
                int droppedEvents = 0;
                int droppedMetrics = 0;
                int droppedSourceLevel = 0;
                for (CuptiActivityEvent cuptiActivityEvent : events) {
                    correlatedIntervalList = this.gpuIntervalMap.get(cuptiActivityEvent.correlationId);
                    for (ITimelineInterval correlatedInterval : correlatedIntervalList) {
                        if (correlatedInterval != null) {
                            if (this.addEvent(correlatedInterval, cuptiActivityEvent)) continue;
                            ++droppedEvents;
                            continue;
                        }
                        ++droppedEvents;
                    }
                }
                for (CuptiActivityMetric cuptiActivityMetric : metrics) {
                    correlatedIntervalList = this.gpuIntervalMap.get(cuptiActivityMetric.correlationId);
                    for (ITimelineInterval correlatedInterval : correlatedIntervalList) {
                        if (correlatedInterval != null) {
                            if (this.addMetric(correlatedInterval, cuptiActivityMetric)) continue;
                            ++droppedMetrics;
                            continue;
                        }
                        ++droppedMetrics;
                    }
                }
                for (ICuptiActivitySourceLevelResult iCuptiActivitySourceLevelResult : sourceLevelResults) {
                    correlatedIntervalList = this.gpuIntervalMap.get(iCuptiActivitySourceLevelResult.getCorrelationId());
                    for (ITimelineInterval correlatedInterval : correlatedIntervalList) {
                        if (correlatedInterval != null) {
                            if (this.addSourceLevelResult(correlatedInterval, iCuptiActivitySourceLevelResult)) continue;
                            ++droppedSourceLevel;
                            continue;
                        }
                        ++droppedSourceLevel;
                    }
                }
                if (droppedEvents > 0 || droppedMetrics > 0 || droppedSourceLevel > 0) {
                    this.openWarning(ViperMessages.DroppedEvents_Label, String.valueOf(droppedEvents) + " events, " + droppedMetrics + " metrics, and " + droppedSourceLevel + " " + ViperMessages.DroppedEvents_Message);
                }
            }
            catch (Exception e) {
                if (e instanceof ViperException) {
                    throw (ViperException)e;
                }
                throw new ViperException(e);
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
        }
        catch (Throwable throwable) {
            try {
                NativeCupti.cuptiPDMDestroyActivityIterator(hIterator);
            }
            catch (CuptiException cuptiException) {
                ViperExceptionHandler.logError("unable to destroy iterator");
            }
            throw throwable;
        }
        try {
            NativeCupti.cuptiPDMDestroyActivityIterator(hIterator);
        }
        catch (CuptiException cuptiException) {
            ViperExceptionHandler.logError("unable to destroy iterator");
        }
    }

    private void openWarning(final String label, final String message) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ViperMessageDialog.openWarning(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), label, message);
            }
        });
    }

    private void addInGpuIntervalMap(int correlationId, ITimelineInterval interval) {
        if (this.gpuIntervalMap.containsKey(correlationId)) {
            this.gpuIntervalMap.get(correlationId).add(interval);
        } else {
            ArrayList<ITimelineInterval> list = new ArrayList<ITimelineInterval>();
            list.add(interval);
            this.gpuIntervalMap.put(correlationId, list);
        }
    }

    private ProcessTL getProcess(int pid) {
        ProcessTL proc = new ProcessTL(pid);
        int idx = this.processes.indexOf(proc);
        if (idx == -1) {
            this.processes.add(proc);
        } else {
            proc = this.processes.get(idx);
        }
        return proc;
    }

    private DeviceTL getDevice(int id) {
        return this.devices.get(id);
    }

    private void addSourceLocator(CuptiActivitySourceLocator source) {
        if (source.id != 0) {
            this.sourceLocations.put(source.id, source);
        }
    }

    private void addFunction(CuptiActivityFunction function) {
        this.functions.put(function.id, function);
    }

    private void addModule(CuptiActivityModule module) {
        this.modules.add(module);
    }

    private DeviceTL addDevice(int id, CuptiActivityDevice activity) {
        DeviceTL device = this.devices.get(id);
        if (device == null) {
            device = new DeviceTL(activity);
            this.devices.put(id, device);
        } else if (activity != null) {
            device.activity = activity;
        }
        return device;
    }

    private ContextTL addContext(int id, CuptiActivityContext activity, String customName) {
        DeviceTL device = this.addDevice(activity.deviceId, null);
        return device.addContext(id, activity, customName);
    }

    private TimelineIntervalAPI addRuntimeInterval(CuptiActivityAPI activity) throws Exception {
        TimelineIntervalAPI runtime = new TimelineIntervalAPI(TimelineIntervalKind.RUNTIME, activity);
        ProcessTL process = this.getProcess(activity.processId);
        ThreadTL thread = process.getThread(activity.processId, activity.threadId);
        if (!thread.addInterval(runtime)) {
            throw new ViperException("unable to add interval for runtime call");
        }
        return runtime;
    }

    private TimelineIntervalAPI addDriverInterval(CuptiActivityAPI activity) throws Exception {
        TimelineIntervalAPI driver = new TimelineIntervalAPI(TimelineIntervalKind.DRIVER, activity);
        ProcessTL process = this.getProcess(activity.processId);
        ThreadTL thread = process.getThread(activity.processId, activity.threadId);
        if (!thread.addInterval(driver)) {
            throw new ViperException("unable to add interval for driver call");
        }
        return driver;
    }

    private TimelineIntervalKernel addKernelInterval(CuptiActivityKernel activity, String streamCustomName) throws ViperException {
        TimelineIntervalKernel kernel = new TimelineIntervalKernel(activity);
        DeviceTL device = this.addDevice(activity.deviceId, null);
        ContextTL context = device.addContext(activity.contextId, null, null);
        if (!context.addInterval(kernel, activity.deviceId, activity.contextId, activity.streamId, streamCustomName)) {
            throw new ViperException("unable to add interval for kernel " + activity.name);
        }
        return kernel;
    }

    private TimelineIntervalMemset addMemsetInterval(CuptiActivityMemset activity, String streamCustomName) throws ViperException {
        TimelineIntervalMemset memset = new TimelineIntervalMemset(activity);
        DeviceTL device = this.addDevice(activity.deviceId, null);
        ContextTL context = device.addContext(activity.contextId, null, null);
        if (!context.addInterval(memset, activity.deviceId, activity.contextId, activity.streamId, streamCustomName)) {
            throw new ViperException("unable to add interval for memset");
        }
        return memset;
    }

    private TimelineIntervalMemcpy addMemcpyInterval(CuptiActivityMemcpy activity, String streamCustomName) throws ViperException {
        TimelineIntervalKind kind = TimelineIntervalKind.UNKNOWN;
        switch (activity.getCopyKind()) {
            case CUPTI_ACTIVITY_MEMCPY_KIND_DTOH: 
            case CUPTI_ACTIVITY_MEMCPY_KIND_ATOH: {
                kind = TimelineIntervalKind.MEMCPY_DTOH;
                break;
            }
            case CUPTI_ACTIVITY_MEMCPY_KIND_HTOD: 
            case CUPTI_ACTIVITY_MEMCPY_KIND_HTOA: {
                kind = TimelineIntervalKind.MEMCPY_HTOD;
                break;
            }
            case CUPTI_ACTIVITY_MEMCPY_KIND_ATOA: 
            case CUPTI_ACTIVITY_MEMCPY_KIND_ATOD: 
            case CUPTI_ACTIVITY_MEMCPY_KIND_DTOA: 
            case CUPTI_ACTIVITY_MEMCPY_KIND_DTOD: {
                kind = TimelineIntervalKind.MEMCPY_DTOD;
                break;
            }
            case CUPTI_ACTIVITY_MEMCPY_KIND_HTOH: {
                break;
            }
            default: {
                throw new ViperException("unexpected memcpy copy kind " + (Object)((Object)activity.getCopyKind()));
            }
        }
        TimelineIntervalMemcpy memcpy = null;
        if (kind != TimelineIntervalKind.UNKNOWN) {
            memcpy = new TimelineIntervalMemcpy(kind, activity);
            DeviceTL device = this.addDevice(activity.deviceId, null);
            ContextTL context = device.addContext(activity.contextId, null, null);
            if (!context.addInterval(memcpy, activity.deviceId, activity.contextId, activity.streamId, streamCustomName)) {
                throw new ViperException("unable to add interval for memcpy");
            }
        }
        return memcpy;
    }

    private TimelineIntervalMemcpy addMemcpyP2pInterval(CuptiActivityMemcpyP2p activity, String streamCustomName) throws ViperException {
        TimelineIntervalMemcpy memcpy = new TimelineIntervalMemcpy(TimelineIntervalKind.MEMCPY_PTOP, activity);
        DeviceTL device = this.addDevice(activity.srcDeviceId, null);
        ContextTL context = device.addContext(activity.srcContextId, null, null);
        context.addInterval(memcpy, activity.srcDeviceId, activity.srcContextId, -1, streamCustomName);
        device = this.addDevice(activity.dstDeviceId, null);
        context = device.addContext(activity.dstContextId, null, null);
        context.addInterval(memcpy, activity.dstDeviceId, activity.dstContextId, -1, streamCustomName);
        device = this.addDevice(activity.deviceId, null);
        context = device.addContext(activity.contextId, null, null);
        context.getTimelineForKind(TimelineKind.STREAMS, true);
        TimelineStream stl = context.getTimelineForStream(activity.deviceId, activity.contextId, activity.streamId, streamCustomName, true);
        stl.addInterval(memcpy);
        return memcpy;
    }

    private void addOverheadInterval(CuptiActivityOverhead activity) throws Exception {
        if (CuptiActivityObjectKind.CUPTI_ACTIVITY_OBJECT_PROCESS.equals((Object)activity.getObjectKind())) {
            ProcessTL process = this.getProcess(activity.objectProcessId);
            if (!process.addOverhead(new TimelineIntervalOverhead(activity))) {
                throw new ViperException("unable to add interval for overhead");
            }
        } else {
            ViperExceptionHandler.logError("dropping unexpected overhead association with " + activity.objectKind);
        }
    }

    private void addEnvironmentInterval(CuptiActivityEnvironment activity) {
        DeviceTL device = this.getDevice(activity.deviceId);
        TimelineIntervalEnvironment interval = new TimelineIntervalEnvironment(activity);
        device.addEnvironmentInterval(interval);
    }

    private void addUVMCounter(CuptiActivityUvmCounter activity) {
        if (activity.getUvmCounterScope().equals((Object)CuptiActivityUvmCounterScope.CUPTI_ACTIVITY_UVM_COUNTER_SCOPE_PROCESS_SINGLE_DEVICE)) {
            DeviceTL device = this.getDevice(activity.deviceId);
            device.addUVMCounter(activity);
        }
    }

    private boolean addEvent(ITimelineInterval interval, CuptiActivityEvent eventActivity) throws Exception {
        Event event = EventManager.getEvent(eventActivity.domain, eventActivity.id);
        if (event == null) {
            return false;
        }
        interval.setEventValue(event, eventActivity.value);
        return true;
    }

    private boolean addMetric(ITimelineInterval interval, CuptiActivityMetric metricActivity) throws Exception {
        Metric metric = MetricManager.getMetric(metricActivity.id);
        if (metric == null) {
            return false;
        }
        metricActivity.valueKindCode = metric.getValueKind().getCode();
        if (metricActivity.getInstance() == -1) {
            interval.setAggregateMetricActivity(metric, metricActivity);
        } else {
            interval.setInstanceMetricActivity(metric, metricActivity.getInstance(), metricActivity);
        }
        return true;
    }

    private boolean addSourceLevelResult(ITimelineInterval interval, ICuptiActivitySourceLevelResult slrActivity) throws Exception {
        return interval.addSourceLevelResult(slrActivity);
    }

    private boolean setName(CuptiActivityName name) {
        switch (name.getObjectKind()) {
            case CUPTI_ACTIVITY_OBJECT_PROCESS: {
                ProcessTL process = this.getProcess(name.objectProcessId);
                if (process == null) {
                    return false;
                }
                process.customName = name.name;
                return true;
            }
            case CUPTI_ACTIVITY_OBJECT_THREAD: {
                ProcessTL process = this.getProcess(name.objectProcessId);
                if (process == null) {
                    return false;
                }
                ThreadTL thread = process.getThread(name.objectProcessId, name.objectThreadId);
                if (thread == null) {
                    return false;
                }
                thread.customName = name.name;
                return true;
            }
            case CUPTI_ACTIVITY_OBJECT_DEVICE: {
                DeviceTL device = this.getDevice(name.objectDeviceId);
                if (device == null) {
                    return false;
                }
                device.customName = name.name;
                return true;
            }
            case CUPTI_ACTIVITY_OBJECT_CONTEXT: {
                DeviceTL device = this.getDevice(name.objectDeviceId);
                if (device == null) {
                    return false;
                }
                ContextTL context = device.getContext(name.objectContextId);
                if (context == null) {
                    return false;
                }
                context.customName = name.name;
                return true;
            }
            case CUPTI_ACTIVITY_OBJECT_STREAM: {
                DeviceTL device = this.getDevice(name.objectDeviceId);
                if (device == null) {
                    return false;
                }
                ContextTL context = device.getContext(name.objectContextId);
                if (context == null) {
                    return false;
                }
                TimelineStream stream = context.getTimelineForStream(name.objectDeviceId, name.objectContextId, name.objectStreamId, null, false);
                if (stream == null) {
                    return false;
                }
                stream.setCustomName(name.name);
                return true;
            }
        }
        return false;
    }

    private int addMarkersAndRanges(List<CuptiActivityMarker> markers, Map<Integer, CuptiActivityMarkerData> markerDatas) {
        int droppedMarkers = 0;
        HashMap<Integer, CuptiActivityMarker> idMarkerMap = new HashMap<Integer, CuptiActivityMarker>();
        for (CuptiActivityMarker marker : markers) {
            CuptiActivityMarker end;
            if (CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_MARKER_INSTANTANEOUS.isSet(marker.flags)) {
                if (this.addMarker(marker, markerDatas.get(marker.id))) continue;
                ++droppedMarkers;
                continue;
            }
            if (!idMarkerMap.containsKey(marker.id)) {
                idMarkerMap.put(marker.id, marker);
                continue;
            }
            CuptiActivityMarker other = (CuptiActivityMarker)idMarkerMap.get(marker.id);
            CuptiActivityMarker start = CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_MARKER_START.isSet(marker.flags) ? marker : other;
            CuptiActivityMarker cuptiActivityMarker = end = CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_MARKER_END.isSet(marker.flags) ? marker : other;
            if (!this.addRange(start, end, markerDatas.get(start.id))) {
                ++droppedMarkers;
            }
            idMarkerMap.remove(marker.id);
        }
        return droppedMarkers;
    }

    private boolean addMarker(CuptiActivityMarker marker, CuptiActivityMarkerData markerData) {
        switch (marker.getObjectKind()) {
            case CUPTI_ACTIVITY_OBJECT_THREAD: {
                ProcessTL process = this.getProcess(marker.objectProcessId);
                if (process == null) {
                    return false;
                }
                ThreadTL thread = process.getThread(marker.objectProcessId, marker.objectThreadId);
                if (thread == null) {
                    return false;
                }
                return thread.addInterval(new TimelineIntervalMarker(marker, markerData));
            }
        }
        return false;
    }

    private boolean addRange(CuptiActivityMarker start, CuptiActivityMarker end, CuptiActivityMarkerData markerData) {
        if (start != null && CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_MARKER_START.isSet(start.flags) && end != null && CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_MARKER_END.isSet(end.flags)) {
            switch (start.getObjectKind()) {
                case CUPTI_ACTIVITY_OBJECT_THREAD: {
                    ProcessTL process = this.getProcess(start.objectProcessId);
                    if (process == null) {
                        return false;
                    }
                    ThreadTL thread = process.getThread(start.objectProcessId, start.objectThreadId);
                    if (thread == null) {
                        return false;
                    }
                    return thread.addInterval(new TimelineIntervalRange(start, end, markerData));
                }
            }
        }
        return false;
    }

    private int addDeviceAttributes(List<CuptiActivityDeviceAttribute> deviceAttributes) {
        int dropped = 0;
        for (CuptiActivityDeviceAttribute attr : deviceAttributes) {
            DeviceTL device = this.getDevice(attr.deviceId);
            if (device == null) {
                ++dropped;
                continue;
            }
            device.addAttribute(attr);
        }
        return dropped;
    }

    public boolean createTimelines(Session session) {
        SourceLocator locator = session.getSourceLocator();
        for (CuptiActivitySourceLocator source : this.sourceLocations.values()) {
            locator.addLocation(source);
        }
        CudaFunctionManager cudaFunctionManager = session.getCudaFunctionManager();
        for (CuptiActivityModule module : this.modules) {
            cudaFunctionManager.addModule(module);
            for (CuptiActivityFunction function : this.functions.values()) {
                cudaFunctionManager.addFunction(function);
            }
        }
        for (ProcessTL process : this.processes) {
            if (process.createTimelines(session)) continue;
            return false;
        }
        for (DeviceTL device : this.devices.values()) {
            if (device.createTimelines(session)) continue;
            return false;
        }
        Executable exec = session.getExecutable();
        List<Timeline> uvmTimelines = session.getTimelines(TimelineKind.UVM);
        if (exec != null && exec.isUvmProfiling() && uvmTimelines != null && uvmTimelines.isEmpty() && !this.devices.isEmpty()) {
            UvmMessageDialog.show();
        }
        this.createAPIAssociations(session);
        for (Timeline timeline : session.getTimelines()) {
            timeline.updateDurations();
        }
        return true;
    }

    private void createAPIAssociations(Session session) {
        for (List<ITimelineInterval> intervalList : this.gpuIntervalMap.values()) {
            for (ITimelineInterval interval : intervalList) {
                TimelineIntervalHierarchy hier;
                if (!(interval instanceof TimelineIntervalHierarchy) || (hier = (TimelineIntervalHierarchy)interval).getParent() != null) continue;
                TimelineIntervalAPI runtime = null;
                if (this.pdmVersion >= 4) {
                    runtime = this.runtimeApiIntervalMap.get(interval.getCorrelationId());
                } else {
                    int runtimeCorrelationId = 0;
                    if (interval instanceof TimelineIntervalKernel) {
                        runtimeCorrelationId = ((TimelineIntervalKernel)interval).getRuntimeCorrelationId();
                    } else if (interval instanceof TimelineIntervalMemset) {
                        runtimeCorrelationId = ((TimelineIntervalMemset)interval).getRuntimeCorrelationId();
                    } else if (interval instanceof TimelineIntervalMemcpy) {
                        runtimeCorrelationId = ((TimelineIntervalMemcpy)interval).getRuntimeCorrelationId();
                    }
                    if (runtimeCorrelationId != 0) {
                        runtime = this.runtimeApiIntervalMap.get(runtimeCorrelationId);
                    }
                }
                TimelineIntervalAPI driver = this.driverApiIntervalMap.get(interval.getCorrelationId());
                if (driver != null) {
                    driver.addChild(hier);
                    if (runtime != null) {
                        runtime.addChild(driver);
                    }
                } else if (runtime != null) {
                    runtime.addChild(hier);
                }
                if (runtime == null) continue;
                runtime.setCorrelationId(interval.getCorrelationId());
            }
        }
    }

    private TimelineDevice getSessionDevice(Session session, int id, String customName) {
        List<Timeline> sessionDevices = session.getTimelines(TimelineKind.DEVICE);
        for (Timeline timeline : sessionDevices) {
            if (!(customName != null ? customName.equals(timeline.getCustomName()) : ((TimelineDevice)timeline).getId() == id)) continue;
            return (TimelineDevice)timeline;
        }
        return null;
    }

    private TimelineContext getSessionContext(Session session, TimelineDevice deviceTimeline, int id, String customName) {
        List<Timeline> sessionContexts = deviceTimeline.getDescendants(TimelineKind.CONTEXT);
        for (Timeline timeline : sessionContexts) {
            if (!(customName != null ? customName.equals(timeline.getCustomName()) : ((TimelineContext)timeline).getId() == id)) continue;
            return (TimelineContext)timeline;
        }
        return null;
    }

    private Timeline getSessionStream(Session session, TimelineContext sessionContext, ContextTL context, Timeline stream) {
        List<Timeline> sessionStreams = sessionContext.getDescendants(TimelineKind.STREAM);
        if (stream.getCustomName() != null) {
            String name = stream.getCustomName();
            for (Timeline timeline : sessionStreams) {
                if (timeline.getCustomName() == null || !timeline.getCustomName().equals(name)) continue;
                return timeline;
            }
        } else {
            StreamOrderComparator streamOrderComparator = new StreamOrderComparator();
            Timeline[] orderedSessionStreams = sessionStreams.toArray(new Timeline[0]);
            Arrays.sort(orderedSessionStreams, streamOrderComparator);
            Timeline[] orderedStreams = context.streamMap.values().toArray(new Timeline[0]);
            Arrays.sort(orderedStreams, streamOrderComparator);
            int i = 0;
            while (i < orderedStreams.length) {
                if (orderedStreams[i] == stream) {
                    return orderedSessionStreams[i];
                }
                ++i;
            }
        }
        return null;
    }

    private boolean mergeIntervalCompare(ITimelineInterval interval, ITimelineInterval sessionInterval) {
        if (!interval.getKind().equals((Object)sessionInterval.getKind())) {
            return false;
        }
        return !TimelineIntervalKind.KERNEL.equals((Object)interval.getKind()) || interval.getName().equals(sessionInterval.getName());
    }

    public boolean merge(Session session, SessionFilter scope, boolean mergeEvents, boolean mergeMetrics, boolean mergeSourceLevelResults, Set<SourceLevelResult> nullSourceLevelResults) {
        if (scope == null) {
            return this.mergeTimelines(session, mergeEvents, mergeMetrics, mergeSourceLevelResults, nullSourceLevelResults);
        }
        if (scope.isSingleKernelInstance()) {
            return this.mergeSingleKernel(session, scope, mergeEvents, mergeMetrics, mergeSourceLevelResults, nullSourceLevelResults);
        }
        return false;
    }

    public boolean mergeSingleKernel(Session session, SessionFilter scope, boolean mergeEvents, boolean mergeMetrics, boolean mergeSourceLevelResults, Set<SourceLevelResult> nullSourceLevelResults) {
        DeviceTL device;
        Timeline sessionKernelTimeline;
        Timeline sessionDeviceTimeline;
        boolean completeMerge = false;
        TimelineIntervalKernel sessionKernel = scope.getSingleKernelInstance(session);
        if (sessionKernel != null && (sessionDeviceTimeline = (sessionKernelTimeline = sessionKernel.getPrimaryTimeline()).getAncestor(TimelineKind.DEVICE)) != null && (device = this.devices.get(scope.getDeviceId())) != null) {
            List<Timeline> sessionContexts;
            ContextTL context = null;
            if (scope.getContextName() != null) {
                for (ContextTL ctx : device.contexts.values()) {
                    if (!scope.getContextName().equals(ctx.customName)) continue;
                    context = ctx;
                    break;
                }
            } else {
                context = (ContextTL)device.contexts.get(scope.getContextId());
            }
            if (context == null && device.contexts.size() == 1 && (sessionContexts = sessionDeviceTimeline.getDescendants(TimelineKind.CONTEXT)).size() == 1) {
                context = (ContextTL)device.contexts.get(0);
            }
            if (context != null) {
                TimelineStream stream = null;
                if (scope.getStreamName() != null) {
                    for (Timeline strm : context.streamMap.values()) {
                        if (!scope.getStreamName().equals(strm.getCustomName())) continue;
                        stream = (TimelineStream)strm;
                        break;
                    }
                } else {
                    stream = (TimelineStream)context.streamMap.get(scope.getStreamId());
                }
                TimelineIntervalKernel kernel = this.getScopeKernel(scope, stream);
                if (kernel != null) {
                    completeMerge = true;
                    if (mergeEvents) {
                        completeMerge &= this.mergeEvents(kernel, sessionKernel);
                    }
                    if (mergeMetrics) {
                        completeMerge &= this.mergeMetrics(kernel, sessionKernel);
                    }
                    if (mergeSourceLevelResults) {
                        completeMerge &= this.mergeSourceLevel(session, kernel, sessionKernel, nullSourceLevelResults, false);
                    }
                }
            }
        }
        return completeMerge;
    }

    private TimelineIntervalKernel getScopeKernel(SessionFilter scope, TimelineStream stream) {
        ITimelineInterval ret;
        if (stream != null && this.correlationIdProfiled >= 0 && (ret = this.gpuIntervalMap.get(this.correlationIdProfiled).get(0)) instanceof TimelineIntervalKernel && scope.getKernelName().equals(ret.getName())) {
            return (TimelineIntervalKernel)ret;
        }
        return null;
    }

    private boolean mergeTimelines(Session session, boolean mergeEvents, boolean mergeMetrics, boolean mergeSourceLevelResults, Set<SourceLevelResult> nullSourceLevelResults) {
        boolean completeMerge = true;
        for (DeviceTL device : this.devices.values()) {
            if (device.activity == null) continue;
            boolean hasContent = false;
            for (ContextTL context : device.contexts.values()) {
                if (context.isEmpty()) continue;
                hasContent = true;
                break;
            }
            if (!hasContent) continue;
            TimelineDevice sessionDevice = this.getSessionDevice(session, ((DeviceTL)device).activity.id, device.customName);
            if (sessionDevice == null) {
                completeMerge = false;
                continue;
            }
            for (ContextTL context : device.contexts.values()) {
                if (context.isEmpty()) continue;
                TimelineContext sessionContext = this.getSessionContext(session, sessionDevice, ((ContextTL)context).activity.contextId, context.customName);
                if (sessionContext == null) {
                    List<Timeline> sessionContexts = sessionDevice.getDescendants(TimelineKind.CONTEXT);
                    if (device.contexts.values().size() == 1 && sessionContexts.size() == 1) {
                        sessionContext = (TimelineContext)sessionContexts.get(0);
                    } else {
                        completeMerge = false;
                        continue;
                    }
                }
                block3: for (Timeline stream : context.streamMap.values()) {
                    Timeline sessionStream = this.getSessionStream(session, sessionContext, context, stream);
                    if (sessionStream == null) {
                        completeMerge = false;
                        continue;
                    }
                    List<ITimelineInterval> intervals = stream.getIntervals();
                    Iterator<ITimelineInterval> sessionIntervalsIter = sessionStream.getIntervals().iterator();
                    for (ITimelineInterval interval : intervals) {
                        ITimelineInterval sessionInterval = null;
                        while (sessionIntervalsIter.hasNext()) {
                            sessionInterval = sessionIntervalsIter.next();
                            if (!sessionInterval.getKind().isMemcpyKind() && !TimelineIntervalKind.MEMSET.equals((Object)sessionInterval.getKind()) || interval.getKind().isMemcpyKind() || TimelineIntervalKind.MEMSET.equals((Object)interval.getKind())) break;
                        }
                        if (sessionInterval == null) continue block3;
                        if (!this.mergeIntervalCompare(interval, sessionInterval)) {
                            completeMerge = false;
                            continue block3;
                        }
                        if (!(interval instanceof TimelineIntervalKernel)) continue;
                        TimelineIntervalKernel kernel = (TimelineIntervalKernel)interval;
                        TimelineIntervalKernel sessionKernel = (TimelineIntervalKernel)sessionInterval;
                        if (mergeEvents) {
                            completeMerge &= this.mergeEvents(kernel, sessionKernel);
                        }
                        if (mergeMetrics) {
                            completeMerge &= this.mergeMetrics(kernel, sessionKernel);
                        }
                        if (!mergeSourceLevelResults) continue;
                        completeMerge &= this.mergeSourceLevel(session, kernel, sessionKernel, nullSourceLevelResults, false);
                    }
                }
            }
        }
        return completeMerge;
    }

    private boolean mergeMetrics(TimelineIntervalKernel kernel, TimelineIntervalKernel sessionKernel) {
        Set<Metric> aggregate = kernel.getAggregateMetrics();
        for (Metric metric : aggregate) {
            sessionKernel.setAggregateMetricActivity(metric, kernel.getAggregateMetricActivity(metric));
        }
        Set<Metric> instance = kernel.getInstanceMetrics();
        for (Metric metric : instance) {
            for (CuptiActivityMetric instanceMetric : kernel.getInstanceMetricActivities(metric)) {
                sessionKernel.setInstanceMetricActivity(metric, instanceMetric.getInstance(), instanceMetric);
            }
        }
        return true;
    }

    private boolean mergeSourceLevel(Session session, TimelineIntervalKernel kernel, TimelineIntervalKernel sessionKernel, Set<SourceLevelResult> nullSourceLevelResults, boolean append) {
        SourceLocator sessionSourceLocator = session.getSourceLocator();
        CudaFunctionManager cudaFunctionManager = session.getCudaFunctionManager();
        if (this.modules != null && this.modules.size() > 1) {
            ViperExceptionHandler.logError("Many modules found for a single kernel");
            return false;
        }
        if (!this.modules.isEmpty()) {
            CuptiActivityModule localModule = this.modules.get(0);
            CuptiActivityModule module = cudaFunctionManager.getModule(localModule.cubinSize, localModule.cubin);
            if (module == null) {
                module = cudaFunctionManager.createModule(localModule.contextId, localModule.cubinSize, localModule.cubin);
            }
            for (CuptiActivityFunction function : this.functions.values()) {
                function.moduleId = module.id;
                function.contextId = module.contextId;
            }
        }
        Collection<ICuptiActivitySourceLevelResult> results = kernel.getSourceLevelResults();
        HashSet<CuptiActivityKind> presentKinds = new HashSet<CuptiActivityKind>();
        HashSet<CuptiActivityKind> kinds = new HashSet<CuptiActivityKind>();
        for (ICuptiActivitySourceLevelResult result : results) {
            kinds.add(result.getKind());
        }
        HashSet<ICuptiActivitySourceLevelResult> currentResults = new HashSet<ICuptiActivitySourceLevelResult>(sessionKernel.getSourceLevelResults());
        for (ICuptiActivitySourceLevelResult iCuptiActivitySourceLevelResult : currentResults) {
            if (!kinds.contains((Object)iCuptiActivitySourceLevelResult.getKind())) continue;
            if (append) {
                presentKinds.add(iCuptiActivitySourceLevelResult.getKind());
                continue;
            }
            sessionKernel.removeSourceLevelResult(iCuptiActivitySourceLevelResult);
        }
        for (ICuptiActivitySourceLevelResult iCuptiActivitySourceLevelResult : results) {
            CuptiActivitySourceLocator cuptiLocator = this.sourceLocations.get(iCuptiActivitySourceLevelResult.getSourceLocatorId());
            CuptiActivitySourceLocator sessionCuptiLocator = null;
            if (cuptiLocator != null && cuptiLocator.id != 0 && (sessionCuptiLocator = sessionSourceLocator.getLocation(cuptiLocator.getFileUri(), cuptiLocator.lineNumber)) == null) {
                sessionCuptiLocator = sessionSourceLocator.createLocation(cuptiLocator.getFileUri(), cuptiLocator.lineNumber);
            }
            iCuptiActivitySourceLevelResult.setSourceLocatorId(sessionCuptiLocator == null ? 0 : sessionCuptiLocator.id);
            sessionKernel.addSourceLevelResult(iCuptiActivitySourceLevelResult);
            presentKinds.add(iCuptiActivitySourceLevelResult.getKind());
            if (!(iCuptiActivitySourceLevelResult instanceof CuptiActivityInstructionExecution)) continue;
            CuptiActivityInstructionExecution instructionExecutionResult = (CuptiActivityInstructionExecution)iCuptiActivitySourceLevelResult;
            CuptiActivityFunction cuptiFunction = this.functions.get(instructionExecutionResult.functionId);
            CuptiActivityFunction sessionCuptiFunction = null;
            if (cuptiFunction != null && (sessionCuptiFunction = cudaFunctionManager.getFunction(cuptiFunction.name, cuptiFunction.moduleId)) == null) {
                sessionCuptiFunction = cudaFunctionManager.createFunction(cuptiFunction.name, cuptiFunction.contextId, cuptiFunction.moduleId, cuptiFunction.index);
            }
            int n = instructionExecutionResult.functionId = sessionCuptiFunction == null ? -1 : sessionCuptiFunction.id;
        }
        if (nullSourceLevelResults != null) {
            for (SourceLevelResult sourceLevelResult : nullSourceLevelResults) {
                if (presentKinds.contains((Object)sourceLevelResult.getActivityKind())) continue;
                sessionKernel.addSourceLevelResult(sourceLevelResult.createNullCuptiActivity(sessionKernel));
            }
        }
        return true;
    }

    private boolean mergeEvents(TimelineIntervalKernel kernel, TimelineIntervalKernel sessionKernel) {
        for (Event event : kernel.getEvents()) {
            sessionKernel.setEventValue(event, kernel.getEventValue(event));
        }
        return true;
    }

    private class ContextTL {
        private CuptiActivityContext activity;
        private String customName;
        private final Map<TimelineKind, Timeline> timelineKindMap;
        private final Map<Integer, Timeline> streamMap;
        private final List<ITimelineInterval> kernelIntervals;

        public ContextTL(CuptiActivityContext activity) {
            this.activity = activity;
            this.timelineKindMap = new HashMap<TimelineKind, Timeline>();
            this.kernelIntervals = new ArrayList<ITimelineInterval>();
            this.streamMap = new HashMap<Integer, Timeline>();
        }

        public void setCustomName(String customName) {
            if (this.customName == null) {
                this.customName = customName;
            }
        }

        public boolean isEmpty() {
            return this.timelineKindMap.isEmpty() && this.kernelIntervals.isEmpty() && this.streamMap.isEmpty();
        }

        protected TimelineStream getTimelineForStream(int deviceId, int contextId, int streamId, String customName, boolean create) {
            Timeline tl = this.streamMap.get(streamId);
            if (create && tl == null) {
                tl = new TimelineStream(deviceId, contextId, streamId);
                tl.setCustomName(customName);
                this.streamMap.put(streamId, tl);
            }
            return (TimelineStream)tl;
        }

        protected Timeline getTimelineForKind(TimelineKind kind, boolean create) {
            Timeline tl = this.timelineKindMap.get((Object)kind);
            if (create && tl == null) {
                tl = TimelineKind.MEMCPY_DTOH.equals((Object)kind) || TimelineKind.MEMCPY_HTOD.equals((Object)kind) || TimelineKind.MEMCPY_DTOD.equals((Object)kind) || TimelineKind.MEMCPY_PTOP.equals((Object)kind) ? new TimelineMemcpy(this.getTimelineNameForKind(kind), kind) : new Timeline(this.getTimelineNameForKind(kind), kind);
                this.timelineKindMap.put(kind, tl);
            }
            return tl;
        }

        protected String getTimelineNameForKind(TimelineKind kind) {
            if (TimelineKind.STREAMS.equals((Object)kind)) {
                return "Streams";
            }
            if (TimelineKind.KERNELS.equals((Object)kind)) {
                return "Compute";
            }
            if (TimelineKind.MEMCPY_DTOH.equals((Object)kind)) {
                return "MemCpy (DtoH)";
            }
            if (TimelineKind.MEMCPY_HTOD.equals((Object)kind)) {
                return "MemCpy (HtoD)";
            }
            if (TimelineKind.MEMCPY_DTOD.equals((Object)kind)) {
                return "MemCpy (DtoD)";
            }
            if (TimelineKind.MEMCPY_PTOP.equals((Object)kind)) {
                return "MemCpy (PtoP)";
            }
            return "<unknown>";
        }

        public boolean addInterval(ITimelineInterval interval, int deviceId, int contextId, int streamId, String streamCustomName) {
            switch (interval.getKind()) {
                case MEMSET: 
                case KERNEL: {
                    Timeline tl = this.getTimelineForKind(TimelineKind.KERNELS, true);
                    tl.addInterval(interval);
                    this.kernelIntervals.add(interval);
                    break;
                }
                case MEMCPY_DTOH: {
                    Timeline tl = this.getTimelineForKind(TimelineKind.MEMCPY_DTOH, true);
                    tl.addInterval(interval);
                    interval.setPrimaryTimeline(tl);
                    break;
                }
                case MEMCPY_HTOD: {
                    Timeline tl = this.getTimelineForKind(TimelineKind.MEMCPY_HTOD, true);
                    tl.addInterval(interval);
                    interval.setPrimaryTimeline(tl);
                    break;
                }
                case MEMCPY_DTOD: {
                    Timeline tl = this.getTimelineForKind(TimelineKind.MEMCPY_DTOD, true);
                    tl.addInterval(interval);
                    interval.setPrimaryTimeline(tl);
                    break;
                }
                case MEMCPY_PTOP: {
                    Timeline tl = this.getTimelineForKind(TimelineKind.MEMCPY_PTOP, true);
                    tl.addInterval(interval);
                    interval.setPrimaryTimeline(tl);
                    break;
                }
                default: {
                    return false;
                }
            }
            if (!(streamId <= -1 || interval instanceof TimelineIntervalHierarchy && ((TimelineIntervalHierarchy)interval).getParentGridId() != 0L)) {
                this.getTimelineForKind(TimelineKind.STREAMS, true);
                TimelineStream stl = this.getTimelineForStream(deviceId, contextId, streamId, streamCustomName, true);
                stl.addInterval(interval);
            }
            return true;
        }

        protected boolean createTimelines(Session session, Timeline parent) {
            if (this.activity == null || CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_UNKNOWN.equals((Object)this.activity.getComputeKind())) {
                return false;
            }
            if (!this.isEmpty()) {
                Timeline comp;
                Timeline ptop;
                Timeline dtod;
                Timeline dtoh;
                Timeline htod;
                TimelineContext ctl = new TimelineContext(this.activity);
                parent.appendChild(ctl);
                if (this.customName != null) {
                    ctl.setCustomName(this.customName);
                }
                if ((htod = this.getTimelineForKind(TimelineKind.MEMCPY_HTOD, false)) != null) {
                    ctl.appendChild(htod);
                }
                if ((dtoh = this.getTimelineForKind(TimelineKind.MEMCPY_DTOH, false)) != null) {
                    ctl.appendChild(dtoh);
                }
                if ((dtod = this.getTimelineForKind(TimelineKind.MEMCPY_DTOD, false)) != null) {
                    ctl.appendChild(dtod);
                }
                if ((ptop = this.getTimelineForKind(TimelineKind.MEMCPY_PTOP, false)) != null) {
                    ctl.appendChild(ptop);
                }
                if ((comp = this.getTimelineForKind(TimelineKind.KERNELS, false)) != null) {
                    ctl.appendChild(comp);
                }
                this.connectParentChildKernels();
                HashSet<TimelineKernel> rootTimelines = new HashSet<TimelineKernel>();
                Map<TimelineKernel, Map<String, TimelineKernel>> timelineTree = this.createTimelineTree(rootTimelines);
                TimelineKernel[] hostLaunchedKernels = new TimelineKernel[rootTimelines.size()];
                int kcnt = 0;
                for (TimelineKernel kernel : rootTimelines) {
                    hostLaunchedKernels[kcnt++] = kernel;
                    this.addChildTimelines(session, kernel, timelineTree);
                    this.setMinimumCompletionTime(kernel);
                    kernel.setContainerState(ContainerState.CLOSED);
                }
                Arrays.sort(hostLaunchedKernels, new TimelineKernel.TotalExecutionTimeComparator());
                TimelineKernel[] timelineKernelArray = hostLaunchedKernels;
                int n = hostLaunchedKernels.length;
                int n2 = 0;
                while (n2 < n) {
                    TimelineKernel kernel;
                    kernel = timelineKernelArray[n2];
                    comp.appendChild(kernel);
                    ++n2;
                }
                Timeline streams = this.getTimelineForKind(TimelineKind.STREAMS, false);
                if (streams != null) {
                    ctl.appendChild(streams);
                }
                Object[] streamIds = this.streamMap.keySet().toArray(new Integer[0]);
                Arrays.sort(streamIds);
                Object[] objectArray = streamIds;
                int n3 = streamIds.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object streamId = objectArray[n4];
                    Timeline stream = this.streamMap.get(streamId);
                    if (stream != null) {
                        streams.appendChild(stream);
                    }
                    ++n4;
                }
            }
            return true;
        }

        private void addChildTimelines(Session session, TimelineKernel parent, Map<TimelineKernel, Map<String, TimelineKernel>> timelineTree) {
            Map<String, TimelineKernel> childTimelineNameMap = timelineTree.get(parent);
            if (childTimelineNameMap != null) {
                TimelineKernel[] childArray = new TimelineKernel[childTimelineNameMap.size()];
                int ccnt = 0;
                for (TimelineKernel child : childTimelineNameMap.values()) {
                    childArray[ccnt++] = child;
                    this.addChildTimelines(session, child, timelineTree);
                    this.setMinimumCompletionTime(child);
                    child.setContainerState(ContainerState.CLOSED);
                }
                Arrays.sort(childArray, new TimelineKernel.TotalExecutionTimeComparator());
                TimelineKernel[] timelineKernelArray = childArray;
                int n = childArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TimelineKernel child;
                    child = timelineKernelArray[n2];
                    parent.appendChild(child);
                    ++n2;
                }
            }
        }

        private void setMinimumCompletionTime(TimelineKernel timeline) {
            for (ITimelineInterval interval : timeline.getIntervals()) {
                TimelineIntervalKernel kernel;
                if (!(interval instanceof TimelineIntervalKernel) || (kernel = (TimelineIntervalKernel)interval).getChildren() == null) continue;
                long completed = 0L;
                for (TimelineIntervalHierarchy child : kernel.getChildren()) {
                    if (!(child instanceof TimelineIntervalKernel)) continue;
                    TimelineIntervalKernel childKernel = (TimelineIntervalKernel)child;
                    long childCompleted = childKernel.getMinimumCompletion();
                    if (childCompleted == 0L) {
                        childCompleted = childKernel.getEnd();
                    }
                    completed = completed == 0L ? childCompleted : Math.max(completed, childCompleted);
                }
                kernel.setMinimumCompletion(completed);
            }
        }

        private void connectParentChildKernels() {
            for (ITimelineInterval kernel : this.kernelIntervals) {
                ITimelineInterval parent;
                TimelineIntervalHierarchy hier;
                long parentGridId;
                if (!(kernel instanceof TimelineIntervalHierarchy) || (parentGridId = (hier = (TimelineIntervalHierarchy)kernel).getParentGridId()) == 0L || (parent = (ITimelineInterval)TimelineFactory.this.gridIdIntervalMap.get(parentGridId)) == null || !(parent instanceof TimelineIntervalHierarchy)) continue;
                ((TimelineIntervalHierarchy)parent).addChild(hier);
            }
        }

        private Map<TimelineKernel, Map<String, TimelineKernel>> createTimelineTree(Set<TimelineKernel> rootTimelines) {
            HashMap<String, TimelineKernel> rootNameMap = new HashMap<String, TimelineKernel>();
            HashMap<TimelineKernel, Map<String, TimelineKernel>> timelineTree = new HashMap<TimelineKernel, Map<String, TimelineKernel>>();
            for (ITimelineInterval kernel : this.kernelIntervals) {
                if (kernel instanceof TimelineIntervalHierarchy && ((TimelineIntervalHierarchy)kernel).getParentGridId() != 0L) continue;
                TimelineKernel rootTimeline = (TimelineKernel)rootNameMap.get(kernel.getName());
                if (rootTimeline == null) {
                    rootTimeline = new TimelineKernel(kernel.getName());
                    rootNameMap.put(kernel.getName(), rootTimeline);
                }
                rootTimeline.addInterval(kernel);
                kernel.setPrimaryTimeline(rootTimeline);
                if (!(kernel instanceof TimelineIntervalHierarchy)) continue;
                this.createChildTimelines((TimelineIntervalHierarchy)kernel, rootTimeline, timelineTree);
            }
            rootTimelines.clear();
            rootTimelines.addAll(rootNameMap.values());
            return timelineTree;
        }

        private void createChildTimelines(TimelineIntervalHierarchy parent, TimelineKernel parentTimeline, Map<TimelineKernel, Map<String, TimelineKernel>> timelineTree) {
            List<TimelineIntervalHierarchy> children = parent.getChildren();
            if (children == null || children.isEmpty()) {
                return;
            }
            Map<String, TimelineKernel> childTimelineNameMap = timelineTree.get(parentTimeline);
            if (childTimelineNameMap == null) {
                childTimelineNameMap = new HashMap<String, TimelineKernel>();
                timelineTree.put(parentTimeline, childTimelineNameMap);
            }
            for (TimelineIntervalHierarchy hchild : children) {
                TimelineIntervalHierarchy child = hchild;
                TimelineKernel childTimeline = childTimelineNameMap.get(child.getName());
                if (childTimeline == null) {
                    childTimeline = new TimelineKernel(child.getName());
                    parentTimeline.appendChild(childTimeline);
                    childTimelineNameMap.put(child.getName(), childTimeline);
                }
                childTimeline.addInterval(child);
                child.setPrimaryTimeline(childTimeline);
                this.createChildTimelines(hchild, childTimeline, timelineTree);
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof ContextTL) {
                return this.activity.contextId == ((ContextTL)obj).activity.contextId;
            }
            return false;
        }
    }

    private class DeviceTL {
        private CuptiActivityDevice activity;
        private String customName;
        private final Map<Integer, ContextTL> contexts;
        private final UVMTL uvm;
        private final List<CuptiActivityDeviceAttribute> attributes;
        private final List<TimelineIntervalEnvironment> environmentIntervals;

        public DeviceTL(CuptiActivityDevice activity) {
            this.activity = activity;
            this.contexts = new HashMap<Integer, ContextTL>();
            this.attributes = new LinkedList<CuptiActivityDeviceAttribute>();
            this.environmentIntervals = new LinkedList<TimelineIntervalEnvironment>();
            this.uvm = new UVMTL();
        }

        public ContextTL getContext(int id) {
            return this.contexts.get(id);
        }

        protected ContextTL addContext(int id, CuptiActivityContext activity, String customName) {
            ContextTL context = this.contexts.get(id);
            if (context == null) {
                context = new ContextTL(activity);
                this.contexts.put(id, context);
            } else if (activity != null) {
                context.activity = activity;
            }
            context.setCustomName(customName);
            return context;
        }

        public void addAttribute(CuptiActivityDeviceAttribute attr) {
            this.attributes.add(attr);
        }

        public void addEnvironmentInterval(TimelineIntervalEnvironment interval) {
            this.environmentIntervals.add(interval);
        }

        protected void addUVMCounter(CuptiActivityUvmCounter uvmCounter) {
            this.uvm.addUvmCounter(uvmCounter);
        }

        protected boolean createTimelines(Session session) {
            if (this.activity == null) {
                return false;
            }
            if (!this.contexts.isEmpty() || !this.uvm.isEmpty()) {
                TimelineDevice deviceTimeline = new TimelineDevice(this.activity);
                this.uvm.createTimelines(session, deviceTimeline);
                if (this.customName != null) {
                    deviceTimeline.setCustomName(this.customName);
                }
                int failedContexts = 0;
                for (ContextTL context : this.contexts.values()) {
                    if (context.createTimelines(session, deviceTimeline)) continue;
                    ++failedContexts;
                }
                if (failedContexts > 0) {
                    ViperMessageDialog.openWarning(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ViperMessages.UnsupportedContext_Label, String.valueOf(failedContexts) + " " + ViperMessages.UnsupportedContext_Message);
                }
                deviceTimeline.addAttributes(this.attributes);
                if (!deviceTimeline.getChildren().isEmpty()) {
                    session.addTopLevelTimeline(deviceTimeline, false);
                }
                for (TimelineIntervalEnvironment environment : this.environmentIntervals) {
                    deviceTimeline.addInterval(environment);
                    environment.setPrimaryTimeline(deviceTimeline);
                }
            }
            return true;
        }

        public boolean equals(Object obj) {
            if (obj instanceof DeviceTL) {
                return this.activity.id == ((DeviceTL)obj).activity.id;
            }
            return false;
        }
    }

    private class ProcessTL {
        private final int pid;
        private String customName;
        private final List<ThreadTL> threads;
        private final List<TimelineIntervalOverhead> overheadIntervals;

        public ProcessTL(int pid) {
            this.pid = pid;
            this.threads = new LinkedList<ThreadTL>();
            this.overheadIntervals = new LinkedList<TimelineIntervalOverhead>();
        }

        protected ThreadTL getThread(int pid, int tid) {
            ThreadTL thd = new ThreadTL(pid, tid);
            int idx = this.threads.indexOf(thd);
            if (idx == -1) {
                this.threads.add(thd);
            } else {
                thd = this.threads.get(idx);
            }
            return thd;
        }

        protected boolean addOverhead(TimelineIntervalOverhead interval) {
            return this.overheadIntervals.add(interval);
        }

        protected boolean createTimelines(Session session) {
            TimelineProcess processTimeline = new TimelineProcess(this.pid);
            if (this.customName != null) {
                processTimeline.setCustomName(this.customName);
            }
            for (ThreadTL thread : this.threads) {
                if (thread.createTimelines(session, processTimeline)) continue;
                return false;
            }
            if (!this.overheadIntervals.isEmpty()) {
                Timeline tl = new Timeline("Profiling Overhead", TimelineKind.OVERHEADS);
                processTimeline.appendChild(tl);
                for (TimelineIntervalOverhead overhead : this.overheadIntervals) {
                    tl.addInterval(overhead);
                    overhead.setPrimaryTimeline(tl);
                }
            }
            if (!processTimeline.getChildren().isEmpty()) {
                session.addTopLevelTimeline(processTimeline, false);
            }
            return true;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProcessTL) {
                return this.pid == ((ProcessTL)obj).pid;
            }
            return false;
        }
    }

    private class StreamOrderComparator
    implements Comparator<Timeline> {
        private StreamOrderComparator() {
        }

        @Override
        public int compare(Timeline o1, Timeline o2) {
            long start1 = 0L;
            long start2 = 0L;
            List<ITimelineInterval> intervals1 = o1.getIntervals();
            List<ITimelineInterval> intervals2 = o2.getIntervals();
            for (ITimelineInterval interval : intervals1) {
                if (!(interval instanceof TimelineIntervalKernel)) continue;
                start1 = interval.getStart();
                break;
            }
            for (ITimelineInterval interval : intervals2) {
                if (!(interval instanceof TimelineIntervalKernel)) continue;
                start2 = interval.getStart();
                break;
            }
            if (start1 == 0L && start2 == 0L) {
                return 0;
            }
            if (start1 == 0L) {
                return 1;
            }
            if (start2 == 0L) {
                return -1;
            }
            if (start1 < start2) {
                return -1;
            }
            if (start1 > start2) {
                return 1;
            }
            return 0;
        }
    }

    private class ThreadTL {
        private final int tid;
        private final int pid;
        private String customName;
        private final Map<TimelineKind, Timeline> timelineMap;

        public ThreadTL(int pid, int tid) {
            this.pid = pid;
            this.tid = tid;
            this.timelineMap = new HashMap<TimelineKind, Timeline>();
        }

        public boolean isEmpty() {
            return this.timelineMap.isEmpty();
        }

        private String getTimelineNameForKind(TimelineKind kind) {
            if (TimelineKind.RUNTIME.equals((Object)kind)) {
                return "Runtime API";
            }
            if (TimelineKind.DRIVER.equals((Object)kind)) {
                return "Driver API";
            }
            if (TimelineKind.MARKER.equals((Object)kind)) {
                return "Markers and Ranges";
            }
            return "<unknown>";
        }

        private Timeline getTimelineForKind(TimelineKind kind, boolean create) {
            Timeline tl = this.timelineMap.get((Object)kind);
            if (create && tl == null) {
                tl = new Timeline(this.getTimelineNameForKind(kind), kind);
                this.timelineMap.put(kind, tl);
            }
            return tl;
        }

        public boolean addInterval(ITimelineInterval interval) {
            TimelineKind kind = null;
            switch (interval.getKind()) {
                case RUNTIME: {
                    kind = TimelineKind.RUNTIME;
                    break;
                }
                case DRIVER: {
                    kind = TimelineKind.DRIVER;
                    break;
                }
                case MARKER: 
                case RANGE: {
                    kind = TimelineKind.MARKER;
                    break;
                }
                default: {
                    return false;
                }
            }
            Timeline tl = this.getTimelineForKind(kind, true);
            tl.addInterval(interval);
            interval.setPrimaryTimeline(tl);
            return true;
        }

        protected boolean createTimelines(Session session, Timeline parent) {
            if (!this.isEmpty()) {
                Timeline marker;
                Timeline driver;
                Timeline runtime;
                TimelineThread threadTimeline = new TimelineThread(this.pid, this.tid);
                parent.appendChild(threadTimeline);
                if (this.customName != null) {
                    threadTimeline.setCustomName(this.customName);
                }
                if ((runtime = this.getTimelineForKind(TimelineKind.RUNTIME, false)) != null) {
                    threadTimeline.appendChild(runtime);
                }
                if ((driver = this.getTimelineForKind(TimelineKind.DRIVER, false)) != null) {
                    threadTimeline.appendChild(driver);
                }
                if ((marker = this.getTimelineForKind(TimelineKind.MARKER, false)) != null) {
                    threadTimeline.appendChild(marker);
                }
            }
            return true;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ThreadTL) {
                return this.tid == ((ThreadTL)obj).tid;
            }
            return false;
        }
    }

    private class UVMTL {
        private Map<Integer, Map<CuptiActivityUvmCounterKind, List<CuptiActivityUvmCounter>>> uvmCounterMap = new HashMap<Integer, Map<CuptiActivityUvmCounterKind, List<CuptiActivityUvmCounter>>>();

        public boolean isEmpty() {
            return this.uvmCounterMap.isEmpty();
        }

        private TimelineUVM getTimelineForKind(TimelineKind timelineKind) {
            TimelineIntervalKind intervalKind;
            CuptiActivityUvmCounterKind uvmCounterKind;
            TimelineUVM t1;
            switch (timelineKind) {
                case UVM_PAGE_FAULT: {
                    t1 = new TimelineUVM(CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_CPU_PAGE_FAULT_COUNT.getName(), timelineKind);
                    uvmCounterKind = CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_CPU_PAGE_FAULT_COUNT;
                    intervalKind = TimelineIntervalKind.UVM_PAGE_FAULT;
                    break;
                }
                case UVM_MEMCPY_HTOD: {
                    t1 = new TimelineUVM(CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_HTOD.getName(), timelineKind);
                    uvmCounterKind = CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_HTOD;
                    intervalKind = TimelineIntervalKind.UVM_MEMCPY_HTOD;
                    break;
                }
                case UVM_MEMCPY_DTOH: {
                    t1 = new TimelineUVM(CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_DTOH.getName(), timelineKind);
                    uvmCounterKind = CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_DTOH;
                    intervalKind = TimelineIntervalKind.UVM_MEMCPY_DTOH;
                    break;
                }
                default: {
                    return null;
                }
            }
            for (Integer processId : this.uvmCounterMap.keySet()) {
                List<CuptiActivityUvmCounter> activityList = this.getCounterListForKind(uvmCounterKind, processId);
                if (activityList == null || activityList.isEmpty()) continue;
                int i = 0;
                while (i < activityList.size() - 1) {
                    long value = activityList.get((int)(i + 1)).value - activityList.get((int)i).value;
                    if (value > 0L) {
                        TimelineIntervalUVM uvmInterval = new TimelineIntervalUVM(intervalKind, activityList.get((int)i).timestamp, activityList.get((int)(i + 1)).timestamp, value, activityList.get((int)i).processId);
                        uvmInterval.setPrimaryTimeline(t1);
                        t1.addInterval(uvmInterval);
                    }
                    ++i;
                }
            }
            return t1;
        }

        private List<CuptiActivityUvmCounter> getCounterListForKind(CuptiActivityUvmCounterKind uvmCounterKind, int processId) {
            if (this.uvmCounterMap.containsKey(processId)) {
                List<CuptiActivityUvmCounter> uvmCounterListPerProcess = this.uvmCounterMap.get(processId).get((Object)uvmCounterKind);
                if (uvmCounterListPerProcess != null) {
                    Collections.sort(uvmCounterListPerProcess, new Comparator<CuptiActivityUvmCounter>(){

                        @Override
                        public int compare(CuptiActivityUvmCounter counter1, CuptiActivityUvmCounter counter2) {
                            if (counter1.timestamp > counter2.timestamp) {
                                return 1;
                            }
                            return -1;
                        }
                    });
                }
                return uvmCounterListPerProcess;
            }
            return null;
        }

        public void addUvmCounter(CuptiActivityUvmCounter uvmCounter) {
            Map<Object, Object> uvmCounterKindMap = this.uvmCounterMap.containsKey(uvmCounter.processId) ? this.uvmCounterMap.get(uvmCounter.processId) : new HashMap();
            List<CuptiActivityUvmCounter> uvmCounterList = uvmCounterKindMap.containsKey((Object)uvmCounter.getUvmCounterKind()) ? (List)uvmCounterKindMap.get((Object)uvmCounter.getUvmCounterKind()) : new ArrayList<CuptiActivityUvmCounter>();
            uvmCounterList.add(uvmCounter);
            uvmCounterKindMap.put((Object)uvmCounter.getUvmCounterKind(), uvmCounterList);
            this.uvmCounterMap.put(uvmCounter.processId, uvmCounterKindMap);
        }

        protected boolean createTimelines(Session session, Timeline parent) {
            if (!this.isEmpty()) {
                TimelineUVM pageFault;
                TimelineUVM dtoh;
                TimelineUVM uvm = new TimelineUVM("Unified Memory", TimelineKind.UVM);
                TimelineUVM htod = this.getTimelineForKind(TimelineKind.UVM_MEMCPY_HTOD);
                if (htod != null && htod.getNumIntervals() > 0) {
                    uvm.appendChild(htod);
                }
                if ((dtoh = this.getTimelineForKind(TimelineKind.UVM_MEMCPY_DTOH)) != null && dtoh.getNumIntervals() > 0) {
                    uvm.appendChild(dtoh);
                }
                if ((pageFault = this.getTimelineForKind(TimelineKind.UVM_PAGE_FAULT)) != null && pageFault.getNumIntervals() > 0) {
                    uvm.appendChild(pageFault);
                }
                if (!uvm.getChildren().isEmpty()) {
                    parent.appendChild(uvm);
                    return true;
                }
            }
            return false;
        }
    }
}

