/*
 * Decompiled with CFR 0.152.
 */
package javafx.fxml;

import com.sun.javafx.beans.IDProperty;
import com.sun.javafx.fxml.BeanAdapter;
import com.sun.javafx.fxml.LoadListener;
import com.sun.javafx.fxml.ObservableListChangeEvent;
import com.sun.javafx.fxml.ObservableMapChangeEvent;
import com.sun.javafx.fxml.PropertyChangeEvent;
import com.sun.javafx.fxml.PropertyNotFoundException;
import com.sun.javafx.fxml.expression.Expression;
import com.sun.javafx.fxml.expression.VariableExpression;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import javafx.beans.DefaultProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.fxml.JavaFXBuilderFactory;
import javafx.fxml.LoadException;
import javafx.fxml.ParseTraceElement;
import javafx.util.Builder;
import javafx.util.BuilderFactory;
import javafx.util.Callback;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;

public class FXMLLoader {
    private ObservableMap<String, Object> namespace = FXCollections.observableHashMap();
    private URL location;
    private ResourceBundle resources;
    private BuilderFactory builderFactory;
    private Callback<Class<?>, Object> controllerFactory;
    private Charset charset;
    private LinkedList<FXMLLoader> loaders;
    private ClassLoader classLoader = defaultClassLoader;
    private boolean staticLoad = false;
    private LoadListener loadListener = null;
    private XMLStreamReader xmlStreamReader = null;
    private Element current = null;
    private Object root = null;
    private Object controller = null;
    private ScriptEngine scriptEngine = null;
    private URL exceptionLocation;
    private int exceptionLineNumber;
    private LinkedList<String> packages = new LinkedList();
    private HashMap<String, Class<?>> classes = new HashMap();
    private ScriptEngineManager scriptEngineManager = null;
    private HashMap<String, Field> controllerFields = null;
    private HashMap<String, Method> controllerMethods = null;
    private static ClassLoader defaultClassLoader;
    private static boolean enableBidirectionalBinding;
    private static final Pattern extraneousWhitespacePattern;
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final String LANGUAGE_PROCESSING_INSTRUCTION = "language";
    public static final String IMPORT_PROCESSING_INSTRUCTION = "import";
    public static final String FX_NAMESPACE_PREFIX = "fx";
    public static final String FX_CONTROLLER_ATTRIBUTE = "controller";
    public static final String FX_ID_ATTRIBUTE = "id";
    public static final String FX_VALUE_ATTRIBUTE = "value";
    public static final String FX_CONSTANT_ATTRIBUTE = "constant";
    public static final String FX_FACTORY_ATTRIBUTE = "factory";
    public static final String INCLUDE_TAG = "include";
    public static final String INCLUDE_SOURCE_ATTRIBUTE = "source";
    public static final String INCLUDE_RESOURCES_ATTRIBUTE = "resources";
    public static final String INCLUDE_CHARSET_ATTRIBUTE = "charset";
    public static final String SCRIPT_TAG = "script";
    public static final String SCRIPT_SOURCE_ATTRIBUTE = "source";
    public static final String SCRIPT_CHARSET_ATTRIBUTE = "charset";
    public static final String DEFINE_TAG = "define";
    public static final String REFERENCE_TAG = "reference";
    public static final String REFERENCE_SOURCE_ATTRIBUTE = "source";
    public static final String ROOT_TAG = "root";
    public static final String ROOT_TYPE_ATTRIBUTE = "type";
    public static final String COPY_TAG = "copy";
    public static final String COPY_SOURCE_ATTRIBUTE = "source";
    public static final String EVENT_HANDLER_PREFIX = "on";
    public static final String EVENT_KEY = "event";
    public static final String CHANGE_EVENT_HANDLER_SUFFIX = "Change";
    public static final String NULL_KEYWORD = "null";
    public static final String ESCAPE_PREFIX = "\\";
    public static final String RELATIVE_PATH_PREFIX = "@";
    public static final String RESOURCE_KEY_PREFIX = "%";
    public static final String EXPRESSION_PREFIX = "$";
    public static final String BINDING_EXPRESSION_PREFIX = "{";
    public static final String BINDING_EXPRESSION_SUFFIX = "}";
    public static final String BI_DIRECTIONAL_BINDING_PREFIX = "#{";
    public static final String BI_DIRECTIONAL_BINDING_SUFFIX = "}";
    public static final String ARRAY_COMPONENT_DELIMITER = ",";
    public static final String LOCATION_KEY = "location";
    public static final String RESOURCES_KEY = "resources";
    public static final String CONTROLLER_METHOD_PREFIX = "#";
    public static final String CONTROLLER_KEYWORD = "controller";
    public static final String CONTROLLER_SUFFIX = "Controller";
    public static final String INITIALIZE_METHOD_NAME = "initialize";

    public FXMLLoader() {
        this((URL)null);
    }

    public FXMLLoader(URL uRL) {
        this(uRL, null);
    }

    public FXMLLoader(URL uRL, ResourceBundle resourceBundle) {
        this(uRL, resourceBundle, new JavaFXBuilderFactory());
    }

    public FXMLLoader(URL uRL, ResourceBundle resourceBundle, BuilderFactory builderFactory) {
        this(uRL, resourceBundle, builderFactory, null);
    }

    public FXMLLoader(URL uRL, ResourceBundle resourceBundle, BuilderFactory builderFactory, Callback<Class<?>, Object> callback) {
        this(uRL, resourceBundle, builderFactory, callback, Charset.forName(DEFAULT_CHARSET_NAME));
    }

    public FXMLLoader(Charset charset) {
        this(null, null, null, null, charset);
    }

    public FXMLLoader(URL uRL, ResourceBundle resourceBundle, BuilderFactory builderFactory, Callback<Class<?>, Object> callback, Charset charset) {
        this(uRL, resourceBundle, builderFactory, callback, charset, new LinkedList<FXMLLoader>());
    }

    public FXMLLoader(URL uRL, ResourceBundle resourceBundle, BuilderFactory builderFactory, Callback<Class<?>, Object> callback, Charset charset, LinkedList<FXMLLoader> linkedList) {
        this.setLocation(uRL);
        this.setResources(resourceBundle);
        this.setBuilderFactory(builderFactory);
        this.setControllerFactory(callback);
        this.setCharset(charset);
        this.loaders = linkedList;
    }

    public ObservableMap<String, Object> getNamespace() {
        return this.namespace;
    }

    public <T> T getRoot() {
        return (T)this.root;
    }

    public void setRoot(Object object) {
        this.root = object;
    }

    public <T> T getController() {
        return (T)this.controller;
    }

    public void setController(Object object) {
        this.controller = object;
        if (object == null) {
            this.namespace.remove("controller");
        } else {
            this.namespace.put("controller", object);
        }
        this.controllerFields = null;
        this.controllerMethods = null;
    }

    public URL getLocation() {
        return this.location;
    }

    public void setLocation(URL uRL) {
        this.location = uRL;
    }

    public ResourceBundle getResources() {
        return this.resources;
    }

    public void setResources(ResourceBundle resourceBundle) {
        this.resources = resourceBundle;
    }

    public BuilderFactory getBuilderFactory() {
        return this.builderFactory;
    }

    public void setBuilderFactory(BuilderFactory builderFactory) {
        this.builderFactory = builderFactory;
    }

    public Callback<Class<?>, Object> getControllerFactory() {
        return this.controllerFactory;
    }

    public void setControllerFactory(Callback<Class<?>, Object> callback) {
        this.controllerFactory = callback;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset is null.");
        }
        this.charset = charset;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException();
        }
        this.classLoader = classLoader;
    }

    public boolean isStaticLoad() {
        return this.staticLoad;
    }

    public void setStaticLoad(boolean bl) {
        this.staticLoad = bl;
    }

    public LoadListener getLoadListener() {
        return this.loadListener;
    }

    public void setLoadListener(LoadListener loadListener) {
        this.loadListener = loadListener;
    }

    public Object load() throws IOException {
        Object object;
        if (this.location == null) {
            throw new IllegalStateException("Location is not set.");
        }
        InputStream inputStream = null;
        try {
            inputStream = this.location.openStream();
            object = this.load(inputStream);
        }
        catch (IOException iOException) {
            this.logException(iOException);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.logException(runtimeException);
            throw runtimeException;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return object;
    }

    public Object load(InputStream inputStream) throws IOException {
        Object object;
        if (inputStream == null) {
            throw new NullPointerException("inputStream is null.");
        }
        this.namespace.put(LOCATION_KEY, this.location);
        this.namespace.put("resources", this.resources);
        this.packages.clear();
        this.classes.clear();
        this.scriptEngine = null;
        this.exceptionLocation = null;
        this.exceptionLineNumber = -1;
        try {
            XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
            xMLInputFactory.setProperty("javax.xml.stream.isCoalescing", true);
            object = new InputStreamReader(inputStream, this.charset);
            this.xmlStreamReader = new StreamReaderDelegate(xMLInputFactory.createXMLStreamReader((Reader)object)){

                @Override
                public String getPrefix() {
                    String string = super.getPrefix();
                    if (string != null && string.length() == 0) {
                        string = null;
                    }
                    return string;
                }

                @Override
                public String getAttributePrefix(int n) {
                    String string = super.getAttributePrefix(n);
                    if (string != null && string.length() == 0) {
                        string = null;
                    }
                    return string;
                }
            };
        }
        catch (XMLStreamException xMLStreamException) {
            throw new LoadException(xMLStreamException);
        }
        this.loaders.push(this);
        try {
            while (this.xmlStreamReader.hasNext()) {
                int n = this.xmlStreamReader.next();
                switch (n) {
                    case 3: {
                        this.processProcessingInstruction();
                        break;
                    }
                    case 5: {
                        this.processComment();
                        break;
                    }
                    case 1: {
                        this.processStartElement();
                        break;
                    }
                    case 2: {
                        this.processEndElement();
                        break;
                    }
                    case 4: {
                        this.processCharacters();
                    }
                }
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new LoadException(xMLStreamException);
        }
        if (this.controller != null) {
            if (this.controller instanceof Initializable) {
                ((Initializable)this.controller).initialize(this.location, this.resources);
            } else {
                Method method;
                Field field;
                HashMap<String, Field> hashMap = this.getControllerFields();
                object = hashMap.get(LOCATION_KEY);
                if (object != null) {
                    try {
                        ((Field)object).set(this.controller, this.location);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                if ((field = hashMap.get("resources")) != null) {
                    try {
                        field.set(this.controller, this.resources);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                if ((method = this.getControllerMethods().get(INITIALIZE_METHOD_NAME)) != null) {
                    try {
                        method.invoke(this.controller, new Object[0]);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new LoadException(illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new LoadException(invocationTargetException);
                    }
                }
            }
        }
        this.loaders.pop();
        this.xmlStreamReader = null;
        return this.root;
    }

    private void logException(Exception exception) {
        String string = exception.getMessage();
        if (string == null) {
            string = exception.getClass().getName();
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append("\n");
        for (FXMLLoader fXMLLoader : this.loaders) {
            stringBuilder.append(fXMLLoader.location.getPath());
            if (fXMLLoader.current != null) {
                stringBuilder.append(":");
                stringBuilder.append(fXMLLoader.current.lineNumber);
            }
            stringBuilder.append("\n");
        }
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        if (stackTraceElementArray != null) {
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                stringBuilder.append("  at ");
                stringBuilder.append(stackTraceElementArray[i].toString());
                stringBuilder.append("\n");
            }
        }
        System.err.println(stringBuilder.toString());
    }

    public int getLineNumber() {
        return this.xmlStreamReader.getLocation().getLineNumber();
    }

    public ParseTraceElement[] getParseTrace() {
        ParseTraceElement[] parseTraceElementArray = new ParseTraceElement[this.loaders.size()];
        int n = 0;
        for (FXMLLoader fXMLLoader : this.loaders) {
            parseTraceElementArray[n++] = new ParseTraceElement(fXMLLoader.location, fXMLLoader.current != null ? fXMLLoader.current.lineNumber : -1);
        }
        return parseTraceElementArray;
    }

    private void processProcessingInstruction() throws LoadException {
        String string = this.xmlStreamReader.getPITarget().trim();
        if (string.equals(LANGUAGE_PROCESSING_INSTRUCTION)) {
            this.processLanguage();
        } else if (string.equals(IMPORT_PROCESSING_INSTRUCTION)) {
            this.processImport();
        }
    }

    private void processLanguage() throws LoadException {
        if (this.scriptEngine != null) {
            throw new LoadException("Page language already set.");
        }
        String string = this.xmlStreamReader.getPIData();
        if (this.loadListener != null) {
            this.loadListener.readLanguageProcessingInstruction(string);
        }
        if (!this.staticLoad) {
            ScriptEngineManager scriptEngineManager = this.getScriptEngineManager();
            this.scriptEngine = scriptEngineManager.getEngineByName(string);
            this.scriptEngine.setBindings(scriptEngineManager.getBindings(), 100);
        }
    }

    private void processImport() throws LoadException {
        String string = this.xmlStreamReader.getPIData().trim();
        if (this.loadListener != null) {
            this.loadListener.readImportProcessingInstruction(string);
        }
        if (string.endsWith(".*")) {
            this.importPackage(string.substring(0, string.length() - 2));
        } else {
            this.importClass(string);
        }
    }

    private void processComment() throws LoadException {
        if (this.loadListener != null) {
            this.loadListener.readComment(this.xmlStreamReader.getText());
        }
    }

    private void processStartElement() throws IOException {
        this.createElement();
        this.current.processStartElement();
        if (this.root == null) {
            this.root = this.current.value;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createElement() throws IOException {
        String string = this.xmlStreamReader.getPrefix();
        String string2 = this.xmlStreamReader.getLocalName();
        if (string == null) {
            int n = string2.lastIndexOf(46);
            if (Character.isLowerCase(string2.charAt(n + 1))) {
                String string3 = string2.substring(n + 1);
                if (n == -1) {
                    if (this.loadListener != null) {
                        this.loadListener.beginPropertyElement(string3, null);
                    }
                    this.current = new PropertyElement(string3, null);
                    return;
                } else {
                    Class<?> clazz = this.getType(string2.substring(0, n));
                    if (clazz != null) {
                        if (this.loadListener != null) {
                            this.loadListener.beginPropertyElement(string3, clazz);
                        }
                        this.current = new PropertyElement(string3, clazz);
                        return;
                    } else {
                        if (!this.staticLoad) throw new LoadException(string2 + " is not a valid property.");
                        if (this.loadListener != null) {
                            this.loadListener.beginUnknownStaticPropertyElement(string2);
                        }
                        this.current = new UnknownStaticPropertyElement(string2);
                    }
                }
                return;
            } else {
                if (this.current == null && this.root != null) {
                    throw new LoadException("Root value already specified.");
                }
                Class<?> clazz = this.getType(string2);
                if (clazz != null) {
                    if (this.loadListener != null) {
                        this.loadListener.beginInstanceDeclarationElement(clazz);
                    }
                    this.current = new InstanceDeclarationElement(clazz);
                    return;
                } else {
                    if (!this.staticLoad) throw new LoadException(string2 + " is not a valid type.");
                    if (this.loadListener != null) {
                        this.loadListener.beginUnknownTypeElement(string2);
                    }
                    this.current = new UnknownTypeElement(string2);
                }
            }
            return;
        } else {
            if (!string.equals(FX_NAMESPACE_PREFIX)) throw new LoadException("Unexpected namespace prefix: " + string + ".");
            if (string2.equals(INCLUDE_TAG)) {
                if (this.loadListener != null) {
                    this.loadListener.beginIncludeElement();
                }
                this.current = new IncludeElement();
                return;
            } else if (string2.equals(REFERENCE_TAG)) {
                if (this.loadListener != null) {
                    this.loadListener.beginReferenceElement();
                }
                this.current = new ReferenceElement();
                return;
            } else if (string2.equals(COPY_TAG)) {
                if (this.loadListener != null) {
                    this.loadListener.beginCopyElement();
                }
                this.current = new CopyElement();
                return;
            } else if (string2.equals(ROOT_TAG)) {
                if (this.loadListener != null) {
                    this.loadListener.beginRootElement();
                }
                this.current = new RootElement();
                return;
            } else if (string2.equals(SCRIPT_TAG)) {
                if (this.loadListener != null) {
                    this.loadListener.beginScriptElement();
                }
                this.current = new ScriptElement();
                return;
            } else {
                if (!string2.equals(DEFINE_TAG)) throw new LoadException(string + ":" + string2 + " is not a valid element.");
                if (this.loadListener != null) {
                    this.loadListener.beginDefineElement();
                }
                this.current = new DefineElement();
            }
        }
    }

    private void processEndElement() throws IOException {
        this.current.processEndElement();
        if (this.loadListener != null) {
            this.loadListener.endElement(this.current.value);
        }
        this.current = this.current.parent;
    }

    private void processCharacters() throws IOException {
        if (!this.xmlStreamReader.isWhiteSpace()) {
            this.current.processCharacters();
        }
    }

    private void importPackage(String string) throws LoadException {
        this.packages.add(string);
    }

    private void importClass(String string) throws LoadException {
        try {
            this.loadType(string, true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new LoadException(classNotFoundException);
        }
    }

    private Class<?> getType(String string) throws LoadException {
        Class<?> clazz = null;
        if (Character.isLowerCase(string.charAt(0))) {
            try {
                clazz = this.loadType(string, false);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        } else {
            clazz = this.classes.get(string);
            if (clazz == null) {
                for (String string2 : this.packages) {
                    try {
                        clazz = this.loadTypeForPackage(string2, string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    if (clazz == null) continue;
                    break;
                }
                if (clazz != null) {
                    this.classes.put(string, clazz);
                }
            }
        }
        return clazz;
    }

    private Class<?> loadType(String string, boolean bl) throws ClassNotFoundException {
        int n = string.indexOf(46);
        int n2 = string.length();
        while (n != -1 && n < n2 && Character.isLowerCase(string.charAt(n + 1))) {
            n = string.indexOf(46, n + 1);
        }
        if (n == -1 || n == n2) {
            throw new ClassNotFoundException();
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        Class<?> clazz = this.loadTypeForPackage(string2, string3);
        if (bl) {
            this.classes.put(string3, clazz);
        }
        return clazz;
    }

    private Class<?> loadTypeForPackage(String string, String string2) throws ClassNotFoundException {
        return this.classLoader.loadClass(string + "." + string2.replace('.', '$'));
    }

    private ScriptEngineManager getScriptEngineManager() {
        if (this.scriptEngineManager == null) {
            this.scriptEngineManager = new ScriptEngineManager();
            this.scriptEngineManager.setBindings(new SimpleBindings(this.namespace));
        }
        return this.scriptEngineManager;
    }

    private HashMap<String, Field> getControllerFields() throws LoadException {
        if (this.controllerFields == null) {
            Class<?> clazz;
            this.controllerFields = new HashMap();
            for (Class<?> clazz2 = clazz = this.controller.getClass(); clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
                Field[] fieldArray = clazz2.getDeclaredFields();
                for (int i = 0; i < fieldArray.length; ++i) {
                    Field field = fieldArray[i];
                    int n = field.getModifiers();
                    if (clazz2 != clazz && (n & 2) != 0) continue;
                    int n2 = field.getModifiers();
                    if ((n2 & 1) == 0 && field.getAnnotation(FXML.class) != null) {
                        try {
                            field.setAccessible(true);
                        }
                        catch (SecurityException securityException) {
                            throw new LoadException(securityException);
                        }
                    }
                    this.controllerFields.put(field.getName(), field);
                }
            }
        }
        return this.controllerFields;
    }

    private HashMap<String, Method> getControllerMethods() throws LoadException {
        if (this.controllerMethods == null) {
            Class<?> clazz;
            this.controllerMethods = new HashMap();
            for (Class<?> clazz2 = clazz = this.controller.getClass(); clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
                Method[] methodArray = clazz2.getDeclaredMethods();
                for (int i = 0; i < methodArray.length; ++i) {
                    Method method = methodArray[i];
                    int n = method.getModifiers();
                    if (clazz2 != clazz && (n & 2) != 0) continue;
                    int n2 = method.getModifiers();
                    if ((n2 & 1) == 0 && method.getAnnotation(FXML.class) != null) {
                        try {
                            method.setAccessible(true);
                        }
                        catch (SecurityException securityException) {
                            throw new LoadException(securityException);
                        }
                    }
                    String string = method.getName();
                    Class<?>[] classArray = method.getParameterTypes();
                    if (string.equals(INITIALIZE_METHOD_NAME)) {
                        if (classArray.length != 0) continue;
                        this.controllerMethods.put(method.getName(), method);
                        continue;
                    }
                    if ((classArray.length != 1 || !Event.class.isAssignableFrom(classArray[0])) && (classArray.length != 0 || this.controllerMethods.containsKey(string))) continue;
                    this.controllerMethods.put(method.getName(), method);
                }
            }
        }
        return this.controllerMethods;
    }

    public static Class<?> loadType(String string, String string2) throws ClassNotFoundException {
        return FXMLLoader.loadType(string + "." + string2.replace('.', '$'));
    }

    public static Class<?> loadType(String string) throws ClassNotFoundException {
        return Class.forName(string, true, defaultClassLoader);
    }

    public static ClassLoader getDefaultClassLoader() {
        return defaultClassLoader;
    }

    public static void setDefaultClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException();
        }
        defaultClassLoader = classLoader;
    }

    public static <T> T load(URL uRL) throws IOException {
        return FXMLLoader.load(uRL, null);
    }

    public static <T> T load(URL uRL, ResourceBundle resourceBundle) throws IOException {
        return FXMLLoader.load(uRL, resourceBundle, new JavaFXBuilderFactory());
    }

    public static <T> T load(URL uRL, ResourceBundle resourceBundle, BuilderFactory builderFactory) throws IOException {
        return FXMLLoader.load(uRL, resourceBundle, builderFactory, null);
    }

    public static <T> T load(URL uRL, ResourceBundle resourceBundle, BuilderFactory builderFactory, Callback<Class<?>, Object> callback) throws IOException {
        return FXMLLoader.load(uRL, resourceBundle, builderFactory, callback, Charset.forName(DEFAULT_CHARSET_NAME));
    }

    public static <T> T load(URL uRL, ResourceBundle resourceBundle, BuilderFactory builderFactory, Callback<Class<?>, Object> callback, Charset charset) throws IOException {
        if (uRL == null) {
            throw new NullPointerException("Location is required.");
        }
        FXMLLoader fXMLLoader = new FXMLLoader(uRL, resourceBundle, builderFactory, callback, charset);
        return (T)fXMLLoader.load();
    }

    static {
        enableBidirectionalBinding = false;
        extraneousWhitespacePattern = Pattern.compile("\\s+");
        defaultClassLoader = Thread.currentThread().getContextClassLoader();
        if (defaultClassLoader == null) {
            defaultClassLoader = ClassLoader.getSystemClassLoader();
        }
        try {
            String string = System.getProperty(FXMLLoader.class.getName() + ".enableBidirectionalBinding");
            enableBidirectionalBinding = string != null && Boolean.parseBoolean(string);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static class ExpressionTargetMapping
    implements ChangeListener<Object> {
        public final Expression source;
        public final Object target;
        public final List<String> path;

        public ExpressionTargetMapping(Expression expression, Object object, List<String> list) {
            this.source = expression;
            this.target = object;
            this.path = list;
        }

        @Override
        public void changed(ObservableValue<? extends Object> observableValue, Object object, Object object2) {
            if (this.source.isDefined()) {
                Expression.set(this.target, this.path, this.source.getValue());
            }
        }
    }

    private static class PropertyChangeAdapter
    implements ChangeListener<Object> {
        public final Object source;
        public final EventHandler<PropertyChangeEvent<?>> handler;

        public PropertyChangeAdapter(Object object, EventHandler<PropertyChangeEvent<?>> eventHandler) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (eventHandler == null) {
                throw new NullPointerException();
            }
            this.source = object;
            this.handler = eventHandler;
        }

        @Override
        public void changed(ObservableValue<? extends Object> observableValue, Object object, Object object2) {
            this.handler.handle(new PropertyChangeEvent<Object>(this.source, object));
        }
    }

    private static class ObservableMapChangeAdapter
    implements MapChangeListener<Object, Object> {
        public final ObservableMap<Object, Object> source;
        public final EventHandler<ObservableMapChangeEvent<?, ?>> handler;

        public ObservableMapChangeAdapter(ObservableMap<Object, Object> observableMap, EventHandler<ObservableMapChangeEvent<?, ?>> eventHandler) {
            this.source = observableMap;
            this.handler = eventHandler;
        }

        @Override
        public void onChanged(MapChangeListener.Change<? extends Object, ? extends Object> change) {
            EventType<ObservableMapChangeEvent<?, ?>> eventType;
            if (change.wasAdded() && change.wasRemoved()) {
                eventType = ObservableMapChangeEvent.UPDATE;
            } else if (change.wasAdded()) {
                eventType = ObservableMapChangeEvent.ADD;
            } else if (change.wasRemoved()) {
                eventType = ObservableMapChangeEvent.REMOVE;
            } else {
                throw new UnsupportedOperationException();
            }
            this.handler.handle(new ObservableMapChangeEvent<Object, Object>(this.source, eventType, change.getKey(), change.getValueRemoved()));
        }
    }

    private static class ObservableListChangeAdapter
    implements ListChangeListener<Object> {
        public final ObservableList<Object> source;
        public final EventHandler<ObservableListChangeEvent<?>> handler;

        public ObservableListChangeAdapter(ObservableList<Object> observableList, EventHandler<ObservableListChangeEvent<?>> eventHandler) {
            this.source = observableList;
            this.handler = eventHandler;
        }

        @Override
        public void onChanged(ListChangeListener.Change<? extends Object> change) {
            while (change.next()) {
                EventType<ObservableListChangeEvent<?>> eventType;
                List<? extends Object> list = change.getRemoved();
                if (change.wasPermutated()) {
                    eventType = ObservableListChangeEvent.UPDATE;
                    list = null;
                } else if (change.wasAdded() && change.wasRemoved()) {
                    eventType = ObservableListChangeEvent.UPDATE;
                } else if (change.wasAdded()) {
                    eventType = ObservableListChangeEvent.ADD;
                } else if (change.wasRemoved()) {
                    eventType = ObservableListChangeEvent.REMOVE;
                } else {
                    throw new UnsupportedOperationException();
                }
                this.handler.handle(new ObservableListChangeEvent<Object>(this.source, eventType, change.getFrom(), change.getTo(), list));
            }
        }
    }

    private static class ScriptEventHandler
    implements EventHandler<Event> {
        public final String script;
        public final ScriptEngine scriptEngine;

        public ScriptEventHandler(String string, ScriptEngine scriptEngine) {
            this.script = string;
            this.scriptEngine = scriptEngine;
        }

        @Override
        public void handle(Event event) {
            Bindings bindings = this.scriptEngine.getBindings(100);
            Bindings bindings2 = this.scriptEngine.createBindings();
            bindings2.put(FXMLLoader.EVENT_KEY, (Object)event);
            this.scriptEngine.setBindings(bindings2, 100);
            try {
                this.scriptEngine.eval(this.script);
            }
            catch (ScriptException scriptException) {
                throw new RuntimeException(scriptException);
            }
            this.scriptEngine.setBindings(bindings, 100);
        }
    }

    private static class ControllerMethodEventHandler
    implements EventHandler<Event> {
        public final Object controller;
        public final Method method;
        public final boolean typed;

        public ControllerMethodEventHandler(Object object, Method method) {
            this.controller = object;
            this.method = method;
            this.typed = method.getParameterTypes().length == 1;
        }

        @Override
        public void handle(Event event) {
            try {
                if (this.typed) {
                    this.method.invoke(this.controller, event);
                } else {
                    this.method.invoke(this.controller, new Object[0]);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
        }
    }

    private static class Attribute {
        public final String name;
        public final Class<?> sourceType;
        public final String value;

        public Attribute(String string, Class<?> clazz, String string2) {
            this.name = string;
            this.sourceType = clazz;
            this.value = string2;
        }
    }

    private class DefineElement
    extends Element {
        private DefineElement() {
        }

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public void add(Object object) {
        }

        @Override
        public void processAttribute(String string, String string2, String string3) throws LoadException {
            throw new LoadException("Element does not support attributes.");
        }
    }

    private class ScriptElement
    extends Element {
        public String source;
        public Charset charset;

        private ScriptElement() {
            this.source = null;
            this.charset = FXMLLoader.this.charset;
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processStartElement() throws IOException {
            super.processStartElement();
            if (this.source != null && !FXMLLoader.this.staticLoad) {
                ScriptEngine scriptEngine;
                Object object;
                int n = this.source.lastIndexOf(".");
                if (n == -1) {
                    throw new LoadException("Cannot determine type of script \"" + this.source + "\".");
                }
                String string = this.source.substring(n + 1);
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(FXMLLoader.this.classLoader);
                    object = FXMLLoader.this.getScriptEngineManager();
                    scriptEngine = ((ScriptEngineManager)object).getEngineByExtension(string);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
                if (scriptEngine == null) {
                    throw new LoadException("Unable to locate scripting engine for extension " + string + ".");
                }
                scriptEngine.setBindings(FXMLLoader.this.scriptEngineManager.getBindings(), 100);
                try {
                    if (this.source.charAt(0) == '/') {
                        object = FXMLLoader.this.classLoader.getResource(this.source.substring(1));
                    } else {
                        if (FXMLLoader.this.location == null) {
                            throw new LoadException("Base location is undefined.");
                        }
                        object = new URL(FXMLLoader.this.location, this.source);
                    }
                    InputStreamReader inputStreamReader = null;
                    try {
                        inputStreamReader = new InputStreamReader(((URL)object).openStream(), this.charset);
                        scriptEngine.eval(inputStreamReader);
                    }
                    catch (ScriptException scriptException) {
                        scriptException.printStackTrace();
                    }
                    finally {
                        if (inputStreamReader != null) {
                            inputStreamReader.close();
                        }
                    }
                }
                catch (IOException iOException) {
                    throw new LoadException(iOException);
                }
            }
        }

        @Override
        public void processEndElement() throws IOException {
            super.processEndElement();
            if (this.value != null && !FXMLLoader.this.staticLoad) {
                try {
                    FXMLLoader.this.scriptEngine.eval((String)this.value);
                }
                catch (ScriptException scriptException) {
                    System.err.println(scriptException.getMessage());
                }
            }
        }

        @Override
        public void processCharacters() throws LoadException {
            if (this.source != null) {
                throw new LoadException("Script source already specified.");
            }
            if (FXMLLoader.this.scriptEngine == null && !FXMLLoader.this.staticLoad) {
                throw new LoadException("Page language not specified.");
            }
            this.updateValue(FXMLLoader.this.xmlStreamReader.getText());
        }

        @Override
        public void processAttribute(String string, String string2, String string3) throws IOException {
            if (string == null && string2.equals("source")) {
                if (FXMLLoader.this.loadListener != null) {
                    FXMLLoader.this.loadListener.readInternalAttribute(string2, string3);
                }
                this.source = string3;
            } else if (string2.equals("charset")) {
                if (FXMLLoader.this.loadListener != null) {
                    FXMLLoader.this.loadListener.readInternalAttribute(string2, string3);
                }
                this.charset = Charset.forName(string3);
            } else {
                throw new LoadException(string == null ? string2 : string + ":" + string2 + " is not a valid attribute.");
            }
        }
    }

    private class UnknownStaticPropertyElement
    extends Element {
        public final String name;

        public UnknownStaticPropertyElement(String string) throws LoadException {
            if (this.parent == null) {
                throw new LoadException("Invalid root element.");
            }
            if (this.parent.value == null) {
                throw new LoadException("Parent element does not support property elements.");
            }
            this.name = string;
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public void set(Object object) {
            this.updateValue(object);
        }

        @Override
        public void processCharacters() throws IOException {
            String string = FXMLLoader.this.xmlStreamReader.getText();
            string = extraneousWhitespacePattern.matcher(string).replaceAll(" ");
            this.updateValue(string.trim());
        }
    }

    private class PropertyElement
    extends Element {
        public final String name;
        public final Class<?> sourceType;
        public final boolean readOnly;

        public PropertyElement(String string, Class<?> clazz) throws LoadException {
            if (this.parent == null) {
                throw new LoadException("Invalid root element.");
            }
            if (this.parent.value == null) {
                throw new LoadException("Parent element does not support property elements.");
            }
            this.name = string;
            this.sourceType = clazz;
            if (clazz == null) {
                if (string.startsWith(FXMLLoader.EVENT_HANDLER_PREFIX)) {
                    throw new LoadException("\"" + string + "\" is not a valid element name.");
                }
                Map<String, Object> map = this.parent.getProperties();
                this.readOnly = this.parent.isTyped() ? this.parent.getValueAdapter().isReadOnly(string) : map.containsKey(string);
                if (this.readOnly) {
                    Object object = map.get(string);
                    if (object == null) {
                        throw new LoadException("Invalid property.");
                    }
                    this.updateValue(object);
                }
            } else {
                this.readOnly = false;
            }
        }

        @Override
        public boolean isCollection() {
            return this.readOnly ? super.isCollection() : false;
        }

        @Override
        public void add(Object object) throws LoadException {
            if (this.parent.isTyped()) {
                Type type = this.parent.getValueAdapter().getGenericType(this.name);
                object = BeanAdapter.coerce(object, BeanAdapter.getListItemType(type));
            }
            super.add(object);
        }

        @Override
        public void set(Object object) throws LoadException {
            this.updateValue(object);
            if (this.sourceType == null) {
                this.parent.getProperties().put(this.name, object);
            } else if (this.parent.value instanceof Builder) {
                this.parent.staticPropertyElements.add(this);
            } else {
                BeanAdapter.put(this.parent.value, this.sourceType, this.name, object);
            }
        }

        @Override
        public void processAttribute(String string, String string2, String string3) throws IOException {
            if (!this.readOnly) {
                throw new LoadException("Attributes are not supported for writable property elements.");
            }
            super.processAttribute(string, string2, string3);
        }

        @Override
        public void processEndElement() throws IOException {
            super.processEndElement();
            if (this.readOnly) {
                this.processInstancePropertyAttributes();
                this.processEventHandlerAttributes();
            }
        }

        @Override
        public void processCharacters() throws IOException {
            if (!this.readOnly) {
                String string = FXMLLoader.this.xmlStreamReader.getText();
                string = extraneousWhitespacePattern.matcher(string).replaceAll(" ");
                this.set(string.trim());
            } else {
                super.processCharacters();
            }
        }
    }

    private class RootElement
    extends ValueElement {
        public String type;

        private RootElement() {
            this.type = null;
        }

        @Override
        public void processAttribute(String string, String string2, String string3) throws IOException {
            if (string == null) {
                if (string2.equals(FXMLLoader.ROOT_TYPE_ATTRIBUTE)) {
                    if (FXMLLoader.this.loadListener != null) {
                        FXMLLoader.this.loadListener.readInternalAttribute(string2, string3);
                    }
                    this.type = string3;
                } else {
                    super.processAttribute(string, string2, string3);
                }
            } else {
                super.processAttribute(string, string2, string3);
            }
        }

        @Override
        public Object constructValue() throws LoadException {
            Object object;
            if (this.type == null) {
                throw new LoadException("type is required.");
            }
            Class clazz = FXMLLoader.this.getType(this.type);
            if (FXMLLoader.this.root == null) {
                Object object2 = object = FXMLLoader.this.builderFactory == null ? null : FXMLLoader.this.builderFactory.getBuilder(clazz);
                if (object == null) {
                    try {
                        object = clazz.newInstance();
                    }
                    catch (InstantiationException instantiationException) {
                        throw new LoadException(instantiationException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new LoadException(illegalAccessException);
                    }
                }
            } else {
                if (!clazz.isAssignableFrom(FXMLLoader.this.root.getClass())) {
                    throw new LoadException("Root is not an instance of " + clazz.getName() + ".");
                }
                object = FXMLLoader.this.root;
            }
            return object;
        }
    }

    private class CopyElement
    extends ValueElement {
        public String source;

        private CopyElement() {
            this.source = null;
        }

        @Override
        public void processAttribute(String string, String string2, String string3) throws IOException {
            if (string == null) {
                if (string2.equals("source")) {
                    if (FXMLLoader.this.loadListener != null) {
                        FXMLLoader.this.loadListener.readInternalAttribute(string2, string3);
                    }
                    this.source = string3;
                } else {
                    super.processAttribute(string, string2, string3);
                }
            } else {
                super.processAttribute(string, string2, string3);
            }
        }

        @Override
        public Object constructValue() throws LoadException {
            Object obj;
            if (this.source == null) {
                throw new LoadException("source is required.");
            }
            List<String> list = Expression.split(this.source);
            if (!Expression.isDefined((Object)FXMLLoader.this.namespace, list)) {
                throw new LoadException("Value \"" + this.source + "\" does not exist.");
            }
            Object t = Expression.get((Object)FXMLLoader.this.namespace, list);
            Class<?> clazz = t.getClass();
            Constructor<?> constructor = null;
            try {
                constructor = clazz.getConstructor(clazz);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (constructor != null) {
                try {
                    obj = constructor.newInstance(t);
                }
                catch (InstantiationException instantiationException) {
                    throw new LoadException(instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new LoadException(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new LoadException(invocationTargetException);
                }
            } else {
                throw new LoadException("Can't copy value " + t + ".");
            }
            return obj;
        }
    }

    private class ReferenceElement
    extends ValueElement {
        public String source;

        private ReferenceElement() {
            this.source = null;
        }

        @Override
        public void processAttribute(String string, String string2, String string3) throws IOException {
            if (string == null) {
                if (string2.equals("source")) {
                    if (FXMLLoader.this.loadListener != null) {
                        FXMLLoader.this.loadListener.readInternalAttribute(string2, string3);
                    }
                    this.source = string3;
                } else {
                    super.processAttribute(string, string2, string3);
                }
            } else {
                super.processAttribute(string, string2, string3);
            }
        }

        @Override
        public Object constructValue() throws LoadException {
            if (this.source == null) {
                throw new LoadException("source is required.");
            }
            List<String> list = Expression.split(this.source);
            if (!Expression.isDefined((Object)FXMLLoader.this.namespace, list)) {
                throw new LoadException("Value \"" + this.source + "\" does not exist.");
            }
            return Expression.get((Object)FXMLLoader.this.namespace, list);
        }
    }

    private class IncludeElement
    extends ValueElement {
        public String source;
        public ResourceBundle resources;
        public Charset charset;

        private IncludeElement() {
            this.source = null;
            this.resources = FXMLLoader.this.resources;
            this.charset = FXMLLoader.this.charset;
        }

        @Override
        public void processAttribute(String string, String string2, String string3) throws IOException {
            if (string == null) {
                if (string2.equals("source")) {
                    if (FXMLLoader.this.loadListener != null) {
                        FXMLLoader.this.loadListener.readInternalAttribute(string2, string3);
                    }
                    this.source = string3;
                } else if (string2.equals("resources")) {
                    if (FXMLLoader.this.loadListener != null) {
                        FXMLLoader.this.loadListener.readInternalAttribute(string2, string3);
                    }
                    this.resources = ResourceBundle.getBundle(string3);
                } else if (string2.equals("charset")) {
                    if (FXMLLoader.this.loadListener != null) {
                        FXMLLoader.this.loadListener.readInternalAttribute(string2, string3);
                    }
                    this.charset = Charset.forName(string3);
                } else {
                    super.processAttribute(string, string2, string3);
                }
            } else {
                super.processAttribute(string, string2, string3);
            }
        }

        @Override
        public Object constructValue() throws IOException {
            URL uRL;
            if (this.source == null) {
                throw new LoadException("source is required.");
            }
            if (this.source.charAt(0) == '/') {
                uRL = FXMLLoader.this.classLoader.getResource(this.source.substring(1));
            } else {
                if (FXMLLoader.this.location == null) {
                    throw new LoadException("Base location is undefined.");
                }
                uRL = new URL(FXMLLoader.this.location, this.source);
            }
            FXMLLoader fXMLLoader = new FXMLLoader(uRL, this.resources, FXMLLoader.this.builderFactory, FXMLLoader.this.controllerFactory, this.charset, FXMLLoader.this.loaders);
            fXMLLoader.setClassLoader(FXMLLoader.this.classLoader);
            fXMLLoader.setStaticLoad(FXMLLoader.this.staticLoad);
            Object object = fXMLLoader.load();
            if (this.id != null) {
                Field field;
                String string = this.id + FXMLLoader.CONTROLLER_SUFFIX;
                Object t = fXMLLoader.getController();
                FXMLLoader.this.namespace.put(string, t);
                if (t != null && (field = (Field)FXMLLoader.this.getControllerFields().get(string)) != null) {
                    try {
                        field.set(FXMLLoader.this.controller, t);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new LoadException(illegalAccessException);
                    }
                }
            }
            return object;
        }
    }

    private class UnknownTypeElement
    extends ValueElement {
        public final String name;

        public UnknownTypeElement(String string) {
            this.name = string;
        }

        @Override
        public void processEndElement() throws IOException {
        }

        @Override
        public Object constructValue() throws LoadException {
            return new UnknownValueMap();
        }

        @DefaultProperty(value="items")
        public class UnknownValueMap
        extends AbstractMap<String, Object> {
            private ArrayList<?> items = new ArrayList();
            private HashMap<String, Object> values = new HashMap();

            @Override
            public Object get(Object object) {
                if (object == null) {
                    throw new NullPointerException();
                }
                return object.equals(this.getClass().getAnnotation(DefaultProperty.class).value()) ? this.items : this.values.get(object);
            }

            @Override
            public Object put(String string, Object object) {
                if (string == null) {
                    throw new NullPointerException();
                }
                if (string.equals(this.getClass().getAnnotation(DefaultProperty.class).value())) {
                    throw new IllegalArgumentException();
                }
                return this.values.put(string, object);
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                return Collections.emptySet();
            }
        }
    }

    private class InstanceDeclarationElement
    extends ValueElement {
        public Class<?> type;
        public String constant;
        public String factory;

        public InstanceDeclarationElement(Class<?> clazz) throws LoadException {
            this.constant = null;
            this.factory = null;
            this.type = clazz;
        }

        @Override
        public void processAttribute(String string, String string2, String string3) throws IOException {
            if (string != null && string.equals(FXMLLoader.FX_NAMESPACE_PREFIX)) {
                if (string2.equals(FXMLLoader.FX_VALUE_ATTRIBUTE)) {
                    this.value = string3;
                } else if (string2.equals(FXMLLoader.FX_CONSTANT_ATTRIBUTE)) {
                    this.constant = string3;
                } else if (string2.equals(FXMLLoader.FX_FACTORY_ATTRIBUTE)) {
                    this.factory = string3;
                } else {
                    super.processAttribute(string, string2, string3);
                }
            } else {
                super.processAttribute(string, string2, string3);
            }
        }

        @Override
        public Object constructValue() throws IOException {
            Object object;
            if (this.value != null) {
                object = BeanAdapter.coerce(this.value, this.type);
            } else if (this.constant != null) {
                object = BeanAdapter.getConstantValue(this.type, this.constant);
            } else {
                if (this.factory != null) {
                    Method method;
                    try {
                        method = this.type.getMethod(this.factory, new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new LoadException(noSuchMethodException);
                    }
                    try {
                        object = method.invoke(null, new Object[0]);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new LoadException(illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new LoadException(invocationTargetException);
                    }
                }
                Object obj = object = FXMLLoader.this.builderFactory == null ? null : FXMLLoader.this.builderFactory.getBuilder(this.type);
                if (object == null) {
                    try {
                        object = this.type.newInstance();
                    }
                    catch (InstantiationException instantiationException) {
                        throw new LoadException(instantiationException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new LoadException(illegalAccessException);
                    }
                }
            }
            return object;
        }
    }

    private abstract class ValueElement
    extends Element {
        public String id;

        private ValueElement() {
            this.id = null;
        }

        @Override
        public void processStartElement() throws IOException {
            super.processStartElement();
            this.updateValue(this.constructValue());
            if (this.value instanceof Builder) {
                this.processInstancePropertyAttributes();
            } else {
                this.processValue();
            }
        }

        @Override
        public void processEndElement() throws IOException {
            super.processEndElement();
            if (this.value instanceof Builder) {
                Iterator iterator = (Builder)this.value;
                this.updateValue(iterator.build());
                this.processValue();
            } else {
                this.processInstancePropertyAttributes();
            }
            this.processEventHandlerAttributes();
            if (this.staticPropertyAttributes.size() > 0) {
                for (Object object : this.staticPropertyAttributes) {
                    this.processPropertyAttribute((Attribute)object);
                }
            }
            if (this.staticPropertyElements.size() > 0) {
                for (Object object : this.staticPropertyElements) {
                    BeanAdapter.put(this.value, ((PropertyElement)object).sourceType, ((PropertyElement)object).name, ((PropertyElement)object).value);
                }
            }
            if (this.parent != null) {
                if (this.parent.isCollection()) {
                    this.parent.add(this.value);
                } else {
                    this.parent.set(this.value);
                }
            }
        }

        private Object getListValue(Element element, String string, Object object) {
            Type type;
            if (element.isTyped() && (type = element.getValueAdapter().getGenericType(string)) != null) {
                Type type2 = BeanAdapter.getGenericListItemType(type);
                if (type2 instanceof ParameterizedType) {
                    type2 = ((ParameterizedType)type2).getRawType();
                }
                object = BeanAdapter.coerce(object, (Class)type2);
            }
            return object;
        }

        private void processValue() throws LoadException {
            if (this.parent == null) {
                FXMLLoader.this.root = this.value;
            }
            if (this.id != null) {
                Object object;
                FXMLLoader.this.namespace.put(this.id, this.value);
                IDProperty iDProperty = this.value.getClass().getAnnotation(IDProperty.class);
                if (iDProperty != null) {
                    object = this.getProperties();
                    object.put((String)iDProperty.value(), (Object)this.id);
                }
                if (FXMLLoader.this.controller != null && (object = (Field)FXMLLoader.this.getControllerFields().get(this.id)) != null) {
                    try {
                        ((Field)object).set(FXMLLoader.this.controller, this.value);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new RuntimeException(illegalAccessException);
                    }
                }
            }
        }

        @Override
        public void processCharacters() throws LoadException {
            Class<?> clazz = this.value.getClass();
            DefaultProperty defaultProperty = clazz.getAnnotation(DefaultProperty.class);
            if (defaultProperty != null) {
                String string = FXMLLoader.this.xmlStreamReader.getText();
                string = extraneousWhitespacePattern.matcher(string).replaceAll(" ");
                String string2 = defaultProperty.value();
                BeanAdapter beanAdapter = this.getValueAdapter();
                if (beanAdapter.isReadOnly(string2) && List.class.isAssignableFrom(beanAdapter.getType(string2))) {
                    List list = (List)beanAdapter.get(string2);
                    list.add(this.getListValue(this, string2, string));
                } else {
                    beanAdapter.put(string2, (Object)string.trim());
                }
            } else {
                throw new LoadException(clazz.getName() + " does not have a default property.");
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void processAttribute(String string, String string2, String string3) throws IOException {
            if (string != null && string.equals(FXMLLoader.FX_NAMESPACE_PREFIX)) {
                Class<?> clazz;
                if (string2.equals(FXMLLoader.FX_ID_ATTRIBUTE)) {
                    if (string3.equals(FXMLLoader.NULL_KEYWORD)) {
                        throw new LoadException("Invalid identifier.");
                    }
                    int n = string3.length();
                    for (int i = 0; i < n; ++i) {
                        if (Character.isJavaIdentifierPart(string3.charAt(i))) continue;
                        throw new LoadException("Invalid identifier.");
                    }
                    this.id = string3;
                    return;
                }
                if (!string2.equals("controller")) throw new LoadException("Invalid attribute.");
                if (((FXMLLoader)FXMLLoader.this).current.parent != null) {
                    throw new LoadException("fx:controller can only be applied to root element.");
                }
                if (FXMLLoader.this.controller != null) {
                    throw new LoadException("Controller value already specified.");
                }
                if (FXMLLoader.this.staticLoad) return;
                try {
                    clazz = FXMLLoader.this.classLoader.loadClass(string3);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new LoadException(classNotFoundException);
                }
                try {
                    if (FXMLLoader.this.controllerFactory == null) {
                        FXMLLoader.this.setController(clazz.newInstance());
                        return;
                    }
                    FXMLLoader.this.setController(FXMLLoader.this.controllerFactory.call(clazz));
                    return;
                }
                catch (InstantiationException instantiationException) {
                    throw new LoadException(instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new LoadException(illegalAccessException);
                }
            }
            super.processAttribute(string, string2, string3);
        }

        public abstract Object constructValue() throws IOException;
    }

    private abstract class Element {
        public final Element parent;
        public final int lineNumber;
        public Object value = null;
        private BeanAdapter valueAdapter = null;
        public final LinkedList<Attribute> eventHandlerAttributes = new LinkedList();
        public final LinkedList<Attribute> instancePropertyAttributes = new LinkedList();
        public final LinkedList<Attribute> staticPropertyAttributes = new LinkedList();
        public final LinkedList<PropertyElement> staticPropertyElements = new LinkedList();

        public Element() {
            this.parent = FXMLLoader.this.current;
            this.lineNumber = FXMLLoader.this.getLineNumber();
        }

        public boolean isCollection() {
            Class<?> clazz;
            DefaultProperty defaultProperty;
            boolean bl = this.value instanceof List ? true : ((defaultProperty = (clazz = this.value.getClass()).getAnnotation(DefaultProperty.class)) != null ? this.getProperties().get(defaultProperty.value()) instanceof List : false);
            return bl;
        }

        public void add(Object object) throws LoadException {
            List list;
            if (this.value instanceof List) {
                list = (List)this.value;
            } else {
                Class<?> clazz = this.value.getClass();
                DefaultProperty defaultProperty = clazz.getAnnotation(DefaultProperty.class);
                String string = defaultProperty.value();
                list = (List)this.getProperties().get(string);
                if (!Map.class.isAssignableFrom(clazz)) {
                    Type type = this.getValueAdapter().getGenericType(string);
                    object = BeanAdapter.coerce(object, BeanAdapter.getListItemType(type));
                }
            }
            list.add(object);
        }

        public void set(Object object) throws LoadException {
            if (this.value == null) {
                throw new LoadException("Cannot set value on this element.");
            }
            Class<?> clazz = this.value.getClass();
            DefaultProperty defaultProperty = clazz.getAnnotation(DefaultProperty.class);
            if (defaultProperty == null) {
                throw new LoadException("Element does not define a default property.");
            }
            this.getProperties().put(defaultProperty.value(), object);
        }

        public void updateValue(Object object) {
            this.value = object;
            this.valueAdapter = null;
        }

        public boolean isTyped() {
            return !(this.value instanceof Map);
        }

        public BeanAdapter getValueAdapter() {
            if (this.valueAdapter == null) {
                this.valueAdapter = new BeanAdapter(this.value);
            }
            return this.valueAdapter;
        }

        public Map<String, Object> getProperties() {
            return this.isTyped() ? this.getValueAdapter() : (Map)this.value;
        }

        public void processStartElement() throws IOException {
            int n = FXMLLoader.this.xmlStreamReader.getAttributeCount();
            for (int i = 0; i < n; ++i) {
                String string = FXMLLoader.this.xmlStreamReader.getAttributePrefix(i);
                String string2 = FXMLLoader.this.xmlStreamReader.getAttributeLocalName(i);
                String string3 = FXMLLoader.this.xmlStreamReader.getAttributeValue(i);
                if (FXMLLoader.this.loadListener != null && string != null && string.equals(FXMLLoader.FX_NAMESPACE_PREFIX)) {
                    FXMLLoader.this.loadListener.readInternalAttribute(string + ":" + string2, string3);
                }
                this.processAttribute(string, string2, string3);
            }
        }

        public void processEndElement() throws IOException {
        }

        public void processCharacters() throws IOException {
            throw new LoadException("Unexpected characters in input stream.");
        }

        public void processInstancePropertyAttributes() throws IOException {
            if (this.instancePropertyAttributes.size() > 0) {
                for (Attribute attribute : this.instancePropertyAttributes) {
                    this.processPropertyAttribute(attribute);
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void processAttribute(String string, String string2, String string3) throws IOException {
            if (string != null) throw new LoadException(string + ":" + string2 + " is not a valid attribute.");
            if (string2.startsWith(FXMLLoader.EVENT_HANDLER_PREFIX)) {
                if (FXMLLoader.this.loadListener != null) {
                    FXMLLoader.this.loadListener.readEventHandlerAttribute(string2, string3);
                }
                this.eventHandlerAttributes.add(new Attribute(string2, null, string3));
                return;
            } else {
                int n = string2.lastIndexOf(46);
                if (n == -1) {
                    if (FXMLLoader.this.loadListener != null) {
                        FXMLLoader.this.loadListener.readPropertyAttribute(string2, null, string3);
                    }
                    this.instancePropertyAttributes.add(new Attribute(string2, null, string3));
                    return;
                } else {
                    String string4 = string2.substring(n + 1);
                    Class clazz = FXMLLoader.this.getType(string2.substring(0, n));
                    if (clazz != null) {
                        if (FXMLLoader.this.loadListener != null) {
                            FXMLLoader.this.loadListener.readPropertyAttribute(string4, clazz, string3);
                        }
                        this.staticPropertyAttributes.add(new Attribute(string4, clazz, string3));
                        return;
                    } else {
                        if (!FXMLLoader.this.staticLoad) throw new LoadException(string2 + " is not a valid attribute.");
                        if (FXMLLoader.this.loadListener == null) return;
                        FXMLLoader.this.loadListener.readUnknownStaticPropertyAttribute(string2, string3);
                    }
                }
            }
        }

        public void processPropertyAttribute(Attribute attribute) throws IOException {
            String string = attribute.value;
            if (string.startsWith(FXMLLoader.ESCAPE_PREFIX)) {
                if (!((string = string.substring(FXMLLoader.ESCAPE_PREFIX.length())).length() != 0 && (string.startsWith(FXMLLoader.ESCAPE_PREFIX) || string.startsWith(FXMLLoader.RELATIVE_PATH_PREFIX) || string.startsWith(FXMLLoader.RESOURCE_KEY_PREFIX) || string.startsWith(FXMLLoader.EXPRESSION_PREFIX) || string.startsWith(FXMLLoader.BI_DIRECTIONAL_BINDING_PREFIX)))) {
                    throw new LoadException("Invalid escape sequence.");
                }
                this.applyProperty(attribute.name, attribute.sourceType, string);
            } else if (string.startsWith(FXMLLoader.RELATIVE_PATH_PREFIX)) {
                if ((string = string.substring(FXMLLoader.RELATIVE_PATH_PREFIX.length())).startsWith(FXMLLoader.RELATIVE_PATH_PREFIX)) {
                    this.warnDeprecatedEscapeSequence(FXMLLoader.RELATIVE_PATH_PREFIX);
                    this.applyProperty(attribute.name, attribute.sourceType, string);
                } else {
                    URL uRL;
                    if (string.length() == 0) {
                        throw new LoadException("Missing relative path.");
                    }
                    if (string.charAt(0) == '/') {
                        uRL = FXMLLoader.this.classLoader.getResource(string.substring(1));
                    } else {
                        if (FXMLLoader.this.location == null) {
                            throw new LoadException("Base location is undefined.");
                        }
                        uRL = new URL(FXMLLoader.this.location, string);
                    }
                    this.applyProperty(attribute.name, attribute.sourceType, uRL);
                }
            } else if (string.startsWith(FXMLLoader.RESOURCE_KEY_PREFIX)) {
                if ((string = string.substring(FXMLLoader.RESOURCE_KEY_PREFIX.length())).startsWith(FXMLLoader.RESOURCE_KEY_PREFIX)) {
                    this.warnDeprecatedEscapeSequence(FXMLLoader.RESOURCE_KEY_PREFIX);
                    this.applyProperty(attribute.name, attribute.sourceType, string);
                } else {
                    if (string.length() == 0) {
                        throw new LoadException("Missing resource key.");
                    }
                    if (FXMLLoader.this.resources == null) {
                        throw new LoadException("No resources specified.");
                    }
                    if (!FXMLLoader.this.resources.containsKey(string)) {
                        throw new LoadException("Resource \"" + string + "\" not found.");
                    }
                    this.applyProperty(attribute.name, attribute.sourceType, FXMLLoader.this.resources.getObject(string));
                }
            } else if (string.startsWith(FXMLLoader.EXPRESSION_PREFIX)) {
                if ((string = string.substring(FXMLLoader.EXPRESSION_PREFIX.length())).startsWith(FXMLLoader.EXPRESSION_PREFIX)) {
                    this.warnDeprecatedEscapeSequence(FXMLLoader.EXPRESSION_PREFIX);
                    this.applyProperty(attribute.name, attribute.sourceType, string);
                } else if (string.equals(FXMLLoader.NULL_KEYWORD)) {
                    this.applyProperty(attribute.name, attribute.sourceType, null);
                } else {
                    Expression expression;
                    if (string.length() == 0) {
                        throw new LoadException("Missing expression.");
                    }
                    if (string.startsWith(FXMLLoader.BINDING_EXPRESSION_PREFIX) && string.endsWith("}")) {
                        if (attribute.sourceType != null) {
                            throw new LoadException("Cannot bind to static property.");
                        }
                        if (this.value instanceof Builder) {
                            throw new LoadException("Cannot bind to builder property.");
                        }
                        string = string.substring(1, string.length() - 1);
                        expression = Expression.valueOf(string, FXMLLoader.this.namespace);
                        Map<String, Object> map = this.getProperties();
                        expression.valueProperty().addListener(new ExpressionTargetMapping(expression, map, Expression.split(attribute.name)));
                    } else {
                        expression = new VariableExpression(Expression.split(string), FXMLLoader.this.namespace);
                    }
                    if (expression.isDefined()) {
                        this.applyProperty(attribute.name, attribute.sourceType, expression.getValue());
                    }
                }
            } else if (string.startsWith(FXMLLoader.BI_DIRECTIONAL_BINDING_PREFIX)) {
                if (!enableBidirectionalBinding) {
                    throw new LoadException("Bi-directional binding is not enabled.");
                }
                if (!string.endsWith("}")) {
                    throw new LoadException("Unterminated expression.");
                }
                if ((string = string.substring(FXMLLoader.BI_DIRECTIONAL_BINDING_PREFIX.length(), string.length() - "}".length())).length() == 0) {
                    throw new LoadException("Missing expression.");
                }
                if (attribute.sourceType != null) {
                    throw new LoadException("Cannot bind to static property.");
                }
                if (this.value instanceof Builder) {
                    throw new LoadException("Cannot bind to builder property.");
                }
                Expression expression = Expression.valueOf(string, FXMLLoader.this.namespace);
                Map<String, Object> map = this.getProperties();
                List<String> list = Expression.split(attribute.name);
                expression.valueProperty().addListener(new ExpressionTargetMapping(expression, map, list));
                if (expression instanceof VariableExpression) {
                    VariableExpression variableExpression = new VariableExpression(list, map);
                    variableExpression.valueProperty().addListener(new ExpressionTargetMapping(variableExpression, FXMLLoader.this.namespace, ((VariableExpression)expression).getPath()));
                }
                if (expression.isDefined()) {
                    this.applyProperty(attribute.name, attribute.sourceType, expression.getValue());
                }
            } else {
                Object object = string;
                if (attribute.sourceType == null && this.isTyped()) {
                    BeanAdapter beanAdapter = this.getValueAdapter();
                    Class<?> clazz = beanAdapter.getType(attribute.name);
                    if (clazz == null) {
                        throw new PropertyNotFoundException("Property \"" + attribute.name + "\" does not exist" + " or is read-only.");
                    }
                    if (List.class.isAssignableFrom(clazz) && beanAdapter.isReadOnly(attribute.name)) {
                        String string2;
                        List list = (List)beanAdapter.get(attribute.name);
                        Type type = beanAdapter.getGenericType(attribute.name);
                        Type type2 = (Class)BeanAdapter.getGenericListItemType(type);
                        if (type2 instanceof ParameterizedType) {
                            type2 = ((ParameterizedType)type2).getRawType();
                        }
                        if ((string2 = string.toString()).length() > 0) {
                            String[] stringArray = string2.split(FXMLLoader.ARRAY_COMPONENT_DELIMITER);
                            for (int i = 0; i < stringArray.length; ++i) {
                                list.add(BeanAdapter.coerce(stringArray[i].trim(), type2));
                            }
                        }
                        object = null;
                    } else if (clazz.isArray()) {
                        Class<?> clazz2 = clazz.getComponentType();
                        String string3 = string.toString();
                        if (string3.length() > 0) {
                            String[] stringArray = string3.split(FXMLLoader.ARRAY_COMPONENT_DELIMITER);
                            object = Array.newInstance(clazz2, stringArray.length);
                            for (int i = 0; i < stringArray.length; ++i) {
                                Array.set(object, i, BeanAdapter.coerce(stringArray[i].trim(), clazz.getComponentType()));
                            }
                        } else {
                            object = Array.newInstance(clazz2, 0);
                        }
                    }
                }
                if (object != null) {
                    this.applyProperty(attribute.name, attribute.sourceType, object);
                }
            }
        }

        public void warnDeprecatedEscapeSequence(String string) {
            System.err.println(string + string + " is a deprecated escape sequence. " + "Please use \\" + string + " instead.");
        }

        public void applyProperty(String string, Class<?> clazz, Object object) {
            if (clazz == null) {
                this.getProperties().put(string, object);
            } else {
                BeanAdapter.put(this.value, clazz, string, object);
            }
        }

        public void processEventHandlerAttributes() throws LoadException {
            if (this.eventHandlerAttributes.size() > 0 && !FXMLLoader.this.staticLoad) {
                for (Attribute attribute : this.eventHandlerAttributes) {
                    EventHandler<Event> eventHandler = null;
                    String string = attribute.value;
                    if (string.startsWith(FXMLLoader.CONTROLLER_METHOD_PREFIX) && !(string = string.substring(FXMLLoader.CONTROLLER_METHOD_PREFIX.length())).startsWith(FXMLLoader.CONTROLLER_METHOD_PREFIX)) {
                        if (string.length() == 0) {
                            throw new LoadException("Missing controller method.");
                        }
                        if (FXMLLoader.this.controller == null) {
                            throw new LoadException("No controller specified.");
                        }
                        Method method = (Method)FXMLLoader.this.getControllerMethods().get(string);
                        if (method == null) {
                            throw new LoadException("Controller method \"" + string + "\" not found.");
                        }
                        eventHandler = new ControllerMethodEventHandler(FXMLLoader.this.controller, method);
                    }
                    if (eventHandler == null) {
                        if (string.length() == 0) {
                            throw new LoadException("Missing handler script.");
                        }
                        if (FXMLLoader.this.scriptEngine == null) {
                            throw new LoadException("Page language not specified.");
                        }
                        eventHandler = new ScriptEventHandler(string, FXMLLoader.this.scriptEngine);
                    }
                    if (eventHandler == null) continue;
                    this.addEventHandler(attribute, eventHandler);
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void addEventHandler(Attribute attribute, EventHandler<? extends Event> eventHandler) throws LoadException {
            if (attribute.name.endsWith(FXMLLoader.CHANGE_EVENT_HANDLER_SUFFIX)) {
                int n;
                int n2 = FXMLLoader.EVENT_HANDLER_PREFIX.length();
                if (n2 == (n = attribute.name.length() - FXMLLoader.CHANGE_EVENT_HANDLER_SUFFIX.length())) {
                    if (this.value instanceof ObservableList) {
                        ObservableList observableList = (ObservableList)this.value;
                        observableList.addListener(new ObservableListChangeAdapter(observableList, eventHandler));
                        return;
                    } else {
                        if (!(this.value instanceof ObservableMap)) throw new LoadException("Invalid event source.");
                        ObservableMap observableMap = (ObservableMap)this.value;
                        observableMap.addListener(new ObservableMapChangeAdapter(observableMap, eventHandler));
                    }
                    return;
                } else {
                    String string = Character.toLowerCase(attribute.name.charAt(n2)) + attribute.name.substring(n2 + 1, n);
                    Property<Object> property = this.getValueAdapter().getPropertyModel(string);
                    if (property == null) {
                        throw new LoadException(this.value.getClass().getName() + " does not define" + " a property model for \"" + string + "\".");
                    }
                    property.addListener(new PropertyChangeAdapter(this.value, eventHandler));
                }
                return;
            } else {
                this.getValueAdapter().put(attribute.name, (Object)eventHandler);
            }
        }
    }
}

