/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.property.adapter;

import com.sun.javafx.binding.ExpressionHelper;
import com.sun.javafx.property.adapter.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import javafx.beans.InvalidationListener;
import javafx.beans.property.StringProperty;
import javafx.beans.property.adapter.JavaBeanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public final class JavaBeanStringProperty
extends StringProperty
implements JavaBeanProperty<String> {
    private final PropertyDescriptor descriptor;
    private final PropertyDescriptor.Listener<String> listener;
    private ObservableValue<? extends String> observable = null;
    private ExpressionHelper<String> helper = null;

    JavaBeanStringProperty(PropertyDescriptor propertyDescriptor, Object object) {
        this.descriptor = propertyDescriptor;
        PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
        propertyDescriptor2.getClass();
        this.listener = propertyDescriptor2.new PropertyDescriptor.Listener<String>(object, this);
        propertyDescriptor.addListener(this.listener);
    }

    protected void finalize() throws Throwable {
        this.descriptor.removeListener(this.listener);
        super.finalize();
    }

    @Override
    public String get() {
        try {
            return (String)this.descriptor.getGetter().invoke(this.getBean(), new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UndeclaredThrowableException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UndeclaredThrowableException(invocationTargetException);
        }
    }

    @Override
    public void set(String string) {
        if (this.isBound()) {
            throw new RuntimeException("A bound value cannot be set.");
        }
        try {
            this.descriptor.getSetter().invoke(this.getBean(), string);
            ExpressionHelper.fireValueChangedEvent(this.helper);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UndeclaredThrowableException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UndeclaredThrowableException(invocationTargetException);
        }
    }

    @Override
    public void bind(ObservableValue<? extends String> observableValue) {
        if (observableValue == null) {
            throw new NullPointerException("Cannot bind to null");
        }
        if (!observableValue.equals(this.observable)) {
            this.unbind();
            this.set(observableValue.getValue());
            this.observable = observableValue;
            this.observable.addListener(this.listener);
        }
    }

    @Override
    public void unbind() {
        if (this.observable != null) {
            this.observable.removeListener(this.listener);
            this.observable = null;
        }
    }

    @Override
    public boolean isBound() {
        return this.observable != null;
    }

    @Override
    public Object getBean() {
        return this.listener.getBean();
    }

    @Override
    public String getName() {
        return this.descriptor.getName();
    }

    @Override
    public void addListener(ChangeListener<? super String> changeListener) {
        this.helper = ExpressionHelper.addListener(this.helper, this, changeListener);
    }

    @Override
    public void removeListener(ChangeListener<? super String> changeListener) {
        this.helper = ExpressionHelper.removeListener(this.helper, changeListener);
    }

    @Override
    public void addListener(InvalidationListener invalidationListener) {
        this.helper = ExpressionHelper.addListener(this.helper, this, invalidationListener);
    }

    @Override
    public void removeListener(InvalidationListener invalidationListener) {
        this.helper = ExpressionHelper.removeListener(this.helper, invalidationListener);
    }

    @Override
    public void fireValueChangedEvent() {
        ExpressionHelper.fireValueChangedEvent(this.helper);
    }

    @Override
    public void dispose() {
        this.descriptor.removeListener(this.listener);
    }
}

