/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.ui.connection;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.wizards.ContextPropertyStore;
import com.nvidia.common.wizards.IContextPropertyListener;
import com.nvidia.common.wizards.PropertyDescriptor;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.internal.connection.Activator;
import com.nvidia.cuda.ide.remote.internal.connection.RSERemoteConnection;
import com.nvidia.cuda.ide.remote.internal.ui.connection.SubSystemConfigurator;
import com.nvidia.cuda.ide.remote.internal.ui.connection.SystemType;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISubSystemConfigurator;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemProfileManager;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystemConfigurationProxy;

public final class ConnectionWorkingCopy
implements IContextPropertyListener {
    public static final PropertyDescriptor<String> PROPERTY_HOST = new PropertyDescriptor("connection.host", String.class, true);
    public static final PropertyDescriptor<String> PROPERTY_LABEL = new PropertyDescriptor("connection.label", String.class, true);
    public static final PropertyDescriptor<Integer> PROPERTY_PORT = new PropertyDescriptor("connection.port", Integer.class, true);
    public static final PropertyDescriptor<SystemType> PROPERTY_SYSTEM_TYPE = new PropertyDescriptor("connection.type", SystemType.class, true);
    public static final PropertyDescriptor<String> PROPERTY_USER = new PropertyDescriptor("connection.user", String.class);
    private final RSERemoteConnection connection;
    private final ContextPropertyStore defaultsStore;
    private IHost host = null;
    private final Collection<ConnectionWorkingCopy> list;
    private final ContextPropertyStore store;

    private static String createName(String base, int i) {
        return i == 0 ? base : String.format("%s_%d", base, i);
    }

    private static String createUniqueName(Collection<ConnectionWorkingCopy> list, String user, String host, Integer port) {
        String prefix = ConnectionWorkingCopy.getBaseConnectionLabel(user, host, ConnectionWorkingCopy.nullIfDefaultPort(port));
        int i = 0;
        if (!CoreUtil.isNullOrEmpty(list)) {
            while (!ConnectionWorkingCopy.isUnique(list, prefix, i)) {
                ++i;
            }
        }
        return ConnectionWorkingCopy.createName(prefix, i);
    }

    private static String getBaseConnectionLabel(String user, String host, Integer port) {
        String prefix = CoreUtil.isNullOrEmpty((String)host) ? "Connection" : (CoreUtil.isNullOrEmpty((String)user) ? host : String.format("%s@%s", user.toLowerCase(), host.toLowerCase()));
        if (port != null) {
            return String.format("%s:%d", prefix, (int)port);
        }
        return prefix;
    }

    public static ISubSystemConfigurator getConfigurator(String id, String user, int port) {
        ISubSystemConfigurationProxy[] proxies;
        ISubSystemConfigurationProxy[] iSubSystemConfigurationProxyArray = proxies = RSECorePlugin.getTheSystemRegistry().getSubSystemConfigurationProxies();
        int n = proxies.length;
        int n2 = 0;
        while (n2 < n) {
            ISubSystemConfigurationProxy proxy = iSubSystemConfigurationProxyArray[n2];
            if (id.equals(proxy.getId())) {
                return new SubSystemConfigurator(proxy, user, port);
            }
            ++n2;
        }
        Activator.log("Protocol not supported: %s", id);
        return null;
    }

    private static Integer getPort(IHost host) {
        Object[] services = host.getConnectorServices();
        if (!CoreUtil.isNullOrEmpty((Object[])services)) {
            return services[0].getPort();
        }
        return null;
    }

    public static Collection<ISubSystemConfigurationProxy> getSubsystemTypes(String category) {
        IRSESystemType type = ConnectionWorkingCopy.getSystemType();
        TreeSet<ISubSystemConfigurationProxy> set = new TreeSet<ISubSystemConfigurationProxy>(new SubSystemsComparator());
        ISubSystemConfigurationProxy[] iSubSystemConfigurationProxyArray = RSECorePlugin.getTheSystemRegistry().getSubSystemConfigurationProxiesBySystemType(type);
        int n = iSubSystemConfigurationProxyArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISubSystemConfigurationProxy proxy = iSubSystemConfigurationProxyArray[n2];
            if (CoreUtil.equals((Object)category, (Object)proxy.getCategory())) {
                set.add(proxy);
            }
            ++n2;
        }
        return set;
    }

    private static IRSESystemType getSystemType() {
        return RSECorePlugin.getTheCoreRegistry().getSystemTypeById("org.eclipse.rse.systemtype.unix");
    }

    private static boolean isUnique(Collection<ConnectionWorkingCopy> list, String base, int i) {
        String label = ConnectionWorkingCopy.createName(base, i);
        for (ConnectionWorkingCopy connection : list) {
            if (!CoreUtil.equals((Object)label, (Object)connection.getProperty(PROPERTY_LABEL))) continue;
            return false;
        }
        return true;
    }

    private static Integer nullIfDefaultPort(Integer port) {
        if (port != null && port.intValue() != SystemType.ssh.getDefaultPort()) {
            return port;
        }
        return null;
    }

    public static <T> IObservableValue observeConnectionProperty(IObservableValue selection, PropertyDescriptor<T> property) {
        return new ConnectionPropertyTracker(property.clazz, property, selection);
    }

    private static void populatePristineCopy(ContextPropertyStore store, RSERemoteConnection connection) {
        IHost host = connection.getHost();
        String hostName = host.getHostName();
        String userName = host.getDefaultUserId();
        String label = host.getName();
        Integer port = ConnectionWorkingCopy.getPort(host);
        store.setProperty(PROPERTY_HOST, (Object)hostName);
        store.setProperty(PROPERTY_USER, (Object)userName);
        if (!CoreUtil.equals((Object)label, (Object)ConnectionWorkingCopy.createUniqueName(null, userName, hostName, port))) {
            store.setProperty(PROPERTY_LABEL, (Object)label);
        }
        store.setProperty(PROPERTY_SYSTEM_TYPE, (Object)SystemType.ssh);
        Object[] connector = host.getConnectorServices();
        if (!CoreUtil.isNullOrEmpty((Object[])connector)) {
            store.setProperty(PROPERTY_PORT, (Object)connector[0].getPort());
        }
    }

    public ConnectionWorkingCopy(RSERemoteConnection connection, Collection<ConnectionWorkingCopy> list, Realm realm) {
        this.connection = connection;
        this.list = list;
        this.store = new ContextPropertyStore(realm);
        this.defaultsStore = this.store.newDefaultsStore();
        this.defaultsStore.setProperty(PROPERTY_SYSTEM_TYPE, (Object)SystemType.ssh);
        this.defaultsStore.setProperty(PROPERTY_PORT, (Object)SystemType.ssh.getDefaultPort());
        if (connection != null) {
            ConnectionWorkingCopy.populatePristineCopy(this.store, connection);
        }
        this.defaultsStore.setProperty(PROPERTY_LABEL, (Object)ConnectionWorkingCopy.createUniqueName(list, this.getProperty(PROPERTY_USER), this.getProperty(PROPERTY_HOST), this.getProperty(PROPERTY_PORT)));
        this.store.addSessionPropertyListener((IContextPropertyListener)this);
    }

    private void createNewRSEConnection() throws Exception {
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        ISystemProfileManager profileManager = registry.getSystemProfileManager();
        ISystemProfile defaultProfile = profileManager.getDefaultPrivateSystemProfile();
        ISubSystemConfigurator[] configs = this.getRSESubSystemConfigurators();
        this.host = registry.createHost(defaultProfile.getName(), ConnectionWorkingCopy.getSystemType(), this.getProperty(PROPERTY_LABEL), this.getProperty(PROPERTY_HOST), null, this.getProperty(PROPERTY_USER), 4, configs);
    }

    public IHost getHost() {
        return this.host;
    }

    public <K> K getProperty(PropertyDescriptor<K> name) {
        return (K)this.store.getProperty(name);
    }

    public IRemoteConnection getRSEConnection() {
        return this.connection;
    }

    private ISubSystemConfigurator[] getRSESubSystemConfigurators() {
        SystemType type = this.getProperty(PROPERTY_SYSTEM_TYPE);
        if (type != null) {
            String[] ids = type.getRseSubSystems();
            Object[] configurators = new ISubSystemConfigurator[ids.length];
            int i = 0;
            while (i < ids.length) {
                configurators[i] = ConnectionWorkingCopy.getConfigurator(ids[i], this.getProperty(PROPERTY_USER), this.getProperty(PROPERTY_PORT));
                ++i;
            }
            return (ISubSystemConfigurator[])CoreUtil.removeGaps((Object[])configurators);
        }
        return new ISubSystemConfigurator[0];
    }

    public boolean isEmpty() {
        return this.store.isClean();
    }

    public <K> IObservableValue observeProperty(PropertyDescriptor<K> name) {
        return this.store.observeProperty(name);
    }

    public void propertyChanged(PropertyDescriptor<?> property, Object oldValue, Object newValue) {
        if (property == PROPERTY_HOST) {
            this.defaultsStore.setProperty(PROPERTY_LABEL, (Object)ConnectionWorkingCopy.createUniqueName(this.list, this.getProperty(PROPERTY_USER), (String)newValue, this.getProperty(PROPERTY_PORT)));
        } else if (property == PROPERTY_USER) {
            this.defaultsStore.setProperty(PROPERTY_LABEL, (Object)ConnectionWorkingCopy.createUniqueName(this.list, (String)newValue, this.getProperty(PROPERTY_HOST), this.getProperty(PROPERTY_PORT)));
        } else if (property == PROPERTY_PORT) {
            this.defaultsStore.setProperty(PROPERTY_LABEL, (Object)ConnectionWorkingCopy.createUniqueName(this.list, this.getProperty(PROPERTY_USER), this.getProperty(PROPERTY_HOST), (Integer)newValue));
        } else if (property == PROPERTY_SYSTEM_TYPE) {
            SystemType protocol = (SystemType)((Object)newValue);
            this.defaultsStore.setProperty(PROPERTY_PORT, (Object)(protocol != null ? protocol.getDefaultPort() : 1));
        } else if (property == PROPERTY_LABEL && CoreUtil.equals((Object)newValue, (Object)((String)this.defaultsStore.getProperty(PROPERTY_LABEL)))) {
            this.setProperty(PROPERTY_LABEL, null);
        }
    }

    public void remove() {
        if (this.connection != null) {
            RSECorePlugin.getTheSystemRegistry().deleteHost(this.connection.getHost());
        }
    }

    public void save() throws CoreException {
        try {
            if (this.connection != null) {
                this.updateRSEConnection();
            } else {
                this.createNewRSEConnection();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw CoreUtil.coreException((Throwable)e);
        }
    }

    public <K> void setProperty(PropertyDescriptor<K> name, K value) {
        this.store.setProperty(name, value);
    }

    private void updateRSEConnection() throws Exception {
        IConnectorService[] services;
        this.host = this.connection.getHost();
        String newHost = this.getProperty(PROPERTY_HOST);
        String newUser = this.getProperty(PROPERTY_USER);
        String newLabel = this.getProperty(PROPERTY_LABEL);
        RSECorePlugin.getTheSystemRegistry().updateHost(this.host, ConnectionWorkingCopy.getSystemType(), newLabel, newHost, null, newUser, 2);
        int port = this.getProperty(PROPERTY_PORT);
        IConnectorService[] iConnectorServiceArray = services = this.host.getConnectorServices();
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectorService service = iConnectorServiceArray[n2];
            if (service.getPort() != port || !CoreUtil.equals((Object)service.getUserId(), (Object)newUser)) {
                service.disconnect((IProgressMonitor)new NullProgressMonitor());
                service.setPort(port);
                service.setUserId(newUser);
                service.commit();
            }
            ++n2;
        }
    }

    private static final class ConnectionPropertyTracker<T>
    extends ComputedValue {
        private final PropertyDescriptor<T> property;
        private final IObservableValue selection;

        private ConnectionPropertyTracker(Object valueType, PropertyDescriptor<T> property, IObservableValue selection) {
            super(valueType);
            this.property = property;
            this.selection = selection;
        }

        protected Object calculate() {
            Object value = this.selection.getValue();
            if (value instanceof ConnectionWorkingCopy) {
                return ((ConnectionWorkingCopy)value).getProperty(this.property);
            }
            return null;
        }

        protected void doSetValue(Object value) {
            try {
                ConnectionWorkingCopy connection = (ConnectionWorkingCopy)this.selection.getValue();
                if (connection != null) {
                    connection.setProperty(this.property, value == null ? null : (Object)this.property.clazz.cast(value));
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }
    }

    private static final class SubSystemsComparator
    implements Comparator<ISubSystemConfigurationProxy> {
        private SubSystemsComparator() {
        }

        @Override
        public int compare(ISubSystemConfigurationProxy o1, ISubSystemConfigurationProxy o2) {
            int p1 = o1.getPriority() - o2.getPriority();
            if (p1 == 0) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
            return p1;
        }
    }
}

