/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote;

import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import java.util.Map;

public final class RemoteUtil {
    private static final String COMMAND_CD = "cd %s";
    private static final String COMMAND_SEPARATOR = ";";
    private static final String COMMAND_SET = "export %s=%s";
    private static final String COMMAND_UNSET = "unset %s";
    private static final String ENV_LIBRARY_PATH = "LD_LIBRARY_PATH";
    private static final String PATH_SEPARATOR = ":";
    private static final String VAR_FORMAT = "${%s}";

    public static String cd(IRemoteConnection connection, String dir) {
        if (dir != null) {
            return String.valueOf(String.format(COMMAND_CD, RemoteUtil.quote(dir))) + COMMAND_SEPARATOR;
        }
        return "";
    }

    public static String setEnvironment(IRemoteConnection connection, ICudaToolkit toolkit, Map<String, String> environment) {
        StringBuilder commands = new StringBuilder();
        if (environment == null || !environment.containsKey(ENV_LIBRARY_PATH)) {
            commands.append(RemoteUtil.buildLibraryPath(toolkit));
        }
        if (environment != null) {
            for (Map.Entry<String, String> entry : environment.entrySet()) {
                commands.append(RemoteUtil.setVariable(entry.getKey(), RemoteUtil.quote(entry.getValue())));
            }
        }
        return commands.toString();
    }

    private static String buildLibraryPath(ICudaToolkit toolkit) {
        Object[] path = toolkit.getLibraryPath();
        if (!CoreUtil.isNullOrEmpty((Object[])path)) {
            StringBuilder libPath = new StringBuilder();
            Object[] objectArray = path;
            int n = path.length;
            int n2 = 0;
            while (n2 < n) {
                Object d = objectArray[n2];
                libPath.append(RemoteUtil.quote((String)d)).append(PATH_SEPARATOR);
                ++n2;
            }
            libPath.append(RemoteUtil.var(ENV_LIBRARY_PATH));
            return RemoteUtil.setVariable(ENV_LIBRARY_PATH, libPath.toString());
        }
        return "";
    }

    public static String quote(String unescaped) {
        if (!CoreUtil.isNullOrEmpty((String)unescaped)) {
            String escaped = unescaped.replaceAll("[\\\"\\$\\\\]", "\\\\$0");
            return String.format("\"%s\"", escaped);
        }
        return unescaped;
    }

    private static String setVariable(String name, String value) {
        if (value != null) {
            return String.valueOf(String.format(COMMAND_SET, name, value)) + COMMAND_SEPARATOR;
        }
        return String.valueOf(String.format(COMMAND_UNSET, name)) + COMMAND_SEPARATOR;
    }

    private static String var(String name) {
        return String.format(VAR_FORMAT, name);
    }
}

