/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.impl;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IShutdownListener;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IDataSetInterceptor;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.data.adapter.impl.DataSetInterceptorFinder;
import org.eclipse.birt.report.data.adapter.impl.QueryExecutionHelper;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DerivedDataSetHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;

public class DefineDataSourceSetUtil {
    public static void defineDataSourceAndDataSet(DataSetHandle dataSet, DataRequestSession sessionImpl) throws BirtException {
        if (dataSet == null) {
            return;
        }
        IModelAdapter modelAdaptor = sessionImpl.getModelAdaptor();
        DataSourceHandle dataSource = dataSet.getDataSource();
        if (dataSource != null) {
            sessionImpl.defineDataSource((IBaseDataSourceDesign)modelAdaptor.adaptDataSource(dataSource));
        }
        if (dataSet instanceof JointDataSetHandle) {
            JointDataSetHandle jointDataSet = (JointDataSetHandle)dataSet;
            Iterator iter = jointDataSet.dataSetsIterator();
            while (iter.hasNext()) {
                DataSetHandle childDataSet = (DataSetHandle)iter.next();
                if (childDataSet == null) continue;
                DataSourceHandle childDataSource = childDataSet.getDataSource();
                if (childDataSource != null) {
                    sessionImpl.defineDataSource((IBaseDataSourceDesign)modelAdaptor.adaptDataSource(childDataSource));
                }
                DefineDataSourceSetUtil.defineDataSourceAndDataSet(childDataSet, sessionImpl);
            }
        }
        if (dataSet instanceof DerivedDataSetHandle) {
            List inputDataSet = ((DerivedDataSetHandle)dataSet).getInputDataSets();
            int i = 0;
            while (i < inputDataSet.size()) {
                DefineDataSourceSetUtil.defineDataSourceAndDataSet((DataSetHandle)inputDataSet.get(i), sessionImpl);
                ++i;
            }
        }
        sessionImpl.defineDataSet((IBaseDataSetDesign)modelAdaptor.adaptDataSet(dataSet));
    }

    public static void defineDataSourceAndDataSet(DataSetHandle dataSet, DataEngine dataEngine, IModelAdapter modelAdaptor, QueryExecutionHelper.DataSetHandleProcessContext context) throws BirtException {
        IBaseDataSetDesign design;
        if (dataSet == null) {
            return;
        }
        DataSourceHandle dataSource = dataSet.getDataSource();
        if (dataSource != null && ((DataEngineImpl)dataEngine).getDataSourceRuntime(dataSource.getQualifiedName()) == null) {
            dataEngine.defineDataSource((IBaseDataSourceDesign)modelAdaptor.adaptDataSource(dataSource));
        }
        if (dataSet instanceof JointDataSetHandle) {
            JointDataSetHandle jointDataSet = (JointDataSetHandle)dataSet;
            Iterator iter = jointDataSet.dataSetsIterator();
            while (iter.hasNext()) {
                DataSetHandle childDataSet = (DataSetHandle)iter.next();
                if (childDataSet == null) continue;
                DataSourceHandle childDataSource = childDataSet.getDataSource();
                if (childDataSource != null) {
                    dataEngine.defineDataSource((IBaseDataSourceDesign)modelAdaptor.adaptDataSource(childDataSource));
                }
                DefineDataSourceSetUtil.defineDataSourceAndDataSet(childDataSet, dataEngine, modelAdaptor, context);
            }
        }
        if (dataSet instanceof DerivedDataSetHandle) {
            List inputDataSet = ((DerivedDataSetHandle)dataSet).getInputDataSets();
            int i = 0;
            while (i < inputDataSet.size()) {
                DefineDataSourceSetUtil.defineDataSourceAndDataSet((DataSetHandle)inputDataSet.get(i), dataEngine, modelAdaptor, context);
                ++i;
            }
        }
        if ((design = ((DataEngineImpl)dataEngine).getDataSetDesign(dataSet.getQualifiedName())) == null) {
            design = modelAdaptor.adaptDataSet(dataSet);
            dataEngine.defineDataSet(design);
        }
        if (context != null) {
            context.process(design, dataSet);
        }
    }

    public static void prepareForTransientQuery(DataSessionContext sessionContext, DataEngineImpl dataEngine, DataSetHandle handle, IQueryDefinition queryDefn) throws BirtException {
        IDataSetInterceptor dataSetInterceptor;
        IBaseDataSetDesign design = null;
        if (handle == null) {
            if (queryDefn.getDataSetName() == null) {
                if (queryDefn.getSourceQuery() != null && queryDefn.getSourceQuery() instanceof IQueryDefinition) {
                    design = dataEngine.getDataSetDesign(((IQueryDefinition)queryDefn.getSourceQuery()).getDataSetName());
                }
            } else {
                design = dataEngine.getDataSetDesign(queryDefn.getDataSetName());
            }
        } else {
            design = dataEngine.getDataSetDesign(handle.getQualifiedName());
        }
        if ((dataSetInterceptor = DataSetInterceptorFinder.find(design)) != null) {
            dataSetInterceptor.preDefineDataSet(sessionContext, dataEngine.getDataSourceDesign(design.getDataSourceName()), design, queryDefn);
            dataEngine.addShutdownListener(new IShutdownListener(){

                public void dataEngineShutdown() {
                    try {
                        dataSetInterceptor.close();
                    }
                    catch (BirtException birtException) {}
                }
            });
            return;
        }
        if (handle instanceof JointDataSetHandle) {
            JointDataSetHandle jointDataSet = (JointDataSetHandle)handle;
            Iterator iter = jointDataSet.dataSetsIterator();
            while (iter.hasNext()) {
                DataSetHandle childDataSet = (DataSetHandle)iter.next();
                if (childDataSet == null) continue;
                DefineDataSourceSetUtil.prepareForTransientQuery(sessionContext, dataEngine, childDataSet, queryDefn);
            }
        }
        if (handle instanceof DerivedDataSetHandle) {
            List inputDataSet = ((DerivedDataSetHandle)handle).getInputDataSets();
            int i = 0;
            while (i < inputDataSet.size()) {
                DefineDataSourceSetUtil.prepareForTransientQuery(sessionContext, dataEngine, (DataSetHandle)inputDataSet.get(i), queryDefn);
                ++i;
            }
        }
    }
}

