/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.DialChart;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Palette;
import org.eclipse.birt.chart.model.component.ComponentPackage;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.layout.TitleBlock;
import org.eclipse.birt.chart.model.type.AreaSeries;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.BubbleSeries;
import org.eclipse.birt.chart.model.type.DialSeries;
import org.eclipse.birt.chart.model.type.DifferenceSeries;
import org.eclipse.birt.chart.model.type.GanttSeries;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.model.type.ScatterSeries;
import org.eclipse.birt.chart.model.type.StockSeries;
import org.eclipse.birt.chart.model.util.ChartDynamicExtension;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.birt.chart.model.util.ChartExtensionValueUpdater;
import org.eclipse.birt.chart.model.util.DefaultValueProvider;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartDefaultValueUtil
extends ChartElementUtil {
    public static boolean isAutoSeriesPalette(Chart chart) {
        SeriesDefinition sd = ChartUtil.getCategorySeriesDefinition(chart);
        return sd.getSeriesPalette().getEntries().size() == 0;
    }

    public static void removeSerlesPalettes(Chart chart) {
        ChartUtil.getCategorySeriesDefinition(chart).getSeriesPalette().getEntries().clear();
        SeriesDefinition[] seriesDefinitionArray = ChartUtil.getValueSeriesDefinitions(chart);
        int n = seriesDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            SeriesDefinition sd = seriesDefinitionArray[n2];
            sd.getSeriesPalette().getEntries().clear();
            ++n2;
        }
    }

    public static void updateSeriesPalettes(Chart chart) {
        ChartDefaultValueUtil.updateSeriesPalettes(chart, null);
    }

    public static void updateSeriesPalettes(Chart chart, Collection<? extends Adapter> adapters) {
        ChartUtil.getCategorySeriesDefinition(chart).setSeriesPalette(DefaultValueProvider.defSeriesDefinition(0).getSeriesPalette().copyInstance());
        if (adapters != null) {
            ChartUtil.getCategorySeriesDefinition(chart).getSeriesPalette().eAdapters().addAll(adapters);
        }
        if (ChartUtil.hasMultipleYAxes(chart)) {
            int axesNum = ChartUtil.getOrthogonalAxisNumber(chart);
            int i = 0;
            while (i < axesNum) {
                int pos = i;
                SeriesDefinition[] seriesDefns = (SeriesDefinition[])ChartUtil.getOrthogonalSeriesDefinitions(chart, i).toArray((Object[])new SeriesDefinition[0]);
                int j = 0;
                while (j < seriesDefns.length) {
                    seriesDefns[j].setSeriesPalette(DefaultValueProvider.defSeriesDefinition(pos += j).getSeriesPalette().copyInstance());
                    if (adapters != null) {
                        seriesDefns[j].getSeriesPalette().eAdapters().addAll(adapters);
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            int i = 0;
            SeriesDefinition[] seriesDefinitionArray = ChartUtil.getValueSeriesDefinitions(chart);
            int n = seriesDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                SeriesDefinition sd = seriesDefinitionArray[n2];
                sd.setSeriesPalette(DefaultValueProvider.defSeriesDefinition(i).getSeriesPalette().copyInstance());
                if (adapters != null) {
                    sd.getSeriesPalette().eAdapters().addAll(adapters);
                }
                ++i;
                ++n2;
            }
        }
    }

    public static Series getDefaultSeries(Series runtimeSeries) {
        if (runtimeSeries instanceof BarSeries) {
            return DefaultValueProvider.defBarSeries();
        }
        if (runtimeSeries instanceof BubbleSeries) {
            return DefaultValueProvider.defBubbleSeries();
        }
        if (runtimeSeries instanceof ScatterSeries) {
            return DefaultValueProvider.defScatterSeries();
        }
        if (runtimeSeries instanceof DifferenceSeries) {
            return DefaultValueProvider.defDifferenceSeries();
        }
        if (runtimeSeries instanceof AreaSeries) {
            return DefaultValueProvider.defAreaSeries();
        }
        if (runtimeSeries instanceof LineSeries) {
            return DefaultValueProvider.defLineSeries();
        }
        if (runtimeSeries instanceof GanttSeries) {
            return DefaultValueProvider.defGanttSeries();
        }
        if (runtimeSeries instanceof DialSeries) {
            return DefaultValueProvider.defDialSeries();
        }
        if (runtimeSeries instanceof PieSeries) {
            return DefaultValueProvider.defPieSeries();
        }
        if (runtimeSeries instanceof StockSeries) {
            return DefaultValueProvider.defStockSeries();
        }
        if (ChartDynamicExtension.isExtended(runtimeSeries)) {
            return (Series)new ChartExtensionValueUpdater().getDefault(ComponentPackage.eINSTANCE.getSeries(), "series", runtimeSeries);
        }
        return null;
    }

    public static Chart getDefaultValueChart(Chart cm) {
        Chart instance = null;
        instance = cm instanceof DialChart ? DefaultValueProvider.defDialChart() : (cm instanceof ChartWithoutAxes ? DefaultValueProvider.defChartWithoutAxes() : DefaultValueProvider.defChartWithAxes());
        return instance;
    }

    public static Orientation getDefaultOrientation(Chart cm) {
        Chart chart = ChartDefaultValueUtil.getDefaultValueChart(cm);
        if (chart instanceof ChartWithAxes) {
            ((ChartWithAxes)chart).getOrientation();
        }
        return null;
    }

    public static Block getDefaultBlock(Chart cm) {
        return ChartDefaultValueUtil.getDefaultValueChart(cm).getBlock();
    }

    public static Legend getDefaultLegend(Chart cm) {
        return ChartDefaultValueUtil.getDefaultValueChart(cm).getLegend();
    }

    public static Plot getDefaultPlot(Chart cm) {
        return ChartDefaultValueUtil.getDefaultValueChart(cm).getPlot();
    }

    public static TitleBlock getDefaultTitle(Chart cm) {
        return ChartDefaultValueUtil.getDefaultValueChart(cm).getTitle();
    }

    public static Chart createDefaultValueChartInstance(Chart cm) {
        Chart instance = ChartDefaultValueUtil.getDefaultValueChart(cm).copyInstance();
        SeriesDefinition sd = (SeriesDefinition)ChartUtil.getOrthogonalSeriesDefinitions(instance, 0).get(0);
        EList<Series> seriesList = sd.getSeries();
        seriesList.clear();
        if (instance instanceof ChartWithAxes) {
            seriesList.add(DefaultValueProvider.defBarSeries().copyInstance());
            seriesList.add(DefaultValueProvider.defBubbleSeries().copyInstance());
            seriesList.add(DefaultValueProvider.defScatterSeries().copyInstance());
            seriesList.add(DefaultValueProvider.defDifferenceSeries().copyInstance());
            seriesList.add(DefaultValueProvider.defAreaSeries().copyInstance());
            seriesList.add(DefaultValueProvider.defLineSeries().copyInstance());
            seriesList.add(DefaultValueProvider.defGanttSeries().copyInstance());
            seriesList.add(DefaultValueProvider.defStockSeries().copyInstance());
        } else {
            seriesList.add(DefaultValueProvider.defDialSeries().copyInstance());
            seriesList.add(DefaultValueProvider.defPieSeries().copyInstance());
        }
        HashSet<String> seriesNameSet = new HashSet<String>();
        for (Series s : seriesList) {
            seriesNameSet.add(s.getClass().getName());
        }
        HashSet<Series> dtSeries = new HashSet<Series>();
        for (SeriesDefinition sdef : ChartUtil.getAllOrthogonalSeriesDefinitions(cm)) {
            for (Series s : sdef.getSeries()) {
                dtSeries.add(s);
            }
        }
        for (Series s : dtSeries) {
            if (seriesNameSet.contains(s.getClass().getName())) continue;
            seriesList.add(ChartDefaultValueUtil.getDefaultSeries(s));
        }
        instance.getTitle().getLabel().getCaption().setValue(ChartUtil.getDefaultChartTitle(cm));
        return instance;
    }

    public static void shiftPaletteColors(Palette p, int offset) {
        if (p.getEntries().size() == 0) {
            p.shift(offset);
            return;
        }
        EList<Fill> el = p.getEntries();
        int size = el.size();
        if (offset == 0 || Math.abs(offset) >= size) {
            offset = 0;
            return;
        }
        ArrayList<Fill> colorList = new ArrayList<Fill>();
        colorList.addAll((Collection<Fill>)el);
        el.clear();
        if (offset < 0) {
            offset = -offset;
        } else if (offset > 0) {
            offset = size - offset;
        }
        int i = offset;
        while (i < size) {
            el.add((Object)((Fill)colorList.get(i)));
            ++i;
        }
        i = 0;
        while (i < offset) {
            el.add((Object)((Fill)colorList.get(i)));
            ++i;
        }
    }

    public static String getDefaultUnits(Chart cm) {
        if (cm instanceof ChartWithAxes) {
            return DefaultValueProvider.defChartWithAxes().getUnits();
        }
        if (cm instanceof DialChart) {
            return DefaultValueProvider.defDialChart().getUnits();
        }
        if (cm instanceof ChartWithoutAxes) {
            return DefaultValueProvider.defChartWithoutAxes().getUnits();
        }
        return null;
    }
}

