/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CSourceViewer;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlightingPresenter;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlightingReconciler;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlightings;
import org.eclipse.cdt.internal.ui.text.CPresentationReconciler;
import org.eclipse.cdt.internal.ui.text.CSourceViewerScalableConfiguration;
import org.eclipse.cdt.ui.text.CSourceViewerConfiguration;
import org.eclipse.cdt.ui.text.IColorManager;
import org.eclipse.cdt.ui.text.ISemanticHighlighting;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;

public class SemanticHighlightingManager
implements IPropertyChangeListener {
    protected SemanticHighlightingPresenter fPresenter;
    private SemanticHighlightingReconciler fReconciler;
    protected ISemanticHighlighting[] fSemanticHighlightings;
    protected HighlightingStyle[] fHighlightings;
    private CEditor fEditor;
    protected CSourceViewer fSourceViewer;
    protected IPreferenceStore fPreferenceStore;
    protected CSourceViewerConfiguration fConfiguration;
    protected CPresentationReconciler fPresentationReconciler;
    private ILanguage fLanguage;
    protected HighlightedRange[][] fHardcodedRanges;

    public void install(CEditor editor, CSourceViewer sourceViewer, IColorManager colorManager, IPreferenceStore preferenceStore) {
        this.fEditor = editor;
        this.fSourceViewer = sourceViewer;
        this.fPreferenceStore = preferenceStore;
        this.fLanguage = sourceViewer.getLanguage();
        if (this.fEditor != null) {
            this.fConfiguration = new CSourceViewerScalableConfiguration(colorManager, preferenceStore, editor, "___c_partitioning");
            this.fPresentationReconciler = (CPresentationReconciler)this.fConfiguration.getPresentationReconciler((ISourceViewer)sourceViewer);
        } else {
            this.fConfiguration = null;
            this.fPresentationReconciler = null;
        }
        this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        if (this.isEnabled()) {
            this.enable();
        }
    }

    public void install(CSourceViewer sourceViewer, IColorManager colorManager, IPreferenceStore preferenceStore, HighlightedRange[][] hardcodedRanges) {
        this.fHardcodedRanges = hardcodedRanges;
        this.install(null, sourceViewer, colorManager, preferenceStore);
    }

    private void enable() {
        this.initializeHighlightings();
        this.fPresenter = new SemanticHighlightingPresenter();
        this.fPresenter.install(this.fSourceViewer, this.fPresentationReconciler);
        if (this.fEditor != null) {
            this.fReconciler = new SemanticHighlightingReconciler();
            this.fReconciler.install(this.fEditor, (ISourceViewer)this.fSourceViewer, this.fPresenter, this.fSemanticHighlightings, this.fHighlightings);
        } else {
            this.fPresenter.updatePresentation(null, this.createHardcodedPositions(), new HighlightedPosition[0]);
        }
    }

    protected HighlightedPosition[] createHardcodedPositions() {
        ArrayList<HighlightedPosition> positions = new ArrayList<HighlightedPosition>();
        int i = 0;
        while (i < this.fHardcodedRanges.length) {
            HighlightedRange range = null;
            HighlightingStyle hl = null;
            int j = 0;
            while (j < this.fHardcodedRanges[i].length) {
                hl = this.getHighlighting(this.fHardcodedRanges[i][j].getKey());
                if (hl.isEnabled()) {
                    range = this.fHardcodedRanges[i][j];
                    break;
                }
                ++j;
            }
            if (range != null) {
                positions.add(this.fPresenter.createHighlightedPosition(range.getOffset(), range.getLength(), hl));
            }
            ++i;
        }
        return positions.toArray(new HighlightedPosition[positions.size()]);
    }

    private HighlightingStyle getHighlighting(String id) {
        int i = 0;
        while (i < this.fSemanticHighlightings.length) {
            ISemanticHighlighting semanticHighlighting = this.fSemanticHighlightings[i];
            if (id.equals(semanticHighlighting.getId())) {
                return this.fHighlightings[i];
            }
            ++i;
        }
        return null;
    }

    public void uninstall() {
        this.disable();
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fPreferenceStore = null;
        }
        this.fEditor = null;
        this.fSourceViewer = null;
        this.fConfiguration = null;
        this.fPresentationReconciler = null;
        this.fHardcodedRanges = null;
    }

    private void disable() {
        if (this.fReconciler != null) {
            this.fReconciler.uninstall();
            this.fReconciler = null;
        }
        if (this.fPresenter != null) {
            this.fPresenter.uninstall();
            this.fPresenter = null;
        }
        if (this.fSemanticHighlightings != null) {
            this.disposeHighlightings();
        }
    }

    protected boolean isEnabled() {
        return SemanticHighlightings.isEnabled(this.fPreferenceStore, this.fLanguage);
    }

    protected void initializeHighlightings() {
        this.fSemanticHighlightings = SemanticHighlightings.getSemanticHighlightings(this.fLanguage);
        this.fHighlightings = new HighlightingStyle[this.fSemanticHighlightings.length];
        int i = 0;
        int n = this.fSemanticHighlightings.length;
        while (i < n) {
            ISemanticHighlighting semanticHighlighting = this.fSemanticHighlightings[i];
            this.fHighlightings[i] = new HighlightingStyle(semanticHighlighting.getTextAttribute(), semanticHighlighting.isEnabled());
            ++i;
        }
    }

    protected void disposeHighlightings() {
        int i = 0;
        int n = this.fSemanticHighlightings.length;
        while (i < n) {
            this.fSemanticHighlightings[i].dispose();
            ++i;
        }
        this.fSemanticHighlightings = null;
        this.fHighlightings = null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.handlePropertyChangeEvent(event);
    }

    protected boolean handlePropertyChangeEvent(PropertyChangeEvent event) {
        if (this.fPreferenceStore == null) {
            return false;
        }
        if (this.fConfiguration != null) {
            this.fConfiguration.handlePropertyChangeEvent(event);
        }
        if (SemanticHighlightings.affectsEnablement(this.fPreferenceStore, event, this.fLanguage)) {
            if (this.isEnabled()) {
                this.enable();
            } else {
                this.disable();
            }
        }
        if (!this.isEnabled()) {
            return false;
        }
        boolean refreshNeeded = false;
        int i = 0;
        int n = this.fSemanticHighlightings.length;
        while (i < n) {
            ISemanticHighlighting semanticHighlighting = this.fSemanticHighlightings[i];
            if (semanticHighlighting.styleUpdated(event)) {
                this.fHighlightings[i].setEnabled(semanticHighlighting.isEnabled());
                this.fHighlightings[i].setTextAttribute(semanticHighlighting.getTextAttribute());
                this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                refreshNeeded = true;
            }
            ++i;
        }
        if (refreshNeeded && this.fReconciler != null) {
            this.fReconciler.refresh();
        }
        return refreshNeeded;
    }

    public void refresh() {
        if (this.fReconciler != null) {
            this.fReconciler.refresh();
        }
    }

    public static class HighlightedPosition
    extends Position {
        private HighlightingStyle fStyle;
        private Object fLock;

        public HighlightedPosition(int offset, int length, HighlightingStyle highlighting, Object lock) {
            super(offset, length);
            this.fStyle = highlighting;
            this.fLock = lock;
        }

        public StyleRange createStyleRange() {
            int len = 0;
            if (this.fStyle.isEnabled()) {
                len = this.getLength();
            }
            TextAttribute textAttribute = this.fStyle.getTextAttribute();
            int style = textAttribute.getStyle();
            int fontStyle = style & 3;
            StyleRange styleRange = new StyleRange(this.getOffset(), len, textAttribute.getForeground(), textAttribute.getBackground(), fontStyle);
            styleRange.strikeout = (style & 0x20000000) != 0;
            styleRange.underline = (style & 0x40000000) != 0;
            return styleRange;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEqual(int off, int len, HighlightingStyle highlighting) {
            Object object = this.fLock;
            synchronized (object) {
                return !this.isDeleted() && this.getOffset() == off && this.getLength() == len && this.fStyle == highlighting;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isContained(int off, int len) {
            Object object = this.fLock;
            synchronized (object) {
                return !this.isDeleted() && off <= this.getOffset() && off + len >= this.getOffset() + this.getLength();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(int off, int len) {
            Object object = this.fLock;
            synchronized (object) {
                super.setOffset(off);
                super.setLength(len);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLength(int length) {
            Object object = this.fLock;
            synchronized (object) {
                super.setLength(length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setOffset(int offset) {
            Object object = this.fLock;
            synchronized (object) {
                super.setOffset(offset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete() {
            Object object = this.fLock;
            synchronized (object) {
                super.delete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void undelete() {
            Object object = this.fLock;
            synchronized (object) {
                super.undelete();
            }
        }

        public HighlightingStyle getHighlighting() {
            return this.fStyle;
        }
    }

    public static class HighlightedRange
    extends Region {
        private String fKey;

        public HighlightedRange(int offset, int length, String key) {
            super(offset, length);
            this.fKey = key;
        }

        public String getKey() {
            return this.fKey;
        }

        public boolean equals(Object o) {
            return super.equals(o) && o instanceof HighlightedRange && this.fKey.equals(((HighlightedRange)((Object)o)).getKey());
        }

        public int hashCode() {
            return super.hashCode() | this.fKey.hashCode();
        }
    }

    public static class HighlightingStyle {
        private TextAttribute fTextAttribute;
        private boolean fIsEnabled;

        public HighlightingStyle(TextAttribute textAttribute, boolean isEnabled) {
            this.setTextAttribute(textAttribute);
            this.setEnabled(isEnabled);
        }

        public TextAttribute getTextAttribute() {
            return this.fTextAttribute;
        }

        public void setTextAttribute(TextAttribute textAttribute) {
            this.fTextAttribute = textAttribute;
        }

        public boolean isEnabled() {
            return this.fIsEnabled;
        }

        public void setEnabled(boolean isEnabled) {
            this.fIsEnabled = isEnabled;
        }
    }
}

