/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.common.toolkit;

import com.nvidia.common.util.NativeUtils;
import com.nvidia.common.util.OS;

public interface ICudaToolkit {
    public String getBinDirectory();

    public String getToolPath(Tool var1);

    public String[] getLibraryPath();

    public String getName();

    public String getId();

    public String getDefaultToolPath(Tool var1);

    public static enum Tool {
        GdbServer("cuda-gdbserver"),
        Nvcc("nvcc"),
        Nvprof("nvprof"),
        Nvdisasm("nvdisasm");

        private final String executable;

        private Tool(String executable) {
            this.executable = executable;
        }

        public String executable(OS os) {
            return String.valueOf(this.executable) + NativeUtils.getExecutableExtension(os);
        }

        public boolean isCustomizable() {
            return this == Nvprof;
        }

        public String fullName() {
            switch (this) {
                case GdbServer: {
                    return "Remote debug server:";
                }
                case Nvcc: {
                    return "Compiler:";
                }
                case Nvprof: {
                    return "Command-line profiler:";
                }
                case Nvdisasm: {
                    return "Disassembler:";
                }
            }
            throw new IllegalArgumentException(this.name());
        }
    }
}

