/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.common.internal.toolkit;

import com.nvidia.common.internal.Activator;
import com.nvidia.common.internal.toolkit.CudaToolkit;
import com.nvidia.common.internal.toolkit.IToolkitLookup;
import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.util.OS;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public final class CommandLineToolkit
implements IToolkitLookup {
    private static final Pattern COMMAND_LINE_ARG_PATTERN = Pattern.compile("-nsight\\.toolkit=\"?(.*)\"?");

    @Override
    public ICudaToolkit[] discover() {
        String[] args;
        String[] stringArray = args = Platform.getCommandLineArgs();
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            Matcher matcher = COMMAND_LINE_ARG_PATTERN.matcher(arg);
            if (matcher.matches()) {
                try {
                    File folder = new File(matcher.group(1)).getCanonicalFile();
                    File nvcc = new File(folder, ICudaToolkit.Tool.Nvcc.executable(OS.local()));
                    if (nvcc.isFile()) {
                        return new ICudaToolkit[]{new CudaToolkit("commandline", (IPath)new Path(folder.getAbsolutePath()), null)};
                    }
                    Activator.log("Path not pointing to NVCC install location: %s", folder.getAbsolutePath());
                }
                catch (IOException e) {
                    Activator.log(e);
                }
            }
            ++n2;
        }
        return null;
    }
}

