/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.common.internal.toolkit;

import com.nvidia.common.internal.Activator;
import com.nvidia.common.internal.toolkit.CudaToolkit;
import com.nvidia.common.internal.toolkit.IToolkitLookup;
import com.nvidia.common.toolkit.ICudaToolkit;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;

public final class BundledToolkit
implements IToolkitLookup {
    private IPath getBundledToolkit() {
        URL url;
        String protocol;
        Location location = Platform.getInstallLocation();
        if (location != null && ((protocol = (url = location.getURL()).getProtocol()) == null || "file".equals(protocol))) {
            try {
                File file = new File(url.toURI()).getParentFile();
                File nvcc = new File(file, "bin" + File.separator + "nvcc");
                if (nvcc.isFile()) {
                    return new Path(nvcc.getParentFile().getAbsoluteFile().getCanonicalPath());
                }
            }
            catch (IOException e) {
                Activator.log(e);
            }
            catch (URISyntaxException e) {
                Activator.log(e);
            }
        }
        return null;
    }

    @Override
    public ICudaToolkit[] discover() {
        IPath toolkit = this.getBundledToolkit();
        if (toolkit != null) {
            return new ICudaToolkit[]{new CudaToolkit("bundled.toolkit", toolkit, "CUDA Toolkit 6.5")};
        }
        return null;
    }
}

