/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.editor;

import com.nvidia.cuda.ide.editor.Activator;
import com.nvidia.cuda.ide.language.ast.CudaCASTUtil;
import com.nvidia.cuda.ide.language.ast.CudaTarget;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.IBackgroundHighlight;
import org.eclipse.cdt.ui.text.ILineBackgroundPainter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class CudaScopesBackground
implements IBackgroundHighlight,
IPropertyChangeListener {
    public static final String PREF_DEVICE_BACKGROUND = "cudaDeviceFunctionBackground";
    public static final String PREF_DEVICE_BACKGROUND_ENABLED = "cudaDeviceFunctionBackground.enabled";
    public static final String PREF_HOST_BACKGROUND = "cudaHostFunctionBackground";
    public static final String PREF_HOST_BACKGROUND_ENABLED = "cudaHostFunctionBackground.enabled";
    public static final String PREF_HOST_DEVICE_BACKGROUND = "cudaHostDeviceFunctionBackground";
    public static final String PREF_HOST_DEVICE_BACKGROUND_ENABLED = "cudaHostDeviceFunctionBackground.enabled";
    private static final Collection<String> PREF_KEYS = new TreeSet<String>(Arrays.asList("cudaDeviceFunctionBackground", "cudaDeviceFunctionBackground.enabled", "cudaHostFunctionBackground", "cudaHostFunctionBackground.enabled", "cudaHostDeviceFunctionBackground", "cudaHostDeviceFunctionBackground.enabled", "semanticHighlighting.enabled"));
    private boolean deviceBackgroundEnabled;
    private IDocument document;
    private boolean hostBackgroundEnabled;
    private boolean hostDeviceBackgroundEnabled;
    private IPreferenceStore store;
    private ILineBackgroundPainter painter;

    private boolean isEnabled(CudaTarget key) {
        if (key == null) {
            return false;
        }
        switch (key) {
            case cudaDevice: {
                return this.deviceBackgroundEnabled;
            }
            case cudaHost: {
                return this.hostBackgroundEnabled;
            }
            case cudaHostDevice: {
                return this.hostDeviceBackgroundEnabled;
            }
        }
        return false;
    }

    public List<Position> collectPositions(IASTTranslationUnit ast) {
        if (ast == null || !this.deviceBackgroundEnabled && !this.hostBackgroundEnabled && !this.hostDeviceBackgroundEnabled) {
            return Collections.emptyList();
        }
        DefinitionsVisitor visitor = new DefinitionsVisitor(this.document);
        ast.accept((ASTVisitor)visitor);
        return visitor.getPositions();
    }

    public void install(IDocument document, ILineBackgroundPainter painter) {
        this.document = document;
        this.painter = painter;
        this.store = CUIPlugin.getDefault().getPreferenceStore();
        this.readPreferences();
        this.store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (PREF_KEYS.contains(event.getProperty())) {
            this.readPreferences();
            this.painter.refresh();
        }
    }

    private void readPreferences() {
        boolean enabled = this.store.getBoolean("semanticHighlighting.enabled");
        this.hostDeviceBackgroundEnabled = this.store.getBoolean(PREF_HOST_DEVICE_BACKGROUND_ENABLED) && enabled;
        this.deviceBackgroundEnabled = this.store.getBoolean(PREF_DEVICE_BACKGROUND_ENABLED) && enabled;
        boolean bl = this.hostBackgroundEnabled = this.store.getBoolean(PREF_HOST_BACKGROUND_ENABLED) && enabled;
        if (this.hostDeviceBackgroundEnabled) {
            this.painter.setBackgroundColor(CudaTarget.cudaHostDevice.name(), PreferenceConverter.getColor((IPreferenceStore)this.store, (String)PREF_HOST_DEVICE_BACKGROUND));
        }
        if (this.deviceBackgroundEnabled) {
            this.painter.setBackgroundColor(CudaTarget.cudaDevice.name(), PreferenceConverter.getColor((IPreferenceStore)this.store, (String)PREF_DEVICE_BACKGROUND));
        }
        if (this.hostBackgroundEnabled) {
            this.painter.setBackgroundColor(CudaTarget.cudaHost.name(), PreferenceConverter.getColor((IPreferenceStore)this.store, (String)PREF_HOST_BACKGROUND));
        }
    }

    public void uninstall() {
        this.store.removePropertyChangeListener((IPropertyChangeListener)this);
    }

    private final class DefinitionsVisitor
    extends ASTVisitor {
        private ScopeVisitor current;

        public DefinitionsVisitor(IDocument document) {
            this.current = new ScopeVisitor(document);
            this.shouldVisitDeclarations = true;
            this.shouldVisitNamespaces = true;
        }

        private IASTDeclSpecifier getDeclSpec(IASTDeclaration declarator) {
            if (declarator instanceof IASTFunctionDefinition) {
                IASTName name = ((IASTFunctionDefinition)declarator).getDeclarator().getName();
                if (name != null) {
                    if (CPPVisitor.isConstructorDeclaration((IASTName)name)) {
                        return null;
                    }
                    char[] id = name.getSimpleID();
                    if (id != null && id.length > 0 && id[0] == '~') {
                        return null;
                    }
                }
                return ((IASTFunctionDefinition)declarator).getDeclSpecifier();
            }
            if (declarator instanceof IASTSimpleDeclaration) {
                IASTSimpleDeclaration simpleDeclaration = (IASTSimpleDeclaration)declarator;
                IASTDeclarator[] declarators = simpleDeclaration.getDeclarators();
                if (declarators.length > 0 && (simpleDeclaration.getPropertyInParent() != IASTCompositeTypeSpecifier.MEMBER_DECLARATION || declarators[0] instanceof IASTFunctionDeclarator)) {
                    return simpleDeclaration.getDeclSpecifier();
                }
                return null;
            }
            return null;
        }

        public List<Position> getPositions() {
            return this.current.getPositions();
        }

        public int leave(IASTDeclaration declaration) {
            this.current = this.current.pop((IASTNode)declaration);
            return 3;
        }

        public int leave(ICPPASTNamespaceDefinition namespaceDefinition) {
            this.current = this.current.pop((IASTNode)namespaceDefinition);
            return 3;
        }

        public int visit(IASTDeclaration declarator) {
            IASTDeclSpecifier declSpecifier = this.getDeclSpec(declarator);
            if (declSpecifier != null) {
                CudaTarget newkey = CudaCASTUtil.getTarget(declSpecifier);
                this.current.add((IASTNode)declarator, newkey);
                return 1;
            }
            this.current = this.current.push((IASTNode)declarator);
            return 3;
        }

        public int visit(ICPPASTNamespaceDefinition namespaceDefinition) {
            this.current = this.current.push((IASTNode)namespaceDefinition);
            return 3;
        }
    }

    private final class ScopeVisitor {
        private final IDocument document;
        private CudaTarget key;
        private final IASTNode node;
        private final ScopeVisitor parentScope;
        private final List<Position> positions = new LinkedList<Position>();
        private int rangeLength = -1;
        private int rangeStart = -1;
        private CudaTarget scopeKey;

        public ScopeVisitor(IDocument document) {
            this(document, null, null);
        }

        public ScopeVisitor(IDocument document, IASTNode node, ScopeVisitor parent) {
            this.document = document;
            this.node = node;
            this.parentScope = parent;
        }

        public void add(IASTNode node, CudaTarget newkey) {
            if (this.key == null) {
                this.scopeKey = newkey;
            } else if (newkey != this.key) {
                this.scopeKey = CudaTarget.undefined;
            }
            IASTFileLocation location = node.getFileLocation();
            int nodeOffset = location.getNodeOffset();
            int newStart = this.alignToLineStart(nodeOffset);
            if (newkey != this.key || this.rangeStart < 0) {
                if (this.key != null) {
                    if (newkey.ordinal() > this.key.ordinal()) {
                        this.rangeLength = newStart - this.rangeStart;
                    } else {
                        newStart = this.alignToLineStart(this.rangeStart + this.rangeLength);
                    }
                }
                this.createPosition();
                this.rangeStart = newStart;
                this.rangeLength = location.getNodeOffset() + location.getNodeLength() - this.rangeStart;
                this.key = newkey;
            } else if (this.rangeStart >= 0) {
                this.rangeLength = newStart + location.getNodeLength() - this.rangeStart;
            }
        }

        private int alignToLineStart(int offset) {
            try {
                int lineNo;
                int lineNo2;
                int rangeEnd = this.rangeStart + this.rangeLength - 1;
                int firstRangeLine = this.document.getLineOfOffset(offset);
                boolean newLine = false;
                newLine = rangeEnd >= 0 ? (lineNo2 = firstRangeLine) > (lineNo = this.document.getLineOfOffset(rangeEnd)) : true;
                if (newLine) {
                    return this.document.getLineOffset(firstRangeLine);
                }
            }
            catch (BadLocationException e) {
                Activator.log(e);
            }
            return offset;
        }

        private void createPosition() {
            if (CudaScopesBackground.this.isEnabled(this.key)) {
                TypedPosition pos = new TypedPosition(this.rangeStart, this.rangeLength, this.key.name());
                this.positions.add((Position)pos);
            }
            this.key = null;
        }

        public List<Position> getPositions() {
            this.createPosition();
            return this.positions;
        }

        private CudaTarget getScopeKey() {
            return this.scopeKey;
        }

        private void merge(ScopeVisitor scope) {
            CudaTarget scopeKey = scope.getScopeKey();
            if (scopeKey != null && scopeKey != CudaTarget.undefined) {
                this.add(scope.node, scopeKey);
            } else {
                this.createPosition();
                this.positions.addAll(scope.getPositions());
            }
        }

        public ScopeVisitor pop(IASTNode declarator) {
            if (declarator == this.node) {
                this.parentScope.merge(this);
                return this.parentScope;
            }
            return this;
        }

        public ScopeVisitor push(IASTNode declarator) {
            return new ScopeVisitor(this.document, declarator, this);
        }
    }
}

