/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.common.internal.toolkit;

import com.nvidia.common.toolkit.AbstractToolkit;
import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.toolkit.ToolkitVersion;
import com.nvidia.common.util.OS;
import org.eclipse.core.runtime.IPath;

public final class CudaToolkit
extends AbstractToolkit
implements ICudaToolkit {
    private final String id;
    private final String name;
    private final IPath path;

    public CudaToolkit(String id, IPath path, String name) {
        this.id = id;
        assert (path != null);
        this.path = path;
        this.name = name;
    }

    private String buildName() {
        return String.format("%s (%s)", ToolkitVersion.current.label, this.path);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CudaToolkit other = (CudaToolkit)obj;
        return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
    }

    @Override
    public String getBinDirectory() {
        return this.path.addTrailingSeparator().toString();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String[] getLibraryPath() {
        IPath root = this.path.removeLastSegments(1);
        return new String[]{root.append("lib64").toString(), root.append("lib").toString()};
    }

    @Override
    public String getName() {
        return this.name == null ? this.buildName() : this.name;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.toPortableString().hashCode());
        return result;
    }

    @Override
    protected OS getToolkitOS() {
        return OS.local();
    }
}

