/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ToolItem
extends Item {
    long arrowHandle;
    long arrowBoxHandle;
    long labelHandle;
    long imageHandle;
    long eventHandle;
    long proxyMenuItem;
    ToolBar parent;
    Control control;
    Image hotImage;
    Image disabledImage;
    String toolTipText;
    boolean drawHotImage;

    public ToolItem(ToolBar parent, int style) {
        super(parent, ToolItem.checkStyle(style));
        this.parent = parent;
        this.createWidget(parent.getItemCount());
    }

    public ToolItem(ToolBar parent, int style, int index) {
        super(parent, ToolItem.checkStyle(style));
        this.parent = parent;
        int count = parent.getItemCount();
        if (index < 0 || index > count) {
            this.error(6);
        }
        this.createWidget(index);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return ToolItem.checkBits(style, 8, 32, 16, 2, 4, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle(int index) {
        this.state |= 8;
        int bits = 62;
        if ((this.style & 2) == 0) {
            this.labelHandle = OS.gtk_label_new_with_mnemonic(null);
            if (this.labelHandle == 0L) {
                this.error(2);
            }
            this.imageHandle = OS.gtk_image_new_from_pixbuf(0L);
            if (this.imageHandle == 0L) {
                this.error(2);
            }
        }
        switch (this.style & bits) {
            case 2: {
                this.handle = OS.gtk_separator_tool_item_new();
                if (this.handle == 0L) {
                    this.error(2);
                }
                OS.gtk_separator_tool_item_set_draw(this.handle, true);
                break;
            }
            case 4: {
                if (OS.GTK_VERSION >= OS.VERSION(2, 6, 0)) {
                    this.handle = OS.gtk_menu_tool_button_new(0L, null);
                    if (this.handle == 0L) {
                        this.error(2);
                    }
                    long child = OS.gtk_bin_get_child(this.handle);
                    long list = OS.gtk_container_get_children(child);
                    this.arrowHandle = OS.g_list_nth_data(list, 1);
                    OS.gtk_widget_set_sensitive(this.arrowHandle, true);
                    OS.gtk_widget_set_size_request(OS.gtk_bin_get_child(this.arrowHandle), 8, 6);
                    break;
                }
                this.handle = OS.gtk_tool_button_new(0L, null);
                if (this.handle == 0L) {
                    this.error(2);
                }
                this.arrowBoxHandle = OS.gtk_hbox_new(false, 0);
                if (this.arrowBoxHandle == 0L) {
                    this.error(2);
                }
                this.arrowHandle = OS.gtk_arrow_new(1, 0);
                if (this.arrowHandle == 0L) {
                    this.error(2);
                }
                OS.gtk_widget_set_size_request(this.arrowHandle, 8, 6);
                OS.gtk_container_add(this.arrowBoxHandle, this.labelHandle);
                OS.gtk_container_add(this.arrowBoxHandle, this.arrowHandle);
                OS.gtk_tool_item_set_is_important(this.handle, true);
                break;
            }
            case 16: 
            case 32: {
                this.handle = OS.gtk_toggle_tool_button_new();
                if (this.handle != 0L) break;
                this.error(2);
                break;
            }
            default: {
                this.handle = OS.gtk_tool_button_new(0L, null);
                if (this.handle != 0L) break;
                this.error(2);
            }
        }
        if (this.labelHandle != 0L) {
            OS.gtk_tool_button_set_label_widget(this.handle, this.labelHandle);
        }
        if (this.imageHandle != 0L) {
            OS.gtk_tool_button_set_icon_widget(this.handle, this.imageHandle);
        }
        if ((this.parent.state & 0x1000) != 0) {
            this.setForegroundColor(this.parent.getForegroundColor());
        }
        if ((this.parent.state & 0x4000) != 0) {
            this.setFontDescription(this.parent.getFontDescription());
        }
        if ((this.parent.style & 0x20000) != 0) {
            OS.gtk_tool_item_set_is_important(this.handle, true);
        }
        if ((this.style & 2) == 0) {
            OS.gtk_tool_button_set_use_underline(this.handle, true);
        }
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.showWidget(index);
        this.parent.relayout();
    }

    Widget[] computeTabList() {
        if (this.isTabGroup() && this.getEnabled()) {
            if ((this.style & 2) != 0) {
                if (this.control != null) {
                    return this.control.computeTabList();
                }
            } else {
                return new Widget[]{this};
            }
        }
        return new Widget[0];
    }

    void deregister() {
        super.deregister();
        if (this.eventHandle != 0L) {
            this.display.removeWidget(this.eventHandle);
        }
        if (this.arrowHandle != 0L) {
            this.display.removeWidget(this.arrowHandle);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        ToolBar parent = this.parent;
        super.dispose();
        parent.relayout();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        this.parent.forceResize();
        long topHandle = this.topHandle();
        int x = OS.GTK_WIDGET_X(topHandle);
        int y = OS.GTK_WIDGET_Y(topHandle);
        int width = OS.GTK_WIDGET_WIDTH(topHandle);
        int height = OS.GTK_WIDGET_HEIGHT(topHandle);
        if ((this.parent.style & 0x8000000) != 0) {
            x = this.parent.getClientWidth() - width - x;
        }
        if ((this.style & 2) != 0 && this.control != null) {
            height = Math.max(height, 23);
        }
        return new Rectangle(x, y, width, height);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public boolean getEnabled() {
        this.checkWidget();
        long topHandle = this.topHandle();
        return OS.GTK_WIDGET_SENSITIVE(topHandle);
    }

    public Image getHotImage() {
        this.checkWidget();
        return this.hotImage;
    }

    public ToolBar getParent() {
        this.checkWidget();
        if (this.parent == null) {
            this.error(24);
        }
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        return OS.gtk_toggle_tool_button_get_active(this.handle);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        this.parent.forceResize();
        long topHandle = this.topHandle();
        return OS.GTK_WIDGET_WIDTH(topHandle);
    }

    long gtk_button_press_event(long widget, long event) {
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, event, (long)GdkEventButton.sizeof);
        double x = gdkEvent.x;
        gdkEvent.x += (double)OS.GTK_WIDGET_X(this.handle);
        double y = gdkEvent.y;
        gdkEvent.y += (double)OS.GTK_WIDGET_Y(this.handle);
        OS.memmove(event, gdkEvent, (long)GdkEventButton.sizeof);
        long result = this.parent.gtk_button_press_event(widget, event);
        gdkEvent.x = x;
        gdkEvent.y = y;
        OS.memmove(event, gdkEvent, (long)GdkEventButton.sizeof);
        return result;
    }

    long gtk_button_release_event(long widget, long event) {
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, event, (long)GdkEventButton.sizeof);
        double x = gdkEvent.x;
        gdkEvent.x += (double)OS.GTK_WIDGET_X(this.handle);
        double y = gdkEvent.y;
        gdkEvent.y += (double)OS.GTK_WIDGET_Y(this.handle);
        OS.memmove(event, gdkEvent, (long)GdkEventButton.sizeof);
        long result = this.parent.gtk_button_release_event(widget, event);
        gdkEvent.x = x;
        gdkEvent.y = y;
        OS.memmove(event, gdkEvent, (long)GdkEventButton.sizeof);
        return result;
    }

    long gtk_clicked(long widget) {
        long eventPtr;
        Event event = new Event();
        if ((this.style & 4) != 0 && (eventPtr = OS.gtk_get_current_event()) != 0L) {
            GdkEvent gdkEvent = new GdkEvent();
            OS.memmove(gdkEvent, eventPtr, (long)GdkEvent.sizeof);
            long topHandle = this.topHandle();
            switch (gdkEvent.type) {
                case 4: 
                case 5: 
                case 7: 
                case 9: {
                    boolean isArrow = false;
                    if (OS.GTK_VERSION < OS.VERSION(2, 6, 0)) {
                        double[] x_win = new double[1];
                        double[] y_win = new double[1];
                        OS.gdk_event_get_coords(eventPtr, x_win, y_win);
                        int x = OS.GTK_WIDGET_X(this.arrowHandle) - OS.GTK_WIDGET_X(this.handle);
                        int width = OS.GTK_WIDGET_WIDTH(this.arrowHandle);
                        if ((this.parent.style & 0x4000000) == 0 && x <= (int)x_win[0] || (this.parent.style & 0x4000000) != 0 && (int)x_win[0] <= x + width) {
                            isArrow = true;
                        }
                    } else if (widget == this.arrowHandle) {
                        isArrow = true;
                        topHandle = widget;
                        OS.g_signal_handlers_block_matched(widget, 16, 0, 0, 0L, 0L, 8L);
                        OS.gtk_toggle_button_set_active(widget, false);
                        OS.g_signal_handlers_unblock_matched(widget, 16, 0, 0, 0L, 0L, 8L);
                    }
                    if (!isArrow) break;
                    event.detail = 4;
                    event.x = OS.GTK_WIDGET_X(topHandle);
                    if ((this.parent.style & 0x8000000) != 0) {
                        event.x = this.parent.getClientWidth() - OS.GTK_WIDGET_WIDTH(topHandle) - event.x;
                    }
                    event.y = OS.GTK_WIDGET_Y(topHandle) + OS.GTK_WIDGET_HEIGHT(topHandle);
                }
            }
            OS.gdk_event_free(eventPtr);
        }
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        this.sendSelectionEvent(13, event, false);
        return 0L;
    }

    long gtk_create_menu_proxy(long widget) {
        int index;
        ImageList imageList;
        byte[] buffer = Converter.wcsToMbcs(null, "menu-id", true);
        if (this.proxyMenuItem != 0L) {
            OS.gtk_tool_item_set_proxy_menu_item(widget, buffer, this.proxyMenuItem);
            return 1L;
        }
        if (this.image != null && (imageList = this.parent.imageList) != null && (index = imageList.indexOf(this.image)) != -1) {
            long property;
            long pixbuf = imageList.getPixbuf(index);
            byte[] label = null;
            int[] showImages = new int[]{1};
            long settings = OS.gtk_settings_get_default();
            if (settings != 0L && (property = OS.g_object_class_find_property(OS.G_OBJECT_GET_CLASS(settings), OS.gtk_menu_images)) != 0L) {
                OS.g_object_get(settings, OS.gtk_menu_images, showImages, 0L);
            }
            label = this.text == null || this.text.length() == 0 ? (showImages[0] == 0 && this.toolTipText != null ? Converter.wcsToMbcs(null, this.toolTipText, true) : new byte[1]) : Converter.wcsToMbcs(null, this.text, true);
            long menuItem = OS.gtk_image_menu_item_new_with_label(label);
            long menuImage = OS.gtk_image_new_from_pixbuf(pixbuf);
            OS.gtk_image_menu_item_set_image(menuItem, menuImage);
            OS.gtk_tool_item_set_proxy_menu_item(widget, buffer, menuItem);
            this.proxyMenuItem = OS.gtk_tool_item_get_proxy_menu_item(widget, buffer);
            OS.g_signal_connect(menuItem, OS.activate, ToolBar.menuItemSelectedFunc.getAddress(), this.handle);
            return 1L;
        }
        return 0L;
    }

    long gtk_enter_notify_event(long widget, long event) {
        int index;
        ImageList imageList;
        this.parent.gtk_enter_notify_event(widget, event);
        boolean bl = this.drawHotImage = (this.parent.style & 0x800000) != 0 && this.hotImage != null;
        if (this.drawHotImage && (imageList = this.parent.imageList) != null && (index = imageList.indexOf(this.hotImage)) != -1 && this.imageHandle != 0L) {
            long pixbuf = imageList.getPixbuf(index);
            OS.gtk_image_set_from_pixbuf(this.imageHandle, pixbuf);
        }
        return 0L;
    }

    long gtk_event_after(long widget, long gdkEvent) {
        GdkEvent event = new GdkEvent();
        OS.memmove(event, gdkEvent, (long)GdkEvent.sizeof);
        switch (event.type) {
            case 4: {
                GdkEventButton gdkEventButton = new GdkEventButton();
                OS.memmove(gdkEventButton, gdkEvent, (long)GdkEventButton.sizeof);
                if (gdkEventButton.button != 3) break;
                this.parent.showMenu((int)gdkEventButton.x_root, (int)gdkEventButton.y_root);
            }
        }
        return 0L;
    }

    long gtk_focus_in_event(long widget, long event) {
        this.parent.hasChildFocus = true;
        this.parent.currentFocusItem = this;
        return 0L;
    }

    long gtk_focus_out_event(long widget, long event) {
        this.parent.hasChildFocus = false;
        return 0L;
    }

    long gtk_leave_notify_event(long widget, long event) {
        this.parent.gtk_leave_notify_event(widget, event);
        if (this.drawHotImage) {
            int index;
            ImageList imageList;
            this.drawHotImage = false;
            if (this.image != null && (imageList = this.parent.imageList) != null && (index = imageList.indexOf(this.image)) != -1 && this.imageHandle != 0L) {
                long pixbuf = imageList.getPixbuf(index);
                OS.gtk_image_set_from_pixbuf(this.imageHandle, pixbuf);
            }
        }
        return 0L;
    }

    long gtk_map(long widget) {
        this.parent.fixZOrder();
        return 0L;
    }

    long gtk_mnemonic_activate(long widget, long arg1) {
        return this.parent.gtk_mnemonic_activate(widget, arg1);
    }

    void hookEvents() {
        super.hookEvents();
        if ((this.style & 2) != 0) {
            return;
        }
        OS.g_signal_connect_closure(this.handle, OS.clicked, this.display.closures[8], false);
        this.eventHandle = OS.gtk_bin_get_child(this.handle);
        if ((this.style & 4) != 0 && OS.GTK_VERSION >= OS.VERSION(2, 6, 0)) {
            long list = OS.gtk_container_get_children(this.eventHandle);
            this.eventHandle = OS.g_list_nth_data(list, 0);
            if (this.arrowHandle != 0L) {
                OS.g_signal_connect_closure(this.arrowHandle, OS.clicked, this.display.closures[8], false);
            }
        }
        OS.g_signal_connect_closure(this.handle, OS.create_menu_proxy, this.display.closures[83], false);
        OS.g_signal_connect_closure_by_id(this.eventHandle, this.display.signalIds[14], 0, this.display.closures[14], false);
        OS.g_signal_connect_closure_by_id(this.eventHandle, this.display.signalIds[29], 0, this.display.closures[29], false);
        OS.g_signal_connect_closure_by_id(this.eventHandle, this.display.signalIds[21], 0, this.display.closures[21], false);
        OS.g_signal_connect_closure_by_id(this.eventHandle, this.display.signalIds[22], 0, this.display.closures[22], false);
        int mask = 32518;
        OS.gtk_widget_add_events(this.eventHandle, mask);
        OS.g_signal_connect_closure_by_id(this.eventHandle, this.display.signalIds[2], 0, this.display.closures[2], false);
        OS.g_signal_connect_closure_by_id(this.eventHandle, this.display.signalIds[4], 0, this.display.closures[4], false);
        OS.g_signal_connect_closure_by_id(this.eventHandle, this.display.signalIds[16], 0, this.display.closures[16], false);
        long topHandle = this.topHandle();
        OS.g_signal_connect_closure_by_id(topHandle, this.display.signalIds[30], 0, this.display.closures[30], true);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isTabGroup() {
        ToolItem[] tabList = this.parent._getTabItemList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return true;
                }
                ++i;
            }
        }
        if ((this.style & 2) != 0) {
            return true;
        }
        int index = this.parent.indexOf(this);
        if (index == 0) {
            return true;
        }
        ToolItem previous = this.parent.getItem(index - 1);
        return (previous.getStyle() & 2) != 0;
    }

    void register() {
        super.register();
        if (this.eventHandle != 0L) {
            this.display.addWidget(this.eventHandle, this);
        }
        if (this.arrowHandle != 0L) {
            this.display.addWidget(this.arrowHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.eventHandle = 0L;
        this.imageHandle = 0L;
        this.labelHandle = 0L;
        this.arrowHandle = 0L;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.parent.currentFocusItem == this) {
            this.parent.currentFocusItem = null;
        }
        this.parent = null;
        this.control = null;
        this.disabledImage = null;
        this.hotImage = null;
        this.toolTipText = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void resizeControl() {
        if (this.control != null && !this.control.isDisposed()) {
            Rectangle itemRect = this.getBounds();
            this.control.setSize(itemRect.width, itemRect.height);
            this.resizeHandle(itemRect.width, itemRect.height);
            Rectangle rect = this.control.getBounds();
            rect.x = itemRect.x + (itemRect.width - rect.width) / 2;
            rect.y = itemRect.y + (itemRect.height - rect.height) / 2;
            this.control.setLocation(rect.x, rect.y);
        }
    }

    void resizeHandle(int width, int height) {
        OS.gtk_widget_set_size_request(this.handle, width, height);
        GtkRequisition requisition = new GtkRequisition();
        this.parent.gtk_widget_size_request(this.handle, requisition);
        GtkAllocation allocation = new GtkAllocation();
        allocation.x = OS.GTK_WIDGET_X(this.handle);
        allocation.y = OS.GTK_WIDGET_Y(this.handle);
        allocation.width = width;
        allocation.height = height;
        OS.gtk_widget_size_allocate(this.handle, allocation);
    }

    void selectRadio() {
        int index = 0;
        ToolItem[] items = this.parent.getItems();
        while (index < items.length && items[index] != this) {
            ++index;
        }
        int i = index - 1;
        while (i >= 0 && items[i].setRadioSelection(false)) {
            --i;
        }
        int j = index + 1;
        while (j < items.length && items[j].setRadioSelection(false)) {
            ++j;
        }
        this.setSelection(true);
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if ((this.style & 2) == 0) {
            return;
        }
        if (this.control == control) {
            return;
        }
        this.control = control;
        this.parent.relayout();
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        this.disabledImage = image;
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        long topHandle = this.topHandle();
        if (OS.GTK_WIDGET_SENSITIVE(topHandle) == enabled) {
            return;
        }
        OS.gtk_widget_set_sensitive(topHandle, enabled);
        if (enabled) {
            int[] x = new int[1];
            int[] y = new int[1];
            OS.gdk_window_get_pointer(this.parent.paintWindow(), x, y, null);
            if (this.getBounds().contains(x[0], y[0])) {
                OS.gtk_widget_hide(this.handle);
                OS.gtk_widget_show(this.handle);
            }
        } else if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            OS.gtk_widget_set_state(topHandle, 0);
        }
    }

    boolean setFocus() {
        return OS.gtk_widget_child_focus(this.handle, 0);
    }

    void setFontDescription(long font) {
        if (this.labelHandle != 0L) {
            OS.gtk_widget_modify_font(this.labelHandle, font);
        }
    }

    void setForegroundColor(GdkColor color) {
        if (this.labelHandle != 0L) {
            this.setForegroundColor(this.labelHandle, color);
        }
    }

    public void setHotImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        this.hotImage = image;
        if (image != null) {
            int imageIndex;
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((imageIndex = imageList.indexOf(image)) == -1) {
                imageIndex = imageList.add(image);
            } else {
                imageList.put(imageIndex, image);
            }
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        if (image != null) {
            int imageIndex;
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((imageIndex = imageList.indexOf(image)) == -1) {
                imageIndex = imageList.add(image);
            } else {
                imageList.put(imageIndex, image);
            }
            long pixbuf = imageList.getPixbuf(imageIndex);
            OS.gtk_image_set_from_pixbuf(this.imageHandle, pixbuf);
        } else {
            OS.gtk_image_set_from_pixbuf(this.imageHandle, 0L);
        }
        if ((this.style & 4) != 0) {
            this.proxyMenuItem = 0L;
            this.proxyMenuItem = OS.gtk_tool_item_retrieve_proxy_menu_item(this.handle);
            OS.g_signal_connect(this.proxyMenuItem, OS.activate, ToolBar.menuItemSelectedFunc.getAddress(), this.handle);
        }
        this.parent.relayout();
    }

    void setOrientation(boolean create) {
        if ((this.parent.style & 0x4000000) != 0 || !create) {
            int dir;
            int n = dir = (this.parent.style & 0x4000000) != 0 ? 2 : 1;
            if (this.handle != 0L) {
                OS.gtk_widget_set_direction(this.handle, dir);
            }
        }
    }

    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 8L);
        OS.gtk_toggle_tool_button_set_active(this.handle, selected);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 8L);
    }

    boolean setTabItemFocus(boolean next) {
        return this.setFocus();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (string.equals(this.text)) {
            return;
        }
        super.setText(string);
        if (this.labelHandle == 0L) {
            return;
        }
        char[] chars = this.fixMnemonic(string);
        byte[] buffer = Converter.wcsToMbcs(null, chars, true);
        OS.gtk_label_set_text_with_mnemonic(this.labelHandle, buffer);
        if ((this.style & 4) != 0 && OS.GTK_VERSION < OS.VERSION(2, 6, 0)) {
            if (string.length() != 0) {
                OS.gtk_widget_show(this.labelHandle);
            } else {
                OS.gtk_widget_hide(this.labelHandle);
            }
        }
        if ((this.style & 4) != 0) {
            this.proxyMenuItem = 0L;
            this.proxyMenuItem = OS.gtk_tool_item_retrieve_proxy_menu_item(this.handle);
            OS.g_signal_connect(this.proxyMenuItem, OS.activate, ToolBar.menuItemSelectedFunc.getAddress(), this.handle);
        }
        this.parent.relayout();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        if (this.toolTipText == string || this.toolTipText != null && this.toolTipText.equals(string)) {
            return;
        }
        if (this.parent.toolTipText == null) {
            Shell shell = this.parent._getShell();
            this.setToolTipText(shell, string);
        }
        this.toolTipText = string;
        if ((this.style & 4) != 0) {
            this.proxyMenuItem = 0L;
            this.proxyMenuItem = OS.gtk_tool_item_retrieve_proxy_menu_item(this.handle);
            OS.g_signal_connect(this.proxyMenuItem, OS.activate, ToolBar.menuItemSelectedFunc.getAddress(), this.handle);
        }
    }

    void setToolTipText(Shell shell, String newString) {
        long child = OS.gtk_bin_get_child(this.handle);
        if ((this.style & 4) != 0) {
            if (OS.GTK_VERSION >= OS.VERSION(2, 6, 0)) {
                long list = OS.gtk_container_get_children(child);
                child = OS.g_list_nth_data(list, 0);
            }
            if (this.arrowHandle != 0L) {
                shell.setToolTipText(this.arrowHandle, newString);
            }
        }
        shell.setToolTipText(child != 0L ? child : this.handle, newString);
    }

    public void setWidth(int width) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            return;
        }
        if (width < 0) {
            return;
        }
        this.resizeHandle(width, (this.parent.style & 0x200) != 0 ? 6 : 15);
        this.parent.relayout();
    }

    void showWidget(int index) {
        if (this.handle != 0L) {
            OS.gtk_widget_show(this.handle);
        }
        if (this.labelHandle != 0L) {
            OS.gtk_widget_show(this.labelHandle);
        }
        if (this.imageHandle != 0L) {
            OS.gtk_widget_show(this.imageHandle);
        }
        if ((this.style & 4) != 0 && OS.GTK_VERSION < OS.VERSION(2, 6, 0)) {
            if (this.arrowBoxHandle != 0L) {
                OS.gtk_widget_show(this.arrowBoxHandle);
            }
            if (this.arrowHandle != 0L) {
                OS.gtk_widget_show(this.arrowHandle);
            }
        }
        OS.gtk_toolbar_insert(this.parent.handle, this.handle, index);
    }
}

