/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ide.launch;

import com.nvidia.viper.FileUtils;
import com.nvidia.viper.IViperWorkbench;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.actions.ColorByKernelAction;
import com.nvidia.viper.actions.ColorByStreamAction;
import com.nvidia.viper.actions.PopupRetargetAction;
import com.nvidia.viper.actions.RunAnalysisAction;
import com.nvidia.viper.actions.RunProfileAction;
import com.nvidia.viper.actions.RunTimelineAction;
import com.nvidia.viper.actions.ScaleFitAction;
import com.nvidia.viper.actions.ScaleInAction;
import com.nvidia.viper.actions.ScaleOutAction;
import com.nvidia.viper.ide.Activator;
import com.nvidia.viper.ide.SessionPropertyPage;
import com.nvidia.viper.ide.ViperIDEUtil;
import com.nvidia.viper.ide.launch.LaunchConfigurationAdapter;
import com.nvidia.viper.ide.launch.LaunchConfigurationEditorInput;
import com.nvidia.viper.ide.launch.ViperLaunchConfigurationsTracker;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.Executable;
import com.nvidia.viper.model.Expert;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.ui.SessionEditor;
import com.nvidia.viper.ui.SessionEditorInput;
import com.nvidia.viper.ui.ViperMessageDialog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.EditorManager;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public final class ViperIDEWorkbench
implements IViperWorkbench {
    private final Map<Executable, Object> resolved = Collections.synchronizedMap(new WeakHashMap());
    private final ConcurrentMap<Executable, Object> resolving = new ConcurrentHashMap<Executable, Object>();
    private final ViperLaunchConfigurationsTracker tracker = new ViperLaunchConfigurationsTracker();

    public void closeEditorInput(IEditorInput editorInput) {
        if (editorInput instanceof SessionEditorInput) {
            ((SessionEditorInput)editorInput).closeSession();
        } else if (editorInput instanceof LaunchConfigurationEditorInput) {
            ((LaunchConfigurationEditorInput)editorInput).setSession(null);
        }
    }

    public Composite configureEditorSite(Composite parent, IEditorPart part) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        ToolBar bar = new ToolBar(composite, 0x800000);
        bar.setLayoutData((Object)new GridData(768));
        new Label(composite, 258).setLayoutData((Object)new GridData(768));
        Composite editorParent = new Composite(composite, 0);
        editorParent.setLayout((Layout)new FillLayout());
        editorParent.setLayoutData((Object)new GridData(1808));
        this.fillActions(bar, part);
        return editorParent;
    }

    public IPropertySheetPage createPropertySheetPage(SessionEditor sessionEditor) {
        return new SessionPropertyPage(sessionEditor);
    }

    private void fillActions(ToolBar bar, IEditorPart part) {
        if (!(part instanceof SessionEditor)) {
            return;
        }
        SessionEditor sessionEditor = (SessionEditor)part;
        Session session = sessionEditor.getSession();
        Expert expert = session.getExpert();
        ToolBarManager tbm = new ToolBarManager(bar);
        tbm.add((IAction)new RunAnalysisAction(sessionEditor.getSession(), false, RunAnalysisAction.ShowMode.CURRENT));
        tbm.add((IAction)new RunTimelineAction(sessionEditor.getSession()));
        tbm.add((IAction)new PopupRetargetAction(new IAction[]{new RunProfileAction(session, expert, true, false), new RunProfileAction(session, expert, true, true)}));
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)new ScaleInAction(sessionEditor));
        tbm.add((IAction)new ScaleOutAction(sessionEditor));
        tbm.add((IAction)new ScaleFitAction(sessionEditor));
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)new ColorByKernelAction(sessionEditor));
        tbm.add((IAction)new ColorByStreamAction(sessionEditor));
        tbm.update(true);
    }

    public String getConsoleViewID() {
        return "org.eclipse.ui.console.ConsoleView";
    }

    public String getPropertiesViewId() {
        return "org.eclipse.ui.views.PropertySheet";
    }

    public String getRunMenuId() {
        return "org.eclipse.ui.run";
    }

    public Session getSession(IEditorInput input) throws PartInitException {
        try {
            Session result = ViperIDEUtil.getSessionFromEditorInput(input);
            if (result != null) {
                Executable executable = result.getExecutable();
                if (executable != null) {
                    this.tracker.startTracking(executable.getLaunchConfigurationName());
                }
                return result;
            }
            throw new PartInitException(String.format("Editor input type %s is not supported", input.getClass()));
        }
        catch (CoreException e) {
            throw new PartInitException("Failed to open session document", (Throwable)e);
        }
    }

    private CSourceLookupDirector getSourcePathComputer(Session session) throws CoreException {
        String name;
        LaunchConfigurationAdapter configuration;
        Executable executable = session.getExecutable();
        if (executable != null && (configuration = LaunchConfigurationAdapter.getLaunchConfigurationAdapter(name = executable.getLaunchConfigurationName(), ViperIDEUtil.isRemote(session))) != null) {
            return configuration.getSourceLocator();
        }
        return null;
    }

    public void informUnableToLoadLibraries(Exception e) {
        ViperExceptionHandler.handle((String)ViperMessages.LibVp_Fail_Title, (String)ViperMessages.LibVp_Fail_Message, (Exception)e);
    }

    public boolean needProfilingDataDelete(Session session) {
        String lcName;
        Analysis analysis;
        Executable executable = session.getExecutable();
        if (executable != null && (analysis = session.getAnalysis()) != null && !analysis.getVisitedStages().isEmpty() && (lcName = executable.getLaunchConfigurationName()) != null && this.tracker.isDirty(lcName)) {
            this.tracker.markClean(lcName);
            return ViperMessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Launch Settings", (String)"Application launch settings have changed. Some changes, like command-line options, may make current profiling data and analysis inaccurate. Do you want to delete all existing profile and analysis data before continuing?");
        }
        return false;
    }

    public boolean readyToRun(Session session) {
        IWorkbench workbench;
        String lcName = session.getExecutable().getLaunchConfigurationName();
        final LaunchConfigurationAdapter adapter = LaunchConfigurationAdapter.getLaunchConfigurationAdapter(lcName, ViperIDEUtil.isRemote(session));
        if (adapter != null && !adapter.readyToRun()) {
            return false;
        }
        if (session.getTimelines().isEmpty()) {
            this.tracker.markClean(lcName);
        }
        if ((workbench = PlatformUI.getWorkbench()) == null || workbench.getActiveWorkbenchWindow() == null) {
            return false;
        }
        if (!this.saveNonProfilerEditors(workbench)) {
            return false;
        }
        if (adapter == null) {
            return true;
        }
        try {
            final boolean[] res = new boolean[]{true};
            workbench.getActiveWorkbenchWindow().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        res[0] = adapter.prepareForLaunch();
                    }
                    catch (CoreException e) {
                        Activator.log(e);
                        res[0] = false;
                    }
                }
            });
            return res[0];
        }
        catch (InvocationTargetException e) {
            Activator.log(e);
        }
        catch (InterruptedException e) {
            Activator.log(e);
        }
        return false;
    }

    public boolean requiresPathMappingWizard() {
        return false;
    }

    public Executable resolveExecutableSettings(Executable executable) {
        if (!this.resolved.containsKey(executable)) {
            Executable fromlc = this.readFromLaunchConfiguration(executable);
            if (fromlc != null) {
                return fromlc;
            }
            if (this.resolving.putIfAbsent(executable, 1) == null) {
                try {
                    ILaunchConfiguration lc = ViperIDEUtil.createLaunchConfiguration(executable);
                    if (lc != null) {
                        this.tracker.markClean(lc.getName());
                    }
                }
                finally {
                    this.resolving.remove(executable);
                }
            }
            return null;
        }
        return null;
    }

    private Executable readFromLaunchConfiguration(Executable executable) {
        boolean remote;
        Executable exe = null;
        String lcName = executable.getLaunchConfigurationName();
        LaunchConfigurationAdapter configuration = LaunchConfigurationAdapter.getLaunchConfigurationAdapter(lcName, remote = executable.getConnectionName() != null);
        if (configuration != null) {
            try {
                Executable resolvedExe = configuration.createExecutable();
                if (resolvedExe != null) {
                    this.resolved.put(resolvedExe, 1);
                }
                exe = resolvedExe;
            }
            catch (CoreException e) {
                Activator.log(e);
                return null;
            }
        } else {
            this.resolved.put(executable, null);
        }
        return exe;
    }

    private void resolveLocations(Map<Object, URI> locations, CSourceLookupDirector director) {
        HashMap<URI, URI> resolved = new HashMap<URI, URI>();
        for (Map.Entry<Object, URI> entry : locations.entrySet()) {
            URI uri = entry.getValue();
            if (!resolved.containsKey(uri)) {
                URI file;
                Object element = director.getSourceElement((Object)uri.getPath());
                if (element instanceof IFile) {
                    file = ((IFile)element).getLocationURI();
                } else if (element instanceof LocalFileStorage) {
                    file = ((LocalFileStorage)element).getFile().toURI();
                } else if (element instanceof ITranslationUnit) {
                    file = ((ITranslationUnit)element).getLocationURI();
                } else if (element != null) {
                    file = null;
                    Activator.log(1, "%s resolved to %s of type %s", uri, element, element.getClass());
                } else {
                    file = null;
                }
                resolved.put(uri, file);
            }
            entry.setValue((URI)resolved.get(uri));
        }
    }

    public void resolvePathsInSession(Session session, Map<Object, URI> locations) {
        try {
            CSourceLookupDirector director = this.getSourcePathComputer(session);
            if (director != null) {
                this.resolveLocations(locations, director);
            }
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }

    public void save(Shell shell, Session session, IEditorInput input) throws ViperException {
        Object file = session.getFile();
        if (input instanceof IFileEditorInput) {
            this.saveSession((IFile)file, session);
        } else if (file instanceof File) {
            FileUtils.saveSession((File)((File)file), (Session)session);
        } else if (file instanceof URI && "file".equals(((URI)file).getScheme())) {
            FileUtils.saveSession((File)new File((URI)file), (Session)session);
        } else {
            this.saveAs(shell, session, input);
        }
    }

    public IEditorInput saveAs(Shell shell, Session session, IEditorInput input) throws ViperException {
        FileEditorInput res = null;
        Object file = session.getFile();
        if (file instanceof URI) {
            FileDialog dialog = new FileDialog(shell, 8192);
            dialog.setFileName(((IFileStore)file).getName());
            dialog.setFilterExtensions(new String[]{"*.nvvp", "*"});
            dialog.setFilterNames(new String[]{"Visual Profiler session files (*.nvvp)", "All files (*)"});
            dialog.setFilterIndex(0);
            URI uri = (URI)file;
            if ("file".equals(uri.getScheme())) {
                File f = new File(uri);
                dialog.setFilterPath(f.getParentFile().getAbsolutePath());
            }
            dialog.setOverwrite(true);
            String path = dialog.open();
            if (path != null) {
                IFileStore store;
                File f = new File(path);
                FileUtils.saveSession((File)f, (Session)session);
                session.setName(f.getName());
                try {
                    store = EFS.getStore((URI)f.toURI());
                }
                catch (CoreException e) {
                    throw new ViperException((Throwable)e);
                }
                res = new FileStoreEditorInput(store);
            }
        } else {
            IFile f;
            SaveAsDialog dialog = new SaveAsDialog(shell);
            if (file instanceof IFile) {
                dialog.setOriginalFile((IFile)file);
            } else {
                dialog.setOriginalName(String.valueOf(session.getName()) + "." + "nvvp");
            }
            if (dialog.open() == 0 && dialog.getResult() != null && this.saveSession(f = ResourcesPlugin.getWorkspace().getRoot().getFile(dialog.getResult()), session)) {
                session.setName(f.getName());
                res = new FileEditorInput(f);
            }
        }
        if (res != null && res != input) {
            this.closeEditorInput(input);
        }
        return res;
    }

    private boolean saveNonProfilerEditors(IWorkbench workbench) {
        IWorkbenchWindow[] windows;
        boolean res = true;
        LinkedList<IEditorPart> editors = new LinkedList<IEditorPart>();
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage[] pages;
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
            int n3 = pages.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                editors.addAll(Arrays.asList(page.getDirtyEditors()));
                ++n4;
            }
            ++n2;
        }
        Iterator i = editors.iterator();
        while (i.hasNext()) {
            IEditorPart part = (IEditorPart)i.next();
            if (!(part instanceof SessionEditor)) continue;
            i.remove();
        }
        if (!EditorManager.saveAll(editors, (boolean)true, (boolean)false, (boolean)true, (IRunnableContext)workbench.getActiveWorkbenchWindow(), (IShellProvider)workbench.getActiveWorkbenchWindow())) {
            res = false;
        }
        return res;
    }

    private boolean saveSession(IFile file, Session session) throws ViperException {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            FileUtils.saveSession((OutputStream)buffer, (Session)session);
            buffer.close();
            ByteArrayInputStream is = new ByteArrayInputStream(buffer.toByteArray());
            if (file.exists()) {
                file.setContents((InputStream)is, 2, (IProgressMonitor)new NullProgressMonitor());
            } else {
                file.create((InputStream)is, false, (IProgressMonitor)new NullProgressMonitor());
            }
            session.setFile((Object)file);
            return true;
        }
        catch (IOException e) {
            throw new ViperException((Throwable)e);
        }
        catch (CoreException e) {
            throw new ViperException((Throwable)e);
        }
    }

    public void start() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener((ILaunchConfigurationListener)this.tracker);
    }

    public void stop() {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchConfigurationListener((ILaunchConfigurationListener)this.tracker);
    }

    public void updatePathsInSession(Session session, Collection<URI> locations, boolean forceMulti) {
    }

    public boolean useGlobalToolbar() {
        return false;
    }
}

