/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataModelAdapterUtil {
    public static boolean isAggregationBinding(ComputedColumnHandle computedColumnHandle, ReportItemHandle itemHandle) {
        if (computedColumnHandle.getAggregateFunction() != null) {
            return true;
        }
        try {
            String expression;
            Iterator iter = itemHandle.getAvailableBindings();
            HashSet result = new HashSet();
            HashMap<String, String> bindingExpressionMap = new HashMap<String, String>();
            DataModelAdapterUtil.populateDirectAggregationBindingNames(result, iter, bindingExpressionMap);
            DataSetHandle dataSetHandle = itemHandle.getDataSet();
            if (dataSetHandle != null && dataSetHandle.computedColumnsIterator() != null && dataSetHandle.computedColumnsIterator().hasNext()) {
                iter = dataSetHandle.computedColumnsIterator();
                DataModelAdapterUtil.populateDirectAggregationBindingNames(result, iter, bindingExpressionMap);
            }
            if ((expression = (String)bindingExpressionMap.get(computedColumnHandle.getName())) != null) {
                return DataModelAdapterUtil.indirectRefAggregation(expression, result, bindingExpressionMap);
            }
        }
        catch (BirtException birtException) {}
        return false;
    }

    private static boolean indirectRefAggregation(String expression, Set directNames, Map<String, String> expressionMap) {
        HashSet<String> names = DataModelAdapterUtil.getBindingRefNames(expression);
        for (String name : names) {
            if (!directNames.contains(name)) continue;
            return true;
        }
        names = DataModelAdapterUtil.getBindingRefColumnNames(expression);
        Iterator<String> iterator = names.iterator();
        if (iterator.hasNext()) {
            String name;
            name = iterator.next();
            if (directNames.contains(name)) {
                return true;
            }
            String expressionName = expressionMap.get(name);
            if (expressionName == null) {
                return false;
            }
            return DataModelAdapterUtil.indirectRefAggregation(expressionName, directNames, expressionMap);
        }
        return false;
    }

    private static HashSet<String> getBindingRefColumnNames(String expression) {
        HashSet<String> result = new HashSet<String>();
        try {
            List columnList = ExpressionUtil.extractColumnExpressions((String)expression, (String)"row");
            int i = 0;
            while (i < columnList.size()) {
                if (columnList.get(i) instanceof IColumnBinding) {
                    result.add(((IColumnBinding)columnList.get(i)).getResultSetColumnName());
                }
                ++i;
            }
        }
        catch (BirtException birtException) {}
        return result;
    }

    private static HashSet<String> getBindingRefNames(String expression) {
        HashSet<String> result = new HashSet<String>();
        try {
            List columnList = ExpressionUtil.extractColumnExpressions((String)expression, (String)"dataSetRow");
            int i = 0;
            while (i < columnList.size()) {
                if (columnList.get(i) instanceof IColumnBinding) {
                    result.add(((IColumnBinding)columnList.get(i)).getResultSetColumnName());
                }
                ++i;
            }
        }
        catch (BirtException birtException) {}
        return result;
    }

    private static void populateDirectAggregationBindingNames(Set aggregationBinding, Iterator iter, Map<String, String> bindingExpressionMap) throws BirtException {
        while (iter.hasNext()) {
            ComputedColumnHandle computedHandle = (ComputedColumnHandle)iter.next();
            ComputedColumn column = (ComputedColumn)computedHandle.getStructure();
            String expressionString = column.getExpression();
            bindingExpressionMap.put(computedHandle.getName(), expressionString);
            if (computedHandle.getAggregateFunction() == null) continue;
            String columnName = null;
            columnName = ExpressionUtil.getColumnName((String)expressionString);
            if (columnName == null) {
                columnName = ExpressionUtil.getColumnBindingName((String)expressionString);
                if (columnName == null) continue;
                aggregationBinding.add(computedHandle.getName());
                continue;
            }
            aggregationBinding.add(computedHandle.getName());
        }
    }
}

