#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :Input: mrc\n");
    fprintf(stderr, "    [-r[ef]              Ref                 (NULL      )] :Essential :Input: ref\n");
    fprintf(stderr, "    [-dtheta             dtheta              (1.0       )] :Optional  :Input: degree\n");
    fprintf(stderr, "    [-o[utput]           Out                 (stdout    )] :Optional  :Output: OptimalParameter\n");
    fprintf(stderr, "    [-O[utput]           Out2                (NULL      )] :Optional  :Output: ParameterImage\n");
    fprintf(stderr, "    [-M[ode]             searchMode          (1         )] :Optional  :SearchMode\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
