#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-I[nput]1           In1                 (NULL      )] :Optional  :InputDataFileList1 : normal correlation\n");
    fprintf(stderr, "    [-I[nput]2           In2                 (NULL      )] :Optional  :InputDataFileList2 : derivation1D correlation\n");
    fprintf(stderr, "    [-I[nput]3           In3                 (NULL      )] :Optional  :InputDataFileList3 : derivation2D correlation\n");
    fprintf(stderr, "    [-I[nput]4           In4                 (NULL      )] :Optional  :InputDataFileList4 : length correlation\n");
    fprintf(stderr, "    [-o[utput]           Out                 (NULL      )] :Essential :OutputDataFile\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    fprintf(stderr, "    [-M[ode]             Mode                (15        )] :Optional  :Mode : choice of used Correlation\n");
    fprintf(stderr, "    [-v[ariance]         variance            (5         )] :Optional  :variance of Gaussian weight function\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
