#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :InputList\n");
    fprintf(stderr, "    [-A[verage]          Avg                 (NULL      )] :Optional  :Output: Average\n");
    fprintf(stderr, "    [-SN                 SN                  (NULL      )] :Optional  :Output: SN:=Average/SD\n");
    fprintf(stderr, "    [-t                  t                   (NULL      )] :Optional  :Output: t=:Average/SD/sqrt(n-2)\n");
    fprintf(stderr, "    [-SE                 SE                  (NULL      )] :Optional  :Output: Standard Error\n");
    fprintf(stderr, "    [-SD                 SD                  (NULL      )] :Optional  :Output: Standard Deviation\n");
    fprintf(stderr, "    [-Var                Var                 (NULL      )] :Optional  :Output: Variance\n");
    fprintf(stderr, "    [-c[onfigFile]       configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
