#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :InputDataFile\n");
    fprintf(stderr, "    [-o[utput]           Out                 (stdout    )] :Optional  :Output: ASCII\n");
    fprintf(stderr, "    [-O[utputMRC]        Out2                (NULL      )] :Optional  :Output: MRC\n");
    fprintf(stderr, "    [-centre             Cx                  (0.0       )Cy                  (0.0       )] :Optional  :[pixel]\n");
    fprintf(stderr, "    [-Avg                ] :Optional  :flagAvg: Averaged Intensity\n");
    fprintf(stderr, "    [-Inv                ] :Optional  :flagInv: Inversed Intensity\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
