#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :InputImageFile\n");
    fprintf(stderr, "    [-o[utput]           Out                 (stdout    )] :Optional  :OutputImageFile\n");
    fprintf(stderr, "    [-H[ighThreshold]    thresHigh           (0.0       )] :Optional  :High Threshold\n");
    fprintf(stderr, "    [-L[owThreshold]     thresLow            (1.0       )] :Optional  :Low Threshold\n");
    fprintf(stderr, "    [-Section            section             (z         )] :Optional  :[z|x|y]Section: Def: z-section\n");
    fprintf(stderr, "    [-x[Section]         xMin                (0         )xMax                (0         )] :Optional  :x section\n");
    fprintf(stderr, "    [-y[Section]         yMin                (0         )yMax                (0         )] :Optional  :y section\n");
    fprintf(stderr, "    [-z[Section]         zMin                (0         )zMax                (0         )] :Optional  :z section\n");
    fprintf(stderr, "    [-S[cale]            Scale               (1.0       )] :Optional  :Scale(Centre is Bottom Left): -S 1 := 1 mm/pixel\n");
    fprintf(stderr, "    [-A[bsolute]S[cale]  AbScale             (1.0       )] :Optional  :Scale(Centre is Bottom Left): -AS 1 := 1 mm/A (Real) or 1 mm/A-1 (Fourier Space)\n");
    fprintf(stderr, "    [-E[nlarge]          Enlarge             (1.0       )] :Optional  :Enlargement(image center is center)\n");
    fprintf(stderr, "    [-center             cx                  (0.0/* in case of FT or N.x/2.0 in case of Image*/)cy                  (0.0/* in case of FT or N.y/2.0 in case of Image */)] :Optional  :Center of a printed image\n");
    fprintf(stderr, "    [-C[ontour]          contourLevel        (1.0       )... ] :Variable  :ContourLevel\n");
    fprintf(stderr, "    [-I[nverse]          ] :Optional  :Black is High Density.\n");
    fprintf(stderr, "    [-A[uto]             ] :Optional  :HighThres=Mean-SD, LowThres=Mean+SD\n");
    fprintf(stderr, "    [-AC[ontour]         AutoContour         (10        )] :Optional  :Auto Contour(thresHigh <-> mean)\n");
    fprintf(stderr, "    [-PC[ontour]         PeakContour         (10        )] :Optional  :Peak Contour(thresHigh <-> (mean+thresHigh)/2\n");
    fprintf(stderr, "    [-AC[ontour]2        AutoContour2        (10        )] :Optional  :Auto Contour2(thresHigh <-> thresLow)\n");
    fprintf(stderr, "    [-Y[expand]          Yexpand             (1         )] :Optional  :Y-axis expanding\n");
    fprintf(stderr, "    [-RGB                Red                 (0         )Green               (0         )Blue                (0         )] :Optional  :Contour Color Mode: RGB\n");
    fprintf(stderr, "    [-RGBGradient        RedFirst            (0         )GreenFirst          (0         )BlueFirst           (0         )RedLast             (0         )GreenLast           (0         )BlueLast            (0         )] :Optional  :Contour Color GradientMode: RGB\n");
    fprintf(stderr, "    [-HSB                Hue                 (0         )Saturation          (0         )Brightness          (0         )] :Optional  :Contour Color Mode: HSB\n");
    fprintf(stderr, "    [-HSBGradient        HueFirst            (0         )SaturationFirst     (0         )BrightnessFirst     (0         )HueLast             (0         )SaturationLast      (0         )BrightnessLast      (0         )] :Optional  :Contour Color GradientMode: HSB\n");
    fprintf(stderr, "    [-LineColourRGB      LineRed             (0         )LineGreen           (0         )LineBlue            (0         )] :Optional  :Contour Color Mode: RGB\n");
    fprintf(stderr, "    [-LineColourRGBGradientLineRedFirst        (0         )LineGreenFirst      (0         )LineBlueFirst       (0         )LineRedLast         (0         )LineGreenLast       (0         )LineBlueLast        (0         )] :Optional  :Contour Color GradientMode: RGB\n");
    fprintf(stderr, "    [-LineColourHSB      LineHue             (0         )LineSaturation      (0         )LineBrightness      (0         )] :Optional  :Contour Color Mode: HSB\n");
    fprintf(stderr, "    [-LineColourHSBGradientLineHueFirst        (0         )LineSaturationFirst (0         )LineBrightnessFirst (0         )LineHueLast         (0         )LineSaturationLast  (0         )LineBrightnessLast  (0         )] :Optional  :Contour Color GradientMode: HSB\n");
    fprintf(stderr, "    [-LineChange         LineColorChange     (0.1       )] :Optional  :Contour Color Change\n");
    fprintf(stderr, "    [-LineWidthStart     LineWidthStart      (0.1       )] :Optional  :Contour Line Width Step\n");
    fprintf(stderr, "    [-LineWidthStep      LineWidthStep       (0.05      )] :Optional  :Contour Line Width Step\n");
    fprintf(stderr, "    [-ReverseOrder       ] :Optional  :Reverse Print Order\n");
    fprintf(stderr, "    [-Untwist            untwist             (0.0       )] :Optional  :Untwist Angle [degree/A], example: (-13,28) = 0.4709576\n");
    fprintf(stderr, "    [-UpsideDown         ] :Optional  :Upside Down\n");
    fprintf(stderr, "    [-Centre             ] :Optional  :Image Centre is at the centre of paper.\n");
    fprintf(stderr, "    [-CircleRadius       CircleRadius        (0.5       )] :Optional  :Radius of circles in the case of imageCircles\n");
    fprintf(stderr, "    [-m[ode]             mode                (49        )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
