#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (stdin     )] :Essential :Input: filename ...\n");
    fprintf(stderr, "    [-info2              CTF                 (stdin     )] :Optional  :InputFileList: the same order as the input: ctfinfo from Display2/ctfDisplay\n");
    fprintf(stderr, "    [-o[utput]           Out                 (stdout    )] :Essential :OutputDataFile(average file)\n");
    fprintf(stderr, "    [-f[ft]              fftOut              (stdout    )] :Optional  :OutputDataFile(averaged fft file)\n");
    fprintf(stderr, "    [-W[hiteNoise]       WhiteNoise          (1.0       )] :Optional  :\n");
    fprintf(stderr, "    [-W[hiteNoise]R[aising]WhiteNoiseRaising   (1.0       )] :Optional  :Weight:W*exp(WR*R)\n");
    fprintf(stderr, "    [-SinWin             SinWinRmin          (0.1       )SinWinRmax          (1.0       )] :Optional  :Windowing by sine function from Rmin[/A] to Rmax[/A]\n");
    fprintf(stderr, "    [-MaxIter[ation]     MaxIter             (10        )] :Optional  :Max Iteration\n");
    fprintf(stderr, "    [-ctfMode            CTFMode             (1         )] :Optional  :CTFMode: refer to mrcImageCTFObservation\n");
    fprintf(stderr, "    [-solventMode        solventMode         (0         )] :Optional  :If solvent flatterning is used, NEED\n");
    fprintf(stderr, "    [-solventSTD         solventSTD          (-1.0      )] :Optional  :If solvent flatterning is used as mode=1, NEED \n");
    fprintf(stderr, "    [-log[file]          Log                 (stderr    )] :Optional  :Log File Name\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
