#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :InputDataFile\n");
    fprintf(stderr, "    [-o[utput]           Out                 (NULL      )] :Optional  :OutputDataFile: Correlation Map\n");
    fprintf(stderr, "    [-O[utput]           Out2                (NULL      )] :Optional  :OutputDataFile: Correlation Map for Refinement\n");
    fprintf(stderr, "    [-r[eference]        Ref                 (NULL      )] :Essential :ReferenceDataFile\n");
    fprintf(stderr, "    [-cor[relation]Info  OutCor              (stdout    )] :Optional  :Output: Correlation Info\n");
    fprintf(stderr, "    [-a[verage]          Avg                 (NULL      )] :Optional  :OutputDataFile: Averaged File\n");
    fprintf(stderr, "    [-s[hit]             Shift               (NULL      )] :Optional  :OutputDataFile: Shifted InputFile\n");
    fprintf(stderr, "    [-refine             RefineStep          (0.25      )RefineRange         (3.0       )RefineMode          (2         )] :Optional  :Refinemnet: Step Range[pixelUnit]\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    fprintf(stderr, "    [-M[ode2]            mode2               (0         )] :Optional  :Mode2\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
