#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-I[nput array of file]In                  (NULL      )] :Essential :InputDataFiles\n");
    fprintf(stderr, "    [-o[utput]           Out                 (stdout    )] :Optional  :OutputDataFile\n");
    fprintf(stderr, "    [-O[utput]           ] :Optional  :Output: averaged images: filename is xxxx.avg: xxxx is input filename.\n");
    fprintf(stderr, "    [-N[umberOfClusters] N                   (1         )] :Optional  :Number of clusters\n");
    fprintf(stderr, "    [-Min[imumCorrelation]Min                 (0.0       )] :Optional  :Minimum: Correlation: Conditions for ending\n");
    fprintf(stderr, "    [-Iter[ation]        ] :Optional  :IterationFlag\n");
    fprintf(stderr, "    [-A[uto]R[otation]   AutoRotation        (72        )] :Optional  :AutoRotation: rotation divided by this value\n");
    fprintf(stderr, "    [-A[utoRot]Range     ARMin               (0         )ARMax               (360       )] :Optional  :AutoRotationRange\n");
    fprintf(stderr, "    [-A[uto]R[otation]iter[ation]AutoRotationIteration(2         )] :Optional  :AutoRotationIteration\n");
    fprintf(stderr, "    [-A[uto]R[otation]MethodAutoRotationMethod  (0         )] :Optional  :Method for Correlation for Auto Rotation\n");
    fprintf(stderr, "    [-M[odeForCorrelation]correlationMode     (19        )] :Optional  :Correlation Mode for AutoRotation\n");
    fprintf(stderr, "    [-pvm                ] :Optional  :Parallel Analysis by PVM\n");
    fprintf(stderr, "    [-pvmList            pvmList             (NULL      )] :Optional  :pvmList: Input\n");
    fprintf(stderr, "    [-Log                Log                 (stdout    )] :Optional  :Log: Output\n");
    fprintf(stderr, "    [-Log2               Log2                (NULL      )] :Optional  :Log2: Output: ClusterNode Only\n");
    fprintf(stderr, "    [-LogIn              LogIn               (NULL      )] :Optional  :previousLog: Input\n");
    fprintf(stderr, "    [-prevF[ileNum]      prevFileNum         (0         )] :Optional  :previousLogFileNum: Input\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (2         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
