#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#define GLOBAL_DECLARATION       
#include "../inc/config.h"
#include "genUtil.h"
#include "mrcImage.h"
#include "Vector.h"
#include "lmrcFFTInfo.h"

int
main(int argc, char* argv[])
{
    mrcImage fft;
	mrcFFTInfoInfo info;
	FILE* fpt;
	floatVector* ScatteringAngularDistribution;
	floatVector* ScatteringAngularDistributionAverage;
	floatVector* ScatteringAngularDistributionSD;
	floatVector* XAxisMag;
	floatVector* XAxisPhase;
	floatVector* YAxisMag;
	floatVector* YAxisMagAvg;
	floatVector* YAxisPhase;
	floatVector* Spacing;
	long i;

    init0(&info);
    argCheck(&info, argc, argv);
    init1(&info);
    mrcFileRead (&fft, info.In,  "from Main Routine", 0);
	fpt = info.fptOut;

    if(0x00000010&info.mode) {
        Spacing = lmrcFSInfoSpacing(&fft);
    }

	switch(0x0000000F&info.mode) {
		case 1: {
        	ScatteringAngularDistribution = lmrcFSInfoScatteringAngularDistribution(&fft);
			break;
		}
		case 2: {
        	XAxisMag = lmrcFSInfoXAxisMag(&fft);
			XAxisPhase = lmrcFSInfoXAxisPhase(&fft);
			break;
		}
		case 4: {
        	YAxisMag = lmrcFSInfoYAxisMag(&fft);
        	YAxisPhase = lmrcFSInfoYAxisPhase(&fft);
			break;
		}
		case 5: {
        	YAxisMagAvg = lmrcFSInfoYAxisMagAverage(&fft);
			break;
		}
		case 8: {
        	ScatteringAngularDistributionAverage = lmrcFSInfoScatteringAngularDistributionAverage(&fft);
			break;
		}
		default: {
			fprintf(stderr, "Not supported mode: %d", info.mode);
			exit(EXIT_FAILURE);
		}
    }

    if(0x00000020&info.mode) {
        ScatteringAngularDistributionSD = lmrcFSInfoScatteringAngularDistributionSD(&fft);
    }

	switch(0xf&info.mode) { 
		case 1: {
        	fprintf(fpt, "%ld\n", ScatteringAngularDistribution->size);
        	for(i=0; i<ScatteringAngularDistribution->size; i++) {
           		fprintf(fpt, "%15.6e\n", ScatteringAngularDistribution->data[i]);
        	}
			break;
		}
		case 2: {
        	fprintf(fpt, "%ld\n", XAxisMag->size);
        	for(i=0; i<XAxisMag->size; i++) {
           		fprintf(fpt, "%15.6e %15.6e\n", XAxisMag->data[i], XAxisPhase->data[i]*DEGREE);
        	}
			break;
    	}
		case 4: {
	        fprintf(fpt, "%ld\n", YAxisMag->size);
	        for(i=0; i<YAxisMag->size; i++) {
	            fprintf(fpt, "%15.6e %15.6e\n",YAxisMag->data[i], YAxisPhase->data[i]*DEGREE);
	        }
			break;
    	}
		case 5: {
	        fprintf(fpt, "%ld\n", YAxisMag->size);
	        for(i=0; i<YAxisMagAvg->size; i++) {
	            fprintf(fpt, "%15.6e %15.6e\n",YAxisMagAvg->data[i]);
	        }
			break;
    	}
		case 8: {		
			switch(0x000000F0&info.mode) {
				case 0 : {
	        		fprintf(fpt, "%ld\n", ScatteringAngularDistributionAverage->size);
	        		for(i=0; i<ScatteringAngularDistributionAverage->size; i++) {
	           			fprintf(fpt, "%15.6e\n",ScatteringAngularDistributionAverage->data[i]);
					}
					break;
				}
				case 0x10: {
					fprintf(fpt, "%ld %ld\n", 2, ScatteringAngularDistributionAverage->size);
	   		     	for(i=0; i<ScatteringAngularDistributionAverage->size; i++) {
	   	        		fprintf(fpt, "%15.6e %15.6e\n",
								Spacing->data[i],
								ScatteringAngularDistributionAverage->data[i]);
					}
					break;
				}
				case 0x20: {
					fprintf(fpt, "%ld %ld\n", 2, ScatteringAngularDistributionAverage->size);
	   		     	for(i=0; i<ScatteringAngularDistributionAverage->size; i++) {
	   	        		fprintf(fpt, "%15.6e %15.6e\n",
								ScatteringAngularDistributionAverage->data[i],
								ScatteringAngularDistributionSD->data[i]);
					}
					break;
				}
				case 0x30: {
					fprintf(fpt, "%ld %ld\n", 3, ScatteringAngularDistributionAverage->size);
	   		     	for(i=0; i<ScatteringAngularDistributionAverage->size; i++) {
	   	        		fprintf(fpt, "%15.6e %15.6e %15.6e\n",
								Spacing->data[i],
								ScatteringAngularDistributionAverage->data[i],
								ScatteringAngularDistributionSD->data[i]);
					}
					break;
				}
			}
		}
    }
	exit(EXIT_SUCCESS);
}

void
additionalUsage()
{
	fprintf(stderr, "Mode: \n");
	fprintf(stderr, "\t 1 :Scattering Angular Distribution(Sum)\n");
	fprintf(stderr, "\t 2 :X-axis (OutPut: Mag, Phase)\n");
	fprintf(stderr, "\t 4 :Y-axis (OutPut: Mag, Phase)\n");
	fprintf(stderr, "\t 5 :Y-axis (Average:Along X-axis)(OutPut: Mag, Phase)\n");
	fprintf(stderr, "\t 8 :Scattering Angular Distribution(Average)\n");
	fprintf(stderr, "\t16 :with spacing \n");
	fprintf(stderr, "\t32 :with Angular Distribution(SD)\n");
}
