#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :InputDataFile\n");
    fprintf(stderr, "    [-o[utput]           Out                 (NULL      )] :Essential :Output: Filtered Image\n");
    fprintf(stderr, "    [-IQ                 IQ                  (NULL      )] :Optional  :Output: IQ Map\n");
    fprintf(stderr, "    [-vx                 vx                  (0         )] :Optional  :Vector(x)\n");
    fprintf(stderr, "    [-vy                 vy                  (0         )] :Optional  :Vector(y)\n");
    fprintf(stderr, "    [-v1                 v1x                 (0         )v1y                 (0         )] :Optional  :Vector(v1)\n");
    fprintf(stderr, "    [-v2                 v2x                 (0         )v2y                 (0         )] :Optional  :Vector(v2)\n");
    fprintf(stderr, "    [-sx                 sx                  (1         )] :Optional  :Size(x)\n");
    fprintf(stderr, "    [-sy                 sy                  (1         )] :Optional  :Size(y)\n");
    fprintf(stderr, "    [-neg[lect]F00       ] :Optional  :Neglect F00\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
