! -*- mode: f90; -*-
!
! Copyright 2005-2007 Intel Corporation.  All Rights Reserved.
!
! The source code contained or described herein and all documents related
! to the source code ("Material") are owned by Intel Corporation or its
! suppliers or licensors.  Title to the Material remains with Intel
! Corporation or its suppliers and licensors.  The Material is protected
! by worldwide copyright laws and treaty provisions.  No part of the
! Material may be used, copied, reproduced, modified, published, uploaded,
! posted, transmitted, distributed, or disclosed in any way without
! Intel's prior express written permission.
!
! No license under any patent, copyright, trade secret or other
! intellectual property right is granted to or conferred upon you by
! disclosure or delivery of the Materials, either expressly, by
! implication, inducement, estoppel or otherwise.  Any license under such
! intellectual property rights must be express and approved by Intel in
! writing.

!
! This file provides the interface to remote memory access operations
! on top of Cluster OpenMP
!
interface
   subroutine kmp_create_rma_request (istatus,src_thread,req_handle)
     integer, intent(out) :: istatus, req_handle
     integer, intent(in)  :: src_thread
   end subroutine kmp_create_rma_request

   subroutine kmp_add_rma_get_request (istatus, req_handle, local_dest, remote_src)
     integer, intent(out) :: istatus
     integer, intent(in)  :: req_handle
     integer, pointer, dimension(:) :: local_dest, remote_src
     !dec$ attributes no_arg_check  :: local_dest, remote_src
   end subroutine kmp_add_rma_get_request

! There is currently no kmp_add_rma_put_request. 
! If it existed it would look like this
!    subroutine kmp_add_rma_put_request (istatus, req_handle, remote_dest, local_src)
!      integer, intent(out) :: istatus
!      integer, intent(in)  :: req_handle
!      integer, pointer, dimension(:) :: remote_dest, local_src
!      !dec$ attributes no_arg_check  :: remote_dest, local_src
!    end subroutine kmp_add_rma_put_request

   subroutine kmp_close_rma_request (istatus, req_handle)
     integer, intent(out) :: istatus
     integer, intent(in)  :: req_handle
   end subroutine kmp_close_rma_request

   subroutine kmp_perform_rma_request (istatus, req_handle)
     integer, intent(out) :: istatus
     integer, intent(in)  :: req_handle
   end subroutine kmp_perform_rma_request

   subroutine kmp_destroy_rma_request (istatus, req_handle)
     integer, intent(out) :: istatus
     integer, intent(in)  :: req_handle
   end subroutine kmp_destroy_rma_request

   subroutine kmp_rma_status_string (istatus, string)
     integer, intent(in) :: istatus
     character (len=*), intent(out) :: string
   end subroutine kmp_rma_status_string
end interface
