/**
*** Copyright (C) 1985-2008 Intel Corporation.  All rights reserved.
***
*** The information and source code contained herein is the exclusive
*** property of Intel Corporation and may not be disclosed, examined
*** or reproduced in whole or in part without explicit written authorization
*** from the company.
***
**/

#ifndef _IA32INTRIN_H_INCLUDED
#define _IA32INTRIN_H_INCLUDED

#include <immintrin.h>


#if defined __cplusplus
extern "C" { /* Begin "C" */
  /* Intrinsics use C name-mangling. */
#endif /* __cplusplus */

/* Implement RDTSC and RDPMC */
extern __int64 __cdecl _rdtsc(void);
extern __int64 __cdecl _rdpmc(int);

/* Implements BSWAP */
extern int __cdecl _bswap(int);

/* Implement BSR and BSF */
extern int __cdecl _bit_scan_forward(int);
extern int __cdecl _bit_scan_reverse(int);

/* Implements a 32-bit popcount */
extern int __cdecl _popcnt32(int);

/* Implements short rotates */
extern unsigned short __cdecl _rotwl(unsigned short, int);
extern unsigned short __cdecl _rotwr(unsigned short, int);

/* Implements integer rotates */
extern unsigned int __cdecl _rotl(unsigned int, int);
extern unsigned int __cdecl _rotr(unsigned int, int);

/* Implements long rotates */
extern unsigned long __cdecl _lrotl(unsigned long, int);
extern unsigned long __cdecl _lrotr(unsigned long, int);

/* User-visible synonyms for svml intrinsics.  */
__m128 __cdecl _mm_acos_ps(__m128 v1);                  //__svml_acosf4     
__m128 __cdecl _mm_acosh_ps(__m128 v1);                 //__svml_acoshf4    
__m128 __cdecl _mm_asin_ps(__m128 v1);                  //__svml_asinf4     
__m128 __cdecl _mm_asinh_ps(__m128 v1);                 //__svml_asinhf4    
__m128 __cdecl _mm_atan_ps(__m128 v1);                  //__svml_atanf4     
__m128 __cdecl _mm_atan2_ps(__m128 v1, __m128 v2);      //__svml_atan2f4    
__m128 __cdecl _mm_atanh_ps(__m128 v1);                 //__svml_atanhf4    
__m128 __cdecl _mm_cbrt_ps(__m128 v1);                  //__svml_cbrtf4     
//__m128 __cdecl _mm_ceil_ps(__m128 v1);                  //__svml_ceilf4     
__m128 __cdecl _mm_cos_ps(__m128 v1);                   //__svml_cosf4      
__m128 __cdecl _mm_cosh_ps(__m128 v1);                  //__svml_coshf4     
__m128 __cdecl _mm_exp_ps(__m128 v1);                   //__svml_expf4      
__m128 __cdecl _mm_exp2_ps(__m128 v1);                  //__svml_exp2f4     
//__m128 __cdecl _mm_floor_ps(__m128 v1);                 //__svml_floorf4    
__m128 __cdecl _mm_invcbrt_ps(__m128 v1);               //__svml_invcbrtf4  
__m128 __cdecl _mm_invsqrt_ps(__m128 v1);               //__svml_invsqrtf4  
__m128 __cdecl _mm_log_ps(__m128 v1);                   //__svml_logf4      
__m128 __cdecl _mm_log10_ps(__m128 v1);                 //__svml_log10f4    
__m128 __cdecl _mm_log2_ps(__m128 v1);                  //__svml_log2f4     
__m128 __cdecl _mm_pow_ps(__m128 v1, __m128 v2);        //__svml_powf4      
//__m128 __cdecl _mm_round_ps(__m128 v1);                 //__svml_roundf4    
__m128 __cdecl _mm_sin_ps(__m128 v1);                   //__svml_sinf4      
__m128 __cdecl _mm_sincos_ps(__m128 * r1, __m128 v1);   //__svml_sincosf4   
__m128 __cdecl _mm_sinh_ps(__m128 v1);                  //__svml_sinhf4     
//__m128 __cdecl _mm_sqrt_ps(__m128 v1);                  //__svml_sqrtf4     
__m128 __cdecl _mm_tan_ps(__m128 v1);                   //__svml_tanf4      
__m128 __cdecl _mm_tanh_ps(__m128 v1);                  //__svml_tanhf4     
__m128 __cdecl _mm_trunc_ps(__m128 v1);                 //__svml_truncf4    
__m128 __cdecl _mm_erf_ps(__m128 v1);                   //__svml_erff4      
__m128 __cdecl _mm_erfc_ps(__m128 v1);                  //__svml_erfcf4     
__m128d __cdecl _mm_acos_pd(__m128d v1);                //__svml_acos2   
__m128d __cdecl _mm_acosh_pd(__m128d v1);               //__svml_acosh2  
__m128d __cdecl _mm_asin_pd(__m128d v1);                //__svml_asin2   
__m128d __cdecl _mm_asinh_pd(__m128d v1);               //__svml_asinh2  
__m128d __cdecl _mm_atan_pd(__m128d v1);                //__svml_atan2   
__m128d __cdecl _mm_atan2_pd(__m128d v1, __m128d v2);   //__svml_atan22  
__m128d __cdecl _mm_atanh_pd(__m128d v1);               //__svml_atanh2  
__m128d __cdecl _mm_cbrt_pd(__m128d v1);                //__svml_cbrt2   
//__m128d __cdecl _mm_ceil_pd(__m128d v1);                //__svml_ceil2   
__m128d __cdecl _mm_cos_pd(__m128d v1);                 //__svml_cos2    
__m128d __cdecl _mm_cosh_pd(__m128d v1);                //__svml_cosh2   
__m128d __cdecl _mm_exp_pd(__m128d v1);                 //__svml_exp2    
__m128d __cdecl _mm_exp2_pd(__m128d v1);                //__svml_exp22   
//__m128d __cdecl _mm_floor_pd(__m128d v1);               //__svml_floor2  
__m128d __cdecl _mm_invcbrt_pd(__m128d v1);             //__svml_invcbrt2
__m128d __cdecl _mm_invsqrt_pd(__m128d v1);             //__svml_invsqrt2
__m128d __cdecl _mm_log_pd(__m128d v1);                 //__svml_log2    
__m128d __cdecl _mm_log10_pd(__m128d v1);               //__svml_log102  
__m128d __cdecl _mm_log2_pd(__m128d v1);                //__svml_log22   
__m128d __cdecl _mm_pow_pd(__m128d v1, __m128d v2);     //__svml_pow2    
//__m128d __cdecl _mm_round_pd(__m128d v1);               //__svml_round2  
__m128d __cdecl _mm_sin_pd(__m128d v1);                 //__svml_sin2    
__m128d __cdecl _mm_sincos_pd(__m128d * r1, __m128d v1); //__svml_sincos2 
__m128d __cdecl _mm_sinh_pd(__m128d v1);                //__svml_sinh2   
//__m128d __cdecl _mm_sqrt_pd(__m128d v1);                //__svml_sqrt2   
__m128d __cdecl _mm_tan_pd(__m128d v1);                 //__svml_tan2    
__m128d __cdecl _mm_tanh_pd(__m128d v1);                //__svml_tanh2   
__m128d __cdecl _mm_trunc_pd(__m128d v1);               //__svml_trunc2  
__m128d __cdecl _mm_erf_pd(__m128d v1);                 //__svml_erf2 
__m128d __cdecl _mm_erfc_pd(__m128d v1);                //__svml_erfc2

__m128i __cdecl _mm_idiv_epi32(__m128i v1, __m128i v2); //__svml_idiv4      
__m128i __cdecl _mm_idivrem_epi32(__m128i * r, __m128i v1, __m128i v2); //__svml_idivrem4   
__m128i __cdecl _mm_irem_epi32(__m128i v1, __m128i v2); //__svml_irem4      

__m128i __cdecl _mm_udiv_epi32(__m128i v1, __m128i v2); //__svml_udiv4    
__m128i __cdecl _mm_udivrem_epi32(__m128i * r, __m128i v1, __m128i v2); //__svml_udivrem4 
__m128i __cdecl _mm_urem_epi32(__m128i v1, __m128i v2); //__svml_urem4    

__m128 __cdecl _mm_cacos_ps(__m128 v1);                 //__svml_cacosf2
__m128 __cdecl _mm_cacosh_ps(__m128 v1);                //__svml_cacoshf2
__m128 __cdecl _mm_casin_ps(__m128 v1);                 //__svml_casinf2
__m128 __cdecl _mm_casinh_ps(__m128 v1);                //__svml_casinhf2
__m128 __cdecl _mm_catan_ps(__m128 v1);                 //__svml_catanf2
__m128 __cdecl _mm_catanh_ps(__m128 v1);                //__svml_catanhf2
__m128 __cdecl _mm_ccos_ps(__m128 v1);                  //__svml_ccosf2
__m128 __cdecl _mm_ccosh_ps(__m128 v1);                 //__svml_ccoshf2
__m128 __cdecl _mm_cexp_ps(__m128 v1);                  //__svml_cexpf2
__m128 __cdecl _mm_clog10_ps(__m128 v1);                //__svml_clog10f2
__m128 __cdecl _mm_clog2_ps(__m128 v1);                 //__svml_clog2f2
__m128 __cdecl _mm_clog_ps(__m128 v1);                  //__svml_clogf2
__m128 __cdecl _mm_cpow_ps(__m128 v1, __m128 v2);       //__svml_cpowf2
__m128 __cdecl _mm_csin_ps(__m128 v1);                  //__svml_csinf2
__m128 __cdecl _mm_csinh_ps(__m128 v1);                 //__svml_csinhf2
__m128 __cdecl _mm_csqrt_ps(__m128 v1);                 //__svml_csqrtf2
__m128 __cdecl _mm_ctan_ps(__m128 v1);                  //__svml_ctanf2
__m128 __cdecl _mm_ctanh_ps(__m128 v1);                 //__svml_ctanhf2

/*
 * User-visible synonyms for 256-bit svml intrinsics
 */
extern __m256 __cdecl _mm256_acos_ps(__m256 v1);
extern __m256 __cdecl _mm256_acosh_ps(__m256 v1);
extern __m256 __cdecl _mm256_asin_ps(__m256 v1);
extern __m256 __cdecl _mm256_asinh_ps(__m256 v1);
extern __m256 __cdecl _mm256_atan_ps(__m256 v1);
extern __m256 __cdecl _mm256_atan2_ps(__m256 v1, __m256 v2);
extern __m256 __cdecl _mm256_atanh_ps(__m256 v1);
extern __m256 __cdecl _mm256_cbrt_ps(__m256 v1);
extern __m256 __cdecl _mm256_cos_ps(__m256 v1);
extern __m256 __cdecl _mm256_cosh_ps(__m256 v1);
extern __m256 __cdecl _mm256_exp_ps(__m256 v1);
extern __m256 __cdecl _mm256_exp2_ps(__m256 v1);
extern __m256 __cdecl _mm256_invcbrt_ps(__m256 v1);
extern __m256 __cdecl _mm256_invsqrt_ps(__m256 v1);
extern __m256 __cdecl _mm256_log_ps(__m256 v1);
extern __m256 __cdecl _mm256_log10_ps(__m256 v1);
extern __m256 __cdecl _mm256_log2_ps(__m256 v1);
extern __m256 __cdecl _mm256_pow_ps(__m256 v1, __m256 v2);
extern __m256 __cdecl _mm256_sin_ps(__m256 v1);
extern __m256 __cdecl _mm256_sincos_ps(__m256 * r1, __m256 v1);
extern __m256 __cdecl _mm256_sinh_ps(__m256 v1);
extern __m256 __cdecl _mm256_tan_ps(__m256 v1);
extern __m256 __cdecl _mm256_tanh_ps(__m256 v1);
extern __m256 __cdecl _mm256_trunc_ps(__m256 v1);
extern __m256 __cdecl _mm256_erf_ps(__m256 v1);
extern __m256 __cdecl _mm256_erfc_ps(__m256 v1);
extern __m256d __cdecl _mm256_acos_pd(__m256d v1);
extern __m256d __cdecl _mm256_acosh_pd(__m256d v1);
extern __m256d __cdecl _mm256_asin_pd(__m256d v1);
extern __m256d __cdecl _mm256_asinh_pd(__m256d v1);
extern __m256d __cdecl _mm256_atan_pd(__m256d v1);
extern __m256d __cdecl _mm256_atan2_pd(__m256d v1, __m256d v2);
extern __m256d __cdecl _mm256_atanh_pd(__m256d v1);
extern __m256d __cdecl _mm256_cbrt_pd(__m256d v1);
extern __m256d __cdecl _mm256_cos_pd(__m256d v1);
extern __m256d __cdecl _mm256_cosh_pd(__m256d v1);
extern __m256d __cdecl _mm256_exp_pd(__m256d v1);
extern __m256d __cdecl _mm256_exp2_pd(__m256d v1);
extern __m256d __cdecl _mm256_invcbrt_pd(__m256d v1);
extern __m256d __cdecl _mm256_invsqrt_pd(__m256d v1);
extern __m256d __cdecl _mm256_log_pd(__m256d v1);
extern __m256d __cdecl _mm256_log10_pd(__m256d v1);
extern __m256d __cdecl _mm256_log2_pd(__m256d v1);
extern __m256d __cdecl _mm256_pow_pd(__m256d v1, __m256d v2);
extern __m256d __cdecl _mm256_sin_pd(__m256d v1);
extern __m256d __cdecl _mm256_sincos_pd(__m256d * r1, __m256d v1);
extern __m256d __cdecl _mm256_sinh_pd(__m256d v1);
extern __m256d __cdecl _mm256_tan_pd(__m256d v1);
extern __m256d __cdecl _mm256_tanh_pd(__m256d v1);
extern __m256d __cdecl _mm256_trunc_pd(__m256d v1);
extern __m256d __cdecl _mm256_erf_pd(__m256d v1);
extern __m256d __cdecl _mm256_erfc_pd(__m256d v1);

extern __m256i __cdecl _mm256_idiv_epi32(__m256i v1, __m256i v2);
extern __m256i __cdecl _mm256_idivrem_epi32(__m256i * r, __m256i v1, __m256i v2);
extern __m256i __cdecl _mm256_irem_epi32(__m256i v1, __m256i v2);

extern __m256i __cdecl _mm256_udiv_epi32(__m256i v1, __m256i v2);
extern __m256i __cdecl _mm256_udivrem_epi32(__m256i * r, __m256i v1, __m256i v2);
extern __m256i __cdecl _mm256_urem_epi32(__m256i v1, __m256i v2);

extern __m256 __cdecl _mm256_cacos_ps(__m256 v1);
extern __m256 __cdecl _mm256_cacohs_ps(__m256 v1);
extern __m256 __cdecl _mm256_casin_ps(__m256 v1);
extern __m256 __cdecl _mm256_casinh_ps(__m256 v1);
extern __m256 __cdecl _mm256_catan_ps(__m256 v1);
extern __m256 __cdecl _mm256_catanh_ps(__m256 v1);
extern __m256 __cdecl _mm256_ccos_ps(__m256 v1);
extern __m256 __cdecl _mm256_ccosh_ps(__m256 v1);
extern __m256 __cdecl _mm256_cexp_ps(__m256 v1);
extern __m256 __cdecl _mm256_clog10_ps(__m256 v1);
extern __m256 __cdecl _mm256_clog2_ps(__m256 v1);
extern __m256 __cdecl _mm256_clog_ps(__m256 v1);
extern __m256 __cdecl _mm256_cpow_ps(__m256 v1, __m256 v2);
extern __m256 __cdecl _mm256_csin_ps(__m256 v1);
extern __m256 __cdecl _mm256_csinh_ps(__m256 v1);
extern __m256 __cdecl _mm256_csqrt_ps(__m256 v1);
extern __m256 __cdecl _mm256_ctan_ps(__m256 v1);
extern __m256 __cdecl _mm256_ctanh_ps(__m256 v1);

#if defined __cplusplus
}; /* End "C" */
#endif /* __cplusplus */

#endif /* _IA32INTRIN_H_INCLUDED */
