#
# Copyright  (C) 1985-2010 Intel Corporation. All rights reserved.
#
# The information and source code contained herein is the exclusive property
# of Intel Corporation and may not be disclosed, examined, or reproduced in
# whole or in part without explicit written authorization from the Company.
#

#!/bin/csh
switch ("$1")
  case "ia32": 
    if ( -e /net/pc20/workPC20/Eos/util/X86LINUX64//bin/ia32/idbvars.csh ) then
       source /net/pc20/workPC20/Eos/util/X86LINUX64//bin/ia32/idbvars.csh;
    endif 
    if ( -e /net/pc20/workPC20/Eos/util/X86LINUX64//tbb/bin/tbbvars.csh ) then
       source /net/pc20/workPC20/Eos/util/X86LINUX64//tbb/bin/tbbvars.csh ia32;
    endif 
    if ( -e /net/pc20/workPC20/Eos/util/X86LINUX64//Frameworks/tbb/bin/tbbvars.csh ) then
       source /net/pc20/workPC20/Eos/util/X86LINUX64//Frameworks/tbb/bin/tbbvars.csh ia32;
    endif 
    if ( -e /net/pc20/workPC20/Eos/util/X86LINUX64//mkl/tools/environment/mklvars32.csh ) then
       source /net/pc20/workPC20/Eos/util/X86LINUX64//mkl/tools/environment/mklvars32.csh;
    endif 
    if ( -e /net/pc20/workPC20/Eos/util/X86LINUX64//Frameworks/mkl/tools/environment/mklvars32.csh ) then
       source /net/pc20/workPC20/Eos/util/X86LINUX64//Frameworks/mkl/tools/environment/mklvars32.csh;
    endif 
    if ( -e /net/pc20/workPC20/Eos/util/X86LINUX64//ipp/ia32/tools/env/ippvars32.csh ) then
       source /net/pc20/workPC20/Eos/util/X86LINUX64//ipp/ia32/tools/env/ippvars32.csh;
    endif 
    if ( -e /net/pc20/workPC20/Eos/util/X86LINUX64//Frameworks/ipp/tools/env/ippvars32.csh ) then
       source /net/pc20/workPC20/Eos/util/X86LINUX64//Frameworks/ipp/tools/env/ippvars32.csh;
    endif 
    if ( -e /net/pc20/workPC20/Eos/util/X86LINUX64//bin/ia32/iccvars_ia32.csh ) then
       source /net/pc20/workPC20/Eos/util/X86LINUX64//bin/ia32/iccvars_ia32.csh;
    endif 
    breaksw;
  case "intel64": 
    if ( -e /net/pc20/workPC20/Eos/util/X86LINUX64//bin/intel64/idbvars.csh ) then
       source /net/pc20/workPC20/Eos/util/X86LINUX64//bin/intel64/idbvars.csh;
    endif 
    if ( -e /net/pc20/workPC20/Eos/util/X86LINUX64//tbb/bin/tbbvars.csh ) then
       source /net/pc20/workPC20/Eos/util/X86LINUX64//tbb/bin/tbbvars.csh intel64;
    endif 
    if ( -e /net/pc20/workPC20/Eos/util/X86LINUX64//Frameworks/tbb/bin/tbbvars.csh ) then
       source /net/pc20/workPC20/Eos/util/X86LINUX64//Frameworks/tbb/bin/tbbvars.csh intel64;
    endif 
    if ( -e /net/pc20/workPC20/Eos/util/X86LINUX64//mkl/tools/environment/mklvarsem64t.csh ) then
       source /net/pc20/workPC20/Eos/util/X86LINUX64//mkl/tools/environment/mklvarsem64t.csh;
    endif 
    if ( -e /net/pc20/workPC20/Eos/util/X86LINUX64//Frameworks/mkl/tools/environment/mklvarsem64t.csh ) then
       source /net/pc20/workPC20/Eos/util/X86LINUX64//Frameworks/mkl/tools/environment/mklvarsem64t.csh;
    endif 
    if ( -e /net/pc20/workPC20/Eos/util/X86LINUX64//ipp/em64t/tools/env/ippvarsem64t.csh ) then
       source /net/pc20/workPC20/Eos/util/X86LINUX64//ipp/em64t/tools/env/ippvarsem64t.csh;
    endif 
    if ( -e /net/pc20/workPC20/Eos/util/X86LINUX64//Frameworks/ipp/tools/env/ippvarsem64t.csh ) then
       source /net/pc20/workPC20/Eos/util/X86LINUX64//Frameworks/ipp/tools/env/ippvarsem64t.csh;
    endif 
    if ( -e /net/pc20/workPC20/Eos/util/X86LINUX64//bin/intel64/iccvars_intel64.csh ) then
       source /net/pc20/workPC20/Eos/util/X86LINUX64//bin/intel64/iccvars_intel64.csh;
    endif 
    breaksw;
  case "ia64": 
    if ( "`uname`" ==  "Darwin" ) then
       echo "ia64 on Mac is not a valid argument. Use ia32 or intel64"
    else
       if ( -e /net/pc20/workPC20/Eos/util/X86LINUX64//tbb/bin/tbbvars.csh ) then
          source /net/pc20/workPC20/Eos/util/X86LINUX64//tbb/bin/tbbvars.csh ia64;
       endif 
       if ( -e /net/pc20/workPC20/Eos/util/X86LINUX64//mkl/tools/environment/mklvars64.csh ) then
          source /net/pc20/workPC20/Eos/util/X86LINUX64//mkl/tools/environment/mklvars64.csh;
       endif 
       if ( -e /net/pc20/workPC20/Eos/util/X86LINUX64//ipp/ia64/tools/env/ippvars64.csh ) then
          source /net/pc20/workPC20/Eos/util/X86LINUX64//ipp/ia64/tools/env/ippvars64.csh;
       endif
       if ( -e /net/pc20/workPC20/Eos/util/X86LINUX64//bin/ia64/iccvars_ia64.csh ) then
          source /net/pc20/workPC20/Eos/util/X86LINUX64//bin/ia64/iccvars_ia64.csh;
       endif 
    endif
    breaksw;
  default:
    if ( "`uname`" == "Darwin" ) then
       echo "ERROR: Unknown switch '$1'. Accepted values: ia32, intel64"
    else
       echo "ERROR: Unknown switch '$1'. Accepted values: ia32, intel64, ia64"
    endif
    breaksw;
endsw

