'\"
'\" Copyright 1991-1997 by Bell Labs Innovations for Lucent Technologies.
'\"
'\" Permission to use, copy, modify, and distribute this software and its
'\" documentation for any purpose and without fee is hereby granted, provided
'\" that the above copyright notice appear in all copies and that both that the
'\" copyright notice and warranty disclaimer appear in supporting documentation,
'\" and that the names of Lucent Technologies any of their entities not be used
'\" in advertising or publicity pertaining to distribution of the software
'\" without specific, written prior permission.
'\"
'\" Lucent Technologies disclaims all warranties with regard to this software,
'\" including all implied warranties of merchantability and fitness.  In no event
'\" shall Lucent Technologies be liable for any special, indirect or
'\" consequential damages or any damages whatsoever resulting from loss of use,
'\" data or profits, whether in an action of contract, negligence or other
'\" tortuous action, arising out of or in connection with the use or performance
'\" of this software.  
'\"
'\" Busy command created by George Howlett.
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .HS name section [date [version]]
'\"	Replacement for .TH in other man pages.  See below for valid
'\"	section names.
'\"
'\" .AP type name in/out [indent]
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS [type [name]]
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .VS
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\"	# Heading for Tcl/Tk man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if '\\$2'BLT'        .TH \\$1 "BLT 2.4" \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
'\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
'\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
'\"	Draw four-sided box normally, but don't draw top of
'\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
'\"	Draw three-sided box if this is the box's first page,
'\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.ft CW
.nf
.sp
..
'\"	# DE - end display
.de DE
.ft R
.fi
.sp
.RE
..
.HS busy BLT
.BS 
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
busy \- Make Tk widgets busy, temporarily blocking user interactions.
.SH SYNOPSIS
\fBbusy hold \fIwindow\fR ?\fIoption value\fR?...
.sp
\fBbusy release \fIwindow\fR ?\fIwindow\fR?...
.sp
\fBbusy configure \fIwindow\fR ?\fIoption value\fR?...
.sp
\fBbusy forget \fIwindow\fR ?\fIwindow\fR?...
.sp
\fBbusy isbusy \fR?\fIpattern\fR?
.sp
\fBbusy status \fIwindow\fR 
.sp
\fBbusy windows \fR?\fIpattern\fR?
.BE
.SH DESCRIPTION
.PP
The \fBbusy\fR command provides a simple means to block
keyboard, button, and pointer events from Tk widgets, while overriding
the widget's cursor with a configurable busy cursor.
.SH INTRODUCTION
.PP
There are many times in applications where you want to temporarily
restrict what actions the user can take.  For example, an application
could have a "run" button that when pressed causes some processing to
occur.  But while the application is busy processing, you probably don't
want the the user to be able to click the "run" button again.  You
may also want restrict the user from other tasks such as clicking a
"print" button.
.PP
The \fBbusy\fR command lets you make Tk widgets busy. This means
that user interactions such as button clicks, moving the mouse, typing
at the keyboard, etc. are ignored by the widget.  You can also set a
special cursor (like a watch) which overrides the widget's normal
cursor, providing feedback that the application (widget) is
temporarily busy.
.PP
When a widget is made busy, all of the widgets in its window
hierarchy also become busy.  It's easy then to make an entire panel of
widgets busy by simply making the uppermost widget (such as ".") busy.
This is far easier and much more efficient than recursively traversing
the widget hierarchy, disabling each widget and re-configuring its
cursor.
.PP
The busy command can also be used in many cases instead of Tk's \fBgrab\fR
command.  Unlike \fBgrab\fR which directs all user interaction to one
widget, the busy command allows more than one widget to be active (for
example, a "cancel" dialog and a "help" button) while the other
widgets are busy.
.SH EXAMPLE
You can make a set of widgets busy by simply making the uppermost widget
in the hierarchy busy using the \fBhold\fR operation.  
.DS
frame .top
button .top.button; canvas .top.canvas
pack .top.button .top.canvas
pack .top
  . . .
busy hold .top
update
.DE
All the widgets within \f(CW.top\fR (including \f(CW.top\fR) are now busy.  
The \fBupdate\fR command insures that \fBbusy\fR command has a 
chance to effect.
.PP
When the application is no longer busy, you can allow user interaction again 
by the \fBrelease\fR operation.
.nf

\f(CW	busy release .top \fR

.fi
You can change the busy cursor using the \fBconfigure\fR operation.
.nf

\f(CW	busy configure .top -cursor "watch"\fR

.fi
Finally, when you no longer need to make the widget busy anymore, 
invoke the \fBforget\fR operation to free any resources allocated.
.nf

\f(CW	busy forget .top \fR

.fi
Destroying the widget also cleans up any resources allocated
by the busy command.
.PP
.SH OPERATIONS
The following operations are available for the \fBbusy\fR command:
.TP
\fBbusy hold \fIwindow\fR ?\fIoption value\fR?...
Makes the widget \fIwindow\fR (and its descendants in the Tk window
hierarchy) busy.  \fIWindow\fR must be a valid path name of a Tk
widget.  After idle tasks are processed, the widget will be blocked
from user interactions. All device events in the widget window and its
descendants will be ignored.  Typically \fBupdate\fR should be called
immediately afterward to insure that the \fBhold\fR operation is in
effect \fIbefore\fR the application starts its processing. The
following configuration options are valid:
.RS
.TP
\fB\-cursor \fIcursorName\fR
Specifies the cursor to be displayed when the widget is made busy.
\fICursorName\fR can be in any form accepted by \fBTk_GetCursor\fR.
The default cursor is \f(CWwatch\fR.
.RE
.TP
\fBbusy configure \fIwindow\fR ?\fIoption value\fR?...
Queries or modifies the \fBbusy\fR command configuration options for 
\fIwindow\fR. \fIWindow\fR must be the path name of a widget previously
made busy by the \fBhold\fR operation.  If no options are
specified, a list describing all of the available options for
\fIwindow\fR (see \fBTk_ConfigureInfo\fR for information on the format
of this list) is returned.  If \fIoption\fR is specified with no
\fIvalue\fR, then the command returns a list describing the one named
option (this list will be identical to the corresponding sublist of
the value returned if no \fIoption\fR is specified).  If one or more
\fIoption\-value\fR pairs are specified, then the command modifies the
given widget option(s) to have the given value(s); in this case the
command returns the empty string.  \fIOption\fR may have any of the
values accepted by the \fBhold\fR operation.  
.sp
Please note that the
option database is referenced through \fIwindow\fR.  For example, if 
the widget \f(CW.frame\fR is to be made busy, the busy 
cursor can be specified for it by either \fBoption\fR command:
.nf

	\f(CWoption add *frame.busyCursor gumby\fR
	\f(CWoption add *Frame.BusyCursor gumby\fR

.fi
.TP
\fBbusy forget \fIwindow\fR ?\fIwindow\fR?...
Releases resources allocated by the busy command for \fIwindow\fR,
including the InputOnly window.  User events will again be received again 
by \fIwindow\fR.  Busy resources are also released when \fIwindow\fR
is destroyed. \fIWindow\fR must be the name of a widget specified 
in the \fBhold\fR operation, otherwise an error is reported.
.TP
\fBbusy isbusy \fR?\fIpattern\fR?
Returns the pathnames of all widget windows which are currently busy.
If a \fIpattern\fR is given, the path names of busy widgets 
matching \fIpattern\fR are returned.
.TP
\fBbusy release \fIwindow\fR ?\fIwindow\fR?...
Restores user interactions to the widget \fIwindow\fR again. 
This differs from the \fBforget\fR operation in that the InputOnly window 
is not destroyed, but simply unmapped.  
\fIWindow\fR must be the name of a widget specified 
in a \fBhold\fR operation, otherwise an error is reported.
.TP
\fBbusy status \fIwindow\fR
Returns the status of a widget \fIwindow\fR previously made busy.
An error is reported if \fIwindow\fR was never made busy, or
the \fBforget\fR operation was invoked (i.e. does not currently have a
InputOnly window associated with it).  If \fIwindow\fR is presently can
not receive user interaction, \f(CW1\fR is returned, otherwise \f(CW0\fR.
.TP
\fBbusy windows \fR?\fIpattern\fR?
Returns the pathnames of all widget windows which have previously been
made busy (i.e. an InputOnly is allocated and associated with the
widget).  It makes no difference if the window is currently busy ot
not.  If a \fIpattern\fR is given, the path names of busy widgets
matching \fIpattern\fR are returned.
.sp 1
.SH BINDINGS
The blocking feature is implemented by creating and mapping a
transparent InputOnly class window which completely covers the
widget.  When the InputOnly window is mapped, it intercepts all
events which could be sent to the widget and its hierarchy.  
Like Tk widgets, the InputOnly windows have names in the
Tk window hierarchy.  This means that you can use the \fBbind\fR 
command, to handle events in the InputOnly window.
.DS
busy hold .frame.canvas
bind .frame.canvas_Busy <Enter> { ... } 
.DE
.PP
Typically, the InputOnly window is a sibling of the widget's window.
The name of the InputOnly window will be "\fIwidget\f(CW_Busy\fR" where 
\fIwidget\fR is the name of the widget made busy.  In the above example,
the pathname of the InputOnly window is "\f(CW.frame.canvas_Busy\fR"
The exception is when the widget is a toplevel window (such as ".").
Then the InputOnly window is a child of the widget's window and the name of
the widget will be "\fIwidget\f(CW._Busy\fR" where \fIwidget\fR is the name 
of the widget made busy.  In the following example,
the pathname of the InputOnly window is "\f(CW._Busy\fR" 
.DS
busy hold .
bind ._Busy <Enter> { ... } 
.DE
.SH ENTER/LEAVE EVENTS
Mapping and unmapping the InputOnly window generates Enter/Leave
events for all widget (windows) that it covers.  Please note this when
you are tracking Enter/Leave events in widgets.
.SH KEYBOARD EVENTS
When a widget is made busy, the widget is prevented from gaining the
keyboard focus by the InputOnly window. But Tk widgets can still get
keyboard events if the keyboard focus is already set. Care must be
taken to move focus to another window.
.DS
busy hold .frame
label .dummy
focus .dummy
update
.DE
The above example moves the focus from .frame immediately after
invoking the \fBhold\fR so that no keyboard events will be relayed to
windows under the hierarchy of \f(CW.frame\fR.
.SH KEYWORDS
busy, keyboard events, pointer events, window, cursor


