// -*- c++ -*-
/*
 *  MICO --- an Open Source CORBA implementation
 *  Copyright (c) 1997-2001 by The Mico Team
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  For more information, visit the MICO Home Page at
 *  http://www.mico.org/
 */

#ifndef __mico_boa_h__
#define __mico_boa_h__

namespace CORBA {

/************************* Interfaces ******************************/

class ORBRequest;

class BOA : public ServerlessObject {
public:
    //typedef BoundedSequenceTmpl<Octet, MICO_TID_OCTET, 1024> ReferenceData;
    typedef SequenceTmpl<Octet,MICO_TID_OCTET> ReferenceData;
    typedef TSeqVar<ReferenceData> ReferenceData_var;

    virtual Object_ptr create (const ReferenceData &,
			       InterfaceDef *,
			       ImplementationDef *,
			       ImplementationBase * = NULL,
                               const char *repoid = 0) = 0;
    // begin-mico-extension
    virtual ~BOA ();
    virtual Boolean restoring () = 0;
    virtual Object_ptr restore (Object_ptr orig,
				const ReferenceData &,
				InterfaceDef *,
				ImplementationDef *,
				ImplementationBase *) = 0;
    virtual ORB_ptr orb () = 0;
    virtual const char *impl_name () = 0;
    virtual void save_objects () = 0;
    virtual void dispose_objects () = 0;
    // end-mico-extension

    virtual void dispose (Object_ptr) = 0;
    virtual ReferenceData *get_id (Object_ptr) = 0;
    virtual void change_implementation (Object_ptr,
					ImplementationDef *) = 0;
    virtual Principal_ptr get_principal (Object_ptr, Environment_ptr) = 0;

    virtual void impl_is_ready (ImplementationDef *) = 0;
    virtual void deactivate_impl (ImplementationDef *) = 0;
    virtual void obj_is_ready (Object_ptr, ImplementationDef *) = 0;
    virtual void deactivate_obj (Object_ptr) = 0;

    static BOA_ptr _duplicate (BOA_ptr o)
    {
	if (o)
	    o->_ref();
	return o;
    }
    static BOA_ptr _nil ()
    {
	return 0;
    }
};

typedef ObjVar<BOA> BOA_var;


class BOAObjectRestorer {
    ServerlessObject *_boa_interceptor;
public:
    BOAObjectRestorer ();
    virtual ~BOAObjectRestorer ();

    virtual Boolean restore (Object_ptr);
    virtual Boolean bind (const char *repoid,
                          const SequenceTmpl<Octet,MICO_TID_OCTET> &tag);
};

class ImplementationBase : virtual public CORBA::Object {
protected:
    ORB_ptr _morb;
    BOA_ptr _mboa;
public:
    ImplementationBase ();
    virtual ~ImplementationBase ();

    virtual CORBA::Boolean _save_object ();
    ORB_ptr _orb ();
    ORB_ptr _orbnc ();

    virtual void _create_ref (const BOA::ReferenceData &, InterfaceDef *,
			      ImplementationDef *, const char *repoid);
    virtual void _restore_ref (Object_ptr orig, const BOA::ReferenceData &,
			       InterfaceDef *, ImplementationDef *);
    virtual void _dispose_ref ();
    virtual const char *_impl_name (const char *);

    ImplementationDef *_find_impl (const char *repoid, const char *name);
    InterfaceDef *_find_iface (const char *repoid);
    
    BOA_ptr _boa ();
    Object_ptr _this ();

    virtual ServerRequestBase_ptr make_request (ORBRequest *,
						CORBA::Object_ptr,
						CORBA::ORBMsgId,
						CORBA::ObjectAdapter *,
						CORBA::Principal_ptr) = 0;

    virtual void doinvoke (ServerRequestBase_ptr request,
			   Environment &env) = 0;
};

// base class for all object implementations. constructor creates
// object reference and registers with BOA.
class DynamicImplementation : virtual public ImplementationBase {
public:
    DynamicImplementation ();
    virtual ~DynamicImplementation ();


    virtual ServerRequestBase_ptr make_request (ORBRequest *,
						CORBA::Object_ptr,
						CORBA::ORBMsgId,
						CORBA::ObjectAdapter *,
						CORBA::Principal_ptr);
    virtual void doinvoke (ServerRequestBase_ptr request,
			   Environment &env);
    virtual void invoke (ServerRequest_ptr request,
			 Environment &env) = 0;
};

class StaticImplementation : virtual public CORBA::ImplementationBase {
public:
    StaticImplementation ();
    virtual ~StaticImplementation ();

    virtual ServerRequestBase_ptr make_request (ORBRequest *,
						CORBA::Object_ptr,
						CORBA::ORBMsgId,
						CORBA::ObjectAdapter *,
						CORBA::Principal_ptr);
    virtual void doinvoke (ServerRequestBase_ptr request,
			   Environment &env);
    virtual void invoke (StaticServerRequest_ptr request,
			 Environment &env) = 0;
};


// Interface dispatcher for DII
class InterfaceDispatcher  {
public:
    virtual ~InterfaceDispatcher ();
    virtual bool dispatch( CORBA::ServerRequest_ptr _req,
			   CORBA::Environment &_env ) = 0;
};

/*
 * The following class is the base class for all automatically
 * generated skeleton classes by idl. It maintains a list
 * of dispatchers which are sequentially offered an incoming
 * method invocation.
 */

class MethodDispatcher : public virtual CORBA::DynamicImplementation {
protected:
    void register_dispatcher( InterfaceDispatcher *disp );
public:
    virtual ~MethodDispatcher ();
    virtual void invoke( CORBA::ServerRequest_ptr _req,
			 CORBA::Environment &_env );
private:
    typedef std::vector<InterfaceDispatcher*> VecInterfaceDispatcher;
    VecInterfaceDispatcher _dispatcher;
};

// Interface dispatcher for SII
class StaticInterfaceDispatcher  {
public:
    virtual ~StaticInterfaceDispatcher ();
    virtual bool dispatch( CORBA::StaticServerRequest_ptr _req,
			   CORBA::Environment &_env ) = 0;
};

/*
 * The following class is the base class for all automatically
 * generated skeleton classes by idl. It maintains a list
 * of dispatchers which are sequentially offered an incoming
 * method invocation.
 */

class StaticMethodDispatcher : public virtual CORBA::StaticImplementation {
protected:
    void register_dispatcher( StaticInterfaceDispatcher *disp );
public:
    virtual ~StaticMethodDispatcher ();
    virtual void invoke( CORBA::StaticServerRequest_ptr _req,
			 CORBA::Environment &_env );
private:
    typedef std::vector<StaticInterfaceDispatcher*> VecInterfaceDispatcher;
    VecInterfaceDispatcher _dispatcher;
};

} /* namespace CORBA */

/*
 * stuff defined in ::
 */

template<class T>
class InterfaceDispatcherWrapper : public CORBA::InterfaceDispatcher {
private:
    T* _interface;
public:
    InterfaceDispatcherWrapper( T* iface )
    {
	_interface = iface;
    }
    virtual bool dispatch( CORBA::ServerRequest_ptr _req,
			   CORBA::Environment &_env )
    {
	return _interface->dispatch( _req, _env );
    }
};

typedef CORBA::MethodDispatcher MethodDispatcher;
typedef CORBA::InterfaceDispatcher InterfaceDispatcher;

template<class T>
class StaticInterfaceDispatcherWrapper :
  public CORBA::StaticInterfaceDispatcher {
private:
    T* _interface;
public:
    StaticInterfaceDispatcherWrapper( T* iface )
    {
	_interface = iface;
    }
    virtual bool dispatch( CORBA::StaticServerRequest_ptr _req,
			   CORBA::Environment &_env )
    {
	return _interface->dispatch( _req, _env );
    }
};

typedef CORBA::StaticMethodDispatcher StaticMethodDispatcher;
typedef CORBA::StaticInterfaceDispatcher StaticInterfaceDispatcher;

#endif // __mico_boa_h__
