#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h> 
#include <vtk.h>  
#include <pdbFile.h>        
#define GLOBAL_DECLARATION
#include "../inc/config.h"

#define DEBUG
#include "genUtil.h"
#include "mrcImage.h"

#define SPHERERADIUS          0.03
#define SPHERETHETARESOLUTION 30
#define SPHEREPHIRESOLUTION   30 
#define SPHERECOLORR          1.0 
#define SPHERECOLORG          0.0  
#define SPHERECOLORB          1.0 
#define SPHEREOPACITY         0.2 
#define CONEHEIGHT           1.0
#define CONERADIUS           0.5
#define CONERESOLUTION       80

class eosStereoWindow:public vtkRenderWindow{

  public:
         vtkRenderer     *ren,*renLeft,*renRight;
         vtkCamera       *cam,*camLeft,*camRight;
         vtkLight        *light;
         vtkRenderWindow *renWin;
         vtkRenderWindowInteractor *iren1,*iren2;

         int             stereoFlag;  

         eosStereoWindow(vtkActor*,int);
         void run(void);
};

eosStereoWindow::eosStereoWindow(vtkActor *coneActor, int a){

         stereoFlag=a;
    
         cam=vtkCamera::New();
	 cam->SetFocalPoint(0,0,0);
	 cam->SetPosition(0,0,10);
	 cam->SetEyeAngle(10.0);
	 camLeft=vtkCamera::New();
	 camLeft->SetFocalPoint(0,0,0);
	 camLeft->SetPosition(0,0,10);
	 camLeft->SetEyeAngle(10.0);
	 camRight=vtkCamera::New();
	 camRight->SetFocalPoint(0,0,0);
	 camRight->SetPosition(0,0,10);
	 camRight->SetEyeAngle(10.0);

	 light=vtkLight::New();
	 light->SetFocalPoint(0.21406,1.5,0);
	 light->SetPosition(8.3761,4.94858,4.1250);

         ren=vtkRenderer::New();
	 ren->SetActiveCamera(cam);
	 ren->AddLight(light);
	 ren->AddActor(coneActor);

	 if(stereoFlag==1){
	   renLeft=vtkRenderer::New();
	   renRight=vtkRenderer::New();

	   renLeft->SetViewport(0,0,0.5,1.0);
	   renLeft->SetActiveCamera(camLeft);
	   renLeft->AddLight(light);
	   renLeft->AddActor(coneActor);

	   renRight->SetViewport(0.5,0,1.0,1.0);
	   renRight->SetActiveCamera(camRight);
	   renRight->AddLight(light);
	   renRight->AddActor(coneActor);
	 }

	 this->eosStereoWindow::New();
	 this->AddRenderer(ren);
	 this->SetWindowName("eosStereoWindow");
	 this->SetSize(300,300);

	 if(stereoFlag==1){
	   renWin=eosStereoWindow::New();
	   renWin->AddRenderer(renLeft);
	   renWin->AddRenderer(renRight);
	   renWin->SetWindowName("eosStereoWindow2");
	   renWin->SetSize(600,300);
	 }

	 iren1=vtkRenderWindowInteractor::New();
	 iren2=vtkRenderWindowInteractor::New();
	 iren1->SetRenderWindow(renWin);
	 iren2->SetRenderWindow(this);


}

void eosStereoWindow::run(void){
	 renWin->Render();
	 this->Render();
	 iren1->Start();
	 iren2->Start();
}

int main(int argc, char* argv[])
{
	mrcViewInfo info;
	pdbFile pdb;
	int flag;

	init0(&info);
    	argCheck(&info, argc, argv);
    	init1(&info);

	DEBUGPRINT("Program Start\n");   

	flag=1;

	vtkConeSource *cone=vtkConeSource::New();
	 cone->SetHeight(CONEHEIGHT);
	 cone->SetRadius(CONERADIUS);
	 cone->SetResolution(CONERESOLUTION);
	vtkPolyDataMapper *coneMapper=vtkPolyDataMapper::New();
	 coneMapper->SetInput(cone->GetOutput());
	vtkActor *coneActor=vtkActor::New();
	 coneActor->SetMapper(coneMapper);
	 coneActor->GetProperty()->SetColor(0.0,0.0,1.0);
	 coneActor->RotateZ(0.0);
	 coneActor->SetPosition(0.0,0.0,0.0);
	 coneActor->RotateY(0.0);

	eosStereoWindow stereoWin(coneActor,flag);

	stereoWin.run();

	exit(EXIT_SUCCESS);
}


void
additionalUsage()
{
	fprintf(stderr, "----- Additional Usage -----\n");
}
